/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import java.util.ArrayList;
import java.util.List;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GoodsForSaleMessage
extends DOMMessage {
    private String unitId;
    private String settlementId;
    private List<Goods> sellGoods;

    public GoodsForSaleMessage(Unit unit, Settlement settlement, List<Goods> sellGoods) {
        this.unitId = unit.getId();
        this.settlementId = settlement.getId();
        this.sellGoods = sellGoods;
    }

    public GoodsForSaleMessage(Game game, Element element) {
        this.unitId = element.getAttribute("unit");
        this.settlementId = element.getAttribute("settlement");
        this.sellGoods = new ArrayList<Goods>();
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            this.sellGoods.add(new Goods(game, (Element)children.item(i)));
        }
    }

    public Element handle(FreeColServer server, Player player, Connection connection) {
        IndianSettlement settlement;
        Unit unit;
        ServerPlayer serverPlayer = server.getPlayer(connection);
        try {
            unit = server.getUnitSafely(this.unitId, serverPlayer);
            settlement = server.getAdjacentIndianSettlementSafely(this.settlementId, unit);
        }
        catch (Exception e) {
            return DOMMessage.clientError(e.getMessage());
        }
        return server.getInGameController().getGoodsForSale(serverPlayer, unit, settlement);
    }

    @Override
    public Element toXMLElement() {
        Element result = GoodsForSaleMessage.createNewRootElement(GoodsForSaleMessage.getXMLElementTagName());
        Document doc = result.getOwnerDocument();
        result.setAttribute("unit", this.unitId);
        result.setAttribute("settlement", this.settlementId);
        if (this.sellGoods != null) {
            for (Goods goods : this.sellGoods) {
                result.appendChild(goods.toXMLElement(null, doc));
            }
        }
        return result;
    }

    public static String getXMLElementTagName() {
        return "goodsForSale";
    }
}

