/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

public class ChatMessage
extends DOMMessage {
    private Player player;
    private String sender;
    private String message;
    private boolean privateChat;

    public ChatMessage(Player player, String message, boolean privateChat) {
        this.player = player;
        this.sender = player.getId();
        this.message = message;
        this.privateChat = privateChat;
    }

    public ChatMessage(Game game, Element element) {
        this.sender = element.getAttribute("sender");
        if (this.sender == null) {
            throw new IllegalStateException("sender is null");
        }
        if (!(game.getFreeColGameObject(this.sender) instanceof Player)) {
            throw new IllegalStateException("not a player: " + this.sender);
        }
        this.player = (Player)game.getFreeColGameObject(this.sender);
        this.message = element.getAttribute("message");
        this.privateChat = Boolean.valueOf(element.getAttribute("privateChat"));
    }

    public Player getPlayer() {
        return this.player;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean isPrivate() {
        return this.privateChat;
    }

    public Element handle(FreeColServer server, Connection connection) {
        ServerPlayer serverPlayer = server.getPlayer(connection);
        this.sender = serverPlayer.getId();
        return server.getInGameController().chat(serverPlayer, this.message, this.privateChat);
    }

    public Element toXMLElement() {
        Element result = ChatMessage.createNewRootElement(ChatMessage.getXMLElementTagName());
        result.setAttribute("sender", this.sender);
        result.setAttribute("message", this.message);
        result.setAttribute("privateChat", String.valueOf(this.privateChat));
        return result;
    }

    public static String getXMLElementTagName() {
        return "chat";
    }
}

