/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

public class CashInTreasureTrainMessage
extends DOMMessage {
    private String unitId;

    public CashInTreasureTrainMessage(Unit unit) {
        this.unitId = unit.getId();
    }

    public CashInTreasureTrainMessage(Game game, Element element) {
        this.unitId = element.getAttribute("unit");
    }

    public Element handle(FreeColServer server, Player player, Connection connection) {
        Unit unit;
        ServerPlayer serverPlayer = server.getPlayer(connection);
        try {
            unit = server.getUnitSafely(this.unitId, serverPlayer);
        }
        catch (Exception e) {
            return DOMMessage.clientError(e.getMessage());
        }
        if (!unit.canCarryTreasure()) {
            return DOMMessage.clientError("Can not cash in unit " + this.unitId + ", can not carry treasure.");
        }
        if (!unit.canCashInTreasureTrain()) {
            return DOMMessage.clientError("Can not cash in unit " + this.unitId + ", unsuitable location.");
        }
        return server.getInGameController().cashInTreasureTrain(serverPlayer, unit);
    }

    public Element toXMLElement() {
        Element result = CashInTreasureTrainMessage.createNewRootElement(CashInTreasureTrainMessage.getXMLElementTagName());
        result.setAttribute("unit", this.unitId);
        return result;
    }

    public static String getXMLElementTagName() {
        return "cashInTreasureTrain";
    }
}

