/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import net.sf.freecol.common.model.StringTemplate;

public class Turn {
    private int turn = 1;
    private static int startingYear = 1492;
    private static int seasonYear = 1600;
    private static int[] ages = new int[]{1492, 1600, 1700};

    public Turn(int turn) {
        this.turn = turn;
    }

    public static int yearToTurn(int year) {
        return Turn.yearToTurn(year, Season.YEAR);
    }

    public static int yearToTurn(int year, Season season) {
        int turn = 1;
        if (year >= startingYear) {
            turn += year - startingYear;
            if (year >= seasonYear) {
                turn += year - seasonYear;
                if (season == Season.AUTUMN) {
                    ++turn;
                }
            }
        }
        return turn;
    }

    public Turn next() {
        return new Turn(this.turn + 1);
    }

    public int getNumber() {
        return this.turn;
    }

    public int getAge() {
        return Turn.getAge(this.getYear());
    }

    public static int getAge(int year) {
        for (int index = 0; index < ages.length; ++index) {
            if (year >= ages[index]) continue;
            return index;
        }
        return ages.length;
    }

    public boolean equals(Object o) {
        if (o instanceof Turn) {
            return this.turn == ((Turn)o).turn;
        }
        return false;
    }

    private static int getOffset(int turn) {
        return turn - (seasonYear - startingYear - 1);
    }

    public static int getYear(int turn) {
        int c = Turn.getOffset(turn);
        if (c < 0) {
            return startingYear + turn - 1;
        }
        return seasonYear + c / 2 - 1;
    }

    public int getYear() {
        return Turn.getYear(this.turn);
    }

    public String toString() {
        return Turn.toString(this.turn);
    }

    public static String toString(int turn) {
        return Turn.getSeason(turn).toString() + " " + Integer.toString(Turn.getYear(turn));
    }

    public static Season getSeason(int turn) {
        int c = Turn.getOffset(turn);
        if (c <= 1) {
            return Season.YEAR;
        }
        if (c % 2 == 0) {
            return Season.SPRING;
        }
        return Season.AUTUMN;
    }

    public Season getSeason() {
        return Turn.getSeason(this.turn);
    }

    public StringTemplate getLabel() {
        return Turn.getLabel(this.turn);
    }

    public static StringTemplate getLabel(int turn) {
        return StringTemplate.template("year." + (Object)((Object)Turn.getSeason(turn))).addAmount("%year%", Turn.getYear(turn));
    }

    public static final int getStartingYear() {
        return startingYear;
    }

    public static final void setStartingYear(int newStartingYear) {
        startingYear = newStartingYear;
    }

    public static final int getSeasonYear() {
        return seasonYear;
    }

    public static final void setSeasonYear(int newSeasonYear) {
        seasonYear = newSeasonYear;
    }

    public boolean isFirstSeasonTurn() {
        return this.turn == Turn.yearToTurn(seasonYear, Season.SPRING);
    }

    public static final int[] getAges() {
        return ages;
    }

    public static final void setAges(int[] newAges) {
        ages = newAges;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Season {
        YEAR,
        SPRING,
        AUTUMN;

    }
}

