/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Ability;
import net.sf.freecol.common.model.FeatureContainer;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.option.OptionGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FreeColGameObjectType
extends FreeColObject {
    private int index = -1;
    private int modifierIndex = 100;
    private boolean abstractType;
    private Specification specification = null;
    private FeatureContainer featureContainer;

    protected FreeColGameObjectType() {
    }

    public FreeColGameObjectType(String id) {
        this(id, null);
    }

    public FreeColGameObjectType(Specification specification) {
        this(null, specification);
    }

    public FreeColGameObjectType(String id, Specification specification) {
        this.setId(id);
        this.specification = specification;
        this.featureContainer = new FeatureContainer();
    }

    @Override
    public final Specification getSpecification() {
        return this.specification;
    }

    public final void setSpecification(Specification newSpecification) {
        this.specification = newSpecification;
    }

    public final FeatureContainer getFeatureContainer() {
        return this.featureContainer;
    }

    public final void setFeatureContainer(FeatureContainer newFeatureContainer) {
        this.featureContainer = newFeatureContainer;
    }

    protected final void setIndex(int index) {
        this.index = index;
    }

    protected int getIndex() {
        return this.index;
    }

    public final String getNameKey() {
        return this.getId() + ".name";
    }

    public final String getDescriptionKey() {
        return this.getId() + ".description";
    }

    @Override
    public boolean hasAbility(String id) {
        return this.featureContainer.hasAbility(id);
    }

    public boolean hasAbility(String id, FreeColGameObjectType type) {
        return this.featureContainer.hasAbility(id, type);
    }

    public void addAbility(Ability ability) {
        this.featureContainer.addAbility(ability);
    }

    public void addModifier(Modifier modifier) {
        this.featureContainer.addModifier(modifier);
    }

    public Set<Modifier> getModifierSet(String id) {
        return this.featureContainer.getModifierSet(id);
    }

    public void applyDifficultyLevel(OptionGroup difficulty) {
    }

    public final int getModifierIndex() {
        return this.modifierIndex;
    }

    public int getModifierIndex(Modifier modifier) {
        return this.modifierIndex;
    }

    public final void setModifierIndex(int newModifierIndex) {
        this.modifierIndex = newModifierIndex;
    }

    public final boolean isAbstractType() {
        return this.abstractType;
    }

    public final void setAbstractType(boolean newAbstract) {
        this.abstractType = newAbstract;
    }

    @Override
    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
    }

    protected void toXMLImpl(XMLStreamWriter out, String tag) throws XMLStreamException {
        super.toXML(out, tag);
    }

    @Override
    protected void writeChildren(XMLStreamWriter out) throws XMLStreamException {
        super.writeChildren(out);
        if (this.featureContainer != null) {
            for (Ability ability : this.featureContainer.getAbilities()) {
                ability.toXMLImpl(out);
            }
            for (Modifier modifier : this.featureContainer.getModifiers()) {
                modifier.toXMLImpl(out);
            }
        }
    }

    @Override
    protected void readAttributes(XMLStreamReader in) throws XMLStreamException {
        super.readAttributes(in);
        this.setAbstractType(FreeColGameObjectType.getAttribute(in, "abstract", false));
    }

    @Override
    protected void readChildren(XMLStreamReader in) throws XMLStreamException {
        while (in.nextTag() != 2) {
            this.readChild(in);
        }
    }

    protected void readChild(XMLStreamReader in) throws XMLStreamException {
        String childName = in.getLocalName();
        if (Ability.getXMLElementTagName().equals(childName)) {
            if (FreeColGameObjectType.getAttribute(in, "delete", false)) {
                String id = in.getAttributeValue(null, "id");
                this.featureContainer.removeAbilities(id);
                in.nextTag();
            } else {
                Ability ability = new Ability(in, this.specification);
                if (ability.getSource() == null) {
                    ability.setSource(this);
                }
                this.addAbility(ability);
                this.specification.addAbility(ability);
            }
        } else if (Modifier.getXMLElementTagName().equals(childName)) {
            if (FreeColGameObjectType.getAttribute(in, "delete", false)) {
                String id = in.getAttributeValue(null, "id");
                this.featureContainer.removeModifiers(id);
                in.nextTag();
            } else {
                Modifier modifier = new Modifier(in, this.specification);
                if (modifier.getSource() == null) {
                    modifier.setSource(this);
                }
                if (modifier.getIndex() < 0) {
                    modifier.setIndex(this.getModifierIndex(modifier));
                }
                this.addModifier(modifier);
                this.specification.addModifier(modifier);
            }
        } else {
            logger.warning("Parsing of " + childName + " is not implemented yet");
            while (in.nextTag() != 2 || !in.getLocalName().equals(childName)) {
                in.nextTag();
            }
        }
    }

    public String toString() {
        return this.getId();
    }
}

