/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.AbstractUnit;
import net.sf.freecol.common.model.NationType;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.option.BooleanOption;
import net.sf.freecol.common.option.OptionGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EuropeanNationType
extends NationType {
    private boolean ref = false;
    private List<AbstractUnit> startingUnits;
    private Map<String, Map<String, AbstractUnit>> startingUnitMap = new HashMap<String, Map<String, AbstractUnit>>();

    public EuropeanNationType(String id, Specification specification) {
        super(id, specification);
    }

    @Override
    public final boolean isREF() {
        return this.ref;
    }

    public final void setREF(boolean newREF) {
        this.ref = newREF;
    }

    @Override
    public boolean isEuropean() {
        return true;
    }

    @Override
    public boolean isIndian() {
        return false;
    }

    public List<AbstractUnit> getStartingUnits() {
        return this.startingUnits;
    }

    public List<AbstractUnit> getStartingUnits(String key) {
        HashMap<String, AbstractUnit> result = new HashMap<String, AbstractUnit>();
        Map<String, AbstractUnit> defaultMap = this.startingUnitMap.get(null);
        Map<String, AbstractUnit> difficultyMap = this.startingUnitMap.get(key);
        if (defaultMap != null) {
            result.putAll(defaultMap);
        }
        if (difficultyMap != null) {
            result.putAll(difficultyMap);
        }
        return new ArrayList<AbstractUnit>(result.values());
    }

    @Override
    public void applyDifficultyLevel(OptionGroup difficulty) {
        String experts = Boolean.toString(((BooleanOption)difficulty.getOption("model.option.expertStartingUnits")).getValue());
        this.startingUnits = this.getStartingUnits(experts);
    }

    @Override
    public void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        super.toXML(out, EuropeanNationType.getXMLElementTagName());
    }

    @Override
    public void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        super.writeAttributes(out);
        out.writeAttribute("ref", Boolean.toString(this.ref));
    }

    @Override
    protected void writeChildren(XMLStreamWriter out) throws XMLStreamException {
        super.writeChildren(out);
        if (this.startingUnitMap != null && !this.startingUnitMap.isEmpty()) {
            for (Map.Entry<String, AbstractUnit> entry : this.startingUnitMap.get(null).entrySet()) {
                this.writeUnit(out, entry.getKey(), entry.getValue(), false);
            }
            for (Map.Entry<String, AbstractUnit> entry : this.startingUnitMap.get("true").entrySet()) {
                this.writeUnit(out, entry.getKey(), entry.getValue(), true);
            }
        }
    }

    private void writeUnit(XMLStreamWriter out, String id, AbstractUnit unit, boolean expert) throws XMLStreamException {
        out.writeStartElement("unit");
        out.writeAttribute("id", id);
        out.writeAttribute("type", unit.getId());
        out.writeAttribute("role", unit.getRole().toString().toLowerCase(Locale.US));
        if (expert) {
            out.writeAttribute("expert-starting-units", "true");
        }
        out.writeEndElement();
    }

    @Override
    protected void readAttributes(XMLStreamReader in) throws XMLStreamException {
        super.readAttributes(in);
        String extendString = in.getAttributeValue(null, "extends");
        EuropeanNationType parent = extendString == null ? this : (EuropeanNationType)this.getSpecification().getNationType(extendString);
        this.ref = EuropeanNationType.getAttribute(in, "ref", parent.ref);
        if (parent != this) {
            for (Map.Entry<String, Map<String, AbstractUnit>> entry : parent.startingUnitMap.entrySet()) {
                this.startingUnitMap.put(entry.getKey(), new HashMap<String, AbstractUnit>(entry.getValue()));
            }
            this.getSettlementTypes().addAll(parent.getSettlementTypes());
            this.getFeatureContainer().add(parent.getFeatureContainer());
            if (parent.isAbstractType()) {
                this.getFeatureContainer().replaceSource(parent, this);
            }
        }
    }

    @Override
    protected void readChild(XMLStreamReader in) throws XMLStreamException {
        String childName = in.getLocalName();
        if ("unit".equals(childName)) {
            String id = in.getAttributeValue(null, "id");
            String type = in.getAttributeValue(null, "type");
            Unit.Role role = Enum.valueOf(Unit.Role.class, this.getAttribute(in, "role", "default").toUpperCase(Locale.US));
            String useExperts = in.getAttributeValue(null, "expert-starting-units");
            AbstractUnit unit = new AbstractUnit(type, role, 1);
            Map<String, AbstractUnit> units = this.startingUnitMap.get(useExperts);
            if (units == null) {
                units = new HashMap<String, AbstractUnit>();
                this.startingUnitMap.put(useExperts, units);
            }
            units.put(id, unit);
            in.nextTag();
        } else {
            super.readChild(in);
        }
    }

    public static String getXMLElementTagName() {
        return "european-nation-type";
    }
}

