/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.BuildingType;
import net.sf.freecol.common.model.Consumer;
import net.sf.freecol.common.model.FeatureContainer;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Locatable;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Named;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.ProductionInfo;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.WorkLocation;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Building
extends WorkLocation
implements Named,
Comparable<Building>,
Consumer {
    private static final Logger logger = Logger.getLogger(Building.class.getName());
    public static final String UNIT_CHANGE = "UNIT_CHANGE";
    protected BuildingType buildingType;

    protected Building() {
    }

    protected Building(Game game) {
        super(game);
    }

    public Building(Game game, XMLStreamReader in) throws XMLStreamException {
        super(game, in);
        this.readFromXML(in);
    }

    public Building(Game game, Element e) {
        super(game, e);
        this.readFromXMLElement(e);
    }

    public Building(Game game, String id) {
        super(game, id);
    }

    @Override
    public String getNameKey() {
        return this.buildingType.getNameKey();
    }

    public int getLevel() {
        return this.buildingType.getLevel();
    }

    @Override
    public StringTemplate getLocationName() {
        return StringTemplate.template("inLocation").add("%location%", this.getNameKey());
    }

    public String getNextNameKey() {
        BuildingType next = this.buildingType.getUpgradesTo();
        return next == null ? null : next.getNameKey();
    }

    public boolean canBuildNext() {
        return this.getColony().canBuild(this.buildingType.getUpgradesTo());
    }

    public BuildingType getType() {
        return this.buildingType;
    }

    @Override
    public boolean hasAbility(String id) {
        return this.getType().hasAbility(id);
    }

    public boolean canTeach() {
        return this.hasAbility("model.ability.teach");
    }

    public boolean canBeDamaged() {
        return !this.buildingType.isAutomaticBuild() && !this.getColony().isAutomaticBuild(this.buildingType);
    }

    public boolean damage() {
        if (this.canBeDamaged()) {
            this.setType(this.buildingType.getUpgradesFrom());
            return true;
        }
        return false;
    }

    public boolean upgrade() {
        if (this.canBuildNext()) {
            this.setType(this.buildingType.getUpgradesTo());
            return true;
        }
        return false;
    }

    private void setType(BuildingType newBuildingType) {
        this.getColony().getFeatureContainer().remove(this.buildingType.getFeatureContainer());
        if (newBuildingType != null) {
            this.buildingType = newBuildingType;
            this.getColony().getFeatureContainer().add(this.buildingType.getFeatureContainer());
            for (Unit unit : this.getUnitList()) {
                if (this.canAdd(unit.getType())) continue;
                unit.putOutsideColony();
            }
        }
        if (this.getUnitCount() > this.getUnitCapacity()) {
            for (Unit unit : new ArrayList<Unit>(this.getUnitList().subList(this.getUnitCapacity(), this.getUnitCount()))) {
                unit.putOutsideColony();
            }
        }
    }

    @Override
    public int getUnitCapacity() {
        return this.buildingType.getWorkPlaces();
    }

    public UnitType getExpertUnitType() {
        return this.getSpecification().getExpertForProducing(this.getGoodsOutputType());
    }

    @Override
    public boolean canAdd(Locatable locatable) {
        if (locatable.getLocation() == this) {
            return true;
        }
        if (this.getUnitCount() >= this.getUnitCapacity()) {
            return false;
        }
        if (!(locatable instanceof Unit)) {
            return false;
        }
        return this.canAdd(((Unit)locatable).getType());
    }

    public boolean canAdd(UnitType unitType) {
        return this.buildingType.canAdd(unitType);
    }

    @Override
    public void add(Locatable locatable) {
        if (!this.canAdd(locatable)) {
            throw new IllegalStateException("Can not add " + locatable + " to " + this.toString());
        }
        if (this.getUnitList().contains(locatable)) {
            return;
        }
        Unit unit = (Unit)locatable;
        this.getUnitList().add(unit);
        unit.setState(Unit.UnitState.IN_COLONY);
        unit.setWorkType(this.getGoodsOutputType());
        this.getColony().invalidateCache();
        if (this.canTeach()) {
            Unit student = unit.getStudent();
            if (student == null && (student = this.getColony().findStudent(unit)) != null) {
                unit.setStudent(student);
                student.setTeacher(unit);
            }
            unit.setWorkType(null);
        } else {
            Unit teacher = unit.getTeacher();
            if (teacher == null && (teacher = this.getColony().findTeacher(unit)) != null) {
                unit.setTeacher(teacher);
                teacher.setStudent(unit);
            }
        }
    }

    @Override
    public void remove(Locatable locatable) {
        if (!(locatable instanceof Unit)) {
            throw new IllegalStateException("Can only remove units from building.");
        }
        Unit unit = (Unit)locatable;
        if (this.getUnitList().remove(unit)) {
            unit.setMovesLeft(0);
            unit.setState(Unit.UnitState.ACTIVE);
            this.getColony().invalidateCache();
            if (this.canTeach()) {
                Unit student = unit.getStudent();
                if (student != null) {
                    student.setTeacher(null);
                    unit.setStudent(null);
                }
            } else {
                Unit teacher = unit.getTeacher();
                if (teacher != null) {
                    teacher.setStudent(null);
                    unit.setTeacher(null);
                }
            }
        }
    }

    public GoodsType getGoodsOutputType() {
        return this.getType().getProducedGoodsType();
    }

    public GoodsType getGoodsInputType() {
        return this.getType().getConsumedGoodsType();
    }

    public ProductionInfo getProductionInfo() {
        return this.getColony().getProductionInfo(this);
    }

    public ProductionInfo getProductionInfo(AbstractGoods output, List<AbstractGoods> input) {
        ProductionInfo result = new ProductionInfo();
        GoodsType outputType = this.getGoodsOutputType();
        GoodsType inputType = this.getGoodsInputType();
        if (outputType != null && outputType != output.getType()) {
            throw new IllegalArgumentException("Wrong output type: " + output.getType() + " should have been: " + outputType);
        }
        int capacity = this.getColony().getWarehouseCapacity();
        if (this.buildingType.hasAbility("model.ability.avoidExcessProduction") && output.getAmount() >= capacity) {
            return result;
        }
        int availableInput = 0;
        if (inputType != null) {
            boolean found = false;
            for (AbstractGoods goods : input) {
                if (goods.getType() != inputType) continue;
                availableInput = goods.getAmount();
                found = true;
                break;
            }
            if (!found) {
                throw new IllegalArgumentException("No input goods of type " + inputType + " available.");
            }
        }
        if (outputType != null) {
            int production;
            int actualInput;
            int maximumInput = 0;
            if (inputType != null && this.canAutoProduce()) {
                int available = this.getColony().getGoodsCount(outputType);
                if (available >= outputType.getBreedingNumber()) {
                    int divisor = (int)this.getType().getFeatureContainer().applyModifier(0.0f, "model.modifier.breedingDivisor");
                    int factor = (int)this.getType().getFeatureContainer().applyModifier(0.0f, "model.modifier.breedingFactor");
                    maximumInput = ((available - 1) / divisor + 1) * factor;
                }
            } else {
                maximumInput = this.getProductivity(new Unit[0]);
            }
            List<Modifier> productionModifiers = this.getProductionModifiers();
            int maximumProduction = (int)FeatureContainer.applyModifiers(maximumInput, this.getGame().getTurn(), productionModifiers);
            int n = actualInput = inputType == null ? maximumInput : Math.min(maximumInput, availableInput);
            if (availableInput < maximumInput && this.buildingType.hasAbility("model.ability.expertsUseConnections") && this.getSpecification().getBoolean("model.option.expertsHaveConnections")) {
                int minimumGoodsInput = 0;
                for (Unit unit : this.getUnitList()) {
                    if (unit.getType() != this.getExpertUnitType()) continue;
                    minimumGoodsInput += 4;
                }
                if (minimumGoodsInput > availableInput) {
                    actualInput = minimumGoodsInput;
                }
            }
            if ((production = (int)FeatureContainer.applyModifiers(actualInput, this.getGame().getTurn(), productionModifiers)) > 0) {
                if (this.buildingType.hasAbility("model.ability.avoidExcessProduction")) {
                    int total = output.getAmount() + production;
                    while (total > capacity) {
                        if (actualInput <= 0) {
                            return result;
                        }
                        production = (int)FeatureContainer.applyModifiers(--actualInput, this.getGame().getTurn(), productionModifiers);
                        total = output.getAmount() + production;
                        maximumInput = actualInput;
                        maximumProduction = production;
                    }
                }
                result.addProduction(new AbstractGoods(outputType, production));
                if (maximumProduction > production) {
                    result.addMaximumProduction(new AbstractGoods(outputType, maximumProduction));
                }
                if (inputType != null) {
                    result.addConsumption(new AbstractGoods(inputType, actualInput));
                    if (maximumInput > actualInput) {
                        result.addMaximumConsumption(new AbstractGoods(inputType, maximumInput));
                    }
                }
            }
        }
        return result;
    }

    public int getProduction() {
        List<AbstractGoods> production = this.getProductionInfo().getProduction();
        if (production == null || production.isEmpty()) {
            return 0;
        }
        return production.get(0).getAmount();
    }

    public int getMaximumProduction() {
        List<AbstractGoods> production = this.getProductionInfo().getMaximumProduction();
        if (production == null || production.isEmpty()) {
            return this.getProduction();
        }
        return production.get(0).getAmount();
    }

    public int getAdditionalProductionNextTurn(Unit addUnit) {
        return this.getUnitProductivity(addUnit);
    }

    public boolean canAutoProduce() {
        return this.buildingType.hasAbility("model.ability.autoProduction");
    }

    @Override
    public int getProductionOf(GoodsType goodsType) {
        if (goodsType == this.getGoodsOutputType()) {
            return this.getProduction();
        }
        return 0;
    }

    private int getProductivity(Unit ... additionalUnits) {
        if (this.getGoodsOutputType() == null) {
            return 0;
        }
        int productivity = 0;
        for (Unit unit : this.getUnitList()) {
            productivity += this.getUnitProductivity(unit);
        }
        for (Unit unit : additionalUnits) {
            if (!this.canAdd(unit)) continue;
            productivity += this.getUnitProductivity(unit);
        }
        return productivity;
    }

    public int getUnitProductivity(Unit prodUnit) {
        if (this.getGoodsOutputType() == null || prodUnit == null) {
            return 0;
        }
        int productivity = this.buildingType.getBasicProduction();
        if (productivity > 0) {
            return (int)prodUnit.getType().getFeatureContainer().applyModifier(Math.max(1, productivity += this.getColony().getProductionBonus()), this.getGoodsOutputType().getId());
        }
        return 0;
    }

    @Override
    public int getPotentialProduction(UnitType unitType, GoodsType goodsType) {
        int production = 0;
        if (this.getGoodsOutputType() == goodsType && (production += this.buildingType.getBasicProduction()) > 0) {
            production += this.getColony().getProductionBonus();
            production = (int)unitType.getFeatureContainer().applyModifier(Math.max(1, production), this.getGoodsOutputType().getId());
            unitType.getFeatureContainer();
            production = (int)FeatureContainer.applyModifiers(production, this.getGame().getTurn(), this.getProductionModifiers());
        }
        return production;
    }

    public List<Modifier> getProductionModifiers() {
        ArrayList<Modifier> modifiers = new ArrayList<Modifier>();
        GoodsType goodsOutputType = this.getGoodsOutputType();
        if (goodsOutputType != null) {
            modifiers.addAll(this.getColony().getFeatureContainer().getModifierSet(goodsOutputType.getId(), this.buildingType, this.getGame().getTurn()));
            if (this.getOwner() != null) {
                modifiers.addAll(this.getOwner().getFeatureContainer().getModifierSet(goodsOutputType.getId(), this.buildingType, this.getGame().getTurn()));
            }
            Collections.sort(modifiers);
        }
        return modifiers;
    }

    @Override
    public int compareTo(Building other) {
        return this.getType().compareTo(other.getType());
    }

    @Override
    public List<FreeColGameObject> disposeList() {
        ArrayList<FreeColGameObject> objects = new ArrayList<FreeColGameObject>();
        while (!this.getUnitList().isEmpty()) {
            objects.addAll(this.getUnitList().remove(0).disposeList());
        }
        objects.addAll(super.disposeList());
        return objects;
    }

    @Override
    public void dispose() {
        this.disposeList();
    }

    public boolean consumes(GoodsType goodsType) {
        return goodsType == this.getGoodsInputType();
    }

    @Override
    public List<AbstractGoods> getConsumedGoods() {
        ArrayList<AbstractGoods> result = new ArrayList<AbstractGoods>();
        GoodsType inputType = this.getGoodsInputType();
        if (inputType != null) {
            result.add(new AbstractGoods(inputType, 0));
        }
        return result;
    }

    @Override
    public int getPriority() {
        return this.buildingType.getPriority();
    }

    @Override
    public Set<Modifier> getModifierSet(String id) {
        return this.buildingType.getModifierSet(id);
    }

    @Override
    protected void toXMLImpl(XMLStreamWriter out, Player player, boolean showAll, boolean toSavedGame) throws XMLStreamException {
        out.writeStartElement(Building.getXMLElementTagName());
        super.writeAttributes(out);
        out.writeAttribute("buildingType", this.buildingType.getId());
        super.writeChildren(out);
        out.writeEndElement();
    }

    @Override
    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        super.readAttributes(in);
        this.buildingType = this.getSpecification().getBuildingType(in.getAttributeValue(null, "buildingType"));
        super.readChildren(in);
    }

    @Override
    protected void toXMLPartialImpl(XMLStreamWriter out, String[] fields) throws XMLStreamException {
        this.toXMLPartialByClass(out, this.getClass(), fields);
    }

    @Override
    protected void readFromXMLPartialImpl(XMLStreamReader in) throws XMLStreamException {
        this.readFromXMLPartialByClass(in, this.getClass());
    }

    @Override
    public String toString() {
        return this.getType().getId() + " [" + this.getColony().getName() + "]";
    }

    public static String getXMLElementTagName() {
        return "building";
    }
}

