/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.plaf;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.UIResource;

public class FreeColComboBoxRenderer
implements ListCellRenderer,
UIResource {
    private final SelectedComponent SELECTED_COMPONENT = new SelectedComponent();
    private final NormalComponent NORMAL_COMPONENT = new NormalComponent();

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
        JLabel c = isSelected ? this.SELECTED_COMPONENT : this.NORMAL_COMPONENT;
        c.setForeground(list.getForeground());
        c.setFont(list.getFont());
        this.setLabelValues(c, value);
        return c;
    }

    public void setLabelValues(JLabel c, Object value) {
        if (value instanceof Icon) {
            c.setIcon((Icon)value);
        } else {
            c.setText(value == null ? null : value.toString());
        }
    }

    private class NormalComponent
    extends JLabel {
        public NormalComponent() {
            this.setOpaque(false);
        }
    }

    private class SelectedComponent
    extends JLabel {
        public SelectedComponent() {
            this.setOpaque(false);
        }

        public void paintComponent(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            Composite oldComposite = g2d.getComposite();
            Color oldColor = g2d.getColor();
            g2d.setComposite(AlphaComposite.getInstance(3, 0.1f));
            g2d.setColor(Color.BLACK);
            g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
            g2d.setComposite(oldComposite);
            g2d.setColor(oldColor);
            super.paintComponent(g);
        }
    }
}

