/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import javax.swing.border.AbstractBorder;
import net.sf.freecol.common.resources.ResourceManager;

public class FreeColImageBorder
extends AbstractBorder {
    private BufferedImage topImage;
    private BufferedImage leftImage;
    private BufferedImage bottomImage;
    private BufferedImage rightImage;
    private BufferedImage topLeftCornerImage;
    private BufferedImage topRightCornerImage;
    private BufferedImage bottomLeftCornerImage;
    private BufferedImage bottomRightCornerImage;
    public static final FreeColImageBorder imageBorder = new FreeColImageBorder(ResourceManager.getImage("menuborder.n.image"), ResourceManager.getImage("menuborder.w.image"), ResourceManager.getImage("menuborder.s.image"), ResourceManager.getImage("menuborder.e.image"), ResourceManager.getImage("menuborder.nw.image"), ResourceManager.getImage("menuborder.ne.image"), ResourceManager.getImage("menuborder.sw.image"), ResourceManager.getImage("menuborder.se.image"));

    public FreeColImageBorder(Image topImage, Image leftImage, Image bottomImage, Image rightImage, Image topLeftCornerImage, Image topRightCornerImage, Image bottomLeftCornerImage, Image bottomRightCornerImage) {
        this.topImage = this.createBufferedImage(topImage);
        this.leftImage = this.createBufferedImage(leftImage);
        this.bottomImage = this.createBufferedImage(bottomImage);
        this.rightImage = this.createBufferedImage(rightImage);
        this.topLeftCornerImage = this.createBufferedImage(topLeftCornerImage);
        this.topRightCornerImage = this.createBufferedImage(topRightCornerImage);
        this.bottomLeftCornerImage = this.createBufferedImage(bottomLeftCornerImage);
        this.bottomRightCornerImage = this.createBufferedImage(bottomRightCornerImage);
    }

    private BufferedImage createBufferedImage(Image img) {
        if (img != null) {
            BufferedImage buff = new BufferedImage(this.getWidth(img), this.getHeight(img), 2);
            Graphics2D gfx = buff.createGraphics();
            gfx.drawImage(img, 0, 0, null);
            gfx.dispose();
            return buff;
        }
        return null;
    }

    public Insets getBorderInsets(Component c) {
        return this.getBorderInsets(c, null);
    }

    public Insets getBorderInsets(Component c, Insets insets) {
        int top = Math.max(Math.max(this.getHeight(this.topImage), this.getHeight(this.topLeftCornerImage)), this.getHeight(this.topRightCornerImage));
        int left = Math.max(Math.max(this.getWidth(this.leftImage), this.getWidth(this.topLeftCornerImage)), this.getWidth(this.bottomLeftCornerImage));
        int bottom = Math.max(Math.max(this.getHeight(this.bottomImage), this.getHeight(this.bottomLeftCornerImage)), this.getHeight(this.bottomRightCornerImage));
        int right = Math.max(Math.max(this.getWidth(this.rightImage), this.getWidth(this.topRightCornerImage)), this.getWidth(this.bottomRightCornerImage));
        if (this.leftImage == null) {
            left = 0;
        }
        if (this.rightImage == null) {
            right = 0;
        }
        if (this.topImage == null) {
            top = 0;
        }
        if (this.bottomImage == null) {
            bottom = 0;
        }
        if (insets == null) {
            return new Insets(top, left, bottom, right);
        }
        insets.top = top;
        insets.left = left;
        insets.bottom = bottom;
        insets.right = right;
        return insets;
    }

    private int getHeight(Image im) {
        return im != null ? im.getHeight(null) : 0;
    }

    private int getWidth(Image im) {
        return im != null ? im.getWidth(null) : 0;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Insets insets = this.getBorderInsets(c);
        Graphics2D g2 = (Graphics2D)g;
        int topHeight = this.getHeight(this.topImage);
        int leftWidth = this.getWidth(this.leftImage);
        int bottomHeight = this.getHeight(this.bottomImage);
        int rightWidth = this.getWidth(this.rightImage);
        int topLeftCornerWidth = this.getWidth(this.topLeftCornerImage);
        int topLeftCornerHeight = this.getHeight(this.topLeftCornerImage);
        int topRightCornerWidth = this.getWidth(this.topRightCornerImage);
        int topRightCornerHeight = this.getHeight(this.topRightCornerImage);
        int bottomLeftCornerWidth = this.getWidth(this.bottomLeftCornerImage);
        int bottomLeftCornerHeight = this.getHeight(this.bottomLeftCornerImage);
        int bottomRightCornerWidth = this.getWidth(this.bottomRightCornerImage);
        int bottomRightCornerHeight = this.getHeight(this.bottomRightCornerImage);
        if (this.topImage != null) {
            this.fillTexture(g2, this.topImage, x + topLeftCornerWidth, y + insets.top - topHeight, width - topLeftCornerWidth - topRightCornerWidth, topHeight);
        }
        if (this.leftImage != null) {
            this.fillTexture(g2, this.leftImage, x + insets.left - leftWidth, y + topLeftCornerHeight, leftWidth, height - topLeftCornerHeight - bottomLeftCornerHeight);
        }
        if (this.bottomImage != null) {
            this.fillTexture(g2, this.bottomImage, x + bottomLeftCornerWidth, y + height - insets.bottom, width - bottomLeftCornerWidth - bottomRightCornerWidth, bottomHeight);
        }
        if (this.rightImage != null) {
            this.fillTexture(g2, this.rightImage, x + width - insets.right, y + topRightCornerHeight, rightWidth, height - topRightCornerHeight - bottomRightCornerHeight);
        }
        if (this.topLeftCornerImage != null) {
            this.fillTexture(g2, this.topLeftCornerImage, x + Math.max(insets.left, topLeftCornerWidth) - topLeftCornerWidth, y + Math.max(insets.top, topLeftCornerHeight) - topLeftCornerHeight, topLeftCornerWidth, topLeftCornerHeight);
        }
        if (this.topRightCornerImage != null) {
            this.fillTexture(g2, this.topRightCornerImage, x + width - Math.max(insets.right, topRightCornerWidth), y + Math.max(insets.top, topRightCornerHeight) - topRightCornerHeight, topRightCornerWidth, topRightCornerHeight);
        }
        if (this.bottomLeftCornerImage != null) {
            this.fillTexture(g2, this.bottomLeftCornerImage, x + Math.max(insets.left, bottomLeftCornerWidth) - bottomLeftCornerWidth, y + height - Math.max(insets.bottom, bottomLeftCornerHeight), bottomLeftCornerWidth, bottomLeftCornerHeight);
        }
        if (this.bottomRightCornerImage != null) {
            this.fillTexture(g2, this.bottomRightCornerImage, x + width - Math.max(insets.right, bottomRightCornerWidth), y + height - Math.max(insets.bottom, bottomRightCornerHeight), bottomRightCornerWidth, bottomRightCornerHeight);
        }
    }

    public void fillTexture(Graphics2D g2, BufferedImage img, int x, int y, int width, int height) {
        Rectangle anchor = new Rectangle(x, y, this.getWidth(img), this.getHeight(img));
        TexturePaint paint = new TexturePaint(img, anchor);
        g2.setPaint(paint);
        g2.fillRect(x, y, width, height);
    }
}

