/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.util.LinkedList;
import java.util.logging.Logger;
import javax.swing.JLabel;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.panel.FreeColDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ErrorPanel
extends FreeColDialog<Boolean>
implements ActionListener {
    private static final Logger logger = Logger.getLogger(ErrorPanel.class.getName());
    private static final int lineWidth = 320;
    private LinkedList<JLabel> errorLabels;

    public ErrorPanel(Canvas parent) {
        super(parent);
        this.setLayout(null);
        this.errorLabels = null;
    }

    public void initialize(String message) {
        int i;
        LinkedList<String> lines = new LinkedList<String>();
        while (this.getFontMetrics(this.getFont()).getStringBounds(message, this.getGraphics()).getWidth() + 40.0 > 320.0) {
            int spaceIndex = message.indexOf(32);
            int previousIndex = -1;
            while (this.getFontMetrics(this.getFont()).getStringBounds(message.substring(0, spaceIndex), this.getGraphics()).getWidth() + 40.0 <= 320.0) {
                previousIndex = spaceIndex;
                if (spaceIndex + 1 >= message.length()) {
                    spaceIndex = 0;
                    break;
                }
                if ((spaceIndex = message.indexOf(32, spaceIndex + 1)) != -1) continue;
                spaceIndex = 0;
                break;
            }
            if (previousIndex >= 0 && spaceIndex >= 0) {
                lines.add(message.substring(0, previousIndex));
                if (previousIndex + 1 >= message.length()) break;
                message = message.substring(previousIndex + 1);
                continue;
            }
            lines.add(message);
            lines.add("Internal error in ErrorPanel");
            break;
        }
        if (message.trim().length() > 0) {
            lines.add(message);
        }
        if (this.errorLabels != null) {
            for (i = 0; i < this.errorLabels.size(); ++i) {
                this.remove(this.errorLabels.get(i));
            }
            this.errorLabels.clear();
        } else {
            this.errorLabels = new LinkedList();
        }
        for (i = 0; i < lines.size(); ++i) {
            JLabel label = new JLabel((String)lines.get(i));
            label.setSize(320, 20);
            label.setLocation(10, 2 + i * 20);
            this.add(label);
            this.errorLabels.add(label);
        }
        this.okButton.setLocation(130, 25 + (lines.size() - 1) * 20);
        Rectangle2D rect = this.getFontMetrics(this.getFont()).getStringBounds(this.okButton.getText(), this.getGraphics());
        this.okButton.setSize((int)rect.getWidth() + 40, 25);
        this.add(this.okButton);
        this.setSize(340, 50 + (lines.size() - 1) * 20);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        super.actionPerformed(event);
        this.setResponse(true);
    }
}

