/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.Autoscroll;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ComponentInputMap;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolTip;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.BuildQueuePanel;
import net.sf.freecol.client.gui.panel.BuildingPanel;
import net.sf.freecol.client.gui.panel.CargoPanel;
import net.sf.freecol.client.gui.panel.ChoiceItem;
import net.sf.freecol.client.gui.panel.ConstructionPanel;
import net.sf.freecol.client.gui.panel.DefaultTransferHandler;
import net.sf.freecol.client.gui.panel.DragListener;
import net.sf.freecol.client.gui.panel.DropListener;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.GoodsLabel;
import net.sf.freecol.client.gui.panel.ProductionLabel;
import net.sf.freecol.client.gui.panel.RebelToolTip;
import net.sf.freecol.client.gui.panel.UnitLabel;
import net.sf.freecol.client.gui.panel.WarehouseDialog;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ColonyTile;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsContainer;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.ModelMessage;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.TradeRoute;
import net.sf.freecol.common.model.Unit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ColonyPanel
extends FreeColPanel
implements ActionListener,
PropertyChangeListener {
    private static Logger logger = Logger.getLogger(ColonyPanel.class.getName());
    public static final int SCROLL_AREA_HEIGHT = 40;
    public static final int SCROLL_SPEED = 40;
    private static final int EXIT = 0;
    private static final int BUILDQUEUE = 1;
    private static final int UNLOAD = 2;
    private static final int WAREHOUSE = 4;
    private static final int FILL = 5;
    private static final int SETGOODS = 6;
    private final JPanel netProductionPanel = new JPanel();
    private final PopulationPanel populationPanel = new PopulationPanel();
    private final JComboBox nameBox;
    private final OutsideColonyPanel outsideColonyPanel;
    private final InPortPanel inPortPanel;
    private final ColonyCargoPanel cargoPanel;
    private final WarehousePanel warehousePanel;
    private final TilePanel tilePanel;
    private final BuildingsPanel buildingsPanel;
    private final ConstructionPanel constructionPanel;
    private final DefaultTransferHandler defaultTransferHandler;
    private final MouseListener pressListener;
    private final MouseListener releaseListener;
    private Colony colony;
    private UnitLabel selectedUnitLabel;
    private JButton unloadButton = new JButton(Messages.message("unload"));
    private JButton fillButton = new JButton(Messages.message("fill"));
    private JButton warehouseButton = new JButton(Messages.message("warehouseDialog.name"));
    private JButton buildQueueButton = new JButton(Messages.message("colonyPanel.buildQueue"));
    private JButton setGoodsButton = FreeCol.isInDebugMode() ? new JButton("Set Goods") : null;

    public ColonyPanel(Canvas parent, Colony colony) {
        super(parent);
        this.setFocusCycleRoot(true);
        ComponentInputMap closeInputMap = new ComponentInputMap(this.okButton);
        ((InputMap)closeInputMap).put(KeyStroke.getKeyStroke(27, 0, false), "pressed");
        ((InputMap)closeInputMap).put(KeyStroke.getKeyStroke(27, 0, true), "released");
        SwingUtilities.replaceUIInputMap(this.okButton, 2, closeInputMap);
        ComponentInputMap unloadInputMap = new ComponentInputMap(this.unloadButton);
        ((InputMap)unloadInputMap).put(KeyStroke.getKeyStroke(85, 0, false), "pressed");
        ((InputMap)unloadInputMap).put(KeyStroke.getKeyStroke(85, 0, true), "released");
        SwingUtilities.replaceUIInputMap(this.unloadButton, 2, unloadInputMap);
        ComponentInputMap fillInputMap = new ComponentInputMap(this.fillButton);
        ((InputMap)fillInputMap).put(KeyStroke.getKeyStroke(76, 0, false), "pressed");
        ((InputMap)fillInputMap).put(KeyStroke.getKeyStroke(76, 0, true), "released");
        SwingUtilities.replaceUIInputMap(this.fillButton, 2, fillInputMap);
        this.netProductionPanel.setOpaque(false);
        this.constructionPanel = new ConstructionPanel(parent, colony, true);
        this.constructionPanel.setOpaque(true);
        this.outsideColonyPanel = new OutsideColonyPanel();
        this.inPortPanel = new InPortPanel();
        this.warehousePanel = new WarehousePanel(this);
        this.tilePanel = new TilePanel(this);
        this.buildingsPanel = new BuildingsPanel(this);
        this.cargoPanel = new ColonyCargoPanel(parent);
        this.cargoPanel.setParentPanel(this);
        this.defaultTransferHandler = new DefaultTransferHandler(parent, this);
        this.pressListener = new DragListener(this);
        this.releaseListener = new DropListener();
        JScrollPane outsideColonyScroll = new JScrollPane(this.outsideColonyPanel, 20, 31);
        outsideColonyScroll.getVerticalScrollBar().setUnitIncrement(16);
        JScrollPane inPortScroll = new JScrollPane(this.inPortPanel);
        inPortScroll.getVerticalScrollBar().setUnitIncrement(16);
        JScrollPane cargoScroll = new JScrollPane(this.cargoPanel, 21, 30);
        JScrollPane warehouseScroll = new JScrollPane(this.warehousePanel, 21, 30);
        JScrollPane tilesScroll = new JScrollPane(this.tilePanel, 20, 30);
        JScrollPane buildingsScroll = new JScrollPane(this.buildingsPanel, 20, 30);
        buildingsScroll.getVerticalScrollBar().setUnitIncrement(16);
        this.nameBox = new JComboBox();
        this.nameBox.setFont(smallHeaderFont);
        for (Colony aColony : this.getSortedColonies()) {
            this.nameBox.addItem(aColony);
        }
        this.nameBox.setSelectedItem(colony);
        this.nameBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ColonyPanel.this.initialize((Colony)ColonyPanel.this.nameBox.getSelectedItem());
            }
        });
        this.nameBox.getInputMap().put(KeyStroke.getKeyStroke("LEFT"), "selectPrevious2");
        this.nameBox.getInputMap().put(KeyStroke.getKeyStroke("RIGHT"), "selectNext2");
        buildingsScroll.setAutoscrolls(true);
        buildingsScroll.getViewport().setOpaque(false);
        this.buildingsPanel.setOpaque(false);
        tilesScroll.setBorder(BorderFactory.createBevelBorder(1));
        buildingsScroll.setBorder(BorderFactory.createEtchedBorder());
        warehouseScroll.setBorder(BorderFactory.createEtchedBorder());
        cargoScroll.setBorder(BorderFactory.createEtchedBorder());
        inPortScroll.setBorder(BorderFactory.createEtchedBorder());
        outsideColonyScroll.setBorder(BorderFactory.createEtchedBorder());
        this.okButton.setText(Messages.message("close"));
        this.unloadButton.setActionCommand(String.valueOf(2));
        ColonyPanel.enterPressesWhenFocused(this.unloadButton);
        this.unloadButton.addActionListener(this);
        this.fillButton.setActionCommand(String.valueOf(5));
        ColonyPanel.enterPressesWhenFocused(this.fillButton);
        this.fillButton.addActionListener(this);
        this.warehouseButton.setActionCommand(String.valueOf(4));
        ColonyPanel.enterPressesWhenFocused(this.warehouseButton);
        this.warehouseButton.addActionListener(this);
        this.buildQueueButton.setActionCommand(String.valueOf(1));
        ColonyPanel.enterPressesWhenFocused(this.buildQueueButton);
        this.buildQueueButton.addActionListener(this);
        if (this.setGoodsButton != null) {
            this.setGoodsButton.setActionCommand(String.valueOf(6));
            ColonyPanel.enterPressesWhenFocused(this.setGoodsButton);
            this.setGoodsButton.addActionListener(this);
        }
        this.selectedUnitLabel = null;
        this.addMouseListener(new MouseAdapter(){});
        this.setLayout((LayoutManager)new MigLayout("fill, wrap 2, insets 2", "[390!][fill]", "[][]0[]0[][growprio 200,shrinkprio 10][growprio 150,shrinkprio 50]"));
        this.add((Component)this.nameBox, "height 48:, grow");
        this.add((Component)this.netProductionPanel, "growx");
        this.add((Component)tilesScroll, "width 390!, height 200!, top");
        this.add((Component)buildingsScroll, "span 1 3, grow");
        this.add((Component)this.populationPanel, "grow");
        this.add((Component)this.constructionPanel, "grow, top");
        this.add((Component)inPortScroll, "span, split 3, grow, sg, height 60:121:");
        this.add((Component)cargoScroll, "grow, sg, height 60:121:");
        this.add((Component)outsideColonyScroll, "grow, sg, height 60:121:");
        this.add((Component)warehouseScroll, "span, height 40:60:, growx");
        this.add((Component)this.unloadButton, "span, split " + Integer.toString(this.setGoodsButton == null ? 5 : 6) + ", align center");
        this.add(this.fillButton);
        this.add(this.warehouseButton);
        this.add(this.buildQueueButton);
        if (this.setGoodsButton != null) {
            this.add(this.setGoodsButton);
        }
        this.add((Component)this.okButton, "tag ok");
        this.initialize(colony);
        this.restoreSavedSize(850, 600);
    }

    public final CargoPanel getCargoPanel() {
        return this.cargoPanel;
    }

    public final WarehousePanel getWarehousePanel() {
        return this.warehousePanel;
    }

    public final TilePanel getTilePanel() {
        return this.tilePanel;
    }

    public final synchronized Colony getColony() {
        return this.colony;
    }

    private synchronized void setColony(Colony colony) {
        this.removePropertyChangeListeners();
        this.colony = colony;
        this.addPropertyChangeListeners();
        this.editable = colony.getOwner() == this.getMyPlayer();
    }

    public void updateConstructionPanel() {
        this.constructionPanel.update();
    }

    public void updateInPortPanel() {
        this.inPortPanel.initialize();
    }

    public void updateWarehousePanel() {
        this.warehousePanel.update();
    }

    public void updateOutsideColonyPanel() {
        this.outsideColonyPanel.initialize();
    }

    public void updateTilePanel() {
        this.tilePanel.initialize();
    }

    public void updateProductionPanel() {
        this.colony.invalidateCache();
        this.netProductionPanel.removeAll();
        for (GoodsType goodsType : this.getSpecification().getGoodsTypeList()) {
            int amount = this.colony.getAdjustedNetProductionOf(goodsType);
            if (amount == 0) continue;
            this.netProductionPanel.add(new ProductionLabel(goodsType, amount, this.getCanvas()));
        }
        this.netProductionPanel.revalidate();
    }

    private void sortBuildings(List<Building> buildings) {
        Collections.sort(buildings);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Canvas canvas = this.getCanvas();
        Colony colony = this.getColony();
        String command = event.getActionCommand();
        if ("OK".equals(command)) {
            this.closeColonyPanel();
        } else {
            try {
                switch (Integer.valueOf(command)) {
                    case 2: {
                        this.unload();
                        break;
                    }
                    case 4: {
                        if (canvas.showFreeColDialog(new WarehouseDialog(canvas, colony)).booleanValue()) {
                            this.updateWarehousePanel();
                        }
                        break;
                    }
                    case 1: {
                        canvas.showSubPanel(new BuildQueuePanel(colony, canvas));
                        this.updateConstructionPanel();
                        break;
                    }
                    case 5: {
                        this.fill();
                        break;
                    }
                    case 6: {
                        this.debugSetGoods(canvas, colony);
                        break;
                    }
                    default: {
                        logger.warning("Invalid action");
                        break;
                    }
                }
            }
            catch (NumberFormatException e) {
                logger.warning("Invalid action number: " + command);
            }
        }
    }

    private void debugSetGoods(Canvas canvas, Colony colony) {
        int a;
        Specification spec = this.getSpecification();
        ArrayList gtl = new ArrayList();
        for (GoodsType t : spec.getGoodsTypeList()) {
            if (t.isFoodType() && t != spec.getPrimaryFoodType()) continue;
            gtl.add(new ChoiceItem<GoodsType>(Messages.message(t.toString() + ".name"), t));
        }
        GoodsType goodsType = (GoodsType)canvas.showChoiceDialog(null, "Select Goods Type", "Cancel", gtl);
        if (goodsType == null) {
            return;
        }
        String amount = canvas.showInputDialog(null, StringTemplate.name("Select Goods Amount"), Integer.toString(colony.getGoodsCount(goodsType)), "ok", "cancel", true);
        if (amount == null) {
            return;
        }
        try {
            a = Integer.parseInt(amount);
        }
        catch (NumberFormatException nfe) {
            return;
        }
        GoodsType sGoodsType = this.getFreeColClient().getFreeColServer().getSpecification().getGoodsType(goodsType.getId());
        GoodsContainer cgc = colony.getGoodsContainer();
        GoodsContainer sgc = (GoodsContainer)this.getFreeColClient().getFreeColServer().getGame().getFreeColGameObject(cgc.getId());
        cgc.setAmount(goodsType, a);
        sgc.setAmount(sGoodsType, a);
        this.updateConstructionPanel();
        this.updateProductionPanel();
        this.updateWarehousePanel();
    }

    private void unload() {
        Unit unit = this.getSelectedUnit();
        if (unit != null && unit.isCarrier()) {
            for (Goods goods : unit.getGoodsContainer().getGoods()) {
                this.getController().unloadCargo(goods, false);
            }
            for (Unit u : unit.getUnitList()) {
                this.getController().leaveShip(u);
            }
            this.cargoPanel.initialize();
            this.outsideColonyPanel.initialize();
        }
        this.unloadButton.setEnabled(false);
        this.fillButton.setEnabled(false);
    }

    private void fill() {
        Unit unit = this.getSelectedUnit();
        if (unit != null && unit.isCarrier()) {
            for (Goods goods : unit.getGoodsContainer().getGoods()) {
                int space = 100 - goods.getAmount();
                int count = this.getColony().getGoodsCount(goods.getType());
                if (space <= 0 || count <= 0) continue;
                Goods newGoods = new Goods(goods.getGame(), this.getColony(), goods.getType(), Math.min(space, count));
                this.getController().loadCargo(newGoods, unit);
            }
        }
    }

    private void updateCarrierButtons() {
        Unit unit;
        this.unloadButton.setEnabled(false);
        this.fillButton.setEnabled(false);
        if (this.isEditable() && this.selectedUnitLabel != null && (unit = this.selectedUnitLabel.getUnit()) != null && unit.isCarrier() && unit.getSpaceLeft() < unit.getType().getSpace()) {
            this.unloadButton.setEnabled(true);
            for (Goods goods : unit.getGoodsList()) {
                if (this.getColony().getGoodsCount(goods.getType()) <= 0) continue;
                this.fillButton.setEnabled(true);
                break;
            }
        }
    }

    public Unit getSelectedUnit() {
        return this.selectedUnitLabel == null ? null : this.selectedUnitLabel.getUnit();
    }

    public void setSelectedUnit(Unit unit) {
        UnitLabel unitLabel = null;
        if (unit != null) {
            Component[] components = this.inPortPanel.getComponents();
            for (int i = 0; i < components.length; ++i) {
                if (!(components[i] instanceof UnitLabel) || ((UnitLabel)components[i]).getUnit() != unit) continue;
                unitLabel = (UnitLabel)components[i];
                break;
            }
        }
        this.setSelectedUnitLabel(unitLabel);
    }

    public UnitLabel getSelectedUnitLabel() {
        return this.selectedUnitLabel;
    }

    public void setSelectedUnitLabel(UnitLabel unitLabel) {
        if (this.selectedUnitLabel != unitLabel) {
            if (this.selectedUnitLabel != null) {
                this.selectedUnitLabel.setSelected(false);
                this.selectedUnitLabel.getUnit().removePropertyChangeListener(this);
            }
            this.selectedUnitLabel = unitLabel;
            if (unitLabel == null) {
                this.cargoPanel.setCarrier(null);
            } else {
                this.cargoPanel.setCarrier(unitLabel.getUnit());
                unitLabel.setSelected(true);
                unitLabel.getUnit().addPropertyChangeListener(this);
            }
        }
        this.updateCarrierButtons();
        this.inPortPanel.revalidate();
        this.inPortPanel.repaint();
    }

    private void initialize(Colony colony) {
        this.setColony(colony);
        this.outsideColonyPanel.removeMouseListener(this.releaseListener);
        this.inPortPanel.removeMouseListener(this.releaseListener);
        this.cargoPanel.removeMouseListener(this.releaseListener);
        this.warehousePanel.removeMouseListener(this.releaseListener);
        if (this.isEditable()) {
            this.outsideColonyPanel.setTransferHandler(this.defaultTransferHandler);
            this.inPortPanel.setTransferHandler(this.defaultTransferHandler);
            this.cargoPanel.setTransferHandler(this.defaultTransferHandler);
            this.warehousePanel.setTransferHandler(this.defaultTransferHandler);
            this.outsideColonyPanel.addMouseListener(this.releaseListener);
            this.inPortPanel.addMouseListener(this.releaseListener);
            this.cargoPanel.addMouseListener(this.releaseListener);
            this.warehousePanel.addMouseListener(this.releaseListener);
        } else {
            this.outsideColonyPanel.setTransferHandler(null);
            this.inPortPanel.setTransferHandler(null);
            this.cargoPanel.setTransferHandler(null);
            this.warehousePanel.setTransferHandler(null);
        }
        this.unloadButton.setEnabled(this.isEditable());
        this.fillButton.setEnabled(this.isEditable());
        this.warehouseButton.setEnabled(this.isEditable());
        this.nameBox.setEnabled(this.isEditable());
        this.cargoPanel.setCarrier(null);
        this.inPortPanel.initialize();
        this.warehousePanel.initialize();
        this.buildingsPanel.initialize();
        this.tilePanel.initialize();
        this.updateProductionPanel();
        this.populationPanel.update();
        this.constructionPanel.setColony(colony);
        this.outsideColonyPanel.setColony(colony);
    }

    public void closeColonyPanel() {
        Canvas canvas = this.getCanvas();
        if (this.getColony().getUnitCount() == 0) {
            if (canvas.showConfirmDialog("abandonColony.text", "abandonColony.yes", "abandonColony.no")) {
                canvas.remove(this);
                this.getController().abandonColony(this.getColony());
            }
        } else {
            BuildableType buildable = this.getColony().getCurrentlyBuilding();
            if (buildable != null && buildable.getPopulationRequired() > this.getColony().getUnitCount() && !canvas.showConfirmDialog(null, StringTemplate.template("colonyPanel.reducePopulation").addName("%colony%", this.getColony().getName()).addAmount("%number%", buildable.getPopulationRequired()).add("%buildable%", buildable.getNameKey()), "ok", "cancel")) {
                return;
            }
            canvas.remove(this);
            this.removePropertyChangeListeners();
            if (this.getSelectedUnit() != null) {
                this.getSelectedUnit().removePropertyChangeListener(this);
            }
            this.buildingsPanel.cleanup();
            this.warehousePanel.cleanup();
            this.tilePanel.cleanup();
            this.constructionPanel.removePropertyChangeListeners();
            this.cargoPanel.setCarrier(null);
            this.outsideColonyPanel.cleanup();
            if (this.getGame().getCurrentPlayer() == this.getMyPlayer()) {
                this.getController().nextModelMessage();
                Unit activeUnit = canvas.getGUI().getActiveUnit();
                if (activeUnit == null || activeUnit.getTile() == null || activeUnit.getMovesLeft() <= 0 || !(activeUnit.getLocation() instanceof Tile) && !activeUnit.isOnCarrier()) {
                    canvas.getGUI().setActiveUnit(null);
                    this.getController().nextActiveUnit();
                }
            }
            this.getFreeColClient().getGUI().restartBlinking();
        }
    }

    private void addPropertyChangeListeners() {
        Colony colony = this.getColony();
        if (colony != null) {
            colony.addPropertyChangeListener(this);
            colony.getGoodsContainer().addPropertyChangeListener(this);
            colony.getTile().addPropertyChangeListener(this);
        }
    }

    private void removePropertyChangeListeners() {
        Colony colony = this.getColony();
        if (colony != null) {
            colony.removePropertyChangeListener(this);
            colony.getGoodsContainer().removePropertyChangeListener(this);
            colony.getTile().removePropertyChangeListener(this);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (!this.isShowing() || this.getColony() == null) {
            return;
        }
        String property = event.getPropertyName();
        logger.finest(this.getColony().getName() + " change " + property + ": " + event.getOldValue() + " -> " + event.getNewValue());
        if (property == null) {
            logger.warning("Null property change");
        } else if ("CARGO_CHANGE".equals(property)) {
            this.updateInPortPanel();
        } else if (Colony.ColonyChangeEvent.POPULATION_CHANGE.toString().equals(property)) {
            this.populationPanel.update();
            this.updateProductionPanel();
        } else if (Colony.ColonyChangeEvent.BONUS_CHANGE.toString().equals(property)) {
            ModelMessage msg = this.getColony().checkForGovMgtChangeMessage();
            if (msg != null) {
                this.getCanvas().showInformationMessage(msg);
            }
            this.populationPanel.update();
        } else if (Colony.ColonyChangeEvent.UNIT_TYPE_CHANGE.toString().equals(property)) {
            FreeColGameObject object = (FreeColGameObject)event.getSource();
            String oldType = (String)event.getOldValue();
            String newType = (String)event.getNewValue();
            this.getCanvas().showInformationMessage((FreeColObject)object, StringTemplate.template("model.colony.unitChange").addName("%oldType%", oldType).addName("%newType%", newType));
            this.updateTilePanel();
        } else if ("UNIT_CHANGE".toString().equals(property)) {
            this.updateTilePanel();
            this.updateProductionPanel();
        } else if (property.startsWith("model.goods.")) {
            this.updateProductionPanel();
            this.updateWarehousePanel();
            this.buildingsPanel.update();
            this.updateConstructionPanel();
        } else if ("TILE_UNIT_CHANGE".equals(property)) {
            this.updateOutsideColonyPanel();
            this.updateInPortPanel();
        } else {
            logger.warning("Unknown property change event: " + event.getPropertyName());
        }
    }

    public final class TilePanel
    extends FreeColPanel {
        private final ColonyPanel colonyPanel;
        private Tile[][] tiles;

        public TilePanel(ColonyPanel colonyPanel2) {
            super(colonyPanel2.getCanvas());
            this.tiles = new Tile[3][3];
            this.colonyPanel = colonyPanel2;
            this.setBackground(Color.BLACK);
            this.setBorder(null);
            this.setLayout(null);
        }

        public void paintComponent(Graphics g) {
            GUI colonyTileGUI = this.getCanvas().getColonyTileGUI();
            g.setColor(Color.black);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            TileType tileType = ColonyPanel.this.getColony().getTile().getType();
            int tileWidth = this.getLibrary().getTerrainImageWidth(tileType) / 2;
            int tileHeight = this.getLibrary().getTerrainImageHeight(tileType) / 2;
            if (ColonyPanel.this.getColony() != null) {
                for (int x = 0; x < 3; ++x) {
                    for (int y = 0; y < 3; ++y) {
                        if (this.tiles[x][y] == null) continue;
                        int xx = (2 - x + y) * tileWidth;
                        int yy = (x + y) * tileHeight;
                        g.translate(xx, yy);
                        colonyTileGUI.displayColonyTile((Graphics2D)g, this.tiles[x][y], ColonyPanel.this.getColony());
                        g.translate(-xx, -yy);
                    }
                }
            }
        }

        public void initialize() {
            this.removePropertyChangeListeners();
            this.removeAll();
            Tile tile = ColonyPanel.this.getColony().getTile();
            this.tiles[0][0] = tile.getNeighbourOrNull(Map.Direction.N);
            this.tiles[0][1] = tile.getNeighbourOrNull(Map.Direction.NE);
            this.tiles[0][2] = tile.getNeighbourOrNull(Map.Direction.E);
            this.tiles[1][0] = tile.getNeighbourOrNull(Map.Direction.NW);
            this.tiles[1][1] = tile;
            this.tiles[1][2] = tile.getNeighbourOrNull(Map.Direction.SE);
            this.tiles[2][0] = tile.getNeighbourOrNull(Map.Direction.W);
            this.tiles[2][1] = tile.getNeighbourOrNull(Map.Direction.SW);
            this.tiles[2][2] = tile.getNeighbourOrNull(Map.Direction.S);
            int layer = 2;
            for (int x = 0; x < 3; ++x) {
                for (int y = 0; y < 3; ++y) {
                    if (this.tiles[x][y] == null) continue;
                    ColonyTile colonyTile = ColonyPanel.this.getColony().getColonyTile(this.tiles[x][y]);
                    ASingleTilePanel p = new ASingleTilePanel(colonyTile, x, y);
                    this.add((Component)p, new Integer(layer));
                    ++layer;
                }
            }
        }

        public void cleanup() {
            this.removePropertyChangeListeners();
        }

        private void removePropertyChangeListeners() {
            for (Component component : this.getComponents()) {
                if (!(component instanceof ASingleTilePanel)) continue;
                ((ASingleTilePanel)component).removePropertyChangeListeners();
            }
        }

        public final class ASingleTilePanel
        extends JPanel
        implements PropertyChangeListener {
            private ColonyTile colonyTile;

            public ASingleTilePanel(ColonyTile colonyTile, int x, int y) {
                this.setLayout(new FlowLayout(1, 0, 0));
                this.colonyTile = colonyTile;
                this.addPropertyChangeListeners();
                this.setOpaque(false);
                TileType tileType = colonyTile.getTile().getType();
                this.setSize(TilePanel.this.getLibrary().getTerrainImageWidth(tileType), TilePanel.this.getLibrary().getTerrainImageHeight(tileType));
                this.setLocation((2 - x + y) * TilePanel.this.getLibrary().getTerrainImageWidth(tileType) / 2, (x + y) * TilePanel.this.getLibrary().getTerrainImage(tileType, 0, 0).getHeight(null) / 2);
                this.initialize();
            }

            private void initializeAsCenterTile() {
                this.setLayout((LayoutManager)new MigLayout("wrap 1, center"));
                for (AbstractGoods goods : ColonyPanel.this.colony.getProductionInfo(this.colonyTile).getProduction()) {
                    this.add((Component)new ProductionLabel(goods, TilePanel.this.getCanvas()), "center");
                }
            }

            private void updateDescriptionLabel(UnitLabel unit, boolean toAdd) {
                String tileDescription = Messages.message(this.colonyTile.getLabel());
                if (unit == null) {
                    this.setToolTipText(tileDescription);
                } else {
                    String unitDescription = Messages.message(Messages.getLabel(unit.getUnit()));
                    if (toAdd) {
                        unitDescription = tileDescription + " [" + unitDescription + "]";
                    }
                    unit.setDescriptionLabel(unitDescription);
                }
            }

            public boolean contains(int px, int py) {
                int dy;
                int w = this.getWidth();
                int h = this.getHeight();
                int dx = Math.abs(w / 2 - px);
                return dx + w * (dy = Math.abs(h / 2 - py)) / h <= w / 2;
            }

            private void initialize() {
                this.removeAll();
                UnitLabel unitLabel = null;
                if (this.colonyTile.getUnit() != null) {
                    Unit unit = this.colonyTile.getUnit();
                    unitLabel = new UnitLabel(unit, TilePanel.this.getCanvas());
                    if (TilePanel.this.colonyPanel.isEditable()) {
                        unitLabel.setTransferHandler(ColonyPanel.this.defaultTransferHandler);
                        unitLabel.addMouseListener(ColonyPanel.this.pressListener);
                    }
                    super.add(unitLabel);
                }
                this.updateDescriptionLabel(unitLabel, true);
                if (this.colonyTile.isColonyCenterTile()) {
                    this.initializeAsCenterTile();
                }
                if (TilePanel.this.colonyPanel.isEditable()) {
                    this.setTransferHandler(ColonyPanel.this.defaultTransferHandler);
                    this.addMouseListener(ColonyPanel.this.releaseListener);
                }
                this.revalidate();
                this.repaint();
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public Component add(Component comp, boolean editState) {
                Container oldParent = comp.getParent();
                if (!editState) return comp;
                if (comp instanceof UnitLabel) {
                    if (!this.tryWorkTile(((UnitLabel)comp).getUnit())) return null;
                    oldParent.remove(comp);
                    ((UnitLabel)comp).setSmall(false);
                    return comp;
                } else {
                    logger.warning("An invalid component was dropped on this ASingleTilePanel.");
                    return null;
                }
            }

            private boolean tryWorkTile(Unit unit) {
                ColonyTile best;
                Tile tile = this.colonyTile.getWorkTile();
                Colony colony = ColonyPanel.this.getColony();
                Player player = unit.getOwner();
                Canvas canvas = TilePanel.this.getCanvas();
                ColonyTile.NoAddReason reason = this.colonyTile.canAddReason(unit);
                if (reason == ColonyTile.NoAddReason.CLAIM) {
                    Player.NoClaimReason claim = player.canClaimForSettlementReason(tile);
                    switch (claim) {
                        case NONE: {
                            throw new IllegalStateException("NoAddReason=CLAIMyet NoClaimReason=NONE");
                        }
                        case NATIVES: {
                            if (TilePanel.this.getController().claimLand(tile, colony, 0) && tile.getOwningSettlement() == colony) {
                                logger.info("Colony " + colony.getName() + " claims tile " + tile.toString() + " with unit " + unit.getId());
                                break;
                            }
                            logger.warning("Colony " + colony.getName() + " did not claim " + tile.toString() + " with unit " + unit.getId());
                            return false;
                        }
                        default: {
                            canvas.errorMessage("badTileUse." + claim.toString().toLowerCase(Locale.US));
                            return false;
                        }
                    }
                    reason = this.colonyTile.canAddReason(unit);
                    if (reason == ColonyTile.NoAddReason.CLAIM) {
                        throw new IllegalStateException("Claim failed");
                    }
                }
                if (reason != ColonyTile.NoAddReason.NONE) {
                    canvas.errorMessage("badTileUse." + reason.toString().toLowerCase(Locale.US));
                    return false;
                }
                GoodsType workType = unit.getWorkType();
                if (workType == null && (workType = unit.getType().getExpertProduction()) == null) {
                    workType = this.colonyTile.getWorkType(unit);
                }
                TilePanel.this.getController().work(unit, this.colonyTile);
                if (workType != null && workType != unit.getWorkType()) {
                    TilePanel.this.getController().changeWorkType(unit, workType);
                }
                if (TilePanel.this.getClientOptions().getBoolean("model.option.guiShowNotBestTile") && (best = colony.getVacantColonyTileFor(unit, false, workType)) != null && this.colonyTile != best && this.colonyTile.getProductionOf(unit, workType) < best.getProductionOf(unit, workType)) {
                    StringTemplate template = StringTemplate.template("colonyPanel.notBestTile").addStringTemplate("%unit%", Messages.getLabel(unit)).add("%goods%", workType.getNameKey()).addStringTemplate("%tile%", best.getLabel());
                    canvas.showInformationMessage(template);
                }
                return true;
            }

            public void addPropertyChangeListeners() {
                this.colonyTile.addPropertyChangeListener(this);
            }

            public void removePropertyChangeListeners() {
                this.colonyTile.removePropertyChangeListener(this);
            }

            public void propertyChange(PropertyChangeEvent event) {
                String property = event.getPropertyName();
                logger.finest(this.colonyTile.getId() + " change " + property + ": " + event.getOldValue() + " -> " + event.getNewValue());
                this.initialize();
            }
        }
    }

    public final class WarehousePanel
    extends JPanel
    implements PropertyChangeListener {
        private final ColonyPanel colonyPanel;

        public WarehousePanel(ColonyPanel colonyPanel2) {
            this.colonyPanel = colonyPanel2;
            this.setLayout((LayoutManager)new MigLayout("fill, gap push, insets 0"));
        }

        public void initialize() {
            this.addPropertyChangeListeners();
            this.update();
            this.revalidate();
            this.repaint();
        }

        public void cleanup() {
            this.removePropertyChangeListeners();
        }

        private void update() {
            int threshold = ColonyPanel.this.getClientOptions().getInteger("model.option.guiMinNumberToDisplayGoods");
            this.removeAll();
            for (GoodsType goodsType : ColonyPanel.this.getSpecification().getGoodsTypeList()) {
                Goods goods = ColonyPanel.this.getColony().getGoodsContainer().getGoods(goodsType);
                if (!goodsType.isStorable() || goods.getAmount() < threshold) continue;
                GoodsLabel goodsLabel = new GoodsLabel(goods, ColonyPanel.this.getCanvas());
                if (this.colonyPanel.isEditable()) {
                    goodsLabel.setTransferHandler(ColonyPanel.this.defaultTransferHandler);
                    goodsLabel.addMouseListener(ColonyPanel.this.pressListener);
                }
                this.add((Component)goodsLabel, false);
            }
            this.revalidate();
            this.repaint();
        }

        public Component add(Component comp, boolean editState) {
            if (editState) {
                if (!(comp instanceof GoodsLabel)) {
                    logger.warning("Invalid component dropped on this WarehousePanel.");
                    return null;
                }
                comp.getParent().remove(comp);
                ((GoodsLabel)comp).setSmall(false);
                return comp;
            }
            Component c = this.add(comp);
            return c;
        }

        private void addPropertyChangeListeners() {
            Colony colony = ColonyPanel.this.getColony();
            if (colony != null) {
                colony.getGoodsContainer().addPropertyChangeListener(this);
            }
        }

        private void removePropertyChangeListeners() {
            Colony colony = ColonyPanel.this.getColony();
            if (colony != null) {
                colony.getGoodsContainer().removePropertyChangeListener(this);
            }
        }

        public void propertyChange(PropertyChangeEvent event) {
            logger.finest(ColonyPanel.this.getColony().getName() + "-warehouse change " + event.getPropertyName() + ": " + event.getOldValue() + " -> " + event.getNewValue());
            this.update();
        }

        public String getUIClassID() {
            return "WarehousePanelUI";
        }
    }

    public final class InPortPanel
    extends JPanel {
        public InPortPanel() {
            super((LayoutManager)new MigLayout("wrap 3, fill, insets 0"));
            this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), Messages.message("inPort")));
        }

        public void initialize() {
            this.removeAll();
            if (ColonyPanel.this.getColony() == null) {
                return;
            }
            UnitLabel lastCarrier = null;
            UnitLabel prevCarrier = null;
            for (Unit unit : ColonyPanel.this.getColony().getTile().getUnitList()) {
                if (!unit.isCarrier()) continue;
                UnitLabel unitLabel = new UnitLabel(unit, ColonyPanel.this.getCanvas());
                TradeRoute tradeRoute = unit.getTradeRoute();
                if (tradeRoute != null) {
                    unitLabel.setDescriptionLabel(Messages.message(Messages.getLabel(unit)) + " (" + tradeRoute.getName() + ")");
                }
                if (ColonyPanel.this.isEditable()) {
                    unitLabel.setTransferHandler(ColonyPanel.this.defaultTransferHandler);
                    unitLabel.addMouseListener(ColonyPanel.this.pressListener);
                }
                this.add(unitLabel);
                lastCarrier = unitLabel;
                if (ColonyPanel.this.getSelectedUnit() != unit) continue;
                prevCarrier = unitLabel;
            }
            ColonyPanel.this.setSelectedUnitLabel(prevCarrier != null ? prevCarrier : (lastCarrier != null ? lastCarrier : null));
        }

        public String getUIClassID() {
            return "InPortPanelUI";
        }
    }

    public final class OutsideColonyPanel
    extends JPanel
    implements PropertyChangeListener {
        private Colony colony;

        public OutsideColonyPanel() {
            super((LayoutManager)new MigLayout("wrap 4, fill, insets 0"));
            this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), Messages.message("outsideColony")));
        }

        public Colony getColony() {
            return this.colony;
        }

        public void setColony(Colony newColony) {
            this.removePropertyChangeListeners();
            this.colony = newColony;
            this.addPropertyChangeListeners();
            this.initialize();
        }

        public void initialize() {
            this.removeAll();
            if (this.getColony() == null) {
                return;
            }
            Tile colonyTile = this.getColony().getTile();
            for (Unit unit : colonyTile.getUnitList()) {
                if (unit.isNaval() || unit.isCarrier()) continue;
                UnitLabel unitLabel = new UnitLabel(unit, ColonyPanel.this.getCanvas());
                if (ColonyPanel.this.isEditable()) {
                    unitLabel.setTransferHandler(ColonyPanel.this.defaultTransferHandler);
                    unitLabel.addMouseListener(ColonyPanel.this.pressListener);
                }
                this.add((Component)unitLabel, false);
            }
            this.revalidate();
            this.repaint();
        }

        public void cleanup() {
            this.removePropertyChangeListeners();
        }

        public Component add(Component comp, boolean editState) {
            Container oldParent = comp.getParent();
            if (editState) {
                if (comp instanceof UnitLabel) {
                    UnitLabel unitLabel = (UnitLabel)comp;
                    Unit unit = unitLabel.getUnit();
                    if (!unit.isOnCarrier()) {
                        ColonyPanel.this.getController().putOutsideColony(unit);
                    }
                    if (unit.getColony() == null) {
                        ColonyPanel.this.closeColonyPanel();
                        return null;
                    }
                    if (!(unit.getLocation() instanceof Tile) && !unit.isOnCarrier()) {
                        return null;
                    }
                    oldParent.remove(comp);
                    this.initialize();
                    return comp;
                }
                logger.warning("An invalid component got dropped on this ColonistsPanel.");
                return null;
            }
            ((UnitLabel)comp).setSmall(false);
            Component c = this.add(comp);
            return c;
        }

        private void addPropertyChangeListeners() {
            Colony colony = this.getColony();
            if (colony != null) {
                colony.getTile().addPropertyChangeListener("TILE_UNIT_CHANGE", this);
            }
        }

        private void removePropertyChangeListeners() {
            Colony colony = this.getColony();
            if (colony != null) {
                colony.getTile().removePropertyChangeListener("TILE_UNIT_CHANGE", this);
            }
        }

        public void propertyChange(PropertyChangeEvent event) {
            String property = event.getPropertyName();
            logger.finest("Outside " + this.getColony().getId() + " change " + property + ": " + event.getOldValue() + " -> " + event.getNewValue());
            this.initialize();
        }

        public String getUIClassID() {
            return "OutsideColonyPanelUI";
        }
    }

    public final class PopulationPanel
    extends JPanel {
        private final JLabel rebelShield = new JLabel();
        private final JLabel rebelLabel = new JLabel();
        private final JLabel bonusLabel = new JLabel();
        private final JLabel royalistLabel = new JLabel();
        private final JLabel royalistShield = new JLabel();
        private final JLabel rebelMemberLabel = new JLabel();
        private final JLabel popLabel = new JLabel();
        private final JLabel royalistMemberLabel = new JLabel();

        public PopulationPanel() {
            this.setOpaque(false);
            this.setToolTipText(" ");
            this.setLayout((LayoutManager)new MigLayout("wrap 5, fill, insets 0", "[][]:push[center]:push[right][]"));
            this.add((Component)this.rebelShield, "bottom");
            this.add((Component)this.rebelLabel, "split 2, flowy");
            this.add(this.rebelMemberLabel);
            this.add((Component)this.popLabel, "split 2, flowy");
            this.add(this.bonusLabel);
            this.add((Component)this.royalistLabel, "split 2, flowy");
            this.add(this.royalistMemberLabel);
            this.add((Component)this.royalistShield, "bottom");
        }

        public JToolTip createToolTip() {
            return new RebelToolTip(ColonyPanel.this.getColony(), ColonyPanel.this.getCanvas());
        }

        public void update() {
            int population = ColonyPanel.this.getColony().getUnitCount();
            int members = ColonyPanel.this.getColony().getMembers();
            int rebels = ColonyPanel.this.getColony().getSoL();
            String rebelNumber = Messages.message(StringTemplate.template("colonyPanel.rebelLabel").addAmount("%number%", members));
            String royalistNumber = Messages.message(StringTemplate.template("colonyPanel.royalistLabel").addAmount("%number%", population - members));
            this.popLabel.setText(Messages.message(StringTemplate.template("colonyPanel.populationLabel").addAmount("%number%", population)));
            this.rebelLabel.setText(rebelNumber);
            this.rebelMemberLabel.setText(Integer.toString(rebels) + "%");
            this.bonusLabel.setText(Messages.message(StringTemplate.template("colonyPanel.bonusLabel").addAmount("%number%", ColonyPanel.this.getColony().getProductionBonus())));
            this.royalistLabel.setText(royalistNumber);
            this.royalistMemberLabel.setText(Integer.toString(ColonyPanel.this.getColony().getTory()) + "%");
            this.rebelShield.setIcon(new ImageIcon(ColonyPanel.this.getLibrary().getCoatOfArmsImage(ColonyPanel.this.getColony().getOwner().getNation(), 0.5)));
            this.royalistShield.setIcon(new ImageIcon(ColonyPanel.this.getLibrary().getCoatOfArmsImage(ColonyPanel.this.getColony().getOwner().getNation().getRefNation(), 0.5)));
            this.revalidate();
            this.repaint();
        }

        public String getUIClassID() {
            return "PopulationPanelUI";
        }
    }

    public final class BuildingsPanel
    extends JPanel {
        private final ColonyPanel colonyPanel;

        public BuildingsPanel(ColonyPanel colonyPanel2) {
            this.setLayout((LayoutManager)new MigLayout("fill, wrap 4, insets 0, gap 0:10:10:push"));
            this.colonyPanel = colonyPanel2;
        }

        public void initialize() {
            this.update();
        }

        public void cleanup() {
            this.removePropertyChangeListeners();
        }

        public void update() {
            this.removePropertyChangeListeners();
            this.removeAll();
            MouseAdapter mouseAdapter = new MouseAdapter(){

                public void mousePressed(MouseEvent e) {
                    ColonyPanel.this.getCanvas().showSubPanel(new BuildQueuePanel(ColonyPanel.this.getColony(), ColonyPanel.this.getCanvas()));
                }
            };
            List<Building> buildings = ColonyPanel.this.getColony().getBuildings();
            ColonyPanel.this.sortBuildings(buildings);
            for (Building building : buildings) {
                ASingleBuildingPanel aSingleBuildingPanel = new ASingleBuildingPanel(building);
                if (this.colonyPanel.isEditable()) {
                    aSingleBuildingPanel.addMouseListener(ColonyPanel.this.releaseListener);
                    aSingleBuildingPanel.setTransferHandler(ColonyPanel.this.defaultTransferHandler);
                }
                aSingleBuildingPanel.setOpaque(false);
                aSingleBuildingPanel.addMouseListener(mouseAdapter);
                this.add(aSingleBuildingPanel);
            }
        }

        private void removePropertyChangeListeners() {
            for (Component component : this.getComponents()) {
                if (!(component instanceof ASingleBuildingPanel)) continue;
                ((ASingleBuildingPanel)component).removePropertyChangeListeners();
            }
        }

        public String getUIClassID() {
            return "BuildingsPanelUI";
        }

        public final class ASingleBuildingPanel
        extends BuildingPanel
        implements Autoscroll {
            public ASingleBuildingPanel(Building building) {
                super(building, ColonyPanel.this.getCanvas());
            }

            public void autoscroll(Point p) {
                JViewport vp = (JViewport)BuildingsPanel.this.colonyPanel.buildingsPanel.getParent();
                if (this.getLocation().y + p.y - vp.getViewPosition().y < 40) {
                    vp.setViewPosition(new Point(vp.getViewPosition().x, Math.max(vp.getViewPosition().y - 40, 0)));
                } else if (this.getLocation().y + p.y - vp.getViewPosition().y >= vp.getHeight() - 40) {
                    vp.setViewPosition(new Point(vp.getViewPosition().x, Math.min(vp.getViewPosition().y + 40, BuildingsPanel.this.colonyPanel.buildingsPanel.getHeight() - vp.getHeight())));
                }
            }

            public Insets getAutoscrollInsets() {
                Rectangle r = this.getBounds();
                return new Insets(r.x, r.y, r.width, r.height);
            }

            public void initialize() {
                super.initialize();
                if (BuildingsPanel.this.colonyPanel.isEditable()) {
                    for (UnitLabel unitLabel : this.getUnitLabels()) {
                        unitLabel.setTransferHandler(ColonyPanel.this.defaultTransferHandler);
                        unitLabel.addMouseListener(ColonyPanel.this.pressListener);
                    }
                }
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public Component add(Component comp, boolean editState) {
                if (editState) {
                    if (comp instanceof UnitLabel) {
                        Unit unit = ((UnitLabel)comp).getUnit();
                        if (!this.getBuilding().canAdd(unit)) return null;
                        ColonyPanel.this.getController().work(unit, this.getBuilding());
                    } else {
                        logger.warning("An invalid component got dropped on this BuildingsPanel.");
                        return null;
                    }
                }
                this.initialize();
                return null;
            }
        }
    }

    public final class ColonyCargoPanel
    extends CargoPanel {
        public ColonyCargoPanel(Canvas canvas) {
            super(canvas, true);
            this.setLayout((LayoutManager)new MigLayout("wrap 6, fill, insets 0"));
        }

        public void update() {
            super.update();
            ColonyPanel.this.updateCarrierButtons();
        }

        public String getUIClassID() {
            return "CargoPanelUI";
        }
    }
}

