/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.option;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.option.OptionUpdater;
import net.sf.freecol.common.option.IntegerOption;

public final class IntegerOptionUI
extends JSpinner
implements OptionUpdater,
PropertyChangeListener {
    private static final Logger logger = Logger.getLogger(IntegerOptionUI.class.getName());
    private final IntegerOption option;
    private int originalValue;
    private JLabel label;

    public IntegerOptionUI(final IntegerOption option, boolean editable) {
        this.option = option;
        this.originalValue = option.getValue();
        String name = Messages.getName(option);
        String description = Messages.getShortDescription(option);
        String text = description != null ? description : name;
        this.label = new JLabel(name, 2);
        this.label.setToolTipText(text);
        this.setToolTipText(text);
        this.setEnabled(editable);
        this.setOpaque(false);
        if (editable) {
            int stepSize = Math.min((option.getMaximumValue() - option.getMinimumValue()) / 10, 1000);
            this.setModel(new SpinnerNumberModel(option.getValue(), option.getMinimumValue(), option.getMaximumValue(), Math.max(1, stepSize)));
            this.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    if (option.isPreviewEnabled()) {
                        int value = (Integer)IntegerOptionUI.this.getValue();
                        if (option.getValue() != value) {
                            option.setValue(value);
                        }
                    }
                }
            });
            option.addPropertyChangeListener(this);
        } else {
            int value = option.getValue();
            this.setModel(new SpinnerNumberModel(value, value, value, 1));
        }
    }

    public JLabel getLabel() {
        return this.label;
    }

    public void setLabel(JLabel newLabel) {
        this.label = newLabel;
    }

    public void rollback() {
        this.option.setValue(this.originalValue);
    }

    public void unregister() {
        this.option.removePropertyChangeListener(this);
    }

    public void propertyChange(PropertyChangeEvent event) {
        int value;
        if (event.getPropertyName().equals("value") && (value = ((Integer)event.getNewValue()).intValue()) != (Integer)this.getValue()) {
            this.setValue(event.getNewValue());
            this.originalValue = value;
        }
    }

    public void updateOption() {
        this.option.setValue((int)((Integer)this.getValue()));
    }

    public void reset() {
        this.setValue(this.option.getValue());
    }
}

