/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.action.UnloadAction;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.ChoiceItem;
import net.sf.freecol.client.gui.panel.ReportPanel;
import net.sf.freecol.client.gui.panel.TilePanel;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.CombatModel;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.LostCityRumour;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tension;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TradeRoute;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.server.ai.AIColony;
import net.sf.freecol.server.ai.AIGoods;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.TileImprovementPlan;
import net.sf.freecol.server.ai.Wish;
import net.sf.freecol.server.ai.mission.TransportMission;
import net.sf.freecol.server.model.ServerGame;
import net.sf.freecol.server.model.ServerUnit;

public final class TilePopup
extends JPopupMenu {
    private static final Logger logger = Logger.getLogger(TilePopup.class.getName());
    public static final int UNIT_LINES_IN_FIRST_MENU = 9;
    public static final int UNIT_LINES_IN_OTHER_MENUS = 19;
    private final Canvas canvas;
    private final FreeColClient freeColClient;
    private final GUI gui;
    private boolean hasAnItem = false;

    public TilePopup(final Tile tile, final FreeColClient freeColClient, final Canvas canvas, final GUI gui) {
        super(Messages.message(StringTemplate.template("tile").addAmount("%x%", tile.getX()).addAmount("%y%", tile.getY())));
        Component lastComponent;
        Settlement settlement;
        this.canvas = canvas;
        this.freeColClient = freeColClient;
        this.gui = gui;
        final Player player = freeColClient.getMyPlayer();
        final Unit activeUnit = gui.getActiveUnit();
        if (activeUnit != null) {
            Tile unitTile = activeUnit.getTile();
            JMenuItem gotoMenuItem = null;
            if (activeUnit.isOffensiveUnit() && unitTile.isAdjacent(tile) && activeUnit.getMoveType(tile).isAttack()) {
                CombatModel.CombatOdds combatOdds = activeUnit.getGame().getCombatModel().calculateCombatOdds(activeUnit, tile.getDefendingUnit(activeUnit));
                String victoryPercent = tile.getSettlement() != null || combatOdds.win == -1.0f ? "??" : Integer.toString((int)(combatOdds.win * 100.0f));
                gotoMenuItem = new JMenuItem(Messages.message(StringTemplate.template("attackTileOdds").addName("%chance%", victoryPercent)));
            } else if (activeUnit.getSimpleMoveType(unitTile, tile).isLegal()) {
                gotoMenuItem = new JMenuItem(Messages.message("gotoThisTile"));
            }
            if (gotoMenuItem != null) {
                gotoMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent event) {
                        if (freeColClient.getGame().getCurrentPlayer() != player) {
                            return;
                        }
                        Tile currTile = activeUnit.getTile();
                        if (currTile == tile) {
                            return;
                        }
                        freeColClient.getInGameController().setDestination(activeUnit, tile);
                        freeColClient.getInGameController().moveToDestination(activeUnit);
                        if (activeUnit.getTile() == currTile) {
                            gui.updateGotoPathForActiveUnit();
                        }
                    }
                });
                this.add(gotoMenuItem);
                this.hasAnItem = true;
            }
            if (unitTile == tile && activeUnit.isNaval() && activeUnit.canMoveToEurope()) {
                JMenuItem europeMenuItem = new JMenuItem(Messages.message(StringTemplate.template("gotoEurope")));
                europeMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent event) {
                        if (freeColClient.getGame().getCurrentPlayer() != player) {
                            return;
                        }
                        freeColClient.getInGameController().moveToEurope(activeUnit);
                    }
                });
                this.add(europeMenuItem);
                this.hasAnItem = true;
            }
            if (this.hasAnItem) {
                this.addSeparator();
            }
        }
        if ((settlement = tile.getSettlement()) != null) {
            if (settlement.getOwner() == player) {
                this.addColony((Colony)settlement);
            } else if (settlement instanceof IndianSettlement) {
                this.addIndianSettlement((IndianSettlement)settlement);
            }
            if (this.hasItem()) {
                this.addSeparator();
            }
        }
        this.addTile(tile);
        this.addSeparator();
        int lineCount = 0;
        int maxUnits = 9;
        JComponent currentMenu = this;
        boolean moreUnits = false;
        List<Unit> units = tile.getUnitList();
        Collections.sort(units, ReportPanel.unitTypeComparator);
        for (Unit currentUnit : units) {
            if (lineCount > maxUnits) {
                JMenu more = new JMenu(Messages.message("more"));
                more.setFont(more.getFont().deriveFont(2));
                more.setOpaque(false);
                currentMenu.add(more);
                currentMenu = more;
                moreUnits = true;
                lineCount = 0;
                maxUnits = 19;
            }
            lineCount += this.addUnit(currentMenu, currentUnit, !currentUnit.isUnderRepair(), false);
        }
        if (tile.getUnitCount() > 1) {
            if (moreUnits) {
                this.addSeparator();
            }
            JMenuItem activateAllItem = new JMenuItem(Messages.message("activateAllUnits"));
            activateAllItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    Unit lastUnit = null;
                    for (Unit unit : tile.getUnitList()) {
                        freeColClient.getInGameController().clearOrders(unit);
                        lastUnit = unit;
                    }
                    gui.setActiveUnit(lastUnit);
                }
            });
            this.add(activateAllItem);
        }
        if (FreeCol.isInDebugMode() && freeColClient.getFreeColServer() != null) {
            final ServerGame serverGame = freeColClient.getFreeColServer().getGame();
            final Player serverPlayer = (Player)serverGame.getFreeColGameObject(player.getId());
            boolean notEmpty = false;
            this.addSeparator();
            JMenu takeOwnership = new JMenu("Take ownership");
            takeOwnership.setOpaque(false);
            JMenu transportLists = new JMenu("Transport lists");
            transportLists.setOpaque(false);
            for (final Unit currentUnit : tile.getUnitList()) {
                AIUnit au;
                JMenuItem toMenuItem = new JMenuItem(currentUnit.toString());
                toMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent event) {
                        Unit serverUnit = (Unit)serverGame.getFreeColGameObject(currentUnit.getId());
                        serverUnit.setOwner(serverPlayer);
                        for (Unit serverChildUnit : currentUnit.getUnitList()) {
                            serverChildUnit.setOwner(serverPlayer);
                        }
                        freeColClient.getConnectController().reconnect();
                    }
                });
                takeOwnership.add(toMenuItem);
                notEmpty = true;
                if (!currentUnit.isCarrier() || (au = freeColClient.getFreeColServer().getAIMain().getAIUnit(currentUnit)).getMission() == null || !(au.getMission() instanceof TransportMission)) continue;
                JMenuItem menuItem = new JMenuItem(currentUnit.toString());
                menuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent event) {
                        canvas.showInformationMessage(au.getMission().toString());
                    }
                });
                transportLists.add(menuItem);
            }
            if (transportLists.getItemCount() > 0) {
                this.add(transportLists);
            }
            if (tile.getColony() != null) {
                if (!notEmpty) {
                    takeOwnership.addSeparator();
                }
                JMenuItem toMenuItem = new JMenuItem(tile.getSettlement().toString());
                toMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent event) {
                        Tile serverTile = (Tile)serverGame.getFreeColGameObject(tile.getId());
                        serverTile.getSettlement().changeOwner(serverPlayer);
                        freeColClient.getConnectController().reconnect();
                    }
                });
                takeOwnership.add(toMenuItem);
                notEmpty = true;
                JMenuItem displayColonyPlan = new JMenuItem("Display Colony Plan");
                displayColonyPlan.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent event) {
                        Tile serverTile = (Tile)serverGame.getFreeColGameObject(tile.getId());
                        AIColony ac = freeColClient.getFreeColServer().getAIMain().getAIColony(serverTile.getColony());
                        StringBuilder info = new StringBuilder(ac.getColonyPlan().toString());
                        info.append("\n\nTILE IMPROVEMENTS:\n");
                        Iterator<TileImprovementPlan> tipIt = ac.getTileImprovementPlanIterator();
                        while (tipIt.hasNext()) {
                            info.append(tipIt.next().toString());
                            info.append("\n");
                        }
                        info.append("\n\nWISHES:\n");
                        Iterator<Wish> wishIterator = ac.getWishIterator();
                        while (wishIterator.hasNext()) {
                            info.append(wishIterator.next().toString());
                            info.append("\n");
                        }
                        info.append("\n\nEXPORT GOODS:\n");
                        Iterator<AIGoods> goodsIterator = ac.getAIGoodsIterator();
                        while (goodsIterator.hasNext()) {
                            info.append(goodsIterator.next().toString());
                            info.append("\n");
                        }
                        canvas.showInformationMessage(info.toString());
                    }
                });
                this.add(displayColonyPlan);
            }
            if (tile.getIndianSettlement() != null) {
                JMenuItem displayGoods = new JMenuItem("Examine Settlement");
                final IndianSettlement is = tile.getIndianSettlement();
                displayGoods.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent event) {
                        IndianSettlement sis = (IndianSettlement)serverGame.getFreeColGameObject(is.getId());
                        canvas.showInformationMessage(TilePopup.this.debugSummarizeSettlement(serverGame, sis));
                    }
                });
                this.add(displayGoods);
            }
            if (notEmpty) {
                this.add(takeOwnership);
                this.hasAnItem = true;
            }
            if (tile.hasLostCityRumour()) {
                JMenuItem rumourItem = new JMenuItem("Set Lost City Rumour type");
                rumourItem.setOpaque(false);
                rumourItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent event) {
                        TilePopup.this.debugSetRumourType(serverGame, tile);
                    }
                });
                this.add(rumourItem);
            }
            JMenuItem addu = new JMenuItem("Add unit");
            addu.setOpaque(false);
            addu.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    TilePopup.this.debugAddNewUnitToTile(serverGame, tile);
                }
            });
            this.add(addu);
            JMenuItem dumpItem = new JMenuItem("Dump tile");
            dumpItem.setOpaque(false);
            dumpItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    System.err.println("\nClient side:\n");
                    tile.dumpObject();
                    System.err.println("\nServer side:\n");
                    serverGame.getFreeColGameObject(tile.getId()).dumpObject();
                }
            });
            this.add(dumpItem);
        }
        if ((lastComponent = this.getComponent(this.getComponentCount() - 1)) instanceof JSeparator) {
            this.remove(lastComponent);
        }
    }

    private int addUnit(Container menu, final Unit unit, boolean enabled, boolean indent) {
        TradeRoute tradeRoute = unit.getTradeRoute();
        StringTemplate occ = unit.getState() == Unit.UnitState.ACTIVE && unit.getMovesLeft() == 0 ? (unit.isUnderRepair() ? StringTemplate.label(": ").add("model.unit.occupation.underRepair").add(Integer.toString(unit.getTurnsForRepair())) : (tradeRoute != null ? StringTemplate.label(": ").add("model.unit.occupation.inTradeRoute").addName(tradeRoute.getName()) : StringTemplate.key("model.unit.occupation.activeNoMovesLeft"))) : (unit.getState() == Unit.UnitState.IMPROVING && unit.getWorkImprovement() != null ? StringTemplate.label(": ").add(unit.getWorkImprovement().getType() + ".occupationString").add(Integer.toString(unit.getWorkTurnsLeft())) : (tradeRoute != null ? StringTemplate.label(": ").add("model.unit.occupation.inTradeRoute").add(tradeRoute.getName()) : (unit.getDestination() != null ? StringTemplate.key("model.unit.occupation.goingSomewhere") : StringTemplate.key("model.unit.occupation." + unit.getState().toString().toLowerCase()))));
        String text = (indent ? "    " : "") + Messages.message(StringTemplate.template("model.unit.nationUnit").addStringTemplate("%nation%", unit.getOwner().getNationName()).addStringTemplate("%unit%", Messages.getLabel(unit))) + " (" + Messages.message(occ) + ")";
        JMenuItem menuItem = new JMenuItem(text);
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                TilePopup.this.gui.setActiveUnit(unit);
            }
        });
        int lineCount = 1;
        if (indent) {
            menuItem.setFont(menuItem.getFont().deriveFont(2));
        }
        menuItem.setEnabled(enabled);
        menu.add(menuItem);
        for (Unit passenger : unit.getUnitList()) {
            lineCount += this.addUnit(menu, passenger, true, true);
        }
        boolean hasGoods = false;
        for (Goods goods : unit.getGoodsList()) {
            text = (indent ? "         " : "     ") + Messages.message(goods.getLabel(true));
            menuItem = new JMenuItem(text);
            menuItem.setFont(menuItem.getFont().deriveFont(2));
            menuItem.setEnabled(false);
            menu.add(menuItem);
            ++lineCount;
            hasGoods = true;
        }
        if (hasGoods) {
            JMenuItem dumpItem = new JMenuItem(Messages.message("dumpCargo"));
            dumpItem.setAction(new UnloadAction(this.freeColClient, unit));
            menu.add(dumpItem);
            ++lineCount;
        }
        this.hasAnItem = true;
        return lineCount;
    }

    private void addColony(final Colony colony) {
        String name = colony.getNameFor(this.freeColClient.getMyPlayer());
        JMenuItem menuItem = new JMenuItem(Messages.message(name));
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                TilePopup.this.canvas.showColonyPanel(colony);
            }
        });
        this.add(menuItem);
        menuItem = new JMenuItem(Messages.message("rename"));
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                TilePopup.this.freeColClient.getInGameController().rename(colony);
            }
        });
        this.add(menuItem);
        this.hasAnItem = true;
    }

    private void addIndianSettlement(final IndianSettlement settlement) {
        String name = settlement.getNameFor(this.freeColClient.getMyPlayer());
        JMenuItem menuItem = new JMenuItem(Messages.message(name));
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                TilePopup.this.canvas.showIndianSettlementPanel(settlement);
            }
        });
        this.add(menuItem);
        this.hasAnItem = true;
    }

    private void addTile(final Tile tile) {
        JMenuItem menuItem = new JMenuItem(Messages.message(tile.getNameKey()));
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                TilePopup.this.canvas.showPanel(new TilePanel(TilePopup.this.canvas, tile));
            }
        });
        this.add(menuItem);
    }

    public boolean hasItem() {
        return this.hasAnItem || FreeCol.isInDebugMode();
    }

    private void debugSetRumourType(Game serverGame, Tile tile) {
        ArrayList rumours = new ArrayList();
        for (LostCityRumour.RumourType rumour : LostCityRumour.RumourType.values()) {
            if (rumour == LostCityRumour.RumourType.NO_SUCH_RUMOUR) continue;
            rumours.add(new ChoiceItem<LostCityRumour.RumourType>(rumour.toString(), rumour));
        }
        LostCityRumour.RumourType rumourChoice = (LostCityRumour.RumourType)((Object)this.freeColClient.getCanvas().showChoiceDialog(null, "Select Lost City Rumour", "Cancel", rumours));
        tile.getTileItemContainer().getLostCityRumour().setType(rumourChoice);
        Tile serverTile = (Tile)serverGame.getFreeColGameObject(tile.getId());
        serverTile.getTileItemContainer().getLostCityRumour().setType(rumourChoice);
    }

    private void debugAddNewUnitToTile(Game serverGame, Tile tile) {
        Specification spec = serverGame.getSpecification();
        ArrayList uts = new ArrayList();
        for (UnitType t : spec.getUnitTypeList()) {
            uts.add(new ChoiceItem<UnitType>(Messages.message(t.toString() + ".name"), t));
        }
        UnitType unitChoice = (UnitType)this.freeColClient.getCanvas().showChoiceDialog(null, "Select Unit Type", "Cancel", uts);
        if (unitChoice == null) {
            return;
        }
        Player player = this.freeColClient.getMyPlayer();
        Player serverPlayer = (Player)serverGame.getFreeColGameObject(player.getId());
        Tile serverTile = (Tile)serverGame.getFreeColGameObject(tile.getId());
        ServerUnit serverUnit = new ServerUnit(serverGame, serverTile, serverPlayer, unitChoice, Unit.UnitState.ACTIVE, unitChoice.getDefaultEquipment());
        serverUnit.setMovesLeft(serverUnit.getInitialMovesLeft());
        Unit unit = new Unit(this.freeColClient.getGame(), serverUnit.toXMLElement(DOMMessage.createNewDocument()));
        tile.add(unit);
        this.gui.setActiveUnit(unit);
        player.invalidateCanSeeTiles();
        this.canvas.refresh();
    }

    private String debugSummarizeSettlement(Game serverGame, IndianSettlement sis) {
        Specification spec = serverGame.getSpecification();
        StringBuilder sb = new StringBuilder(sis.getName() + "\n");
        sb.append("\nAlarm\n");
        for (Player p : serverGame.getLiveEuropeanPlayers()) {
            Tension tension = sis.getAlarm(p);
            sb.append(Messages.message(p.getNationName()) + " " + (tension == null ? "(none)" : Integer.toString(tension.getValue())) + " " + Messages.message(sis.getShortAlarmLevelMessageId(p)) + " " + (sis.hasSpokenToChief(p) ? "(spoke to chief)" : "") + "\n");
        }
        sb.append("\nGoods Present\n");
        for (Goods goods : sis.getCompactGoods()) {
            sb.append(Messages.message(goods.getLabel(true)) + "\n");
        }
        sb.append("\nGoods Production\n");
        for (GoodsType type : spec.getGoodsTypeList()) {
            int prod = sis.getProductionOf(type);
            if (prod <= 0) continue;
            sb.append(Messages.message(type.getNameKey()) + " " + prod + "\n");
        }
        sb.append("\nPrices (buy 1/100 / sell 1/100)\n");
        GoodsType[] wanted = sis.getWantedGoods();
        for (GoodsType type : spec.getGoodsTypeList()) {
            int i;
            if (!type.isStorable()) continue;
            for (i = wanted.length - 1; i >= 0 && type != wanted[i]; --i) {
            }
            sb.append(Messages.message(type.getNameKey()) + ": " + sis.getPriceToBuy(type, 1) + "/" + sis.getPriceToBuy(type, 100) + " / " + sis.getPriceToSell(type, 1) + "/" + sis.getPriceToSell(type, 100) + (i < 0 ? "" : " wanted[" + Integer.toString(i) + "]") + "\n");
        }
        sb.append("\nOwned Units\n");
        for (Unit u : sis.getOwnedUnits()) {
            sb.append(u + "\n");
            sb.append("  at " + u.getTile() + "\n");
        }
        sb.append("\nTiles\n");
        for (Tile t : sis.getOwnedTiles()) {
            sb.append(t + "\n");
        }
        return sb.toString();
    }
}

