/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyVetoException;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.basic.BasicInternalFrameUI;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.GUIMessage;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.TilePopup;
import net.sf.freecol.client.gui.action.FreeColAction;
import net.sf.freecol.client.gui.action.MapControlsAction;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.CaptureGoodsDialog;
import net.sf.freecol.client.gui.panel.ChatPanel;
import net.sf.freecol.client.gui.panel.ChoiceItem;
import net.sf.freecol.client.gui.panel.ClientOptionsDialog;
import net.sf.freecol.client.gui.panel.ColonyPanel;
import net.sf.freecol.client.gui.panel.ConfirmDeclarationDialog;
import net.sf.freecol.client.gui.panel.DeclarationDialog;
import net.sf.freecol.client.gui.panel.DumpCargoDialog;
import net.sf.freecol.client.gui.panel.EmigrationPanel;
import net.sf.freecol.client.gui.panel.ErrorPanel;
import net.sf.freecol.client.gui.panel.EuropePanel;
import net.sf.freecol.client.gui.panel.EventPanel;
import net.sf.freecol.client.gui.panel.FreeColDialog;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.IndianSettlementPanel;
import net.sf.freecol.client.gui.panel.InformationDialog;
import net.sf.freecol.client.gui.panel.LoadingSavegameDialog;
import net.sf.freecol.client.gui.panel.MainPanel;
import net.sf.freecol.client.gui.panel.MapControls;
import net.sf.freecol.client.gui.panel.NegotiationDialog;
import net.sf.freecol.client.gui.panel.NewPanel;
import net.sf.freecol.client.gui.panel.PreCombatDialog;
import net.sf.freecol.client.gui.panel.RecruitDialog;
import net.sf.freecol.client.gui.panel.ReportHighScoresPanel;
import net.sf.freecol.client.gui.panel.ReportTurnPanel;
import net.sf.freecol.client.gui.panel.SelectDestinationDialog;
import net.sf.freecol.client.gui.panel.ServerListPanel;
import net.sf.freecol.client.gui.panel.StartGamePanel;
import net.sf.freecol.client.gui.panel.StatusPanel;
import net.sf.freecol.client.gui.panel.TilePanel;
import net.sf.freecol.client.gui.panel.TradeRouteDialog;
import net.sf.freecol.client.gui.panel.TrainDialog;
import net.sf.freecol.client.gui.video.Video;
import net.sf.freecol.client.gui.video.VideoComponent;
import net.sf.freecol.client.gui.video.VideoListener;
import net.sf.freecol.common.ServerInfo;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.DiplomaticTrade;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.IndianNationType;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.LostCityRumour;
import net.sf.freecol.common.model.ModelMessage;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TradeRoute;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.common.option.Option;
import net.sf.freecol.common.option.OptionGroup;
import net.sf.freecol.common.resources.ResourceManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Canvas
extends JDesktopPane {
    private static final Logger logger = Logger.getLogger(Canvas.class.getName());
    private static final Integer MAIN_LAYER = JLayeredPane.DEFAULT_LAYER;
    private static final Integer STATUS_LAYER = JLayeredPane.POPUP_LAYER;
    private FreeColDialog<Integer> europeOpenDialog = null;
    private final FreeColClient freeColClient;
    private MainPanel mainPanel;
    private final StartGamePanel startGamePanel;
    private final EuropePanel europePanel;
    private final StatusPanel statusPanel;
    private final ChatPanel chatPanel;
    private final GUI gui;
    private final ServerListPanel serverListPanel;
    private final ClientOptionsDialog clientOptionsDialog;
    private final LoadingSavegameDialog loadingSavegameDialog;
    private final GUI colonyTileGUI;
    private boolean clientOptionsDialogShowing = false;
    private MapControls mapControls;
    private Dimension oldSize = null;
    private Dimension initialSize = null;

    public Canvas(FreeColClient client, Dimension size, GUI gui) {
        this.freeColClient = client;
        this.gui = gui;
        this.colonyTileGUI = new GUI(client, size, this.freeColClient.getImageLibrary());
        this.initialSize = size;
        this.setLocation(0, 0);
        this.setSize(size);
        this.setDoubleBuffered(true);
        this.setOpaque(false);
        this.setLayout(null);
        this.startGamePanel = new StartGamePanel(this);
        this.serverListPanel = new ServerListPanel(this, this.freeColClient.getConnectController());
        this.europePanel = new EuropePanel(this);
        this.statusPanel = new StatusPanel(this);
        this.chatPanel = new ChatPanel(this);
        this.clientOptionsDialog = new ClientOptionsDialog(this);
        this.loadingSavegameDialog = new LoadingSavegameDialog(this);
        this.setFocusable(true);
        this.setFocusTraversalKeysEnabled(false);
        Runtime runtime = Runtime.getRuntime();
        runtime.addShutdownHook(new Thread("FreeColClient:Quitting Game"){

            public void run() {
                Canvas.this.freeColClient.getConnectController().quitGame(true);
            }
        });
        this.createKeyBindings();
        logger.info("Canvas created.");
    }

    @Override
    public Component add(Component comp) {
        this.add(comp, null);
        return comp;
    }

    public void add(Component comp, Integer i) {
        this.add(comp, i, true);
    }

    public void add(Component comp, Integer i, boolean update) {
        if (comp != this.statusPanel && !(comp instanceof JMenuItem) && !(comp instanceof FreeColDialog) && this.statusPanel.isVisible()) {
            this.remove(this.statusPanel, false);
        }
        try {
            if (i == null) {
                super.add(comp);
            } else {
                super.add(comp, i);
            }
        }
        catch (Exception e) {
            logger.warning("add component failed with layer " + i);
        }
        if (update) {
            this.freeColClient.updateMenuBar();
            this.freeColClient.getActionManager().update();
        }
    }

    public JInternalFrame addAsFrame(JComponent comp) {
        return this.addAsFrame(comp, false);
    }

    public JInternalFrame addAsSimpleFrame(JComponent comp) {
        JInternalFrame f = new JInternalFrame();
        JScrollPane scrollPane = new JScrollPane(comp, 20, 30);
        f.getContentPane().add(scrollPane);
        f.pack();
        this.addCentered(f);
        f.setName(comp.getClass().getSimpleName());
        if (f.getUI() instanceof BasicInternalFrameUI) {
            BasicInternalFrameUI biu = (BasicInternalFrameUI)f.getUI();
            biu.setNorthPane(null);
        }
        f.setFrameIcon(null);
        f.setVisible(true);
        f.setResizable(false);
        try {
            f.setSelected(true);
        }
        catch (PropertyVetoException e) {
            // empty catch block
        }
        return f;
    }

    public JInternalFrame addAsToolBox(JComponent comp) {
        return this.addAsFrame(comp, true);
    }

    public Component addCentered(Component comp) {
        this.addCentered(comp, null);
        return comp;
    }

    public void addCentered(Component comp, Integer i) {
        comp.setLocation((this.getWidth() - comp.getWidth()) / 2, (this.getHeight() - comp.getHeight()) / 2);
        this.add(comp, i);
    }

    public void closeMainPanel() {
        if (this.mainPanel != null) {
            this.remove(this.mainPanel);
            this.mainPanel = null;
        }
    }

    public void closeMenus() {
        for (JInternalFrame frame : this.getAllFrames()) {
            for (Component c : frame.getContentPane().getComponents()) {
                if (c instanceof FreeColPanel) {
                    ((FreeColPanel)c).notifyClose();
                }
                if (!(c instanceof ReportTurnPanel)) continue;
                try {
                    throw new IllegalStateException();
                }
                catch (IllegalStateException e) {
                    logger.log(Level.WARNING, "Probably BR#3206298", e);
                }
            }
            frame.dispose();
        }
    }

    public void closeStatusPanel() {
        if (this.statusPanel.isVisible()) {
            this.remove(this.statusPanel);
        }
    }

    public boolean containsInGameComponents() {
        KeyListener[] keyListeners = this.getKeyListeners();
        if (keyListeners.length > 0) {
            return true;
        }
        MouseListener[] mouseListeners = this.getMouseListeners();
        if (mouseListeners.length > 0) {
            return true;
        }
        MouseMotionListener[] mouseMotionListeners = this.getMouseMotionListeners();
        return mouseMotionListeners.length > 0;
    }

    public void debugForeignColony(Settlement settlement) {
        if (settlement instanceof Colony) {
            FreeColGameObject fcgo = this.freeColClient.getFreeColServer().getGame().getFreeColGameObject(settlement.getId());
            this.showColonyPanel((Colony)fcgo);
        }
    }

    public void displayChat(String senderNme, String message, boolean privateChat) {
        this.startGamePanel.displayChat(senderNme, message, privateChat);
    }

    public void displayChatMessage(Player sender, String message, boolean privateChat) {
        this.gui.addMessage(new GUIMessage(sender.getName() + ": " + message, this.getImageLibrary().getColor(sender)));
    }

    public void displayChatMessage(String message) {
        this.displayChatMessage(this.freeColClient.getMyPlayer(), message, false);
    }

    public void errorMessage(String messageID) {
        this.errorMessage(messageID, "Unspecified error: " + messageID);
    }

    public void errorMessage(String messageID, String message) {
        String display = null;
        if (messageID != null) {
            try {
                display = Messages.message(messageID);
            }
            catch (MissingResourceException e) {
                logger.warning("could not find message with id: " + messageID);
            }
        }
        if (display == null || "".equals(display)) {
            display = message;
        }
        ErrorPanel errorPanel = new ErrorPanel(this);
        errorPanel.initialize(display);
        this.showFreeColDialog(errorPanel);
    }

    public FreeColClient getFreeColClient() {
        return this.freeColClient;
    }

    public GUI getColonyTileGUI() {
        return this.colonyTileGUI;
    }

    public GUI getGUI() {
        return this.gui;
    }

    public ImageIcon getImageIcon(Object display, boolean small) {
        ImageLibrary imageLibrary = this.getImageLibrary();
        Image image = null;
        if (display == null) {
            return new ImageIcon();
        }
        if (display instanceof GoodsType) {
            GoodsType goodsType = (GoodsType)display;
            try {
                image = imageLibrary.getGoodsImage(goodsType);
            }
            catch (Exception e) {
                logger.warning("could not find image for goods " + goodsType);
            }
        } else if (display instanceof Unit) {
            Unit unit = (Unit)display;
            try {
                image = imageLibrary.getUnitImageIcon(unit).getImage();
            }
            catch (Exception e) {
                logger.warning("could not find image for unit " + unit.toString());
            }
        } else if (display instanceof UnitType) {
            UnitType unitType = (UnitType)display;
            try {
                image = imageLibrary.getUnitImageIcon(unitType).getImage();
            }
            catch (Exception e) {
                logger.warning("could not find image for unit " + unitType);
            }
        } else if (display instanceof Settlement) {
            Settlement settlement = (Settlement)display;
            try {
                image = imageLibrary.getSettlementImage(settlement);
            }
            catch (Exception e) {
                logger.warning("could not find image for settlement " + settlement);
            }
        } else if (display instanceof LostCityRumour) {
            try {
                image = imageLibrary.getMiscImage("lostCityRumour.image");
            }
            catch (Exception e) {
                logger.warning("could not find image for lost city rumour");
            }
        } else if (display instanceof Player) {
            image = imageLibrary.getCoatOfArmsImage(((Player)display).getNation());
        }
        if (image != null && small) {
            return new ImageIcon(image.getScaledInstance(image.getWidth(null) / 3 * 2, image.getHeight(null) / 3 * 2, 4));
        }
        return image != null ? new ImageIcon(image) : null;
    }

    public ImageLibrary getImageLibrary() {
        return this.freeColClient.getImageLibrary();
    }

    public LoadingSavegameDialog getLoadingSavegameDialog() {
        return this.loadingSavegameDialog;
    }

    public MapControls getMapControls() {
        return this.mapControls;
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(640, 480);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.initialSize;
    }

    public Component getShowingSubPanel() {
        Component[] components;
        for (Component c : components = this.getComponents()) {
            if (c instanceof ToolBoxFrame) continue;
            if (c instanceof JInternalFrame) {
                return c;
            }
            if (!(c instanceof JInternalFrame.JDesktopIcon)) continue;
            return c;
        }
        return null;
    }

    public Specification getSpecification() {
        return this.freeColClient.getGame().getSpecification();
    }

    public boolean isClientOptionsDialogShowing() {
        return this.clientOptionsDialogShowing;
    }

    public boolean isMapboardActionsEnabled() {
        return !this.isShowingSubPanel();
    }

    public boolean isShowingSubPanel() {
        return this.getShowingSubPanel() != null;
    }

    public void newGame() {
        Specification specification = null;
        if (this.freeColClient.getGame() != null) {
            if (this.freeColClient.isMapEditor()) {
                specification = this.freeColClient.getGame().getSpecification();
            } else if (this.showConfirmDialog("stopCurrentGame.text", "stopCurrentGame.yes", "stopCurrentGame.no")) {
                this.freeColClient.getConnectController().quitGame(true);
                FreeCol.incrementFreeColSeed();
            } else {
                return;
            }
            this.removeInGameComponents();
        }
        this.showPanel(new NewPanel(this, specification));
    }

    @Override
    public void paintComponent(Graphics g) {
        this.updateSizes();
        Graphics2D g2d = (Graphics2D)g;
        this.gui.display(g2d);
    }

    public void askToQuit() {
        if (this.showConfirmDialog("quitDialog.areYouSure.text", "ok", "cancel")) {
            this.freeColClient.quit();
        }
    }

    public void refresh() {
        this.gui.forceReposition();
        this.repaint(0, 0, this.getWidth(), this.getHeight());
    }

    public void refreshPlayersTable() {
        this.startGamePanel.refreshPlayersTable();
    }

    public void refreshTile(Tile t) {
        if (t.getX() >= 0 && t.getY() >= 0) {
            this.repaint(this.gui.getTileBounds(t));
        }
    }

    @Override
    public void remove(Component comp) {
        this.remove(comp, true);
    }

    public void remove(Component comp, boolean update) {
        boolean takeFocus;
        if (comp == null) {
            return;
        }
        if (comp instanceof FreeColPanel) {
            ((FreeColPanel)comp).notifyClose();
        }
        Rectangle updateBounds = comp.getBounds();
        JInternalFrame frame = this.getInternalFrame(comp);
        if (frame != null && frame != comp) {
            frame.dispose();
        } else {
            super.remove(comp);
        }
        this.repaint(updateBounds.x, updateBounds.y, updateBounds.width, updateBounds.height);
        boolean bl = takeFocus = comp != this.statusPanel;
        if (update) {
            this.freeColClient.updateMenuBar();
            this.freeColClient.getActionManager().update();
            if (takeFocus && !this.isShowingSubPanel()) {
                this.takeFocus();
            }
        }
    }

    public void removeInGameComponents() {
        KeyListener[] keyListeners = this.getKeyListeners();
        for (int i = 0; i < keyListeners.length; ++i) {
            this.removeKeyListener(keyListeners[i]);
        }
        MouseListener[] mouseListeners = this.getMouseListeners();
        for (int i = 0; i < mouseListeners.length; ++i) {
            this.removeMouseListener(mouseListeners[i]);
        }
        MouseMotionListener[] mouseMotionListeners = this.getMouseMotionListeners();
        for (int i = 0; i < mouseMotionListeners.length; ++i) {
            this.removeMouseMotionListener(mouseMotionListeners[i]);
        }
        this.getGUI().getViewMode().changeViewMode(0);
        for (Component c : this.getComponents()) {
            this.remove(c, false);
        }
    }

    public void retire() {
        if (this.showConfirmDialog("retireDialog.areYouSure.text", "ok", "cancel")) {
            this.freeColClient.setIsRetired(true);
            if (this.freeColClient.askServer().retire()) {
                this.showHighScoresPanel(null);
            }
            this.freeColClient.quit();
        }
    }

    public void showHighScoresPanel(String messageId) {
        this.showPanel(new ReportHighScoresPanel(this, messageId), false);
    }

    public void returnToTitle() {
        this.closeMenus();
        this.removeInGameComponents();
        this.showMainPanel();
        this.freeColClient.playSound("sound.intro.general");
        this.repaint();
    }

    public ScoutIndianSettlementAction showArmedUnitIndianSettlementDialog(IndianSettlement settlement) {
        ArrayList choices = new ArrayList();
        choices.add(new ChoiceItem<ScoutIndianSettlementAction>(Messages.message("scoutSettlement.tribute"), ScoutIndianSettlementAction.INDIAN_SETTLEMENT_TRIBUTE));
        choices.add(new ChoiceItem<ScoutIndianSettlementAction>(Messages.message("scoutSettlement.attack"), ScoutIndianSettlementAction.INDIAN_SETTLEMENT_ATTACK));
        String messageId = settlement.getAlarmLevelMessageId(this.freeColClient.getMyPlayer());
        ScoutIndianSettlementAction result = (ScoutIndianSettlementAction)((Object)this.showChoiceDialog(settlement.getTile(), Messages.message(StringTemplate.template(messageId).addStringTemplate("%nation%", settlement.getOwner().getNationName())), Messages.message("cancel"), choices));
        return result == null ? ScoutIndianSettlementAction.CANCEL : result;
    }

    public BoycottAction showBoycottedGoodsDialog(Goods goods, Europe europe) {
        int arrears = europe.getOwner().getArrears(goods.getType());
        ArrayList choices = new ArrayList();
        choices.add(new ChoiceItem<BoycottAction>(Messages.message("boycottedGoods.payArrears"), BoycottAction.PAY_ARREARS));
        choices.add(new ChoiceItem<BoycottAction>(Messages.message("boycottedGoods.dumpGoods"), BoycottAction.DUMP_CARGO));
        BoycottAction result = (BoycottAction)((Object)this.showChoiceDialog(null, Messages.message(StringTemplate.template("boycottedGoods.text").add("%goods%", goods.getNameKey()).add("%europe%", europe.getNameKey()).addAmount("%amount%", arrears)), Messages.message("cancel"), choices));
        return result == null ? BoycottAction.CANCEL : result;
    }

    public List<Goods> showCaptureGoodsDialog(Unit winner, List<Goods> loot) {
        CaptureGoodsDialog dialog = new CaptureGoodsDialog(this, winner, loot);
        return this.showFreeColDialog(dialog, winner.getTile());
    }

    public void showChatPanel() {
        if (this.freeColClient.isSingleplayer()) {
            return;
        }
        this.showPanel(this.chatPanel);
    }

    public <T> T showChoiceDialog(Tile tile, String text, String cancelText, List<ChoiceItem<T>> choices) {
        ChoiceItem<T> response;
        FreeColDialog<ChoiceItem<T>> choiceDialog = FreeColDialog.createChoiceDialog(text, cancelText, choices);
        if (choiceDialog.getHeight() > this.getHeight() / 3) {
            choiceDialog.setSize(choiceDialog.getWidth(), this.getHeight() * 2 / 3);
        }
        return (response = this.showFreeColDialog(choiceDialog, tile)) == null ? null : (T)response.getObject();
    }

    public <T> T showChoiceDialog(Tile tile, StringTemplate template, String cancelKey, List<ChoiceItem<T>> choices) {
        return this.showChoiceDialog(tile, Messages.message(template), Messages.message(cancelKey), choices);
    }

    public ClaimAction showClaimDialog(Tile tile, Player player, int price, Player owner, boolean canAccept) {
        ArrayList choices = new ArrayList();
        choices.add(new ChoiceItem<ClaimAction>(Messages.message(StringTemplate.template("indianLand.pay").addAmount("%amount%", price)), ClaimAction.ACCEPT, canAccept));
        choices.add(new ChoiceItem<ClaimAction>(Messages.message("indianLand.take"), ClaimAction.STEAL));
        ClaimAction result = (ClaimAction)((Object)this.showChoiceDialog(tile, Messages.message(StringTemplate.template("indianLand.text").addStringTemplate("%player%", owner.getNationName())), Messages.message("indianLand.cancel"), choices));
        return result == null ? ClaimAction.CANCEL : result;
    }

    public OptionGroup showClientOptionsDialog() {
        this.clientOptionsDialog.initialize();
        this.clientOptionsDialogShowing = true;
        OptionGroup group = this.showFreeColDialog(this.clientOptionsDialog);
        this.clientOptionsDialogShowing = false;
        this.freeColClient.getActionManager().update();
        return group;
    }

    public ColonyPanel getColonyPanel(Colony colony) {
        for (Component c1 : this.getComponents()) {
            if (!(c1 instanceof JInternalFrame)) continue;
            for (Component c2 : ((JInternalFrame)c1).getContentPane().getComponents()) {
                if (!(c2 instanceof ColonyPanel) || ((ColonyPanel)c2).getColony() != colony) continue;
                return (ColonyPanel)c2;
            }
        }
        return null;
    }

    public ColonyPanel showColonyPanel(Colony colony) {
        ColonyPanel panel = this.getColonyPanel(colony);
        if (panel != null) {
            return panel;
        }
        panel = new ColonyPanel(this, colony);
        this.showSubPanel(panel, this.getPopupPosition(colony.getTile()));
        return panel;
    }

    public void showColonyPanel(Tile t) {
        if (this.gui.getViewMode().getView() == 0 && t != null && t.getColony() != null && t.getColony().getOwner().equals(this.freeColClient.getMyPlayer())) {
            this.gui.setFocus(t);
            this.gui.stopBlinking();
            this.showColonyPanel(t.getColony());
        }
    }

    public List<String> showConfirmDeclarationDialog() {
        return this.showFreeColDialog(new ConfirmDeclarationDialog(this));
    }

    public boolean showConfirmDialog(String text, String okText, String cancelText) {
        return this.showFreeColDialog(FreeColDialog.createConfirmDialog(Messages.message(text), Messages.message(okText), Messages.message(cancelText)), null);
    }

    public boolean showConfirmDialog(Tile tile, ModelMessage[] messages, String okText, String cancelText) {
        try {
            okText = Messages.message(okText);
        }
        catch (MissingResourceException e) {
            logger.warning("could not find message with id: " + okText + ".");
        }
        try {
            cancelText = Messages.message(cancelText);
        }
        catch (MissingResourceException e) {
            logger.warning("could not find message with id: " + cancelText + ".");
        }
        String[] texts = new String[messages.length];
        ImageIcon[] images = new ImageIcon[messages.length];
        for (int i = 0; i < messages.length; ++i) {
            String id = messages[i].getId();
            try {
                texts[i] = Messages.message(messages[i]);
            }
            catch (MissingResourceException e) {
                logger.warning("could not find message with id: " + id + ".");
            }
            images[i] = this.getImageIcon(this.freeColClient.getGame().getMessageDisplay(messages[i]), false);
        }
        FreeColDialog<Boolean> confirmDialog = FreeColDialog.createConfirmDialog(texts, images, okText, cancelText);
        return this.showFreeColDialog(confirmDialog, tile);
    }

    public boolean showConfirmDialog(Tile tile, StringTemplate text, String okText, String cancelText) {
        return this.showFreeColDialog(FreeColDialog.createConfirmDialog(Messages.message(text), Messages.message(okText), Messages.message(cancelText)), tile);
    }

    public void showDeclarationDialog() {
        this.showFreeColDialog(new DeclarationDialog(this));
    }

    public List<Goods> showDumpCargoDialog(Unit unit) {
        DumpCargoDialog dumpDialog = new DumpCargoDialog(this, unit);
        return this.showFreeColDialog(dumpDialog, unit.getTile());
    }

    public int showEmigrationPanel(boolean fountainOfYouth) {
        EmigrationPanel emigrationPanel = new EmigrationPanel(this);
        emigrationPanel.initialize(this.freeColClient.getMyPlayer().getEurope(), fountainOfYouth);
        return this.showFreeColDialog(emigrationPanel);
    }

    public int showEuropeDialog(EuropePanel.EuropeAction europeAction) {
        try {
            if (this.europeOpenDialog != null) {
                this.europeOpenDialog.setResponse(new Integer(-1));
            }
        }
        catch (NumberFormatException e) {
            logger.warning("Canvas.showEuropeDialog: Invalid europeDialogType");
        }
        FreeColDialog localDialog = null;
        switch (europeAction) {
            case EXIT: 
            case UNLOAD: 
            case SAIL: {
                return -1;
            }
            case RECRUIT: {
                localDialog = new RecruitDialog(this);
                break;
            }
            case PURCHASE: 
            case TRAIN: {
                localDialog = new TrainDialog(this, europeAction);
            }
        }
        localDialog.initialize();
        this.europeOpenDialog = localDialog;
        int response = (Integer)this.showFreeColDialog(localDialog);
        if (this.europeOpenDialog == localDialog) {
            this.europeOpenDialog = null;
        }
        return response;
    }

    public void showEuropePanel() {
        if (this.freeColClient.getGame() == null) {
            this.errorMessage("europe.noGame");
        } else {
            this.europePanel.initialize(this.freeColClient.getMyPlayer().getEurope(), this.freeColClient.getGame());
            this.showSubPanel(this.europePanel);
        }
    }

    public void showEventPanel(EventType type) {
        this.showEventPanel(null, type);
    }

    public void showEventPanel(Tile tile, EventType type) {
        this.showFreeColDialog(new EventPanel(this, type), tile);
    }

    public <T> T showFreeColDialog(FreeColDialog<T> freeColDialog) {
        return this.showFreeColDialog(freeColDialog, null);
    }

    public <T> T showFreeColDialog(FreeColDialog<T> freeColDialog, Tile tile) {
        PopupPosition popupPosition = this.getPopupPosition(tile);
        this.showSubPanel(freeColDialog, popupPosition);
        T response = freeColDialog.getResponse();
        this.remove(freeColDialog);
        return response;
    }

    public void showIndianSettlementPanel(IndianSettlement indianSettlement) {
        IndianSettlementPanel panel = new IndianSettlementPanel(this, indianSettlement);
        this.showSubPanel(panel, this.getPopupPosition(indianSettlement.getTile()));
    }

    public TradeAction showIndianSettlementTradeDialog(Settlement settlement, boolean canBuy, boolean canSell, boolean canGift) {
        ArrayList choices = new ArrayList();
        choices.add(new ChoiceItem<TradeAction>(Messages.message("tradeProposition.toBuy"), TradeAction.BUY, canBuy));
        choices.add(new ChoiceItem<TradeAction>(Messages.message("tradeProposition.toSell"), TradeAction.SELL, canSell));
        choices.add(new ChoiceItem<TradeAction>(Messages.message("tradeProposition.toGift"), TradeAction.GIFT, canGift));
        TradeAction result = (TradeAction)((Object)this.showChoiceDialog(settlement.getTile(), Messages.message(StringTemplate.template("tradeProposition.welcome").addStringTemplate("%nation%", settlement.getOwner().getNationName()).addName("%settlement%", settlement.getName())), Messages.message("tradeProposition.cancel"), choices));
        return result == null ? TradeAction.CANCEL : result;
    }

    public void showInformationMessage(FreeColObject displayObject, String messageId) {
        this.showInformationMessage(displayObject, StringTemplate.key(messageId));
    }

    public void showInformationMessage(FreeColObject displayObject, StringTemplate template) {
        String text = Messages.message(template);
        ImageIcon icon = null;
        if (displayObject != null) {
            icon = this.getImageIcon(displayObject, false);
        }
        Tile tile = null;
        if (displayObject instanceof Tile) {
            tile = (Tile)displayObject;
        } else {
            try {
                tile = (Tile)displayObject.getClass().getMethod("getTile", new Class[0]).invoke((Object)displayObject, new Object[0]);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.showFreeColDialog(new InformationDialog(this, text, icon), tile);
    }

    public void showInformationMessage(ModelMessage message) {
        this.showInformationMessage(this.freeColClient.getGame().getMessageDisplay(message), message);
    }

    public void showInformationMessage(String messageId) {
        this.showInformationMessage(null, StringTemplate.key(messageId));
    }

    public void showInformationMessage(StringTemplate template) {
        this.showInformationMessage(null, template);
    }

    public String showInputDialog(Tile tile, StringTemplate text, String defaultValue, String okText, String cancelText, boolean rejectEmptyString) {
        FreeColDialog<String> inputDialog = FreeColDialog.createInputDialog(Messages.message(text), defaultValue, Messages.message(okText), cancelText == null ? null : Messages.message(cancelText));
        String response = null;
        while (true) {
            response = this.showFreeColDialog(inputDialog, tile);
            if (!rejectEmptyString || response == null || response.length() > 0) break;
            String okTxt = "ok";
            String txt = "enterSomeText";
            try {
                okTxt = Messages.message(okTxt);
                txt = Messages.message(txt);
            }
            catch (MissingResourceException e) {
                logger.warning("could not find message with id: " + txt + " or " + okTxt + ".");
            }
            this.showFreeColDialog(new InformationDialog(this, txt, null), tile);
        }
        return response;
    }

    public File showLoadDialog(File directory) {
        return this.showLoadDialog(directory, new FileFilter[]{FreeColDialog.getFSGFileFilter()});
    }

    public File showLoadDialog(File directory, FileFilter[] fileFilters) {
        FreeColDialog<File> loadDialog = FreeColDialog.createLoadDialog(directory, fileFilters);
        File response = null;
        this.showSubPanel(loadDialog);
        while ((response = loadDialog.getResponse()) != null && !response.isFile()) {
            this.errorMessage("noSuchFile");
        }
        this.remove(loadDialog);
        return response;
    }

    public boolean showLoadingSavegameDialog(boolean publicServer, boolean singleplayer) {
        this.loadingSavegameDialog.initialize(publicServer, singleplayer);
        return this.showFreeColDialog(this.loadingSavegameDialog);
    }

    public void showMainPanel() {
        this.closeMenus();
        this.freeColClient.getFrame().setJMenuBar(null);
        this.mainPanel = new MainPanel(this);
        this.addCentered(this.mainPanel, MAIN_LAYER);
        this.mainPanel.requestFocus();
    }

    private List<ModelMessage> filterEventPanels(ModelMessage[] messages) {
        String eventMatch = "EventPanel.";
        ArrayList<ModelMessage> normal = new ArrayList<ModelMessage>();
        for (int i = 0; i < messages.length; ++i) {
            String id = messages[i].getId();
            if (id.startsWith("EventPanel.")) {
                id = id.substring("EventPanel.".length());
                final EventType e = EventType.valueOf(id);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        Canvas.this.showEventPanel(e);
                    }
                });
                continue;
            }
            normal.add(messages[i]);
        }
        return normal;
    }

    public void showModelMessages(ModelMessage ... modelMessages) {
        List<ModelMessage> messages = this.filterEventPanels(modelMessages);
        Game game = this.freeColClient.getGame();
        String okText = "ok";
        String cancelText = "display";
        String[] messageText = new String[messages.size()];
        ImageIcon[] messageIcon = new ImageIcon[messages.size()];
        try {
            okText = Messages.message(okText);
        }
        catch (MissingResourceException e) {
            logger.warning("could not find message with id: " + okText + ".");
        }
        try {
            cancelText = Messages.message(cancelText);
        }
        catch (MissingResourceException e) {
            logger.warning("could not find message with id: " + cancelText + ".");
        }
        for (int i = 0; i < messages.size(); ++i) {
            try {
                messageText[i] = Messages.message(messages.get(i));
            }
            catch (MissingResourceException e) {
                logger.warning("could not find message with id: " + messages.get(i).getId() + ".");
            }
            messageIcon[i] = this.getImageIcon(game.getMessageDisplay(messages.get(i)), false);
        }
        FreeColGameObject source = game.getMessageSource(messages.get(0));
        if (source instanceof Europe && !this.europePanel.isShowing() || source instanceof Colony || source instanceof WorkLocation) {
            FreeColDialog<Boolean> confirmDialog = FreeColDialog.createConfirmDialog(messageText, messageIcon, okText, cancelText);
            if (this.showFreeColDialog(confirmDialog).booleanValue()) {
                if (!this.isShowingSubPanel()) {
                    this.freeColClient.getInGameController().nextModelMessage();
                }
            } else if (source instanceof Europe) {
                this.showEuropePanel();
            } else if (source instanceof Colony) {
                this.showColonyPanel((Colony)source);
            } else if (source instanceof WorkLocation) {
                this.showColonyPanel(((WorkLocation)source).getColony());
            }
        } else {
            this.showFreeColDialog(new InformationDialog(this, messageText, messageIcon));
            if (!this.isShowingSubPanel()) {
                this.freeColClient.getInGameController().nextModelMessage();
            }
        }
    }

    public DiplomaticTrade showNegotiationDialog(Unit unit, Settlement settlement, DiplomaticTrade agreement) {
        NegotiationDialog negotiationDialog = new NegotiationDialog(this, unit, settlement, agreement);
        negotiationDialog.initialize();
        return this.showFreeColDialog(negotiationDialog, unit.getTile());
    }

    public void showOpenGamePanel() {
        this.errorMessage("openGame.unimplemented");
    }

    public void showOpeningVideoPanel() {
        this.closeMenus();
        Video video = ResourceManager.getVideo("Opening.video");
        boolean muteAudio = !this.getFreeColClient().canPlaySound();
        final VideoComponent vp = new VideoComponent(video, muteAudio);
        this.addCentered(vp, MAIN_LAYER);
        vp.play();
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        final class AbortListener
        implements KeyListener,
        MouseListener,
        VideoListener {
            AbortListener() {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                this.execute();
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                this.execute();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void stopped() {
                this.execute();
            }

            private void execute() {
                Canvas.this.removeKeyListener(this);
                Canvas.this.removeMouseListener(this);
                vp.removeMouseListener(this);
                vp.removeVideoListener(this);
                vp.stop();
                Canvas.this.remove(vp);
                Canvas.this.showMainPanel();
                Canvas.this.freeColClient.playSound("sound.intro.general");
            }
        }
        AbortListener l = new AbortListener();
        this.addMouseListener(l);
        this.addKeyListener(l);
        vp.addMouseListener(l);
        vp.addVideoListener(l);
    }

    public void showPanel(FreeColPanel panel) {
        this.showSubPanel(panel);
    }

    public void showPanel(FreeColPanel panel, boolean centered) {
        this.repaint();
        this.addAsFrame(panel, false, centered ? PopupPosition.CENTERED : PopupPosition.ORIGIN);
        panel.requestFocus();
    }

    public void showPopup(JPopupMenu popup, int x, int y) {
        popup.show(this, x, y);
        popup.repaint();
    }

    public boolean showPreCombatDialog(FreeColGameObject attacker, FreeColGameObject defender, Tile tile) {
        return this.showFreeColDialog(new PreCombatDialog(this, attacker, defender), tile);
    }

    public void showReportTurnPanel(ModelMessage ... messages) {
        this.showPanel(new ReportTurnPanel(this, messages));
    }

    public File showSaveDialog(File directory, String defaultName) {
        return this.showSaveDialog(directory, ".fsg", new FileFilter[]{FreeColDialog.getFSGFileFilter()}, defaultName);
    }

    public File showSaveDialog(File directory, String standardName, FileFilter[] fileFilters, String defaultName) {
        FreeColDialog<File> saveDialog = FreeColDialog.createSaveDialog(directory, standardName, fileFilters, defaultName);
        return this.showFreeColDialog(saveDialog);
    }

    public ScoutColonyAction showScoutForeignColonyDialog(Colony colony, Unit unit, boolean canNegotiate) {
        ArrayList choices = new ArrayList();
        choices.add(new ChoiceItem<ScoutColonyAction>(Messages.message("scoutColony.negotiate"), ScoutColonyAction.FOREIGN_COLONY_NEGOTIATE, canNegotiate));
        choices.add(new ChoiceItem<ScoutColonyAction>(Messages.message("scoutColony.spy"), ScoutColonyAction.FOREIGN_COLONY_SPY));
        choices.add(new ChoiceItem<ScoutColonyAction>(Messages.message("scoutColony.attack"), ScoutColonyAction.FOREIGN_COLONY_ATTACK));
        StringTemplate template = StringTemplate.template("scoutColony.text").addStringTemplate("%unit%", Messages.getLabel(unit)).addName("%colony%", colony.getName());
        ScoutColonyAction result = (ScoutColonyAction)((Object)this.showChoiceDialog(unit.getTile(), template, "cancel", choices));
        return result == null ? ScoutColonyAction.CANCEL : result;
    }

    public ScoutIndianSettlementAction showScoutIndianSettlementDialog(IndianSettlement settlement, String number) {
        GoodsType[] wantedGoods;
        StringBuilder text = new StringBuilder(400);
        Player owner = settlement.getOwner();
        text.append(Messages.message(StringTemplate.template(settlement.getAlarmLevelMessageId(this.freeColClient.getMyPlayer())).addStringTemplate("%nation%", owner.getNationName())));
        text.append("\n\n");
        text.append(Messages.message(StringTemplate.template("scoutSettlement.greetings").addStringTemplate("%nation%", settlement.getOwner().getNationName()).addName("%settlement%", settlement.getName()).add("%number%", number).add("%settlementType%", ((IndianNationType)owner.getNationType()).getSettlementTypeKey(true))));
        text.append(" ");
        if (settlement.getLearnableSkill() != null) {
            text.append(Messages.message(StringTemplate.template("scoutSettlement.skill").add("%skill%", settlement.getLearnableSkill().getNameKey())));
            text.append(" ");
        }
        if ((wantedGoods = settlement.getWantedGoods())[0] != null) {
            text.append(Messages.message(StringTemplate.template("scoutSettlement.trade").add("%goods1%", wantedGoods[0].getNameKey()).add("%goods2%", wantedGoods[1].getNameKey()).add("%goods3%", wantedGoods[2].getNameKey())));
            text.append("\n\n");
        }
        ArrayList choices = new ArrayList();
        choices.add(new ChoiceItem<ScoutIndianSettlementAction>(Messages.message("scoutSettlement.speak"), ScoutIndianSettlementAction.INDIAN_SETTLEMENT_SPEAK));
        choices.add(new ChoiceItem<ScoutIndianSettlementAction>(Messages.message("scoutSettlement.tribute"), ScoutIndianSettlementAction.INDIAN_SETTLEMENT_TRIBUTE));
        choices.add(new ChoiceItem<ScoutIndianSettlementAction>(Messages.message("scoutSettlement.attack"), ScoutIndianSettlementAction.INDIAN_SETTLEMENT_ATTACK));
        ScoutIndianSettlementAction result = (ScoutIndianSettlementAction)((Object)this.showChoiceDialog(settlement.getTile(), text.toString(), Messages.message("cancel"), choices));
        return result == null ? ScoutIndianSettlementAction.CANCEL : result;
    }

    public Location showSelectDestinationDialog(Unit unit) {
        return this.showFreeColDialog(new SelectDestinationDialog(this, unit), unit.getTile());
    }

    public BuyAction showBuyDialog(Unit unit, Settlement settlement, Goods goods, int gold, boolean canBuy) {
        StringTemplate goodsTemplate = StringTemplate.template("model.goods.goodsAmount").add("%goods%", goods.getType().getNameKey()).addAmount("%amount%", goods.getAmount());
        StringTemplate nation = settlement.getOwner().getNationName();
        ArrayList choices = new ArrayList();
        choices.add(new ChoiceItem<BuyAction>(Messages.message("buy.takeOffer"), BuyAction.BUY, canBuy));
        choices.add(new ChoiceItem<BuyAction>(Messages.message("buy.moreGold"), BuyAction.HAGGLE));
        BuyAction result = (BuyAction)((Object)this.showChoiceDialog(unit.getTile(), Messages.message(StringTemplate.template("buy.text").addStringTemplate("%nation%", nation).addStringTemplate("%goods%", goodsTemplate).addAmount("%gold%", gold)), Messages.message("buyProposition.cancel"), choices));
        return result == null ? BuyAction.CANCEL : result;
    }

    public SellAction showSellDialog(Unit unit, Settlement settlement, Goods goods, int gold) {
        StringTemplate goodsTemplate = StringTemplate.template("model.goods.goodsAmount").add("%goods%", goods.getType().getNameKey()).addAmount("%amount%", goods.getAmount());
        StringTemplate nation = settlement.getOwner().getNationName();
        ArrayList choices = new ArrayList();
        choices.add(new ChoiceItem<SellAction>(Messages.message("sell.takeOffer"), SellAction.SELL));
        choices.add(new ChoiceItem<SellAction>(Messages.message("sell.moreGold"), SellAction.HAGGLE));
        choices.add(new ChoiceItem<SellAction>(Messages.message(StringTemplate.template("sell.gift").addStringTemplate("%goods%", goodsTemplate)), SellAction.GIFT));
        SellAction result = (SellAction)((Object)this.showChoiceDialog(unit.getTile(), Messages.message(StringTemplate.template("sell.text").addStringTemplate("%nation%", nation).addStringTemplate("%goods%", goodsTemplate).addAmount("%gold%", gold)), Messages.message("sellProposition.cancel"), choices));
        return result == null ? SellAction.CANCEL : result;
    }

    public void showServerListPanel(String username, ArrayList<ServerInfo> serverList) {
        this.closeMenus();
        this.serverListPanel.initialize(username, serverList);
        this.showSubPanel(this.serverListPanel);
    }

    public <T> T showSimpleChoiceDialog(Tile tile, String text, String cancelText, List<T> objects) {
        ArrayList<ChoiceItem<T>> choices = new ArrayList<ChoiceItem<T>>();
        for (T object : objects) {
            choices.add(new ChoiceItem<T>(object));
        }
        return this.showChoiceDialog(tile, Messages.message(text), Messages.message(cancelText), choices);
    }

    public void showStartGamePanel(Game game, Player player, boolean singlePlayerMode) {
        this.closeMenus();
        if (game != null && player != null) {
            this.startGamePanel.initialize(singlePlayerMode);
            this.showSubPanel(this.startGamePanel);
        } else {
            logger.warning("Tried to open 'StartGamePanel' without having 'game' and/or 'player' set.");
        }
    }

    public void showStatusPanel(String message) {
        this.statusPanel.setStatusMessage(message);
        this.addCentered(this.statusPanel, STATUS_LAYER);
    }

    public void showSubPanel(FreeColPanel panel) {
        this.repaint();
        this.addAsFrame(panel);
        panel.requestFocus();
    }

    public void showSubPanel(FreeColPanel panel, PopupPosition popupPosition) {
        this.repaint();
        this.addAsFrame(panel, false, popupPosition);
        panel.requestFocus();
    }

    public void showTilePopup(Tile tile, int x, int y) {
        if (tile != null) {
            TilePopup tp = new TilePopup(tile, this.freeColClient, this, this.getGUI());
            if (tp.hasItem()) {
                this.showPopup(tp, x, y);
            } else if (tile.isExplored()) {
                this.showPanel(new TilePanel(this, tile));
            }
        }
    }

    public TradeRoute showTradeRouteDialog(Unit unit) {
        return this.showFreeColDialog(new TradeRouteDialog(this, unit.getTradeRoute()), unit.getTile());
    }

    public MissionaryAction showUseMissionaryDialog(Unit unit, IndianSettlement settlement, boolean canEstablish, boolean canDenounce) {
        ArrayList choices = new ArrayList();
        choices.add(new ChoiceItem<MissionaryAction>(Messages.message("missionarySettlement.establish"), MissionaryAction.ESTABLISH_MISSION, canEstablish));
        choices.add(new ChoiceItem<MissionaryAction>(Messages.message("missionarySettlement.heresy"), MissionaryAction.DENOUNCE_HERESY, canDenounce));
        choices.add(new ChoiceItem<MissionaryAction>(Messages.message("missionarySettlement.incite"), MissionaryAction.INCITE_INDIANS));
        String messageId = settlement.getAlarmLevelMessageId(unit.getOwner());
        StringBuilder introText = new StringBuilder(Messages.message(StringTemplate.template(messageId).addStringTemplate("%nation%", settlement.getOwner().getNationName())));
        introText.append("\n\n");
        introText.append(Messages.message(StringTemplate.template("missionarySettlement.question").addName("%settlement%", settlement.getName())));
        MissionaryAction result = (MissionaryAction)((Object)this.showChoiceDialog(unit.getTile(), introText.toString(), Messages.message("cancel"), choices));
        return result == null ? MissionaryAction.CANCEL : result;
    }

    public void updateGameOptions() {
        this.startGamePanel.updateGameOptions();
    }

    public void updateGoldLabel() {
        this.getFreeColClient().getFrame().getJMenuBar().repaint();
    }

    public void updateMapGeneratorOptions() {
        this.startGamePanel.updateMapGeneratorOptions();
    }

    public void updateSizes() {
        if (this.oldSize == null) {
            this.oldSize = this.getSize();
        }
        if (this.oldSize.width != this.getWidth() || this.oldSize.height != this.getHeight()) {
            MapControlsAction mca = (MapControlsAction)this.freeColClient.getActionManager().getFreeColAction("mapControlsAction");
            MapControls mc = mca.getMapControls();
            if (mc != null && mc.isShowing()) {
                mc.removeFromComponent(this);
                mc.addToComponent(this);
                this.mapControls = mc;
            }
            this.gui.setSize(this.getSize());
            this.gui.forceReposition();
            this.oldSize = this.getSize();
        }
    }

    private JInternalFrame addAsFrame(JComponent comp, boolean toolBox) {
        return this.addAsFrame(comp, toolBox, PopupPosition.CENTERED);
    }

    private JInternalFrame addAsFrame(JComponent comp, boolean toolBox, PopupPosition popupPosition) {
        Point p;
        JInternalFrame f;
        int FRAME_EMPTY_SPACE = 60;
        JInternalFrame jInternalFrame = f = toolBox ? new ToolBoxFrame() : new JInternalFrame();
        if (f.getContentPane() instanceof JComponent) {
            JComponent c = (JComponent)f.getContentPane();
            c.setOpaque(false);
            c.setBorder(null);
        }
        if (comp.getBorder() != null) {
            if (comp.getBorder() instanceof EmptyBorder) {
                f.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            } else {
                f.setBorder(comp.getBorder());
                comp.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            }
        } else {
            f.setBorder(null);
        }
        FrameMotionListener fml = new FrameMotionListener(f);
        comp.addMouseMotionListener(fml);
        comp.addMouseListener(fml);
        if (f.getUI() instanceof BasicInternalFrameUI) {
            BasicInternalFrameUI biu = (BasicInternalFrameUI)f.getUI();
            biu.setNorthPane(null);
            biu.setSouthPane(null);
            biu.setWestPane(null);
            biu.setEastPane(null);
        }
        f.getContentPane().add(comp);
        f.setOpaque(false);
        f.pack();
        int width = f.getWidth();
        int height = f.getHeight();
        if (width > this.getWidth() - 60) {
            width = Math.min(width, this.getWidth());
        }
        if (height > this.getHeight() - 60) {
            height = Math.min(height, this.getHeight());
        }
        f.setSize(width, height);
        Point point = p = comp instanceof FreeColPanel ? ((FreeColPanel)comp).getSavedPosition() : null;
        if (p == null) {
            switch (popupPosition) {
                case CENTERED: {
                    f.setLocation((this.getWidth() - f.getWidth()) / 2, (this.getHeight() - f.getHeight()) / 2);
                    break;
                }
                case CENTERED_LEFT: {
                    f.setLocation((this.getWidth() - f.getWidth()) / 4, (this.getHeight() - f.getHeight()) / 2);
                    break;
                }
                case CENTERED_RIGHT: {
                    f.setLocation((this.getWidth() - f.getWidth()) * 3 / 4, (this.getHeight() - f.getHeight()) / 2);
                    break;
                }
                default: {
                    f.setLocation(0, 0);
                    break;
                }
            }
        } else {
            f.setLocation(p);
        }
        this.add((Component)f, MODAL_LAYER);
        f.setName(comp.getClass().getSimpleName());
        f.setFrameIcon(null);
        f.setVisible(true);
        f.setResizable(true);
        try {
            f.setSelected(true);
        }
        catch (PropertyVetoException e) {
            // empty catch block
        }
        return f;
    }

    private void createKeyBindings() {
        for (Option option : this.freeColClient.getActionManager().getOptions()) {
            FreeColAction action = (FreeColAction)option;
            this.getInputMap().put(action.getAccelerator(), action.getId());
            this.getActionMap().put(action.getId(), action);
        }
    }

    private JInternalFrame getInternalFrame(Component c) {
        Component temp;
        for (temp = c; temp != null && !(temp instanceof JInternalFrame); temp = temp.getParent()) {
        }
        return (JInternalFrame)temp;
    }

    private PopupPosition getPopupPosition(Tile tile) {
        if (tile == null) {
            return PopupPosition.CENTERED;
        }
        int where = this.gui.setOffsetFocus(tile);
        return where > 0 ? PopupPosition.CENTERED_LEFT : (where < 0 ? PopupPosition.CENTERED_RIGHT : PopupPosition.CENTERED);
    }

    private void takeFocus() {
        if (!this.isShowingSubPanel()) {
            this.requestFocus();
        }
    }

    public void showSettlement(Settlement s) {
        if (s instanceof Colony) {
            if (s.getOwner().equals(this.freeColClient.getMyPlayer())) {
                this.showColonyPanel((Colony)s);
            } else if (FreeCol.isInDebugMode()) {
                this.debugForeignColony(s);
            }
        } else if (s instanceof IndianSettlement) {
            this.showIndianSettlementPanel((IndianSettlement)s);
        } else {
            throw new IllegalStateException("Bogus settlement");
        }
    }

    class ToolBoxFrame
    extends JInternalFrame {
        ToolBoxFrame() {
        }
    }

    class FrameMotionListener
    extends MouseAdapter
    implements MouseMotionListener {
        private JInternalFrame f;
        private Point loc = null;

        FrameMotionListener(JInternalFrame f) {
            this.f = f;
        }

        public void mouseDragged(MouseEvent e) {
            if (this.loc == null || this.f.getDesktopPane() == null || this.f.getDesktopPane().getDesktopManager() == null) {
                return;
            }
            Point p = SwingUtilities.convertPoint((Component)e.getSource(), e.getX(), e.getY(), null);
            int moveX = this.loc.x - p.x;
            int moveY = this.loc.y - p.y;
            this.f.getDesktopPane().getDesktopManager().dragFrame(this.f, this.f.getX() - moveX, this.f.getY() - moveY);
            this.loc = p;
        }

        public void mouseMoved(MouseEvent arg0) {
        }

        public void mousePressed(MouseEvent e) {
            if (this.f.getDesktopPane() == null || this.f.getDesktopPane().getDesktopManager() == null) {
                return;
            }
            this.loc = SwingUtilities.convertPoint((Component)e.getSource(), e.getX(), e.getY(), null);
            this.f.getDesktopPane().getDesktopManager().beginDraggingFrame(this.f);
        }

        public void mouseReleased(MouseEvent e) {
            if (this.loc == null || this.f.getDesktopPane() == null || this.f.getDesktopPane().getDesktopManager() == null) {
                return;
            }
            this.f.getDesktopPane().getDesktopManager().endDraggingFrame(this.f);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TradeAction {
        CANCEL,
        BUY,
        SELL,
        GIFT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SellAction {
        CANCEL,
        SELL,
        HAGGLE,
        GIFT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ScoutIndianSettlementAction {
        CANCEL,
        INDIAN_SETTLEMENT_SPEAK,
        INDIAN_SETTLEMENT_TRIBUTE,
        INDIAN_SETTLEMENT_ATTACK;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ScoutColonyAction {
        CANCEL,
        FOREIGN_COLONY_NEGOTIATE,
        FOREIGN_COLONY_SPY,
        FOREIGN_COLONY_ATTACK;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PopupPosition {
        ORIGIN,
        CENTERED,
        CENTERED_LEFT,
        CENTERED_RIGHT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MissionaryAction {
        CANCEL,
        ESTABLISH_MISSION,
        DENOUNCE_HERESY,
        INCITE_INDIANS;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EventType {
        FIRST_LANDING,
        MEETING_NATIVES,
        MEETING_EUROPEANS,
        MEETING_AZTEC,
        MEETING_INCA,
        DISCOVER_PACIFIC;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ClaimAction {
        CANCEL,
        ACCEPT,
        STEAL;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BuyAction {
        CANCEL,
        BUY,
        HAGGLE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BoycottAction {
        CANCEL,
        PAY_ARREARS,
        DUMP_CARGO;

    }
}

