/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.model;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Unit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionSession {
    private static final Logger logger = Logger.getLogger(TransactionSession.class.getName());
    private static final Map<String, Map<String, TransactionSession>> allSessions = new HashMap<String, Map<String, TransactionSession>>();
    private Map<String, Object> session = new HashMap<String, Object>();

    private TransactionSession() {
    }

    private static TransactionSession create(FreeColGameObject o1, FreeColGameObject o2) {
        Map<String, TransactionSession> base = allSessions.get(o1.getId());
        if (base == null) {
            base = new HashMap<String, TransactionSession>();
            allSessions.put(o1.getId(), base);
        } else if (base.containsKey(o2.getId())) {
            base.remove(o2.getId());
        }
        TransactionSession session = new TransactionSession();
        base.put(o2.getId(), session);
        return session;
    }

    public static void clearAll() {
        for (Map<String, TransactionSession> s : allSessions.values()) {
            s.clear();
        }
        allSessions.clear();
    }

    public static TransactionSession establishDiplomacySession(Unit unit, Settlement settlement) {
        TransactionSession ts = TransactionSession.create(unit, settlement);
        return ts;
    }

    public static TransactionSession establishLootSession(Unit winner, Unit loser, List<Goods> capture) {
        TransactionSession ts = TransactionSession.create(winner, loser);
        ts.put("lootCargo", capture);
        return ts;
    }

    public static TransactionSession establishTradeSession(Unit unit, Settlement settlement) {
        TransactionSession ts = TransactionSession.create(unit, settlement);
        ts.put("actionTaken", false);
        ts.put("unitMoves", unit.getMovesLeft());
        boolean atWar = settlement.getOwner().atWarWith(unit.getOwner());
        ts.put("canBuy", !atWar);
        ts.put("canSell", !atWar && unit.getSpaceTaken() > 0);
        ts.put("canGift", true);
        return ts;
    }

    public static TransactionSession lookup(String id1, String id2) {
        Map<String, TransactionSession> base = allSessions.get(id1);
        return base == null ? null : base.get(id2);
    }

    public static TransactionSession lookup(FreeColGameObject o1, FreeColGameObject o2) {
        return TransactionSession.lookup(o1.getId(), o2.getId());
    }

    public static void forget(String id1, String id2) {
        Map<String, TransactionSession> base = allSessions.get(id1);
        if (base != null) {
            base.remove(id2);
            if (base.isEmpty()) {
                allSessions.remove(id1);
            }
        }
    }

    public static void forget(FreeColGameObject o1, FreeColGameObject o2) {
        TransactionSession.forget(o1.getId(), o2.getId());
    }

    public Object get(String id) {
        return this.session.get(id);
    }

    public void put(String id, Object val) {
        this.session.put(id, val);
    }
}

