/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.model;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.Event;
import net.sf.freecol.common.model.FreeColGameObjectListener;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.HistoryEvent;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Limit;
import net.sf.freecol.common.model.ModelMessage;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.SimpleCombatModel;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.server.control.ChangeSet;
import net.sf.freecol.server.model.ServerModelObject;
import net.sf.freecol.server.model.ServerPlayer;
import net.sf.freecol.server.model.TransactionSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerGame
extends Game
implements ServerModelObject {
    private static final Logger logger = Logger.getLogger(ServerGame.class.getName());

    public ServerGame(Specification specification) {
        super(specification);
        this.combatModel = new SimpleCombatModel();
        this.currentPlayer = null;
    }

    public ServerGame(FreeColGameObjectListener freeColGameObjectListener, XMLStreamReader in, List<String> serverStrings, Specification specification) throws XMLStreamException {
        super(specification);
        this.setFreeColGameObjectListener(freeColGameObjectListener);
        this.combatModel = new SimpleCombatModel();
        this.viewOwner = null;
        this.setGame(this);
        ArrayList<Object> serverObjects = new ArrayList<Object>();
        while (!serverStrings.isEmpty()) {
            String type = serverStrings.remove(0);
            String string = serverStrings.remove(0);
            try {
                Object o = this.makeServerObject(type, string);
                serverObjects.add(o);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Build " + type + " failed", e);
            }
        }
        this.readFromXML(in);
        for (Object e : serverObjects) {
            if (!(e instanceof Player)) continue;
            Player player = (Player)e;
            if (player.isUnknownEnemy()) {
                this.setUnknownEnemy(player);
                continue;
            }
            this.players.add(player);
        }
    }

    private Object makeServerObject(String type, String id) throws ClassNotFoundException, IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException {
        type = "net.sf.freecol.server.model." + type.substring(0, 1).toUpperCase() + type.substring(1);
        Class<?> c = Class.forName(type);
        return c.getConstructor(Game.class, String.class).newInstance(this, id);
    }

    public String getNextID() {
        String id = Integer.toString(this.nextId);
        ++this.nextId;
        return id;
    }

    public Player checkForWinner() {
        Player winner;
        Specification spec = this.getSpecification();
        if (spec.getBoolean("model.option.victoryDefeatREF")) {
            for (Player player : this.getLiveEuropeanPlayers()) {
                if (player.getPlayerType() != Player.PlayerType.INDEPENDENT) continue;
                return player;
            }
        }
        if (spec.getBoolean("model.option.victoryDefeatEuropeans")) {
            winner = null;
            for (Player player : this.getLiveEuropeanPlayers()) {
                if (player.isREF()) continue;
                if (winner != null) {
                    winner = null;
                    break;
                }
                winner = player;
            }
            if (winner != null) {
                return winner;
            }
        }
        if (spec.getBoolean("model.option.victoryDefeatHumans")) {
            winner = null;
            for (Player player : this.getLiveEuropeanPlayers()) {
                if (player.isAI()) continue;
                if (winner != null) {
                    winner = null;
                    break;
                }
                winner = player;
            }
            if (winner != null) {
                return winner;
            }
        }
        return null;
    }

    public boolean isNextPlayerInNewTurn() {
        Player nextPlayer = this.getNextPlayer();
        return this.players.indexOf(this.currentPlayer) > this.players.indexOf(nextPlayer) || this.currentPlayer == nextPlayer;
    }

    @Override
    public void csNewTurn(Random random, ChangeSet cs) {
        Limit yearLimit;
        TransactionSession.clearAll();
        this.setTurn(this.getTurn().next());
        cs.addTrivial(ChangeSet.See.all(), "newTurn", ChangeSet.ChangePriority.CHANGE_NORMAL, "turn", Integer.toString(this.getTurn().getNumber()));
        logger.info("ServerGame.csNewTurn, turn is " + this.getTurn().toString());
        for (Player player : this.getPlayers()) {
            if (player.isUnknownEnemy()) continue;
            ((ServerPlayer)player).csNewTurn(random, cs);
        }
        Event spanishSuccession = this.getSpecification().getEvent("model.event.spanishSuccession");
        if (spanishSuccession != null && !this.getSpanishSuccession() && (yearLimit = spanishSuccession.getLimit("model.limit.spanishSuccession.year")).evaluate(this)) {
            this.csSpanishSuccession(cs, spanishSuccession);
        }
    }

    private void csSpanishSuccession(ChangeSet cs, Event spanishSuccession) {
        Limit strongestPlayerLimit;
        Limit weakestPlayerLimit;
        Player weakestAIPlayer = null;
        Player strongestAIPlayer = null;
        for (Player player : this.getLiveEuropeanPlayers()) {
            if (player.isREF() || !player.isAI()) continue;
            if (weakestAIPlayer == null || weakestAIPlayer.getScore() > player.getScore()) {
                weakestAIPlayer = player;
            }
            if (strongestAIPlayer != null && strongestAIPlayer.getScore() >= player.getScore()) continue;
            strongestAIPlayer = player;
        }
        if (weakestAIPlayer != null && strongestAIPlayer != null && weakestAIPlayer != strongestAIPlayer && ((weakestPlayerLimit = spanishSuccession.getLimit("model.limit.spanishSuccession.weakestPlayer")) == null || weakestPlayerLimit.evaluate(weakestAIPlayer)) && ((strongestPlayerLimit = spanishSuccession.getLimit("model.limit.spanishSuccession.strongestPlayer")) == null || strongestPlayerLimit.evaluate(strongestAIPlayer))) {
            for (Player player : this.getPlayers()) {
                for (IndianSettlement settlement : player.getIndianSettlementsWithMission(weakestAIPlayer)) {
                    Unit missionary = settlement.getMissionary();
                    missionary.setOwner(strongestAIPlayer);
                    settlement.getTile().updatePlayerExploredTiles();
                    cs.add(ChangeSet.See.perhaps().always((ServerPlayer)strongestAIPlayer), settlement);
                }
            }
            for (Colony colony : weakestAIPlayer.getColonies()) {
                colony.changeOwner(strongestAIPlayer);
                for (Tile tile : colony.getOwnedTiles()) {
                    cs.add(ChangeSet.See.perhaps(), tile);
                }
            }
            for (Unit unit : weakestAIPlayer.getUnits()) {
                unit.setOwner(strongestAIPlayer);
                if (unit.getLocation() instanceof Europe) {
                    unit.setLocation(strongestAIPlayer.getEurope());
                }
                cs.add(ChangeSet.See.perhaps(), unit);
            }
            StringTemplate loser = weakestAIPlayer.getNationName();
            StringTemplate winner = strongestAIPlayer.getNationName();
            cs.addMessage(ChangeSet.See.all(), new ModelMessage(ModelMessage.MessageType.FOREIGN_DIPLOMACY, "model.diplomacy.spanishSuccession", strongestAIPlayer).addStringTemplate("%loserNation%", loser).addStringTemplate("%nation%", winner));
            cs.addGlobalHistory(this, new HistoryEvent(this.getTurn(), HistoryEvent.EventType.SPANISH_SUCCESSION).addStringTemplate("%loserNation%", loser).addStringTemplate("%nation%", winner));
            this.setSpanishSuccession(true);
            cs.addPartial(ChangeSet.See.all(), this, "spanishSuccession");
            ((ServerPlayer)weakestAIPlayer).csKill(cs);
        }
    }

    @Override
    public String getServerXMLElementTagName() {
        return "serverGame";
    }
}

