/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.control;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.sf.freecol.common.model.FoundingFather;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.HistoryEvent;
import net.sf.freecol.common.model.LastSale;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.ModelMessage;
import net.sf.freecol.common.model.Ownable;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Region;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TradeRoute;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeSet {
    private ArrayList<Change> changes;
    private static Comparator<Change> changeComparator = new Comparator<Change>(){

        @Override
        public int compare(Change c1, Change c2) {
            return c1.sortPriority() - c2.sortPriority();
        }
    };

    public ChangeSet() {
        this.changes = new ArrayList();
    }

    public ChangeSet(ChangeSet other) {
        this.changes = new ArrayList<Change>(other.changes);
    }

    public ChangeSet add(See see, FreeColGameObject ... objects) {
        for (FreeColGameObject o : objects) {
            this.changes.add(new ObjectChange(see, o));
        }
        return this;
    }

    public ChangeSet add(See see, List<FreeColGameObject> objects) {
        for (FreeColGameObject o : objects) {
            this.changes.add(new ObjectChange(see, o));
        }
        return this;
    }

    public ChangeSet add(See see, ChangePriority cp, Message message) {
        this.changes.add(new MessageChange(see, cp, message));
        return this;
    }

    public ChangeSet addAttack(See see, Unit unit, Unit defender, boolean success) {
        this.changes.add(new AttackChange(see, unit, defender, success));
        return this;
    }

    public ChangeSet addAttribute(See see, String key, String value) {
        this.changes.add(new AttributeChange(see, key, value));
        return this;
    }

    public ChangeSet addDead(ServerPlayer serverPlayer) {
        this.addTrivial(See.all(), "setDead", ChangePriority.CHANGE_EARLY, "player", serverPlayer.getId());
        return this;
    }

    public ChangeSet addDispose(ServerPlayer owner, Location loc, FreeColGameObject obj) {
        this.changes.add(new RemoveChange(See.perhaps().always(owner), loc, obj.disposeList()));
        return this;
    }

    public ChangeSet addDisappear(ServerPlayer owner, Tile tile, FreeColGameObject fcgo) {
        ArrayList<FreeColGameObject> objects = new ArrayList<FreeColGameObject>();
        objects.add(fcgo);
        this.changes.add(new ObjectChange(See.perhaps().except(owner), tile));
        this.changes.add(new RemoveChange(See.perhaps().except(owner), tile, objects));
        return this;
    }

    public ChangeSet addFather(ServerPlayer serverPlayer, FoundingFather father) {
        this.changes.add(new OwnedChange(See.only(serverPlayer), father));
        serverPlayer.addFather(father);
        return this;
    }

    public ChangeSet addGlobalHistory(Game game, HistoryEvent history) {
        this.changes.add(new OwnedChange(See.all(), history));
        for (Player p : game.getLiveEuropeanPlayers()) {
            p.addHistory(history);
        }
        return this;
    }

    public ChangeSet addHistory(ServerPlayer serverPlayer, HistoryEvent history) {
        this.changes.add(new OwnedChange(See.only(serverPlayer), history));
        serverPlayer.addHistory(history);
        return this;
    }

    public ChangeSet addMessage(See see, ModelMessage message) {
        this.changes.add(new OwnedChange(see, message));
        return this;
    }

    public ChangeSet addMove(See see, Unit unit, Location loc, Tile tile) {
        this.changes.add(new MoveChange(see, unit, loc, tile));
        return this;
    }

    public ChangeSet addPartial(See see, FreeColGameObject fcgo, String ... fields) {
        this.changes.add(new PartialObjectChange(see, fcgo, fields));
        return this;
    }

    public ChangeSet addRegion(ServerPlayer serverPlayer, Region region, String name) {
        Game game = serverPlayer.getGame();
        HistoryEvent h = region.discover(serverPlayer, game.getTurn(), name);
        this.changes.add(new ObjectChange(See.all(), region));
        this.addGlobalHistory(game, h);
        return this;
    }

    public ChangeSet addSale(ServerPlayer serverPlayer, Settlement settlement, GoodsType type, int price) {
        Game game = settlement.getGame();
        LastSale sale = new LastSale(settlement, type, game.getTurn(), price);
        this.changes.add(new OwnedChange(See.only(serverPlayer), sale));
        serverPlayer.saveSale(sale);
        return this;
    }

    public ChangeSet addSpy(See see, Settlement settlement) {
        this.changes.add(new SpyChange(see, settlement));
        return this;
    }

    public ChangeSet addStance(See see, Player first, Player.Stance stance, Player second, boolean war) {
        this.changes.add(new StanceChange(see, first, stance, second, war));
        return this;
    }

    public ChangeSet addTradeRoute(ServerPlayer serverPlayer, TradeRoute tradeRoute) {
        this.changes.add(new OwnedChange(See.only(serverPlayer), tradeRoute));
        serverPlayer.getTradeRoutes().add(tradeRoute);
        return this;
    }

    public ChangeSet addTrivial(See see, String name, ChangePriority cp, String ... attributes) {
        this.changes.add(new TrivialChange(see, name, cp.getPriority(), attributes));
        return this;
    }

    private static void collapseElements(Element head, Element tail) {
        while (tail.hasChildNodes()) {
            head.appendChild(tail.removeChild(tail.getFirstChild()));
        }
    }

    private static boolean collapseOK(Element e1, Element e2) {
        if (e1.getTagName() != e2.getTagName()) {
            return false;
        }
        NamedNodeMap nnm1 = e1.getAttributes();
        NamedNodeMap nnm2 = e2.getAttributes();
        if (nnm1.getLength() != nnm2.getLength()) {
            return false;
        }
        for (int i = 0; i < nnm1.getLength(); ++i) {
            if (nnm1.item(i).getNodeType() != nnm2.item(i).getNodeType()) {
                return false;
            }
            if (nnm1.item(i).getNodeName() != nnm2.item(i).getNodeName()) {
                return false;
            }
            if (nnm1.item(i).getNodeValue() == nnm2.item(i).getNodeValue()) continue;
            return false;
        }
        return true;
    }

    private static List<Element> collapseElementList(List<Element> elements) {
        ArrayList<Element> results = new ArrayList<Element>();
        if (!elements.isEmpty()) {
            Element head = elements.remove(0);
            while (!elements.isEmpty()) {
                Element e = elements.remove(0);
                if (ChangeSet.collapseOK(head, e)) {
                    ChangeSet.collapseElements(head, e);
                    continue;
                }
                results.add(head);
                head = e;
            }
            results.add(head);
        }
        return results;
    }

    public Element build(ServerPlayer serverPlayer) {
        Element result;
        ArrayList<Change> c = new ArrayList<Change>(this.changes);
        List<Element> elements = new ArrayList<Element>();
        ArrayList<Change> diverted = new ArrayList<Change>();
        Document doc = Message.createNewDocument();
        Collections.sort(c, changeComparator);
        while (!c.isEmpty()) {
            Change change = (Change)c.remove(0);
            if (!change.isNotifiable(serverPlayer)) continue;
            if (change.convertsToElement()) {
                elements.add(change.toElement(serverPlayer, doc));
            } else {
                diverted.add(change);
            }
            c.addAll(change.consequences(serverPlayer));
        }
        elements = ChangeSet.collapseElementList(elements);
        switch (elements.size()) {
            case 0: {
                if (diverted.isEmpty()) {
                    return null;
                }
                result = doc.createElement("update");
                break;
            }
            case 1: {
                result = elements.get(0);
                break;
            }
            default: {
                result = doc.createElement("multiple");
                for (Element e : elements) {
                    result.appendChild(e);
                }
            }
        }
        doc.appendChild(result);
        for (Change change : diverted) {
            change.attachToElement(result);
        }
        return result;
    }

    private static class TrivialChange
    extends Change {
        private int priority;
        private String name;
        private String[] attributes;

        TrivialChange(See see, String name, int priority, String[] attributes) {
            super(see);
            if ((attributes.length & 1) == 1) {
                throw new IllegalArgumentException("Attributes must be even sized");
            }
            this.name = name;
            this.priority = priority;
            this.attributes = attributes;
        }

        public int sortPriority() {
            return this.priority;
        }

        public Element toElement(ServerPlayer serverPlayer, Document doc) {
            Element element = doc.createElement(this.name);
            for (int i = 0; i < this.attributes.length; i += 2) {
                element.setAttribute(this.attributes[i], this.attributes[i + 1]);
            }
            return element;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StanceChange
    extends Change {
        private Player first;
        private Player.Stance stance;
        private Player second;
        private boolean war;

        StanceChange(See see, Player first, Player.Stance stance, Player second, boolean war) {
            super(see);
            this.first = first;
            this.stance = stance;
            this.second = second;
            this.war = war;
        }

        @Override
        public int sortPriority() {
            return ChangePriority.CHANGE_STANCE.getPriority();
        }

        @Override
        public boolean isPerhapsNotifiable(ServerPlayer serverPlayer) {
            return (ServerPlayer)this.first == serverPlayer || (ServerPlayer)this.second == serverPlayer || this.war && serverPlayer.hasContacted(this.first) && serverPlayer.hasContacted(this.second) || serverPlayer.hasAbility("model.ability.betterForeignAffairsReport");
        }

        @Override
        public List<Change> consequences(ServerPlayer serverPlayer) {
            ArrayList<Change> changes = new ArrayList<Change>();
            String sta = this.stance.toString();
            ModelMessage m = (ServerPlayer)this.first == serverPlayer ? new ModelMessage(ModelMessage.MessageType.FOREIGN_DIPLOMACY, "model.diplomacy." + sta + ".declared", this.second).addStringTemplate("%nation%", this.second.getNationName()) : ((ServerPlayer)this.second == serverPlayer ? new ModelMessage(ModelMessage.MessageType.FOREIGN_DIPLOMACY, "model.diplomacy." + sta + ".declared", this.first).addStringTemplate("%nation%", this.first.getNationName()) : new ModelMessage(ModelMessage.MessageType.FOREIGN_DIPLOMACY, "model.diplomacy." + sta + ".others", this.first).addStringTemplate("%attacker%", this.first.getNationName()).addStringTemplate("%defender%", this.second.getNationName()));
            changes.add(new OwnedChange(See.only(serverPlayer), m));
            return changes;
        }

        @Override
        public Element toElement(ServerPlayer serverPlayer, Document doc) {
            Element element = doc.createElement("setStance");
            element.setAttribute("stance", this.stance.toString());
            element.setAttribute("first", this.first.getId());
            element.setAttribute("second", this.second.getId());
            return element;
        }
    }

    private static class SpyChange
    extends Change {
        private Tile tile;

        SpyChange(See see, Settlement settlement) {
            super(see);
            this.tile = settlement.getTile();
        }

        public int sortPriority() {
            return ChangePriority.CHANGE_NORMAL.getPriority();
        }

        public Element toElement(ServerPlayer serverPlayer, Document doc) {
            Element element = doc.createElement("spyResult");
            element.setAttribute("tile", this.tile.getId());
            element.appendChild(this.tile.toXMLElement(serverPlayer, doc, true, false));
            element.appendChild(this.tile.toXMLElement(serverPlayer, doc, false, false));
            return element;
        }
    }

    private static class OwnedChange
    extends Change {
        private FreeColObject fco;

        OwnedChange(See see, FreeColObject fco) {
            super(see);
            this.fco = fco;
        }

        public int sortPriority() {
            return ChangePriority.CHANGE_OWNED.getPriority();
        }

        public Element toElement(ServerPlayer serverPlayer, Document doc) {
            Element element = doc.createElement("addObject");
            Element child = this.fco.toXMLElement(serverPlayer, doc, false, false);
            child.setAttribute("owner", serverPlayer.getId());
            element.appendChild(child);
            return element;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RemoveChange
    extends Change {
        private Tile tile;
        private FreeColGameObject fcgo;
        private List<FreeColGameObject> contents;

        RemoveChange(See see, Location loc, List<FreeColGameObject> objects) {
            super(see);
            this.tile = loc instanceof Tile ? (Tile)loc : null;
            this.fcgo = objects.remove(objects.size() - 1);
            this.contents = objects;
        }

        @Override
        public int sortPriority() {
            return ChangePriority.CHANGE_REMOVE.getPriority();
        }

        @Override
        public boolean isPerhapsNotifiable(ServerPlayer serverPlayer) {
            return this.tile != null && serverPlayer.canSee(this.tile) && (this.tile.getSettlement() == null || (ServerPlayer)this.tile.getSettlement().getOwner() == serverPlayer);
        }

        @Override
        public Element toElement(ServerPlayer serverPlayer, Document doc) {
            Element element = doc.createElement("remove");
            if (this.fcgo instanceof Ownable && ((Ownable)((Object)this.fcgo)).getOwner() == serverPlayer) {
                for (FreeColGameObject o : this.contents) {
                    element.appendChild(o.toXMLElementPartial(doc, new String[0]));
                }
                element.setAttribute("divert", this.tile != null ? this.tile.getId() : serverPlayer.getId());
            }
            element.appendChild(this.fcgo.toXMLElementPartial(doc, new String[0]));
            return element;
        }
    }

    private static class PartialObjectChange
    extends ObjectChange {
        private String[] fields;

        PartialObjectChange(See see, FreeColGameObject fcgo, String ... fields) {
            super(see, fcgo);
            this.fields = fields;
        }

        public int sortPriority() {
            return ChangePriority.CHANGE_UPDATE.getPriority();
        }

        public boolean isPerhapsNotifiable(ServerPlayer serverPlayer) {
            return false;
        }

        public Element toElement(ServerPlayer serverPlayer, Document doc) {
            Element element = doc.createElement("update");
            element.appendChild(this.fcgo.toXMLElement(serverPlayer, doc, false, false, this.fields));
            return element;
        }
    }

    private static class ObjectChange
    extends Change {
        protected FreeColGameObject fcgo;

        ObjectChange(See see, FreeColGameObject fcgo) {
            super(see);
            this.fcgo = fcgo;
        }

        public int sortPriority() {
            return ChangePriority.CHANGE_UPDATE.getPriority();
        }

        public boolean isPerhapsNotifiable(ServerPlayer serverPlayer) {
            if (this.fcgo instanceof Unit) {
                return ((Unit)this.fcgo).isVisibleTo(serverPlayer);
            }
            if (this.fcgo instanceof Ownable && ((Ownable)((Object)this.fcgo)).getOwner() == serverPlayer) {
                return true;
            }
            if (this.fcgo instanceof WorkLocation) {
                return false;
            }
            return this.fcgo instanceof Location && ((Location)((Object)this.fcgo)).getTile() != null && serverPlayer.canSee(((Location)((Object)this.fcgo)).getTile());
        }

        public Element toElement(ServerPlayer serverPlayer, Document doc) {
            Element element = doc.createElement("update");
            element.appendChild(this.fcgo.toXMLElement(serverPlayer, doc, false, false));
            return element;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MoveChange
    extends Change {
        private Unit unit;
        private Location oldLocation;
        private Tile newTile;

        private boolean seeOld(ServerPlayer serverPlayer) {
            Tile oldTile = this.oldLocation.getTile();
            return this.unit.getOwner() == serverPlayer || this.oldLocation instanceof Tile && serverPlayer.canSee(oldTile) && oldTile.getSettlement() == null;
        }

        private boolean seeNew(ServerPlayer serverPlayer) {
            return this.unit.getOwner() == serverPlayer || this.unit.isVisibleTo(serverPlayer);
        }

        MoveChange(See see, Unit unit, Location oldLocation, Tile newTile) {
            super(see);
            this.unit = unit;
            this.oldLocation = oldLocation;
            this.newTile = newTile;
        }

        @Override
        public int sortPriority() {
            return ChangePriority.CHANGE_ANIMATION.getPriority();
        }

        @Override
        public boolean isPerhapsNotifiable(ServerPlayer serverPlayer) {
            return this.seeOld(serverPlayer) || this.seeNew(serverPlayer);
        }

        @Override
        public List<Change> consequences(ServerPlayer serverPlayer) {
            if (this.seeOld(serverPlayer) && !this.seeNew(serverPlayer)) {
                ArrayList<Change> changes = new ArrayList<Change>();
                ArrayList<FreeColGameObject> objects = new ArrayList<FreeColGameObject>();
                objects.add(this.unit);
                changes.add(new RemoveChange(See.only(serverPlayer), this.unit.getLocation(), objects));
                return changes;
            }
            return Collections.emptyList();
        }

        @Override
        public Element toElement(ServerPlayer serverPlayer, Document doc) {
            Element element = doc.createElement("animateMove");
            element.setAttribute("unit", this.unit.getId());
            element.setAttribute("oldTile", this.oldLocation.getTile().getId());
            element.setAttribute("newTile", this.newTile.getId());
            if (!this.seeOld(serverPlayer)) {
                element.appendChild(this.unit.toXMLElement(serverPlayer, doc, false, false));
            }
            return element;
        }
    }

    private static class MessageChange
    extends Change {
        private ChangePriority priority;
        private Message message;

        MessageChange(See see, ChangePriority priority, Message message) {
            super(see);
            this.priority = priority;
            this.message = message;
        }

        public int sortPriority() {
            return this.priority.getPriority();
        }

        public Element toElement(ServerPlayer serverPlayer, Document doc) {
            Element element = this.message.toXMLElement();
            return (Element)doc.importNode(element, true);
        }
    }

    private static class AttributeChange
    extends Change {
        private String key;
        private String value;

        AttributeChange(See see, String key, String value) {
            super(see);
            this.key = key;
            this.value = value;
        }

        public int sortPriority() {
            return ChangePriority.CHANGE_ATTRIBUTE.getPriority();
        }

        public boolean convertsToElement() {
            return false;
        }

        public Element toElement(ServerPlayer serverPlayer, Document doc) {
            return null;
        }

        public void attachToElement(Element element) {
            element.setAttribute(this.key, this.value);
        }
    }

    private static class AttackChange
    extends Change {
        private Unit attacker;
        private Unit defender;
        private boolean success;

        AttackChange(See see, Unit attacker, Unit defender, boolean success) {
            super(see);
            this.attacker = attacker;
            this.defender = defender;
            this.success = success;
        }

        public int sortPriority() {
            return ChangePriority.CHANGE_ANIMATION.getPriority();
        }

        public boolean isPerhapsNotifiable(ServerPlayer serverPlayer) {
            return serverPlayer == this.attacker.getOwner() || serverPlayer == this.defender.getOwner() || this.attacker.isVisibleTo(serverPlayer) && this.defender.isVisibleTo(serverPlayer);
        }

        public Element toElement(ServerPlayer serverPlayer, Document doc) {
            Element element = doc.createElement("animateAttack");
            element.setAttribute("attacker", this.attacker.getId());
            element.setAttribute("defender", this.defender.getId());
            element.setAttribute("success", Boolean.toString(this.success));
            if (!this.attacker.isVisibleTo(serverPlayer)) {
                element.appendChild(this.attacker.toXMLElement(serverPlayer, doc, false, false));
            }
            if (!this.defender.isVisibleTo(serverPlayer)) {
                element.appendChild(this.defender.toXMLElement(serverPlayer, doc, false, false));
            }
            return element;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class Change {
        protected See see;

        Change(See see) {
            this.see = see;
        }

        public abstract int sortPriority();

        public boolean isNotifiable(ServerPlayer serverPlayer) {
            return this.see.check(serverPlayer, this.isPerhapsNotifiable(serverPlayer));
        }

        public boolean isPerhapsNotifiable(ServerPlayer serverPlayer) {
            return false;
        }

        public List<Change> consequences(ServerPlayer serverPlayer) {
            return Collections.emptyList();
        }

        public boolean convertsToElement() {
            return true;
        }

        public abstract Element toElement(ServerPlayer var1, Document var2);

        public void attachToElement(Element element) {
        }
    }

    public static class See {
        private static final int ALL = 1;
        private static final int PERHAPS = 0;
        private static final int ONLY = -1;
        private ServerPlayer seeAlways = null;
        private ServerPlayer seePerhaps = null;
        private ServerPlayer seeNever = null;
        private int type;

        private See(int type) {
            this.type = type;
        }

        public boolean check(ServerPlayer player, boolean perhapsResult) {
            return this.seeNever == player ? false : (this.seeAlways == player ? true : (this.type == -1 ? false : (this.type == 1 ? true : perhapsResult)));
        }

        public static See all() {
            return new See(1);
        }

        public static See perhaps() {
            return new See(0);
        }

        public static See only(ServerPlayer player) {
            return new See(-1).always(player);
        }

        public See always(ServerPlayer player) {
            this.seeAlways = player;
            return this;
        }

        public See perhaps(ServerPlayer player) {
            this.seePerhaps = player;
            return this;
        }

        public See except(ServerPlayer player) {
            this.seeNever = player;
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ChangePriority {
        CHANGE_ATTRIBUTE(-1),
        CHANGE_ANIMATION(0),
        CHANGE_REMOVE(100),
        CHANGE_STANCE(5),
        CHANGE_OWNED(20),
        CHANGE_UPDATE(10),
        CHANGE_EARLY(1),
        CHANGE_NORMAL(15),
        CHANGE_LATE(90);

        private int level;

        private ChangePriority(int level) {
            this.level = level;
        }

        public int getPriority() {
            return this.level;
        }
    }
}

