/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ColonyTile;
import net.sf.freecol.common.model.ColonyTradeItem;
import net.sf.freecol.common.model.CombatModel;
import net.sf.freecol.common.model.DiplomaticTrade;
import net.sf.freecol.common.model.EquipmentType;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.FoundingFather;
import net.sf.freecol.common.model.GoldTradeItem;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsTradeItem;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Ownable;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StanceTradeItem;
import net.sf.freecol.common.model.Tension;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TradeItem;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitTradeItem;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.common.model.pathfinding.CostDeciders;
import net.sf.freecol.common.model.pathfinding.GoalDecider;
import net.sf.freecol.server.ai.AIColony;
import net.sf.freecol.server.ai.AIGoods;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIMessage;
import net.sf.freecol.server.ai.AIObject;
import net.sf.freecol.server.ai.AIPlayer;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.TileImprovementPlan;
import net.sf.freecol.server.ai.Transportable;
import net.sf.freecol.server.ai.Wish;
import net.sf.freecol.server.ai.WorkerWish;
import net.sf.freecol.server.ai.mission.BuildColonyMission;
import net.sf.freecol.server.ai.mission.CashInTreasureTrainMission;
import net.sf.freecol.server.ai.mission.DefendSettlementMission;
import net.sf.freecol.server.ai.mission.IdleAtColonyMission;
import net.sf.freecol.server.ai.mission.IndianBringGiftMission;
import net.sf.freecol.server.ai.mission.IndianDemandMission;
import net.sf.freecol.server.ai.mission.Mission;
import net.sf.freecol.server.ai.mission.PioneeringMission;
import net.sf.freecol.server.ai.mission.PrivateerMission;
import net.sf.freecol.server.ai.mission.ScoutingMission;
import net.sf.freecol.server.ai.mission.TransportMission;
import net.sf.freecol.server.ai.mission.UnitSeekAndDestroyMission;
import net.sf.freecol.server.ai.mission.UnitWanderHostileMission;
import net.sf.freecol.server.ai.mission.UnitWanderMission;
import net.sf.freecol.server.ai.mission.WishRealizationMission;
import net.sf.freecol.server.ai.mission.WorkInsideColonyMission;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardAIPlayer
extends AIPlayer {
    private static final Logger logger = Logger.getLogger(StandardAIPlayer.class.getName());
    private static final int MAX_DISTANCE_TO_BRING_GIFT = 5;
    private static final int MAX_NUMBER_OF_GIFTS_BEING_DELIVERED = 1;
    private static final int MAX_DISTANCE_TO_MAKE_DEMANDS = 5;
    private static final int MAX_NUMBER_OF_DEMANDS = 1;
    private AIStrategy strategy = AIStrategy.NONE;
    private HashMap<String, Integer> sessionRegister = new HashMap();

    public StandardAIPlayer(AIMain aiMain, ServerPlayer player) {
        super(aiMain, player.getId());
        this.setPlayer(player);
    }

    public StandardAIPlayer(AIMain aiMain, Element element) {
        super(aiMain, element.getAttribute("ID"));
        this.readFromXMLElement(element);
    }

    public StandardAIPlayer(AIMain aiMain, XMLStreamReader in) throws XMLStreamException {
        super(aiMain, in.getAttributeValue(null, "ID"));
        this.readFromXML(in);
    }

    @Override
    public void startWorking() {
        Player player = this.getPlayer();
        logger.finest("Entering method startWorking: " + player + ", year " + this.getGame().getTurn());
        this.strategy = AIStrategy.TRADE;
        this.sessionRegister.clear();
        this.clearAIUnits();
        if (player.isREF() && !player.isWorkForREF()) {
            logger.warning("No work for REF: " + player);
            return;
        }
        this.cheat();
        this.determineStances();
        this.rearrangeWorkersInColonies();
        this.abortInvalidAndOneTimeMissions();
        this.ensureCorrectMissions();
        this.giveNavalMissions();
        this.secureSettlements();
        this.giveNormalMissions();
        this.bringGifts();
        this.demandTribute();
        this.createAIGoodsInColonies();
        this.createTransportLists();
        this.doMissions();
        this.rearrangeWorkersInColonies();
        this.abortInvalidMissions();
        this.giveNormalMissions();
        this.doMissions();
        this.rearrangeWorkersInColonies();
        this.abortInvalidMissions();
        this.ensureCorrectMissions();
        this.clearAIUnits();
    }

    @Override
    public Iterator<TileImprovementPlan> getTileImprovementPlanIterator() {
        ArrayList<TileImprovementPlan> tileImprovements = new ArrayList<TileImprovementPlan>();
        Iterator<AIColony> acIterator = this.getAIColonyIterator();
        while (acIterator.hasNext()) {
            AIColony ac = acIterator.next();
            Iterator<TileImprovementPlan> it = ac.getTileImprovementPlanIterator();
            while (it.hasNext()) {
                tileImprovements.add(it.next());
            }
        }
        return tileImprovements.iterator();
    }

    @Override
    public void removeTileImprovementPlan(TileImprovementPlan plan) {
        Iterator<AIColony> colonyIter = this.getAIColonyIterator();
        while (colonyIter.hasNext()) {
            AIColony colony = colonyIter.next();
            if (!colony.removeTileImprovementPlan(plan)) continue;
            return;
        }
        logger.warning("Not found given TileImprovementPlan to remove");
    }

    @Override
    public boolean hasFewColonies() {
        if (!this.getPlayer().canBuildColonies()) {
            return false;
        }
        int numberOfColonies = 0;
        int numberOfWorkers = 0;
        for (Settlement settlement : this.getPlayer().getSettlements()) {
            ++numberOfColonies;
            numberOfWorkers += settlement.getUnitCount();
        }
        boolean result = numberOfColonies <= 2 || numberOfColonies >= 3 && numberOfWorkers / numberOfColonies > numberOfColonies - 2;
        logger.finest("hasFewColonies = " + result);
        return result;
    }

    @Override
    public Iterator<Wish> getWishIterator() {
        ArrayList<Wish> wishList = new ArrayList<Wish>();
        Iterator<AIColony> ai = this.getAIColonyIterator();
        while (ai.hasNext()) {
            AIColony ac = ai.next();
            Iterator<Wish> wishIterator = ac.getWishIterator();
            while (wishIterator.hasNext()) {
                Wish w = wishIterator.next();
                wishList.add(w);
            }
        }
        Collections.sort(wishList);
        return wishList.iterator();
    }

    @Override
    public FoundingFather selectFoundingFather(List<FoundingFather> foundingFathers) {
        int age = this.getGame().getTurn().getAge();
        FoundingFather bestFather = null;
        int bestWeight = -1;
        for (FoundingFather father : foundingFathers) {
            if (father == null) continue;
            if (father.hasAbility("model.ability.buildCustomHouse")) {
                return father;
            }
            int weight = father.getWeight(age);
            if (weight <= bestWeight) continue;
            bestWeight = weight;
            bestFather = father;
        }
        return bestFather;
    }

    @Override
    public boolean acceptTax(int tax) {
        Goods toBeDestroyed = this.getPlayer().getMostValuableGoods();
        if (toBeDestroyed == null) {
            return false;
        }
        GoodsType goodsType = toBeDestroyed.getType();
        if (goodsType.isFoodType() || goodsType.isBreedable()) {
            return false;
        }
        if (goodsType.isMilitaryGoods() || goodsType.isTradeGoods() || goodsType.isBuildingMaterial()) {
            return this.getGame().getTurn().getAge() != 3;
        }
        int averageIncome = 0;
        int numberOfGoods = 0;
        List<GoodsType> goodsTypes = this.getAIMain().getGame().getSpecification().getGoodsTypeList();
        for (GoodsType type : goodsTypes) {
            if (!type.isStorable()) continue;
            averageIncome += this.getPlayer().getIncomeAfterTaxes(type);
            ++numberOfGoods;
        }
        return this.getPlayer().getIncomeAfterTaxes(toBeDestroyed.getType()) <= (averageIncome /= numberOfGoods);
    }

    @Override
    public boolean acceptIndianDemand(Unit unit, Colony colony, Goods goods, int gold) {
        return this.strategy != AIStrategy.CONQUEST;
    }

    @Override
    public boolean acceptMercenaryOffer() {
        return this.strategy == AIStrategy.CONQUEST || this.getPlayer().isAtWar();
    }

    @Override
    public boolean acceptDiplomaticTrade(DiplomaticTrade agreement) {
        boolean validOffer = true;
        Player.Stance stance = null;
        int value = 0;
        Iterator<TradeItem> itemIterator = agreement.iterator();
        while (itemIterator.hasNext()) {
            TradeItem item = itemIterator.next();
            if (item instanceof GoldTradeItem) {
                int gold = ((GoldTradeItem)item).getGold();
                if (item.getSource() == this.getPlayer()) {
                    value -= gold;
                    continue;
                }
                value += gold;
                continue;
            }
            if (item instanceof StanceTradeItem) {
                stance = ((StanceTradeItem)item).getStance();
                switch (stance) {
                    case UNCONTACTED: {
                        validOffer = false;
                        break;
                    }
                    case WAR: {
                        break;
                    }
                    case CEASE_FIRE: {
                        value -= 500;
                        break;
                    }
                    case PEACE: {
                        if (agreement.getSender().hasAbility("model.ability.alwaysOfferedPeace")) break;
                        value -= 1000;
                        break;
                    }
                    case ALLIANCE: {
                        value -= 2000;
                    }
                }
                continue;
            }
            if (item instanceof ColonyTradeItem) {
                if (item.getSource() == this.getPlayer()) {
                    validOffer = false;
                    break;
                }
                value += 1000;
                continue;
            }
            if (item instanceof UnitTradeItem) {
                if (item.getSource() == this.getPlayer()) {
                    validOffer = false;
                    break;
                }
                value += 100;
                continue;
            }
            if (!(item instanceof GoodsTradeItem)) continue;
            Goods goods = ((GoodsTradeItem)item).getGoods();
            if (item.getSource() == this.getPlayer()) {
                value -= this.getPlayer().getMarket().getBidPrice(goods.getType(), goods.getAmount());
                continue;
            }
            value += this.getPlayer().getMarket().getSalePrice(goods.getType(), goods.getAmount());
        }
        if (validOffer) {
            logger.info("Trade value is " + value + ", accept if >=0");
        } else {
            logger.info("Trade offer is considered invalid!");
        }
        return value >= 0 && validOffer;
    }

    @Override
    public void registerSellGoods(Goods goods) {
        String goldKey = "tradeGold#" + goods.getType().getId() + "#" + goods.getAmount() + "#" + goods.getLocation().getId();
        this.sessionRegister.put(goldKey, null);
    }

    @Override
    public int buyProposition(Unit unit, Settlement settlement, Goods goods, int gold) {
        logger.finest("Entering method buyProposition");
        String goldKey = "tradeGold#" + goods.getType().getId() + "#" + goods.getAmount() + "#" + settlement.getId();
        String hagglingKey = "tradeHaggling#" + unit.getId();
        Integer registered = this.sessionRegister.get(goldKey);
        if (registered == null) {
            int price = ((IndianSettlement)settlement).getPriceToSell(goods) + this.getPlayer().getTension(unit.getOwner()).getValue();
            this.sessionRegister.put(goldKey, new Integer(price));
            return price;
        }
        int price = registered;
        if (price < 0 || price == gold) {
            return price;
        }
        if (gold < price * 9 / 10) {
            logger.warning("Cheating attempt: sending a offer too low");
            this.sessionRegister.put(goldKey, new Integer(-1));
            return -1;
        }
        int haggling = 1;
        if (this.sessionRegister.containsKey(hagglingKey)) {
            haggling = this.sessionRegister.get(hagglingKey);
        }
        if (this.getAIRandom().nextInt(3 + haggling) <= 3) {
            this.sessionRegister.put(goldKey, new Integer(gold));
            this.sessionRegister.put(hagglingKey, new Integer(haggling + 1));
            return gold;
        }
        this.sessionRegister.put(goldKey, new Integer(-1));
        return -1;
    }

    @Override
    public int sellProposition(Unit unit, Settlement settlement, Goods goods, int gold) {
        logger.finest("Entering method sellProposition");
        if (settlement instanceof IndianSettlement) {
            int price;
            String goldKey = "tradeGold#" + goods.getType().getId() + "#" + goods.getAmount() + "#" + unit.getId();
            String hagglingKey = "tradeHaggling#" + unit.getId();
            if (this.sessionRegister.containsKey(goldKey)) {
                price = this.sessionRegister.get(goldKey);
                if (price <= 0) {
                    return price;
                }
            } else {
                price = ((IndianSettlement)settlement).getPriceToBuy(goods) - this.getPlayer().getTension(unit.getOwner()).getValue();
                if (price <= 0) {
                    return 0;
                }
                this.sessionRegister.put(goldKey, new Integer(price));
            }
            if (gold < 0 || price == gold) {
                return price;
            }
            if (gold > price * 11 / 10) {
                logger.warning("Cheating attempt: haggling with a request too high");
                this.sessionRegister.put(goldKey, new Integer(-1));
                return -1;
            }
            int haggling = 1;
            if (this.sessionRegister.containsKey(hagglingKey)) {
                haggling = this.sessionRegister.get(hagglingKey);
            }
            if (this.getAIRandom().nextInt(3 + haggling) <= 3) {
                this.sessionRegister.put(goldKey, new Integer(gold));
                this.sessionRegister.put(hagglingKey, new Integer(haggling + 1));
                return gold;
            }
            this.sessionRegister.put(goldKey, new Integer(-1));
            return -1;
        }
        if (settlement instanceof Colony) {
            Colony colony = (Colony)settlement;
            Player otherPlayer = unit.getOwner();
            if (this.getPlayer().atWarWith(otherPlayer)) {
                return -1;
            }
            int amount = colony.getWarehouseCapacity() - colony.getGoodsCount(goods.getType());
            amount = Math.min(amount, goods.getAmount());
            Tension.Level tensionLevel = this.getPlayer().getTension(otherPlayer).getLevel();
            int percentage = (9 - tensionLevel.ordinal()) * 10;
            int netProfits = (100 - this.getPlayer().getTax()) * this.getPlayer().getMarket().getSalePrice(goods.getType(), amount) / 100;
            int price = netProfits * percentage / 100;
            return price;
        }
        throw new IllegalArgumentException("Unknown type of settlement.");
    }

    @Override
    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement(StandardAIPlayer.getXMLElementTagName());
        out.writeAttribute("ID", this.getId());
        out.writeEndElement();
    }

    @Override
    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        this.setPlayer((ServerPlayer)this.getAIMain().getFreeColGameObject(in.getAttributeValue(null, "ID")));
        in.nextTag();
    }

    public static String getXMLElementTagName() {
        return "aiPlayer";
    }

    private void cheat() {
        logger.finest("Entering method cheat");
        for (GoodsType goodsType : this.getAIMain().getGame().getSpecification().getGoodsTypeList()) {
            this.getPlayer().getMarket().setArrears(goodsType, 0);
        }
        if (this.getAIMain().getFreeColServer().isSingleplayer() && this.getPlayer().isEuropean() && !this.getPlayer().isREF() && this.getPlayer().isAI() && this.getPlayer().getPlayerType() == Player.PlayerType.COLONIAL) {
            Europe europe = this.getPlayer().getEurope();
            List<UnitType> unitTypes = this.getAIMain().getGame().getSpecification().getUnitTypeList();
            if (this.getAIRandom().nextInt(10) == 1) {
                int price = 0;
                UnitType unitToTrain = null;
                for (UnitType unitType : unitTypes) {
                    if (!unitType.hasPrice()) continue;
                    int unitPrice = europe.getUnitPrice(unitType);
                    if (unitToTrain != null && unitPrice >= price) continue;
                    unitToTrain = unitType;
                    price = unitPrice;
                }
                Unit unit = null;
                if (unitToTrain != null) {
                    this.getPlayer().modifyGold(price);
                    AIUnit aiUnit = this.trainAIUnitInEurope(unitToTrain);
                    if (aiUnit != null) {
                        unit = aiUnit.getUnit();
                    }
                }
                if (unit != null && unit.isColonist()) {
                    Specification spec = this.getAIMain().getGame().getSpecification();
                    GoodsType muskets = spec.getGoodsType("model.goods.muskets");
                    GoodsType horses = spec.getGoodsType("model.goods.horses");
                    this.getPlayer().modifyGold(this.getPlayer().getMarket().getBidPrice(muskets, 50));
                    this.getPlayer().modifyGold(this.getPlayer().getMarket().getBidPrice(horses, 50));
                    AIMessage.askClearSpeciality(this.getAIUnit(unit));
                    EquipmentType horsesEq = spec.getEquipmentType("model.equipment.horses");
                    EquipmentType musketsEq = spec.getEquipmentType("model.equipment.muskets");
                    AIMessage.askEquipUnit(this.getAIUnit(unit), horsesEq, 1);
                    AIMessage.askEquipUnit(this.getAIUnit(unit), musketsEq, 1);
                }
            }
            if (this.getAIRandom().nextInt(40) == 21) {
                int total = 0;
                ArrayList<UnitType> navalUnits = new ArrayList<UnitType>();
                for (UnitType unitType : unitTypes) {
                    if (!unitType.hasAbility("model.ability.navalUnit") || !unitType.hasPrice()) continue;
                    navalUnits.add(unitType);
                    total += europe.getUnitPrice(unitType);
                }
                UnitType unitToPurchase = null;
                int random = this.getAIRandom().nextInt(total);
                total = 0;
                for (UnitType unitType : navalUnits) {
                    if (random >= (total += unitType.getPrice())) continue;
                    unitToPurchase = unitType;
                    break;
                }
                this.getPlayer().modifyGold(europe.getUnitPrice(unitToPurchase));
                this.trainAIUnitInEurope(unitToPurchase);
            }
        }
    }

    private void ensureCorrectMissions() {
        logger.finest("Entering method ensureCorrectMissions");
        if (this.getPlayer().isIndian()) {
            return;
        }
        for (AIUnit au : this.getAIUnits()) {
            Unit u;
            if (au.hasMission() || !((u = au.getUnit()).getLocation() instanceof WorkLocation)) continue;
            AIColony ac = this.getAIColony(u.getColony());
            if (ac == null) {
                logger.warning("No AIColony for unit: " + u + " at: " + u.getLocation());
                continue;
            }
            au.setMission(new WorkInsideColonyMission(this.getAIMain(), au, ac));
        }
    }

    private void determineStances() {
        logger.finest("Entering method determineStances");
        Player player = this.getPlayer();
        for (Player p : this.getGame().getPlayers()) {
            if (p == player || p.isDead()) continue;
            this.determineStance(p);
        }
    }

    private void abortInvalidMissions() {
        for (AIUnit au : this.getAIUnits()) {
            if (au.getMission() == null || au.getMission().isValid()) continue;
            logger.finest("Abort invalid mission for: " + au.getUnit());
            au.setMission(null);
        }
    }

    private void abortInvalidAndOneTimeMissions() {
        for (AIUnit au : this.getAIUnits()) {
            Mission mission = au.getMission();
            if (mission == null) continue;
            if (!mission.isValid()) {
                logger.finest("Abort invalid mission: " + mission + " for: " + au.getUnit());
                au.setMission(null);
                continue;
            }
            if (!(mission instanceof UnitWanderHostileMission) && !(mission instanceof UnitWanderMission) && !(mission instanceof IdleAtColonyMission)) continue;
            logger.finest("Abort one-time mission: " + mission + " for: " + au.getUnit());
            au.setMission(null);
        }
    }

    private void giveNavalMissions() {
        logger.finest("Entering method giveNavalMissions");
        if (!this.getPlayer().isEuropean()) {
            return;
        }
        for (AIUnit au : this.getAIUnits()) {
            if (au.hasMission() || !au.getUnit().isNaval()) continue;
            Mission mission = PrivateerMission.isValid(au) ? new PrivateerMission(this.getAIMain(), au) : new TransportMission(this.getAIMain(), au);
            au.setMission(mission);
        }
    }

    private void rearrangeWorkersInColonies() {
        logger.finest("Entering method rearrangeWorkersInColonies");
        if (!this.getPlayer().isEuropean()) {
            return;
        }
        Iterator<AIColony> ci = this.getAIColonyIterator();
        while (ci.hasNext()) {
            AIColony c = ci.next();
            if (c.getColony().getOwner() != this.getPlayer()) continue;
            ArrayList<Tile> oldWorkTiles = new ArrayList<Tile>();
            for (ColonyTile colonyTile : c.getColony().getColonyTiles()) {
                if (colonyTile.getUnit() == null) continue;
                oldWorkTiles.add(colonyTile.getWorkTile());
            }
            c.rearrangeWorkers(this.getConnection());
        }
    }

    private void secureSettlements() {
        logger.finest("Entering method secureSettlements");
        if (this.getPlayer().isEuropean()) {
            for (Colony colony : this.getPlayer().getColonies()) {
                this.equipSoldiersOutsideColony(colony);
                this.reOrganizeSoldiersOfColony(colony);
            }
        } else {
            List<IndianSettlement> settlements = this.getPlayer().getIndianSettlements();
            for (IndianSettlement is : settlements) {
                int n = this.getAIRandom().nextInt(settlements.size());
                IndianSettlement settlement = settlements.get(n);
                if (settlement == is) continue;
                is.tradeGoodsWithSetlement(settlement);
            }
            for (IndianSettlement is : settlements) {
                this.equipBraves(is);
                this.secureIndianSettlement(is);
            }
        }
    }

    public void equipBraves(IndianSettlement is) {
        Specification spec = this.getGame().getSpecification();
        GoodsType armsType = spec.getGoodsType("model.goods.muskets");
        GoodsType horsesType = spec.getGoodsType("model.goods.horses");
        EquipmentType armsEqType = spec.getEquipmentType("model.equipment.indian.muskets");
        EquipmentType horsesEqType = spec.getEquipmentType("model.equipment.indian.horses");
        int musketsToArmIndian = armsEqType.getAmountRequiredOf(armsType);
        int horsesToMountIndian = horsesEqType.getAmountRequiredOf(horsesType);
        int armsAvail = is.getGoodsCount(armsType);
        int horsesAvail = is.getGoodsCount(horsesType);
        for (Unit brave : is.getUnitList()) {
            if (armsAvail < musketsToArmIndian) break;
            if (brave.isArmed()) continue;
            logger.info("Equipping brave with muskets");
            AIMessage.askEquipUnit(this.getAIUnit(brave), armsEqType, 1);
            if (!brave.isArmed()) {
                logger.warning("Brave has not been armed");
            }
            armsAvail = is.getGoodsCount(armsType);
        }
        for (Unit brave : is.getUnitList()) {
            if (horsesAvail < horsesToMountIndian) break;
            if (brave.isMounted()) continue;
            logger.info("Equipping brave with horses");
            AIMessage.askEquipUnit(this.getAIUnit(brave), horsesEqType, 1);
            if (!brave.isMounted()) {
                logger.warning("Brave has not mounted");
            }
            horsesAvail = is.getGoodsCount(horsesType);
        }
    }

    void equipSoldiersOutsideColony(Colony colony) {
        boolean colonyHasArmedUnits = false;
        boolean canArmUnit = false;
        EquipmentType musketsEqType = this.getAIMain().getGame().getSpecification().getEquipmentType("model.equipment.muskets");
        EquipmentType horsesEqType = this.getAIMain().getGame().getSpecification().getEquipmentType("model.equipment.horses");
        Comparator<Unit> comp = Unit.getSkillLevelComparator();
        ArrayList<Unit> unarmedExpertSoldiers = new ArrayList<Unit>();
        ArrayList<Unit> unarmedColonists = new ArrayList<Unit>();
        ArrayList<Unit> unmountedSoldiers = new ArrayList<Unit>();
        for (Unit unit : colony.getTile().getUnitList()) {
            boolean isArmed = unit.isArmed();
            boolean isMounted = unit.isMounted();
            boolean isExpertSoldier = unit.hasAbility("model.ability.expertSoldier");
            if (isExpertSoldier) {
                if (isArmed) {
                    colonyHasArmedUnits = true;
                    if (isMounted) continue;
                    unmountedSoldiers.add(unit);
                    continue;
                }
                unarmedExpertSoldiers.add(unit);
                continue;
            }
            if (unit.isArmed()) {
                colonyHasArmedUnits = true;
                if (isMounted) continue;
                unmountedSoldiers.add(unit);
                continue;
            }
            unarmedColonists.add(unit);
        }
        for (Unit unit : unarmedExpertSoldiers) {
            canArmUnit = colony.canBuildEquipment(musketsEqType);
            boolean isMounted = unit.isMounted();
            if (!canArmUnit) continue;
            AIMessage.askEquipUnit(this.getAIUnit(unit), musketsEqType, 1);
            colonyHasArmedUnits = true;
            if (isMounted) continue;
            unmountedSoldiers.add(unit);
        }
        if (!colonyHasArmedUnits) {
            canArmUnit = colony.canBuildEquipment(musketsEqType);
            if (!canArmUnit || unarmedColonists.size() == 0) {
                return;
            }
            Collections.sort(unarmedColonists, comp);
            for (Unit unit : unarmedColonists) {
                if (!unit.canBeEquippedWith(musketsEqType)) continue;
                this.cheatEquipmentGoods(colony, musketsEqType, 1);
                AIMessage.askEquipUnit(this.getAIUnit(unit), musketsEqType, 1);
                if (unit.isMounted()) break;
                unmountedSoldiers.add(unit);
                break;
            }
        }
        comp = new Comparator<Unit>(){

            @Override
            public int compare(Unit unit1, Unit unit2) {
                boolean isUnit1Expert = unit1.hasAbility("model.ability.expertSoldier");
                boolean isUnit2Expert = unit2.hasAbility("model.ability.expertSoldier");
                if (isUnit1Expert && !isUnit2Expert) {
                    return -1;
                }
                if (!isUnit1Expert && isUnit2Expert) {
                    return 1;
                }
                return 0;
            }
        };
        Collections.sort(unmountedSoldiers, comp);
        while (unmountedSoldiers.size() > 0 && colony.canBuildEquipment(horsesEqType)) {
            Unit soldier = (Unit)unmountedSoldiers.remove(0);
            this.cheatEquipmentGoods(colony, horsesEqType, 1);
            AIMessage.askEquipUnit(this.getAIUnit(soldier), horsesEqType, 1);
        }
    }

    private void cheatEquipmentGoods(Colony colony, EquipmentType type, int amount) {
        for (AbstractGoods goods : type.getGoodsRequired()) {
            GoodsType goodsType = goods.getType();
            int n = amount * goods.getAmount() - colony.getGoodsCount(goodsType);
            if (n <= 0) continue;
            colony.addGoods(goodsType, n);
        }
    }

    void reOrganizeSoldiersOfColony(Colony colony) {
        ArrayList<Unit> unarmedExpertSoldiers = new ArrayList<Unit>();
        ArrayList<Unit> armedNonExpertSoldiers = new ArrayList<Unit>();
        ArrayList<Unit> colonistsInside = new ArrayList<Unit>();
        Comparator<Unit> comp = Unit.getSkillLevelComparator();
        Comparator<Unit> reverseComp = Collections.reverseOrder(comp);
        for (Unit unit : colony.getTile().getUnitList()) {
            boolean isArmed = unit.isArmed();
            boolean isExpertSoldier = unit.hasAbility("model.ability.expertSoldier");
            if (isExpertSoldier) {
                if (isArmed) continue;
                unarmedExpertSoldiers.add(unit);
                continue;
            }
            if (!isArmed) continue;
            armedNonExpertSoldiers.add(unit);
        }
        Collections.sort(armedNonExpertSoldiers, reverseComp);
        for (Unit unit : unarmedExpertSoldiers) {
            if (armedNonExpertSoldiers.size() == 0) {
                return;
            }
            Unit otherSoldier = (Unit)armedNonExpertSoldiers.remove(0);
            this.switchEquipmentWith(unit, otherSoldier);
            unit.setState(Unit.UnitState.ACTIVE);
            otherSoldier.setState(Unit.UnitState.ACTIVE);
            this.getAIUnit(unit).setMission(null);
            this.getAIUnit(otherSoldier).setMission(null);
        }
        if (armedNonExpertSoldiers.size() == 0) {
            return;
        }
        colonistsInside.addAll(colony.getUnitList());
        Collections.sort(colonistsInside, comp);
        for (Unit unit : armedNonExpertSoldiers) {
            if (colonistsInside.size() == 0) {
                return;
            }
            Unit unitInside = (Unit)colonistsInside.remove(0);
            if (unit.getSkillLevel() <= unitInside.getSkillLevel()) {
                return;
            }
            Location loc = unitInside.getLocation();
            unitInside.putOutsideColony();
            this.switchEquipmentWith(unit, unitInside);
            unit.setLocation(loc);
            unit.setState(Unit.UnitState.IN_COLONY);
            unitInside.setState(Unit.UnitState.ACTIVE);
            this.getAIUnit(unit).setMission(null);
            this.getAIUnit(unitInside).setMission(null);
        }
    }

    public void removeAllEquipment(Unit unit) {
        AIUnit aiUnit = this.getAIUnit(unit);
        Set<EquipmentType> kit = unit.getEquipment().keySet();
        for (EquipmentType type : new ArrayList<EquipmentType>(kit)) {
            AIMessage.askEquipUnit(aiUnit, type, -unit.getEquipmentCount(type));
        }
    }

    public void switchEquipmentWith(Unit unit1, Unit unit2) {
        if (!unit1.isColonist() || !unit2.isColonist()) {
            throw new IllegalArgumentException("Both units need to be colonists to switch equipment");
        }
        if (unit1.getTile() != unit2.getTile()) {
            throw new IllegalStateException("Units can only switch equipment in the same location");
        }
        if (unit1.getSettlement() == null) {
            throw new IllegalStateException("Units can only switch equipment in a settlement");
        }
        ArrayList<EquipmentType> equipList1 = new ArrayList<EquipmentType>(unit1.getEquipment().keySet());
        ArrayList<EquipmentType> equipList2 = new ArrayList<EquipmentType>(unit2.getEquipment().keySet());
        this.removeAllEquipment(unit1);
        this.removeAllEquipment(unit2);
        for (EquipmentType equip : equipList2) {
            AIMessage.askEquipUnit(this.getAIUnit(unit1), equip, 1);
        }
        for (EquipmentType equip : equipList1) {
            AIMessage.askEquipUnit(this.getAIUnit(unit2), equip, 1);
        }
    }

    void secureIndianSettlement(IndianSettlement is) {
        AIUnit newDefenderAI;
        if (!is.getOwner().isAtWar()) {
            return;
        }
        int defenders = is.getTile().getUnitCount();
        int threat = 0;
        int worstThreat = 0;
        Location bestTarget = null;
        for (Tile t : is.getTile().getSurroundingTiles(2)) {
            if (!t.isLand() || t.getUnitCount() == 0) continue;
            Player enemy = t.getFirstUnit().getOwner();
            if (enemy == this.getPlayer()) {
                ++defenders;
                continue;
            }
            if (!this.getPlayer().hasContacted(enemy)) continue;
            int value = this.getPlayer().getTension(enemy).getValue();
            int threatModifier = 0;
            int unitThreat = 0;
            if (value >= 300) {
                threatModifier = 2;
                unitThreat = t.getUnitCount() * 2;
            } else if (value >= 100) {
                threatModifier = 1;
                unitThreat = t.getUnitCount();
            }
            threat += threatModifier;
            if (unitThreat <= worstThreat) continue;
            bestTarget = t.getSettlement() != null ? t.getSettlement() : t.getFirstUnit();
            worstThreat = unitThreat;
        }
        if (threat > defenders && bestTarget != null && (newDefenderAI = this.getBraveForSeekAndDestroy(is)) != null) {
            Tile targetTile = bestTarget.getTile();
            if (this.isTargetValidForSeekAndDestroy(newDefenderAI.getUnit(), targetTile)) {
                newDefenderAI.setMission(new UnitSeekAndDestroyMission(this.getAIMain(), newDefenderAI, bestTarget));
            }
        }
    }

    private AIUnit getBraveForSeekAndDestroy(IndianSettlement indianSettlement) {
        Iterator<Unit> it = indianSettlement.getOwnedUnitsIterator();
        while (it.hasNext()) {
            AIUnit chosenOne = this.getAIUnit(it.next());
            if (!(chosenOne.getUnit().getLocation() instanceof Tile) || chosenOne.getMission() != null && !(chosenOne.getMission() instanceof UnitWanderHostileMission)) continue;
            return chosenOne;
        }
        return null;
    }

    private void giveNormalMissions() {
        logger.finest("Entering method giveNormalMissions");
        HashMap workerWishes = new HashMap();
        for (UnitType unitType : this.getAIMain().getGame().getSpecification().getUnitTypeList()) {
            workerWishes.put(unitType, new ArrayList());
        }
        if (this.getPlayer().isEuropean()) {
            Iterator<AIColony> aIterator = this.getAIColonyIterator();
            while (aIterator.hasNext()) {
                Iterator<Wish> wIterator = aIterator.next().getWishIterator();
                while (wIterator.hasNext()) {
                    Wish w = wIterator.next();
                    if (!(w instanceof WorkerWish) || w.getTransportable() != null) continue;
                    ((ArrayList)workerWishes.get(((WorkerWish)w).getUnitType())).add(w);
                }
            }
        }
        boolean fewColonies = this.hasFewColonies();
        boolean isPioneerReq = PioneeringMission.getPlayerPioneers(this).size() == 0;
        Iterator<AIUnit> aiUnitsIterator = this.getAIUnitIterator();
        while (aiUnitsIterator.hasNext()) {
            boolean isExpert;
            AIUnit aiUnit = aiUnitsIterator.next();
            if (aiUnit.hasMission()) continue;
            Unit unit = aiUnit.getUnit();
            if (unit.isUninitialized()) {
                logger.warning("Trying to assign a mission to an uninitialized object: " + unit.getId());
                continue;
            }
            if (unit.getState() == Unit.UnitState.IN_COLONY && unit.getSettlement().getUnitCount() <= 1 || unit.isNaval()) continue;
            if (unit.canCarryTreasure()) {
                aiUnit.setMission(new CashInTreasureTrainMission(this.getAIMain(), aiUnit));
                continue;
            }
            if (unit.hasAbility("model.ability.scoutIndianSettlement") && ScoutingMission.isValid(aiUnit)) {
                aiUnit.setMission(new ScoutingMission(this.getAIMain(), aiUnit));
                continue;
            }
            if (unit.isOffensiveUnit() || unit.isDefensiveUnit()) {
                boolean isPastStart;
                Player owner = unit.getOwner();
                boolean bl = isPastStart = this.getGame().getTurn().getNumber() > 5 && !owner.getSettlements().isEmpty();
                if (!unit.isColonist() || isPastStart || owner.isIndian() || owner.isREF()) {
                    this.giveMilitaryMission(aiUnit);
                    continue;
                }
            }
            boolean isPioneer = unit.hasAbility("model.ability.improveTerrain") || unit.hasAbility("model.ability.expertPioneer");
            boolean bl = isExpert = unit.getSkillLevel() > 0;
            if ((isPioneer || isPioneerReq && !isExpert) && PioneeringMission.isValid(aiUnit)) {
                aiUnit.setMission(new PioneeringMission(this.getAIMain(), aiUnit));
                isPioneerReq = false;
                continue;
            }
            if (unit.isColonist() && unit.getOwner().isEuropean()) {
                HashMap<Location, Integer> distances = new HashMap<Location, Integer>(121);
                for (ArrayList al : workerWishes.values()) {
                    for (Wish w : al) {
                        if (distances.containsKey(w.getDestination())) continue;
                        distances.put(w.getDestination(), unit.getTurnsToReach(w.getDestination()));
                    }
                }
                ArrayList wishList = (ArrayList)workerWishes.get(unit.getType());
                Wish bestWish = null;
                int bestTurns = Integer.MAX_VALUE;
                for (int i = 0; i < wishList.size(); ++i) {
                    WorkerWish ww = (WorkerWish)wishList.get(i);
                    if (ww.getTransportable() != null) {
                        wishList.remove(i);
                        --i;
                        continue;
                    }
                    int turns = (Integer)distances.get(ww.getDestination());
                    if (turns == Integer.MAX_VALUE) {
                        turns = ww.getDestination().getTile() == null ? 5 : 10;
                    } else if (turns > 5) {
                        turns = 5;
                    }
                    if (bestWish != null && ww.getValue() - turns * 2 <= bestWish.getValue() - bestTurns * 2) continue;
                    bestWish = ww;
                    bestTurns = turns;
                }
                if (bestWish != null) {
                    bestWish.setTransportable(aiUnit);
                    aiUnit.setMission(new WishRealizationMission(this.getAIMain(), aiUnit, bestWish));
                    continue;
                }
                Tile colonyTile = null;
                if (this.getPlayer().canBuildColonies() && (colonyTile = BuildColonyMission.findColonyLocation(aiUnit.getUnit())) != null) {
                    bestTurns = unit.getTurnsToReach(colonyTile);
                }
                if (!fewColonies || colonyTile == null || bestTurns > 10) {
                    for (ArrayList wishes : workerWishes.values()) {
                        for (int j = 0; j < wishes.size(); ++j) {
                            WorkerWish ww = (WorkerWish)wishes.get(j);
                            if (ww.getTransportable() != null) {
                                wishes.remove(j);
                                --j;
                                continue;
                            }
                            int turns = (Integer)distances.get(ww.getDestination());
                            if (turns == Integer.MAX_VALUE) {
                                turns = ww.getDestination().getTile() == null ? 5 : 10;
                            } else if (turns > 5) {
                                turns = 5;
                            }
                            if (bestWish != null && ww.getValue() - turns * 2 <= bestWish.getValue() - bestTurns * 2) continue;
                            bestWish = ww;
                            bestTurns = turns;
                        }
                    }
                }
                if (bestWish != null) {
                    bestWish.setTransportable(aiUnit);
                    aiUnit.setMission(new WishRealizationMission(this.getAIMain(), aiUnit, bestWish));
                    continue;
                }
                if (colonyTile != null) {
                    BuildColonyMission mission = new BuildColonyMission(this.getAIMain(), aiUnit, colonyTile, this.getPlayer().getColonyValue(colonyTile));
                    aiUnit.setMission(mission);
                    boolean isUnitOnCarrier = aiUnit.getUnit().isOnCarrier();
                    if (!isUnitOnCarrier) continue;
                    AIUnit carrier = this.getAIUnit((Unit)aiUnit.getUnit().getLocation());
                    Mission carrierMission = carrier.getMission();
                    boolean isCarrierMissionToTransport = carrierMission instanceof TransportMission;
                    if (!isCarrierMissionToTransport) {
                        throw new IllegalStateException("Carrier carrying unit not on a transport mission");
                    }
                    ((TransportMission)carrierMission).addToTransportList(aiUnit);
                    continue;
                }
            }
            if (aiUnit.hasMission()) continue;
            if (aiUnit.getUnit().isOffensiveUnit()) {
                aiUnit.setMission(new UnitWanderHostileMission(this.getAIMain(), aiUnit));
                continue;
            }
            aiUnit.setMission(new IdleAtColonyMission(this.getAIMain(), aiUnit));
        }
    }

    private void bringGifts() {
        logger.finest("Entering method bringGifts");
        if (!this.getPlayer().isIndian()) {
            return;
        }
        block0: for (IndianSettlement indianSettlement : this.getPlayer().getIndianSettlements()) {
            if (this.getAIRandom().nextInt(10) != 1) continue;
            int alreadyAssignedUnits = 0;
            Iterator<Unit> ownedUnits = indianSettlement.getOwnedUnitsIterator();
            while (ownedUnits.hasNext()) {
                if (!(this.getAIUnit(ownedUnits.next()).getMission() instanceof IndianBringGiftMission)) continue;
                ++alreadyAssignedUnits;
            }
            if (alreadyAssignedUnits > 1) continue;
            ArrayList<Colony> nearbyColonies = new ArrayList<Colony>();
            for (Tile t : indianSettlement.getTile().getSurroundingTiles(5)) {
                if (t.getColony() == null || !IndianBringGiftMission.isValidMission(this.getPlayer(), t.getColony().getOwner())) continue;
                nearbyColonies.add(t.getColony());
            }
            if (nearbyColonies.size() <= 0) continue;
            Colony target = (Colony)nearbyColonies.get(this.getAIRandom().nextInt(nearbyColonies.size()));
            Iterator<Unit> it2 = indianSettlement.getOwnedUnitsIterator();
            AIUnit chosenOne = null;
            while (it2.hasNext()) {
                PathNode pn;
                chosenOne = this.getAIUnit(it2.next());
                if (!(chosenOne.getUnit().getLocation() instanceof Tile) || chosenOne.getMission() != null && !(chosenOne.getMission() instanceof UnitWanderHostileMission) || (pn = chosenOne.getUnit().findPath(indianSettlement.getTile(), target.getTile())) == null || pn.getTotalTurns() > 5) continue;
                chosenOne.setMission(new IndianBringGiftMission(this.getAIMain(), chosenOne, target));
                continue block0;
            }
        }
    }

    private void demandTribute() {
        logger.finest("Entering method demandTribute");
        if (!this.getPlayer().isIndian()) {
            return;
        }
        block0: for (IndianSettlement indianSettlement : this.getPlayer().getIndianSettlements()) {
            if (this.getAIRandom().nextInt(10) != 1) continue;
            int alreadyAssignedUnits = 0;
            Iterator<Unit> ownedUnits = indianSettlement.getOwnedUnitsIterator();
            while (ownedUnits.hasNext()) {
                if (!(this.getAIUnit(ownedUnits.next()).getMission() instanceof IndianDemandMission)) continue;
                ++alreadyAssignedUnits;
            }
            if (alreadyAssignedUnits > 1) continue;
            ArrayList<Colony> nearbyColonies = new ArrayList<Colony>();
            for (Tile t : indianSettlement.getTile().getSurroundingTiles(5)) {
                if (t.getColony() == null) continue;
                nearbyColonies.add(t.getColony());
            }
            if (nearbyColonies.size() <= 0) continue;
            int targetTension = Integer.MIN_VALUE;
            Settlement target = null;
            for (int i = 0; i < nearbyColonies.size(); ++i) {
                Colony t = (Colony)nearbyColonies.get(i);
                Player to = t.getOwner();
                if (!this.getPlayer().hasContacted(to) || !indianSettlement.hasContactedSettlement(to)) continue;
                int tension = 1 + this.getPlayer().getTension(to).getValue() + indianSettlement.getAlarm(to).getValue();
                tension = this.getAIRandom().nextInt(tension);
                if (tension <= targetTension) continue;
                targetTension = tension;
                target = t;
            }
            if (target == null) continue;
            Iterator<Unit> it2 = indianSettlement.getOwnedUnitsIterator();
            AIUnit chosenOne = null;
            while (it2.hasNext()) {
                PathNode pn;
                chosenOne = this.getAIUnit(it2.next());
                if (!(chosenOne.getUnit().getLocation() instanceof Tile) || chosenOne.getMission() != null && !(chosenOne.getMission() instanceof UnitWanderHostileMission) || (pn = chosenOne.getUnit().findPath(indianSettlement.getTile(), target.getTile())) == null || pn.getTotalTurns() > 5) continue;
                Player tp = target.getOwner();
                int tension = 1 + this.getPlayer().getTension(tp).getValue() + indianSettlement.getAlarm(tp).getValue();
                if (this.getAIRandom().nextInt(tension) <= Tension.Level.HAPPY.getLimit()) continue;
                chosenOne.setMission(new IndianDemandMission(this.getAIMain(), chosenOne, (Colony)target));
                continue block0;
            }
        }
    }

    private void createAIGoodsInColonies() {
        logger.finest("Entering method createAIGoodsInColonies");
        if (!this.getPlayer().isEuropean()) {
            return;
        }
        Iterator<AIColony> ci = this.getAIColonyIterator();
        while (ci.hasNext()) {
            AIColony c = ci.next();
            c.createAIGoods();
        }
    }

    private void doMissions() {
        logger.finest("Entering method doMissions");
        Iterator<AIUnit> aiUnitsIterator = this.getAIUnitIterator();
        while (aiUnitsIterator.hasNext()) {
            AIUnit aiUnit = aiUnitsIterator.next();
            if (!aiUnit.hasMission() || !aiUnit.getMission().isValid() || aiUnit.getUnit().isOnCarrier()) continue;
            try {
                aiUnit.doMission(this.getConnection());
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "doMissions failed", e);
            }
        }
    }

    public int getDefendColonyMissionValue(Unit unit, Colony colony, int turns) {
        if (unit == null || colony == null) {
            return Integer.MIN_VALUE;
        }
        int value = 10025 - 10 * turns;
        int defenders = 0;
        for (AIUnit au : this.getAIUnits()) {
            Mission m = au.getMission();
            if (m == null || !(m instanceof DefendSettlementMission) || ((DefendSettlementMission)m).getSettlement() != colony || au.getUnit().getColony() != colony) continue;
            value -= 500;
            ++defenders;
        }
        if (unit.getOwner().isREF()) {
            if (defenders > 0) {
                return 0;
            }
            value -= 100;
        }
        if (colony.hasStockade()) {
            value = defenders > colony.getStockade().getLevel() + 1 ? 20 - defenders : (value -= 1000 * colony.getStockade().getLevel());
        }
        return Math.max(0, value);
    }

    int getUnitSeekAndDestroyMissionValue(Unit unit, Tile newTile, int turns) {
        if (!this.isTargetValidForSeekAndDestroy(unit, newTile)) {
            return Integer.MIN_VALUE;
        }
        Settlement settlement = newTile.getSettlement();
        Unit defender = newTile.getDefendingUnit(unit);
        int value = 10020 - turns * 100;
        if (settlement != null) {
            IndianSettlement is;
            Tension tension;
            if (settlement instanceof Colony) {
                Colony colony = (Colony)settlement;
                value += 50 * colony.getUnitCount();
                if (colony.hasStockade()) {
                    value -= 1000 * colony.getStockade().getLevel();
                }
            } else if (settlement instanceof IndianSettlement && (tension = (is = (IndianSettlement)settlement).getAlarm(unit.getOwner())) != null) {
                value += tension.getValue();
            }
        } else if (defender != null) {
            CombatModel combatModel = unit.getGame().getCombatModel();
            float off = combatModel.getOffencePower(unit, defender);
            float def = combatModel.getDefencePower(unit, defender);
            Unit train = this.getBestTreasureTrain(newTile);
            if (train != null) {
                value += Math.min(train.getTreasureAmount() / 10, 50);
            }
            if (defender.getType().getOffence() > 0) {
                value = (int)((float)value + (200.0f - def * 2.0f - (float)(turns * 50)));
            }
            value = (int)((float)value + (combatModel.getOffencePower(defender, unit) - combatModel.getDefencePower(defender, unit)));
            if (!defender.isNaval() && defender.hasAbility("model.ability.expertSoldier") && !defender.isArmed()) {
                value = (int)((float)value + (10.0f - def * 2.0f - (float)(turns * 25)));
            }
            if (value < 0) {
                value = 0;
            }
        }
        logger.finest("getUnitSeekAndDestroyMissionValue " + unit.getId() + " v " + (settlement != null ? settlement.getId() : (defender != null ? defender.getId() : "none")) + " = " + value);
        return value;
    }

    public boolean isTargetValidForSeekAndDestroy(Unit attacker, Tile tile) {
        Player defenderPlayer;
        Player attackerPlayer = attacker.getOwner();
        if (attacker == null) {
            return false;
        }
        Settlement settlement = tile.getSettlement();
        Unit defender = tile.getDefendingUnit(attacker);
        Player player = settlement != null ? settlement.getOwner() : (defenderPlayer = defender != null ? defender.getOwner() : null);
        if (defenderPlayer == null) {
            return false;
        }
        if (attackerPlayer == defenderPlayer) {
            return false;
        }
        boolean atWar = attackerPlayer.atWarWith(defenderPlayer);
        if (attackerPlayer.isEuropean() ? !atWar : attackerPlayer.isIndian() && !atWar && attackerPlayer.getTension(defenderPlayer).getLevel().compareTo(Tension.Level.CONTENT) <= 0) {
            return false;
        }
        return !(attacker.isNaval() ? settlement != null || !defender.isNaval() || defender.getTile().isLand() : defender != null && !defender.getTile().isLand());
    }

    public void giveMilitaryMission(AIUnit aiUnit) {
        logger.finest("Entering giveMilitaryMission for: " + aiUnit.getUnit());
        AIMain aiMain = this.getAIMain();
        Player player = this.getPlayer();
        Mission mission = null;
        if (player.isIndian()) {
            mission = new UnitWanderHostileMission(aiMain, aiUnit);
        } else {
            Tile targetTile;
            int value;
            GoalDecider targetDecider;
            PathNode newTarget;
            PathNode last;
            Colony colony;
            int value2;
            final Unit unit = aiUnit.getUnit();
            Map map = aiMain.getGame().getMap();
            Unit carrier = !unit.isOnCarrier() ? null : (Unit)unit.getLocation();
            Ownable bestTarget = null;
            int bestValue = Integer.MIN_VALUE;
            Tile startTile = (carrier != null ? carrier : unit).getTile();
            if (startTile == null) {
                startTile = (carrier != null ? carrier : unit).getFullEntryLocation();
            }
            if (startTile == null) {
                logger.warning("giveMilitaryMission failed, no tile for: " + unit);
                return;
            }
            if (unit.getColony() != null) {
                bestTarget = unit.getColony();
                bestValue = this.getDefendColonyMissionValue(unit, (Colony)bestTarget, 0);
            }
            GoalDecider gd = new GoalDecider(){
                private PathNode best = null;
                private int bestValue = 0;

                public PathNode getGoal() {
                    return this.best;
                }

                public boolean hasSubGoals() {
                    return true;
                }

                private int getValue(PathNode pathNode) {
                    Colony colony = pathNode.getTile().getColony();
                    return colony == null || colony.getOwner() != unit.getOwner() ? Integer.MIN_VALUE : StandardAIPlayer.this.getDefendColonyMissionValue(unit, colony, pathNode.getTurns());
                }

                public boolean check(Unit u, PathNode pathNode) {
                    int value = this.getValue(pathNode);
                    if (value > this.bestValue) {
                        this.bestValue = value;
                        this.best = pathNode;
                        return true;
                    }
                    return false;
                }
            };
            int MAXIMUM_TURNS_TO_SETTLEMENT = 10;
            PathNode bestPath = map.search(unit, startTile, gd, CostDeciders.avoidIllegal(), 10, carrier);
            if (bestPath != null && (value2 = this.getDefendColonyMissionValue(unit, colony = (last = bestPath.getLastNode()).getTile().getColony(), last.getTurns())) > bestValue) {
                bestTarget = colony;
                bestValue = value2;
            }
            Location bestExistingTarget = null;
            int bestDistance = Integer.MAX_VALUE;
            for (AIUnit au : this.getAIUnits()) {
                UnitSeekAndDestroyMission usdm;
                int distance;
                Unit u = au.getUnit();
                if (u.getTile() == null || !(au.getMission() instanceof UnitSeekAndDestroyMission) || (distance = unit.getTurnsToReach(startTile, (usdm = (UnitSeekAndDestroyMission)au.getMission()).getTarget().getTile())) >= bestDistance) continue;
                bestExistingTarget = usdm.getTarget();
                bestDistance = distance;
            }
            if (bestExistingTarget != null && (value = this.getUnitSeekAndDestroyMissionValue(unit, bestExistingTarget.getTile(), bestDistance)) > bestValue) {
                bestValue = value;
                bestTarget = (Ownable)((Object)bestExistingTarget);
            }
            if ((newTarget = map.search(unit, startTile, targetDecider = new GoalDecider(){
                private PathNode bestTarget = null;
                private int bestNewTargetValue = Integer.MIN_VALUE;

                public PathNode getGoal() {
                    return this.bestTarget;
                }

                public boolean hasSubGoals() {
                    return true;
                }

                private int getValue(PathNode pathNode) {
                    Tile tile = pathNode.getTile();
                    return StandardAIPlayer.this.isTargetValidForSeekAndDestroy(unit, tile) ? StandardAIPlayer.this.getUnitSeekAndDestroyMissionValue(unit, tile, pathNode.getTurns()) : Integer.MIN_VALUE;
                }

                public boolean check(Unit u, PathNode pathNode) {
                    int value = this.getValue(pathNode);
                    if (value > this.bestNewTargetValue) {
                        this.bestTarget = pathNode;
                        this.bestNewTargetValue = value;
                        return true;
                    }
                    return false;
                }
            }, CostDeciders.avoidIllegal(), Integer.MAX_VALUE, carrier)) != null && (value = this.getUnitSeekAndDestroyMissionValue(unit, targetTile = newTarget.getLastNode().getTile(), newTarget.getTotalTurns())) > bestValue) {
                bestValue = value;
                bestTarget = targetTile.getSettlement() != null ? targetTile.getSettlement() : (this.getBestTreasureTrain(targetTile) != null ? this.getBestTreasureTrain(targetTile) : targetTile.getDefendingUnit(unit));
            }
            if (bestTarget != null && bestValue > 0) {
                if (bestTarget instanceof Settlement && ((Settlement)bestTarget).getOwner() == player) {
                    Settlement settlement = bestTarget;
                    mission = new DefendSettlementMission(aiMain, aiUnit, settlement);
                } else {
                    mission = new UnitSeekAndDestroyMission(aiMain, aiUnit, (Location)((Object)bestTarget));
                }
            } else {
                mission = new UnitWanderHostileMission(aiMain, aiUnit);
            }
        }
        aiUnit.setMission(mission);
        logger.finest("giveMilitaryMission found: " + mission + " for unit: " + aiUnit);
    }

    private void createTransportLists() {
        logger.finest("Entering method createTransportLists");
        if (!this.getPlayer().isEuropean()) {
            return;
        }
        ArrayList<AIObject> transportables = new ArrayList<AIObject>();
        for (AIUnit au : this.getAIUnits()) {
            if (au.getUnit().isNaval() || au.getTransport() != null || au.getTransportDestination() == null) continue;
            transportables.add(au);
        }
        Iterator<AIColony> aci = this.getAIColonyIterator();
        while (aci.hasNext()) {
            AIColony ac = aci.next();
            Iterator<AIGoods> iterator = ac.getAIGoodsIterator();
            while (iterator.hasNext()) {
                AIGoods ag = iterator.next();
                if (ag.getTransportDestination() == null || ag.getTransport() != null) continue;
                transportables.add(ag);
            }
        }
        for (Transportable transportable : transportables) {
            transportable.increaseTransportPriority();
        }
        Collections.sort(transportables, new Comparator<Transportable>(){

            @Override
            public int compare(Transportable o1, Transportable o2) {
                if (o1 == o2) {
                    return 0;
                }
                int result = o2.getTransportPriority() - o1.getTransportPriority();
                return result == 0 ? o1.getId().compareTo(o2.getId()) : result;
            }
        });
        ArrayList<TransportMission> availableMissions = new ArrayList<TransportMission>();
        for (AIUnit au : this.getAIUnits()) {
            if (!au.hasMission() || !(au.getMission() instanceof TransportMission) || au.getUnit().getSpaceLeft() <= 0) continue;
            availableMissions.add((TransportMission)au.getMission());
        }
        for (Transportable t : new ArrayList(transportables)) {
            Location transportableLoc = t.getTransportLocatable().getLocation();
            boolean onCarrier = transportableLoc instanceof Unit;
            if (!onCarrier) continue;
            AIUnit carrierAI = this.getAIUnit((Unit)transportableLoc);
            Mission m = carrierAI.getMission();
            if (m instanceof TransportMission) {
                ((TransportMission)m).addToTransportList(t);
            }
            transportables.remove(t);
        }
        while (!transportables.isEmpty() && !availableMissions.isEmpty()) {
            Transportable transportable = (Transportable)transportables.remove(0);
            TransportMission bestTransport = null;
            int bestTransportSpace = 0;
            int bestTransportTurns = Integer.MAX_VALUE;
            for (TransportMission tm : availableMissions) {
                int transportSpace = tm.getAvailableSpace(transportable);
                if (transportSpace <= 0) continue;
                if (transportable.getTransportSource().getTile() == tm.getUnit().getTile()) {
                    if (bestTransportTurns <= 0 && (bestTransportTurns != 0 || transportSpace <= bestTransportSpace)) continue;
                    bestTransport = tm;
                    bestTransportSpace = transportSpace;
                    bestTransportTurns = 0;
                    continue;
                }
                PathNode path = tm.getPath(transportable);
                if (path == null || path.getTotalTurns() >= bestTransportTurns && (path.getTotalTurns() != bestTransportTurns || transportSpace <= bestTransportSpace)) continue;
                bestTransport = tm;
                bestTransportSpace = transportSpace;
                bestTransportTurns = path.getTotalTurns();
            }
            if (bestTransport == null) {
                logger.finest("Transport failed for: " + transportable);
                continue;
            }
            bestTransport.addToTransportList(transportable);
            logger.finest("Transport found for: " + transportable + " using: " + bestTransport);
            for (int i = 0; i < transportables.size(); ++i) {
                Transportable t2 = (Transportable)transportables.get(i);
                if (t2.getTransportLocatable().getLocation() != transportable.getTransportLocatable().getLocation() || bestTransport.getAvailableSpace(t2) <= 0) continue;
                transportables.remove(t2);
                bestTransport.addToTransportList(t2);
                logger.finest("Transport piggyback for: " + t2 + " using: " + transportable);
            }
        }
    }

    private Unit getBestTreasureTrain(Tile tile) {
        Unit best = null;
        for (Unit unit : tile.getUnitList()) {
            if (!unit.canCarryTreasure() || best != null && best.getTreasureAmount() >= unit.getTreasureAmount()) continue;
            best = unit;
        }
        return best;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum AIStrategy {
        NONE,
        TRADE,
        IMMIGRATION,
        COOPERATION,
        CONQUEST;

    }
}

