/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai;

import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.server.ai.AIGoods;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.Transportable;
import net.sf.freecol.server.ai.Wish;
import org.w3c.dom.Element;

public class GoodsWish
extends Wish {
    private static final Logger logger = Logger.getLogger(GoodsWish.class.getName());
    private GoodsType goodsType;
    private int amountRequested;

    public GoodsWish(AIMain aiMain, Location destination, int value, int amountRequested, GoodsType goodsType) {
        super(aiMain, GoodsWish.getXMLElementTagName() + ":" + aiMain.getNextID());
        if (destination == null) {
            throw new NullPointerException("destination == null");
        }
        this.destination = destination;
        this.setValue(value);
        this.goodsType = goodsType;
        this.amountRequested = amountRequested;
    }

    public GoodsWish(AIMain aiMain, Location destination, int value, GoodsType goodsType) {
        this(aiMain, destination, value, 100, goodsType);
    }

    public GoodsWish(AIMain aiMain, Element element) {
        super(aiMain, element.getAttribute("ID"));
        this.readFromXMLElement(element);
    }

    public GoodsWish(AIMain aiMain, String id) {
        super(aiMain, id);
    }

    public GoodsWish(AIMain aiMain, XMLStreamReader in) throws XMLStreamException {
        super(aiMain, in.getAttributeValue(null, "ID"));
        this.readFromXML(in);
    }

    public GoodsType getGoodsType() {
        return this.goodsType;
    }

    public int getGoodsAmount() {
        return this.amountRequested;
    }

    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement(GoodsWish.getXMLElementTagName());
        out.writeAttribute("ID", this.getId());
        out.writeAttribute("destination", this.destination.getId());
        if (this.transportable != null) {
            out.writeAttribute("transportable", this.transportable.getId());
        }
        out.writeAttribute("value", Integer.toString(this.getValue()));
        out.writeAttribute("goodsType", this.goodsType.getId());
        out.writeAttribute("amountRequested", Integer.toString(this.amountRequested));
        out.writeEndElement();
    }

    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        this.setId(in.getAttributeValue(null, "ID"));
        this.destination = (Location)((Object)this.getAIMain().getFreeColGameObject(in.getAttributeValue(null, "destination")));
        String transportableStr = in.getAttributeValue(null, "transportable");
        if (transportableStr != null) {
            this.transportable = (Transportable)((Object)this.getAIMain().getAIObject(transportableStr));
            if (this.transportable == null) {
                this.transportable = new AIGoods(this.getAIMain(), transportableStr);
            }
        } else {
            this.transportable = null;
        }
        this.setValue(Integer.parseInt(in.getAttributeValue(null, "value")));
        this.goodsType = this.getAIMain().getGame().getSpecification().getGoodsType(in.getAttributeValue(null, "goodsType"));
        String amountStr = in.getAttributeValue(null, "amountRequested");
        this.amountRequested = amountStr != null ? Integer.parseInt(amountStr) : 100;
        in.nextTag();
    }

    public static String getXMLElementTagName() {
        return "GoodsWish";
    }

    public String toString() {
        return "GoodsWish: " + this.amountRequested + " " + this.goodsType + " (" + this.getValue() + ")";
    }
}

