/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai;

import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.DiplomaticTrade;
import net.sf.freecol.common.model.FoundingFather;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.Monarch;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DiplomacyMessage;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.common.networking.MessageHandler;
import net.sf.freecol.common.networking.StreamedMessageHandler;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIMessage;
import net.sf.freecol.server.ai.AIPlayer;
import net.sf.freecol.server.model.ServerGame;
import net.sf.freecol.server.model.ServerPlayer;
import net.sf.freecol.server.networking.DummyConnection;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class AIInGameInputHandler
implements MessageHandler,
StreamedMessageHandler {
    private static final Logger logger = Logger.getLogger(AIInGameInputHandler.class.getName());
    private final ServerPlayer serverPlayer;
    private final FreeColServer freeColServer;
    private final AIMain aiMain;

    public AIInGameInputHandler(FreeColServer freeColServer, ServerPlayer me, AIMain aiMain) {
        this.freeColServer = freeColServer;
        this.serverPlayer = me;
        this.aiMain = aiMain;
        if (freeColServer == null) {
            throw new NullPointerException("freeColServer == null");
        }
        if (me == null) {
            throw new NullPointerException("me == null");
        }
        if (aiMain == null) {
            throw new NullPointerException("aiMain == null");
        }
        if (!me.isAI()) {
            logger.warning("VERY BAD: Applying AIInGameInputHandler to a non-AI player!!!");
        }
    }

    public synchronized Element handle(Connection connection, Element element) {
        Element reply = null;
        try {
            String type;
            if (!(element == null || (type = element.getTagName()).equals("update") || type.equals("remove") || type.equals("startGame") || type.equals("updateGame") || type.equals("addPlayer") || type.equals("animateMove") || type.equals("animateAttack"))) {
                if (type.equals("setCurrentPlayer")) {
                    reply = this.setCurrentPlayer((DummyConnection)connection, element);
                } else if (!(type.equals("newTurn") || type.equals("setDead") || type.equals("gameEnded") || type.equals("disconnect") || type.equals("logout") || type.equals("error") || type.equals("setAI") || type.equals("chat"))) {
                    if (type.equals("chooseFoundingFather")) {
                        reply = this.chooseFoundingFather((DummyConnection)connection, element);
                    } else if (type.equals("reconnect")) {
                        logger.warning("The server requests a reconnect. This means an illegal operation has been performed. Please refer to any previous error message.");
                    } else if (!type.equals("setStance")) {
                        if (type.equals("monarchAction")) {
                            reply = this.monarchAction((DummyConnection)connection, element);
                        } else if (!type.equals("removeGoods")) {
                            if (type.equals("indianDemand")) {
                                reply = this.indianDemand((DummyConnection)connection, element);
                            } else if (type.equals("diplomacy")) {
                                reply = this.diplomaticTrade((DummyConnection)connection, element);
                            } else if (!type.equals("addObject")) {
                                if (type.equals("multiple")) {
                                    reply = this.multiple((DummyConnection)connection, element);
                                } else {
                                    logger.warning("Message is of unsupported type \"" + type + "\".");
                                }
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "AI input handler for " + this.serverPlayer + " caught error handling " + element.getTagName(), e);
        }
        return reply;
    }

    public void handle(Connection connection, XMLStreamReader in, XMLStreamWriter out) {
    }

    public boolean accepts(String tagName) {
        return false;
    }

    private Element setCurrentPlayer(final DummyConnection connection, Element setCurrentPlayerElement) {
        ServerGame game = this.freeColServer.getGame();
        Player currentPlayer = (Player)game.getFreeColGameObject(setCurrentPlayerElement.getAttribute("player"));
        if (this.serverPlayer.getId() == currentPlayer.getId()) {
            logger.finest("Starting new Thread for " + this.serverPlayer.getName());
            Thread t = new Thread("FreeColServer:AIPlayer (" + this.serverPlayer.getName() + ")"){

                public void run() {
                    try {
                        AIInGameInputHandler.this.getAIPlayer().startWorking();
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "AI player failed while working!", e);
                    }
                    AIMessage.sendTrivial(connection, "endTurn", new String[0]);
                }
            };
            t.start();
        }
        return null;
    }

    private Element chooseFoundingFather(DummyConnection connection, Element element) {
        ArrayList<FoundingFather> possibleFoundingFathers = new ArrayList<FoundingFather>();
        for (FoundingFather.FoundingFatherType type : FoundingFather.FoundingFatherType.values()) {
            String id = element.getAttribute(type.toString());
            if (id == null || id == "") continue;
            FoundingFather father = this.aiMain.getGame().getSpecification().getFoundingFather(id);
            if (father == null) {
                logger.warning("Bogus " + type.toString() + " father: " + id);
                continue;
            }
            possibleFoundingFathers.add(father);
        }
        FoundingFather foundingFather = this.getAIPlayer().selectFoundingFather(possibleFoundingFathers);
        return foundingFather == null ? null : AIMessage.makeTrivial("chooseFoundingFather", "foundingFather", foundingFather.getId());
    }

    private Element monarchAction(DummyConnection connection, Element element) {
        Monarch.MonarchAction action = Enum.valueOf(Monarch.MonarchAction.class, element.getAttribute("action"));
        boolean accept = false;
        switch (action) {
            case RAISE_TAX: {
                int tax = Integer.parseInt(element.getAttribute("amount"));
                accept = this.getAIPlayer().acceptTax(tax);
                element.setAttribute("accepted", String.valueOf(accept));
                logger.finest("AI player monarch action " + (Object)((Object)action) + " = " + accept);
                break;
            }
            case OFFER_MERCENARIES: {
                accept = this.getAIPlayer().acceptMercenaryOffer();
                element.setAttribute("accepted", String.valueOf(accept));
                logger.finest("AI player monarch action " + (Object)((Object)action) + " = " + accept);
                break;
            }
            default: {
                logger.finest("AI player ignoring monarch action " + (Object)((Object)action));
                return null;
            }
        }
        return element;
    }

    private Element indianDemand(DummyConnection connection, Element element) {
        ServerGame game = this.freeColServer.getGame();
        Unit unit = (Unit)game.getFreeColGameObject(element.getAttribute("unit"));
        Colony colony = (Colony)game.getFreeColGameObject(element.getAttribute("colony"));
        int gold = 0;
        Goods goods = null;
        Element goodsElement = Message.getChildElement(element, Goods.getXMLElementTagName());
        if (goodsElement == null) {
            gold = Integer.parseInt(element.getAttribute("gold"));
        } else {
            goods = new Goods((Game)game, goodsElement);
        }
        boolean accept = this.getAIPlayer().acceptIndianDemand(unit, colony, goods, gold);
        element.setAttribute("accepted", String.valueOf(accept));
        return element;
    }

    private Element diplomaticTrade(DummyConnection connection, Element element) {
        DiplomacyMessage message = new DiplomacyMessage(this.freeColServer.getGame(), element);
        DiplomaticTrade agreement = message.getAgreement();
        boolean accept = this.getAIPlayer().acceptDiplomaticTrade(agreement);
        agreement.setStatus(accept ? DiplomaticTrade.TradeStatus.ACCEPT_TRADE : DiplomaticTrade.TradeStatus.REJECT_TRADE);
        return message.toXMLElement();
    }

    public Element multiple(Connection connection, Element element) {
        NodeList nodes = element.getChildNodes();
        Element reply = null;
        for (int i = 0; i < nodes.getLength(); ++i) {
            reply = this.handle(connection, (Element)nodes.item(i));
        }
        return reply;
    }

    private AIPlayer getAIPlayer() {
        return this.aiMain.getAIPlayer(this.serverPlayer);
    }
}

