/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ColonyTile;
import net.sf.freecol.common.model.EquipmentType;
import net.sf.freecol.common.model.ExportData;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovement;
import net.sf.freecol.common.model.TileImprovementType;
import net.sf.freecol.common.model.TypeCountMap;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.UnitTypeChange;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.server.ai.AIGoods;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIMessage;
import net.sf.freecol.server.ai.AIObject;
import net.sf.freecol.server.ai.AIPlayer;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.ColonyPlan;
import net.sf.freecol.server.ai.GoodsWish;
import net.sf.freecol.server.ai.TileImprovementPlan;
import net.sf.freecol.server.ai.Wish;
import net.sf.freecol.server.ai.WorkLocationPlan;
import net.sf.freecol.server.ai.WorkerWish;
import net.sf.freecol.server.ai.mission.PioneeringMission;
import net.sf.freecol.server.ai.mission.TransportMission;
import net.sf.freecol.server.ai.mission.WorkInsideColonyMission;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AIColony
extends AIObject
implements PropertyChangeListener {
    private static final Logger logger = Logger.getLogger(AIColony.class.getName());
    private Colony colony;
    private ColonyPlan colonyPlan;
    private ArrayList<AIGoods> aiGoods = new ArrayList();
    private ArrayList<Wish> wishes = new ArrayList();
    private ArrayList<TileImprovementPlan> tileImprovementPlans = new ArrayList();
    private boolean rearrangeWorkers = false;

    public AIColony(AIMain aiMain, Colony colony) {
        super(aiMain, colony.getId());
        this.colony = colony;
        this.colonyPlan = new ColonyPlan(aiMain, colony);
        colony.addPropertyChangeListener("rearrangeWorkers", this);
    }

    public AIColony(AIMain aiMain, Element element) {
        super(aiMain, element.getAttribute("ID"));
        this.readFromXMLElement(element);
    }

    public AIColony(AIMain aiMain, XMLStreamReader in) throws XMLStreamException {
        super(aiMain, in.getAttributeValue(null, "ID"));
        this.readFromXML(in);
    }

    protected AIUnit getAIUnit(Unit unit) {
        return this.getAIMain().getAIUnit(unit);
    }

    protected AIPlayer getAIOwner() {
        return this.getAIMain().getAIPlayer(this.colony.getOwner());
    }

    protected Connection getConnection() {
        return this.getAIOwner().getConnection();
    }

    public AIColony(AIMain aiMain, String id) {
        this(aiMain, (Colony)aiMain.getGame().getFreeColGameObject(id));
    }

    public Colony getColony() {
        return this.colony;
    }

    @Override
    public void dispose() {
        ArrayList<AIObject> disposeList = new ArrayList<AIObject>();
        for (AIGoods ag : this.aiGoods) {
            if (ag.getGoods().getLocation() != this.colony) continue;
            disposeList.add(ag);
        }
        for (Wish w : this.wishes) {
            disposeList.add(w);
        }
        for (TileImprovementPlan ti : this.tileImprovementPlans) {
            disposeList.add(ti);
        }
        for (AIObject o : disposeList) {
            o.dispose();
        }
        super.dispose();
    }

    public Iterator<AIGoods> getAIGoodsIterator() {
        Iterator<AIGoods> agi = this.aiGoods.iterator();
        while (agi.hasNext()) {
            AIGoods ag = agi.next();
            if (ag.getGoods().getLocation() == this.colony) continue;
            agi.remove();
        }
        return this.aiGoods.iterator();
    }

    public Iterator<Wish> getWishIterator() {
        return this.wishes.iterator();
    }

    public void createTileImprovementPlans() {
        HashMap<Tile, TileImprovementPlan> plans = new HashMap<Tile, TileImprovementPlan>();
        for (TileImprovementPlan plan : this.tileImprovementPlans) {
            plans.put(plan.getTarget(), plan);
        }
        for (WorkLocationPlan wlp : this.colonyPlan.getWorkLocationPlans()) {
            if (!(wlp.getWorkLocation() instanceof ColonyTile)) continue;
            ColonyTile colonyTile = (ColonyTile)wlp.getWorkLocation();
            Tile target = colonyTile.getWorkTile();
            boolean others = target.getOwningSettlement() != this.colony && target.getOwner() == this.colony.getOwner();
            TileImprovementPlan plan = (TileImprovementPlan)plans.get(target);
            if (plan == null) {
                if (others || (plan = wlp.createTileImprovementPlan()) == null) continue;
                int value = plan.getValue();
                if (colonyTile.getUnit() != null) {
                    value *= 2;
                }
                plan.setValue(value -= this.colony.getOwner().getLandPrice(target));
                this.tileImprovementPlans.add(plan);
                plans.put(target, plan);
                continue;
            }
            if (wlp.updateTileImprovementPlan(plan) != null && !others) continue;
            this.tileImprovementPlans.remove(plan);
            plan.dispose();
        }
        Tile centerTile = this.colony.getTile();
        TileImprovementPlan centerPlan = (TileImprovementPlan)plans.get(centerTile);
        TileImprovementType type = TileImprovement.findBestTileImprovementType(centerTile, this.colony.getSpecification().getGoodsType("model.goods.grain"));
        if (type == null) {
            if (centerPlan != null) {
                this.tileImprovementPlans.remove(centerPlan);
            }
        } else if (centerPlan == null) {
            centerPlan = new TileImprovementPlan(this.getAIMain(), this.colony.getTile(), type, 30);
            this.tileImprovementPlans.add(0, centerPlan);
        } else {
            centerPlan.setType(type);
        }
        Collections.sort(this.tileImprovementPlans);
    }

    public Iterator<TileImprovementPlan> getTileImprovementPlanIterator() {
        return this.tileImprovementPlans.iterator();
    }

    public boolean removeTileImprovementPlan(TileImprovementPlan plan) {
        return this.tileImprovementPlans.remove(plan);
    }

    private void createWishes() {
        boolean badlyDefended;
        int newPopulation;
        UnitType expert;
        this.wishes.clear();
        int expertValue = 100;
        int goodsWishValue = 50;
        for (Unit unit : this.colony.getUnitList()) {
            if (unit.getWorkType() == null || unit.getWorkType() == unit.getType().getExpertProduction()) continue;
            expert = this.colony.getSpecification().getExpertForProducing(unit.getWorkType());
            this.wishes.add(new WorkerWish(this.getAIMain(), this.colony, expertValue, expert, true));
        }
        if (this.wishes.isEmpty() && this.colony.governmentChange(newPopulation = this.colony.getUnitCount() + 1) >= 0) {
            boolean needFood = this.colony.getFoodProduction() <= this.colony.getFoodConsumption() + this.colony.getOwner().getMaximumFoodConsumption();
            expert = this.getNextExpert(needFood);
            this.wishes.add(new WorkerWish(this.getAIMain(), this.colony, expertValue / 5, expert, false));
        }
        if (badlyDefended = this.isBadlyDefended()) {
            UnitType bestDefender = null;
            for (UnitType unitType : this.colony.getSpecification().getUnitTypeList()) {
                if (bestDefender != null && bestDefender.getDefence() >= unitType.getDefence() || unitType.hasAbility("model.ability.navalUnit") || !unitType.isAvailableTo(this.colony.getOwner())) continue;
                bestDefender = unitType;
            }
            if (bestDefender != null) {
                this.wishes.add(new WorkerWish(this.getAIMain(), this.colony, expertValue, bestDefender, true));
            }
        }
        TypeCountMap<GoodsType> requiredGoods = new TypeCountMap<GoodsType>();
        if (this.colony.getCurrentlyBuilding() != null) {
            for (AbstractGoods abstractGoods : this.colony.getCurrentlyBuilding().getGoodsRequired()) {
                if (this.colony.getAdjustedNetProductionOf(abstractGoods.getType()) != 0) continue;
                requiredGoods.incrementCount(abstractGoods.getType(), abstractGoods.getAmount());
            }
        }
        for (TileImprovementPlan tileImprovementPlan : this.tileImprovementPlans) {
            for (AbstractGoods goods : tileImprovementPlan.getType().getExpendedEquipmentType().getGoodsRequired()) {
                requiredGoods.incrementCount(goods.getType(), goods.getAmount());
            }
        }
        for (WorkLocation workLocation : this.colony.getWorkLocations()) {
            Building building;
            GoodsType inputType;
            if (!(workLocation instanceof Building) || (inputType = (building = (Building)workLocation).getGoodsInputType()) == null || this.colony.getProductionInfo(building).hasMaximumProduction()) continue;
            requiredGoods.incrementCount(inputType, 100);
        }
        for (GoodsType goodsType : this.colony.getSpecification().getGoodsTypeList()) {
            if (!goodsType.isBreedable()) continue;
            requiredGoods.incrementCount(goodsType, goodsType.getBreedingNumber());
        }
        if (badlyDefended) {
            block7: for (EquipmentType equipmentType : this.colony.getSpecification().getEquipmentTypeList()) {
                if (!equipmentType.isMilitaryEquipment()) continue;
                for (Unit unit : this.colony.getUnitList()) {
                    if (!unit.canBeEquippedWith(equipmentType)) continue;
                    for (AbstractGoods goods : equipmentType.getGoodsRequired()) {
                        requiredGoods.incrementCount(goods.getType(), goods.getAmount());
                    }
                    continue block7;
                }
            }
        }
        Iterator<Object> i$ = requiredGoods.keySet().iterator();
        while (i$.hasNext()) {
            int amount;
            GoodsType goodsType;
            GoodsType requiredType;
            for (requiredType = goodsType = (GoodsType)i$.next(); requiredType != null && !requiredType.isStorable(); requiredType = requiredType.getRawMaterial()) {
            }
            if (requiredType == null || (amount = Math.min(requiredGoods.getCount(requiredType) - this.colony.getGoodsCount(requiredType), this.colony.getWarehouseCapacity())) <= 0) continue;
            int value = this.colonyCouldProduce(requiredType) ? goodsWishValue / 10 : goodsWishValue;
            this.wishes.add(new GoodsWish(this.getAIMain(), this.colony, value, amount, requiredType));
        }
        Collections.sort(this.wishes);
    }

    private boolean colonyCouldProduce(GoodsType goodsType) {
        if (goodsType.isBreedable()) {
            return this.colony.getGoodsCount(goodsType) >= goodsType.getBreedingNumber();
        }
        if (goodsType.isFarmed()) {
            for (ColonyTile colonyTile : this.colony.getColonyTiles()) {
                if (colonyTile.getWorkTile().potential(goodsType, null) <= 0) continue;
                return true;
            }
        } else if (!this.colony.getBuildingsForProducing(goodsType).isEmpty()) {
            if (goodsType.getRawMaterial() == null) {
                return true;
            }
            return this.colonyCouldProduce(goodsType.getRawMaterial());
        }
        return false;
    }

    private UnitType getNextExpert(boolean onlyFood) {
        UnitType bestType = this.colony.getSpecification().getUnitType("model.unit.freeColonist");
        for (WorkLocationPlan plan : this.colonyPlan.getSortedWorkLocationPlans()) {
            Building building;
            if (!plan.getGoodsType().isFoodType() && onlyFood) continue;
            WorkLocation location = plan.getWorkLocation();
            if (location instanceof ColonyTile) {
                ColonyTile colonyTile = (ColonyTile)location;
                if (colonyTile.getUnit() != null || !colonyTile.getWorkTile().isLand() && !this.colony.hasAbility("model.ability.produceInWater")) continue;
                bestType = this.colony.getSpecification().getExpertForProducing(plan.getGoodsType());
                break;
            }
            if (!(location instanceof Building) || (building = (Building)location).getUnitCount() >= building.getMaxUnits()) continue;
            bestType = building.getExpertUnitType();
            break;
        }
        return bestType;
    }

    private int getToolsRequired(BuildableType buildableType) {
        int toolsRequiredForBuilding = 0;
        if (buildableType != null) {
            for (AbstractGoods goodsRequired : buildableType.getGoodsRequired()) {
                if (goodsRequired.getType() != this.colony.getSpecification().getGoodsType("model.goods.tools")) continue;
                toolsRequiredForBuilding = goodsRequired.getAmount();
                break;
            }
        }
        return toolsRequiredForBuilding;
    }

    private int getHammersRequired(BuildableType buildableType) {
        int hammersRequiredForBuilding = 0;
        if (buildableType != null) {
            for (AbstractGoods goodsRequired : buildableType.getGoodsRequired()) {
                if (goodsRequired.getType() != this.colony.getSpecification().getGoodsType("model.goods.hammers")) continue;
                hammersRequiredForBuilding = goodsRequired.getAmount();
                break;
            }
        }
        return hammersRequiredForBuilding;
    }

    public boolean isBadlyDefended() {
        int defence = 0;
        for (Unit unit : this.colony.getTile().getUnitList()) {
            defence += unit.getType().getDefence();
            if (unit.isArmed()) {
                ++defence;
            }
            if (!unit.isMounted()) continue;
            ++defence;
        }
        return defence < 3 * this.colony.getUnitCount();
    }

    public void removeWish(Wish w) {
        this.wishes.remove(w);
    }

    public void addGoodsWish(GoodsWish gw) {
        this.wishes.add(gw);
    }

    public void removeAIGoods(AIGoods ag) {
        while (this.aiGoods.remove(ag)) {
        }
    }

    public void createAIGoods() {
        int capacity = this.colony.getWarehouseCapacity();
        if (this.colony.hasAbility("model.ability.export")) {
            for (GoodsType goodsType : this.colony.getSpecification().getGoodsTypeList()) {
                if (goodsType.isTradeGoods()) {
                    this.colony.setExportData(new ExportData(goodsType, false, 0));
                    continue;
                }
                if (!goodsType.isStorable()) {
                    this.colony.setExportData(new ExportData(goodsType, false, 0));
                    continue;
                }
                if (goodsType.isBreedable()) {
                    this.colony.setExportData(new ExportData(goodsType, true, capacity - 20));
                    continue;
                }
                if (goodsType.isMilitaryGoods()) {
                    this.colony.setExportData(new ExportData(goodsType, true, capacity - 50));
                    continue;
                }
                if (goodsType.isBuildingMaterial()) {
                    this.colony.setExportData(new ExportData(goodsType, true, Math.min(capacity, 250)));
                    continue;
                }
                if (goodsType.isFoodType()) {
                    this.colony.setExportData(new ExportData(goodsType, false, 0));
                    continue;
                }
                if (goodsType.isNewWorldGoodsType() || goodsType.isRefined()) {
                    this.colony.setExportData(new ExportData(goodsType, true, 0));
                    continue;
                }
                this.colony.setExportData(new ExportData(goodsType, false, 0));
            }
            this.aiGoods.clear();
        } else {
            GoodsType toolType = this.colony.getSpecification().getGoodsType("model.goods.tools");
            GoodsType hammerType = this.colony.getSpecification().getGoodsType("model.goods.hammers");
            ArrayList<AIGoods> newAIGoods = new ArrayList<AIGoods>();
            List<GoodsType> goodsList = this.colony.getSpecification().getGoodsTypeList();
            block1: for (GoodsType goodsType : goodsList) {
                if (goodsType.isFoodType() || goodsType == this.colony.getSpecification().getGoodsType("model.goods.lumber") || !goodsType.isStorable() || goodsType.isMilitaryGoods() && (this.colony.getNetProductionOf(goodsType) == 0 || this.colony.getGoodsCount(goodsType) < capacity - this.colony.getNetProductionOf(goodsType))) continue;
                for (Wish wish : this.wishes) {
                    if (!(wish instanceof GoodsWish) || ((GoodsWish)wish).getGoodsType() != goodsType) continue;
                    continue block1;
                }
                if (this.colony.getNetProductionOf(goodsType) < 0) continue;
                if (goodsType == toolType && this.colony.getGoodsCount(toolType) > 0) {
                    if (this.colony.getNetProductionOf(toolType) <= 0) continue;
                    BuildableType currentlyBuilding = this.colony.getCurrentlyBuilding();
                    int requiredTools = this.getToolsRequired(currentlyBuilding);
                    int requiredHammers = this.getHammersRequired(currentlyBuilding);
                    int buildTurns = (requiredHammers - this.colony.getGoodsCount(hammerType)) / (this.colony.getNetProductionOf(hammerType) + 1);
                    if (requiredTools > 0) {
                        int toolsProductionTurns;
                        if (this.colony.getWarehouseCapacity() > 100) {
                            requiredTools += 100;
                        }
                        if (buildTurns <= (toolsProductionTurns = requiredTools / this.colony.getNetProductionOf(toolType)) + 1) {
                            continue;
                        }
                    } else if (this.colony.getWarehouseCapacity() > 100 && this.colony.getGoodsCount(toolType) <= 100) continue;
                }
                if (this.colony.getGoodsCount(goodsType) <= 0) continue;
                ArrayList<AIGoods> alreadyAdded = new ArrayList<AIGoods>();
                for (int j = 0; j < this.aiGoods.size(); ++j) {
                    AIGoods ag = this.aiGoods.get(j);
                    if (ag == null) {
                        logger.warning("aiGoods == null");
                    } else if (ag.getGoods() == null) {
                        logger.warning("aiGoods.getGoods() == null");
                        if (ag.isUninitialized()) {
                            logger.warning("AIGoods uninitialized: " + ag.getId());
                        }
                    }
                    if (ag == null || ag.getGoods() == null || ag.getGoods().getType() != goodsType || ag.getGoods().getLocation() != this.colony) continue;
                    alreadyAdded.add(ag);
                }
                int amountRemaining = this.colony.getGoodsCount(goodsType);
                for (int i = 0; i < alreadyAdded.size(); ++i) {
                    AIGoods oldGoods = (AIGoods)alreadyAdded.get(i);
                    if (oldGoods.getGoods().getLocation() != this.colony) continue;
                    if (oldGoods.getGoods().getAmount() < 100 && oldGoods.getGoods().getAmount() < amountRemaining) {
                        int goodsAmount = Math.min(100, amountRemaining);
                        oldGoods.getGoods().setAmount(goodsAmount);
                        if (amountRemaining >= this.colony.getWarehouseCapacity() && oldGoods.getTransportPriority() < 110) {
                            oldGoods.setTransportPriority(110);
                        } else if (goodsAmount == 100 && oldGoods.getTransportPriority() < 100) {
                            oldGoods.setTransportPriority(100);
                        }
                        amountRemaining -= goodsAmount;
                        newAIGoods.add(oldGoods);
                        continue;
                    }
                    if (oldGoods.getGoods().getAmount() > amountRemaining) {
                        if (amountRemaining == 0) {
                            if (oldGoods.getTransport() != null && oldGoods.getTransport().getMission() instanceof TransportMission) {
                                ((TransportMission)oldGoods.getTransport().getMission()).removeFromTransportList(oldGoods);
                            }
                            oldGoods.dispose();
                            continue;
                        }
                        oldGoods.getGoods().setAmount(amountRemaining);
                        newAIGoods.add(oldGoods);
                        amountRemaining = 0;
                        continue;
                    }
                    newAIGoods.add(oldGoods);
                    amountRemaining -= oldGoods.getGoods().getAmount();
                }
                while (amountRemaining > 0) {
                    if (amountRemaining >= 100) {
                        AIGoods newGoods = new AIGoods(this.getAIMain(), this.colony, goodsType, 100, this.getColony().getOwner().getEurope());
                        if (amountRemaining >= this.colony.getWarehouseCapacity()) {
                            newGoods.setTransportPriority(110);
                        } else {
                            newGoods.setTransportPriority(100);
                        }
                        newAIGoods.add(newGoods);
                        amountRemaining -= 100;
                        continue;
                    }
                    AIGoods newGoods = new AIGoods(this.getAIMain(), this.colony, goodsType, amountRemaining, this.getColony().getOwner().getEurope());
                    newAIGoods.add(newGoods);
                    amountRemaining = 0;
                }
            }
            this.aiGoods.clear();
            for (AIGoods ag : newAIGoods) {
                int i;
                for (i = 0; i < this.aiGoods.size() && this.aiGoods.get(i).getTransportPriority() > ag.getTransportPriority(); ++i) {
                }
                this.aiGoods.add(i, ag);
            }
        }
    }

    public int getAvailableGoods(GoodsType goodsType) {
        int materialsRequiredForBuilding = 0;
        if (this.colony.getCurrentlyBuilding() != null) {
            for (AbstractGoods materials : this.colony.getCurrentlyBuilding().getGoodsRequired()) {
                if (materials.getType() != goodsType) continue;
                materialsRequiredForBuilding = materials.getAmount();
                break;
            }
        }
        return Math.max(0, this.colony.getGoodsCount(goodsType) - materialsRequiredForBuilding);
    }

    public boolean canBuildEquipment(EquipmentType equipmentType) {
        if (this.getColony().canBuildEquipment(equipmentType)) {
            for (AbstractGoods goods : equipmentType.getGoodsRequired()) {
                int breedingNumber = goods.getType().getBreedingNumber();
                if (breedingNumber != Integer.MAX_VALUE && this.getColony().getGoodsCount(goods.getType()) < goods.getAmount() + breedingNumber) {
                    return false;
                }
                if (this.getAvailableGoods(goods.getType()) >= goods.getAmount()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean tryUseTile(Tile tile) {
        if (tile.getOwningSettlement() == this.colony) {
            return true;
        }
        return this.colony.getOwner().canClaimForSettlement(tile) && AIMessage.askClaimLand(this.getConnection(), tile, this.colony, 0) && tile.getOwningSettlement() == this.colony;
    }

    private ColonyTile getBestVacantTile(Unit unit, GoodsType goodsType) {
        ColonyTile colonyTile = this.colony.getVacantColonyTileFor(unit, true, goodsType);
        if (colonyTile == null) {
            return null;
        }
        Tile tile = colonyTile.getWorkTile();
        return this.tryUseTile(tile) ? colonyTile : null;
    }

    public boolean rearrangeWorkers(Connection connection) {
        Iterator<Unit> unitIterator;
        Unit u4;
        int food;
        this.colonyPlan.create();
        if (!this.rearrangeWorkers) {
            logger.fine("No need to rearrange workers in " + this.colony.getName() + ".");
            return false;
        }
        this.checkForUnequippedExpertPioneer();
        this.checkForUnarmedExpertSoldier();
        ArrayList<Unit> units = new ArrayList<Unit>();
        List<WorkLocationPlan> workLocationPlans = this.colonyPlan.getWorkLocationPlans();
        Collections.sort(workLocationPlans);
        Iterator<Unit> ui = this.colony.getUnitIterator();
        while (ui.hasNext()) {
            Unit unit = ui.next();
            units.add(unit);
            unit.putOutsideColony();
        }
        this.placeExpertsInWorkPlaces(units, workLocationPlans);
        boolean workerAdded = true;
        GoodsType foodType = this.colony.getSpecification().getGoodsType("model.goods.grain");
        while (workerAdded) {
            WorkLocationPlan wlp;
            int i;
            workerAdded = false;
            food = this.colony.getFoodProduction() - this.colony.getFoodConsumption();
            for (i = 0; i < workLocationPlans.size() && food < 2; ++i) {
                wlp = workLocationPlans.get(i);
                WorkLocation wl = wlp.getWorkLocation();
                if (wlp.getGoodsType() != foodType || !((ColonyTile)wl).getWorkTile().isLand() && !this.colony.hasAbility("model.ability.produceInWater")) continue;
                Unit bestUnit = null;
                int bestProduction = 0;
                for (Unit unit : units) {
                    int production = ((ColonyTile)wlp.getWorkLocation()).getProductionOf(unit, foodType);
                    if (production <= 1 || bestUnit != null && production <= bestProduction && (production != bestProduction || unit.getSkillLevel() >= bestUnit.getSkillLevel())) continue;
                    bestUnit = unit;
                    bestProduction = production;
                }
                if (bestUnit == null || !wlp.getWorkLocation().canAdd(bestUnit) || !AIMessage.askWork(this.getAIUnit(bestUnit), wlp.getWorkLocation())) continue;
                AIMessage.askChangeWorkType(this.getAIUnit(bestUnit), wlp.getGoodsType());
                units.remove(bestUnit);
                workLocationPlans.remove(wlp);
                workerAdded = true;
                food = this.colony.getFoodProduction() - this.colony.getFoodConsumption();
            }
            if (food < 2) continue;
            for (i = 0; i < workLocationPlans.size(); ++i) {
                wlp = workLocationPlans.get(i);
                if (wlp.getGoodsType() == foodType) continue;
                Unit bestUnit = null;
                int bestProduction = 0;
                for (Unit unit : units) {
                    int production = 0;
                    WorkLocation location = wlp.getWorkLocation();
                    if (location instanceof ColonyTile) {
                        production = ((ColonyTile)wlp.getWorkLocation()).getProductionOf(unit, wlp.getGoodsType());
                    } else if (location instanceof Building) {
                        production = ((Building)location).getUnitProductivity(unit);
                    }
                    if (bestUnit != null && production <= bestProduction && (production != bestProduction || unit.getSkillLevel() >= bestUnit.getSkillLevel())) continue;
                    bestUnit = unit;
                    bestProduction = production;
                }
                if (bestUnit == null || !wlp.getWorkLocation().canAdd(bestUnit) || !AIMessage.askWork(this.getAIUnit(bestUnit), wlp.getWorkLocation())) continue;
                AIMessage.askChangeWorkType(this.getAIUnit(bestUnit), wlp.getGoodsType());
                units.remove(bestUnit);
                workLocationPlans.remove(wlp);
                workerAdded = true;
                food = this.colony.getFoodProduction() - this.colony.getFoodConsumption();
            }
        }
        food = this.colony.getFoodProduction() - this.colony.getFoodConsumption();
        while (food < 0 && this.colony.getGoodsCount(foodType) + food * 3 < 0) {
            Unit u2;
            WorkLocation bestPick = null;
            for (WorkLocation wl : this.colony.getWorkLocations()) {
                if (wl.getUnitCount() <= 0) continue;
                if (wl instanceof ColonyTile) {
                    ColonyTile ct = (ColonyTile)wl;
                    u2 = ct.getUnit();
                    if (ct.getUnit().getWorkType() == foodType) continue;
                    int uProduction = ct.getProductionOf(u2, foodType);
                    if (uProduction > 1) {
                        if (bestPick == null || bestPick instanceof Building) {
                            bestPick = wl;
                            continue;
                        }
                        ColonyTile bpct = (ColonyTile)bestPick;
                        int bestPickProduction = bpct.getProductionOf(bpct.getUnit(), foodType);
                        if (uProduction <= bestPickProduction && (uProduction != bestPickProduction || u2.getSkillLevel() >= bpct.getUnit().getSkillLevel())) continue;
                        bestPick = wl;
                        continue;
                    }
                    if (bestPick != null) continue;
                    bestPick = wl;
                    continue;
                }
                if (bestPick != null && (!(bestPick instanceof Building) || ((Building)wl).getProduction() >= ((Building)bestPick).getProduction())) continue;
                bestPick = wl;
            }
            if (bestPick == null) break;
            if (bestPick instanceof ColonyTile) {
                ColonyTile ct = (ColonyTile)bestPick;
                u4 = ct.getUnit();
                if (ct.getProductionOf(u4, foodType) > 1) {
                    AIMessage.askChangeWorkType(this.getAIUnit(u4), foodType);
                } else {
                    u4.putOutsideColony();
                    AIUnit au = this.getAIUnit(u4);
                    if (au.getMission() instanceof WorkInsideColonyMission) {
                        au.setMission(null);
                    }
                }
            } else {
                Building b = (Building)bestPick;
                unitIterator = b.getUnitIterator();
                Unit bestUnit = unitIterator.next();
                while (unitIterator.hasNext()) {
                    u2 = unitIterator.next();
                    if (u2.getType().getExpertProduction() == u2.getWorkType()) continue;
                    bestUnit = u2;
                    break;
                }
                bestUnit.putOutsideColony();
                AIUnit au = this.getAIUnit(bestUnit);
                if (au.getMission() instanceof WorkInsideColonyMission) {
                    au.setMission(null);
                }
            }
            food = this.colony.getFoodProduction() - this.colony.getFoodConsumption();
        }
        block9: for (WorkLocation wl : this.colony.getWorkLocations()) {
            while (wl.getUnitCount() > 0 && wl instanceof Building && !this.colony.isProductive(wl)) {
                GoodsType type;
                FreeColGameObject w;
                unitIterator = wl.getUnitIterator();
                Unit bestPick = unitIterator.next();
                while (unitIterator.hasNext()) {
                    Unit u3 = unitIterator.next();
                    if (u3.getType().getExpertProduction() == u3.getWorkType()) continue;
                    bestPick = u3;
                    break;
                }
                ColonyTile colonyTile = w = (type = bestPick.getWorkType().getRawMaterial()) == null ? null : this.getBestVacantTile(bestPick, type);
                if (w == null) {
                    type = this.colony.getSpecification().getGoodsType("model.goods.bells");
                    w = this.colony.getBuildingForProducing(type);
                }
                if (w == null) {
                    w = this.getBestVacantTile(bestPick, foodType);
                    type = foodType;
                }
                if (w != null) {
                    if (AIMessage.askWork(this.getAIUnit(bestPick), w) && bestPick.getLocation() == w) {
                        AIMessage.askChangeWorkType(this.getAIUnit(bestPick), type);
                        continue block9;
                    }
                } else {
                    bestPick.putOutsideColony();
                }
                if (w != wl) continue;
                continue block9;
            }
        }
        List<GoodsType> goodsList = this.colony.getSpecification().getGoodsTypeList();
        for (GoodsType goodsType : goodsList) {
            int production = this.colony.getNetProductionOf(goodsType);
            int in_stock = this.colony.getGoodsCount(goodsType);
            if (foodType == goodsType || !goodsType.isStorable() || production + in_stock <= this.colony.getWarehouseCapacity()) continue;
            Iterator<Unit> unitIterator2 = this.colony.getUnitIterator();
            int waste = production + in_stock - this.colony.getWarehouseCapacity();
            while (unitIterator2.hasNext() && waste > 0) {
                Unit unit = unitIterator2.next();
                if (unit.getWorkType() != goodsType) continue;
                Location oldLocation = unit.getLocation();
                unit.putOutsideColony();
                boolean working = false;
                waste = this.colony.getGoodsCount(goodsType) + this.colony.getNetProductionOf(goodsType) - this.colony.getWarehouseCapacity();
                int best = 0;
                for (GoodsType goodsType2 : goodsList) {
                    ColonyTile bestTile;
                    int production2;
                    if (!goodsType2.isFarmed() || (production2 = (bestTile = this.getBestVacantTile(unit, goodsType2)) == null ? 0 : bestTile.getProductionOf(unit, goodsType2)) <= best || production2 + this.colony.getGoodsCount(goodsType2) + this.colony.getNetProductionOf(goodsType2) >= this.colony.getWarehouseCapacity()) continue;
                    if (working) {
                        unit.putOutsideColony();
                    }
                    if (!AIMessage.askWork(this.getAIUnit(unit), bestTile)) continue;
                    AIMessage.askChangeWorkType(this.getAIUnit(unit), goodsType2);
                    best = production2;
                    working = true;
                }
                if (working) continue;
                unit.setLocation(oldLocation);
            }
        }
        for (int i = 0; i < workLocationPlans.size(); ++i) {
            WorkLocationPlan wlp = workLocationPlans.get(i);
            WorkLocation wl = wlp.getWorkLocation();
            if (wlp.getGoodsType() != foodType || !((ColonyTile)wl).getWorkTile().isLand() && !this.colony.hasAbility("model.ability.produceInWater")) continue;
            Unit bestUnit = null;
            int bestProduction = 0;
            for (Unit unit : units) {
                int production = ((ColonyTile)wlp.getWorkLocation()).getProductionOf(unit, foodType);
                if (production <= 1 || bestUnit != null && production <= bestProduction && (production != bestProduction || unit.getSkillLevel() >= bestUnit.getSkillLevel())) continue;
                bestUnit = unit;
                bestProduction = production;
            }
            if (bestUnit == null || !wlp.getWorkLocation().canAdd(bestUnit) || !AIMessage.askWork(this.getAIUnit(bestUnit), wlp.getWorkLocation())) continue;
            AIMessage.askChangeWorkType(this.getAIUnit(bestUnit), wlp.getGoodsType());
            units.remove(bestUnit);
            workLocationPlans.remove(wlp);
        }
        for (Unit u4 : units) {
            u4.putOutsideColony();
            AIUnit au = this.getAIUnit(u4);
            if (!(au.getMission() instanceof WorkInsideColonyMission)) continue;
            au.setMission(null);
        }
        this.decideBuildable(connection);
        this.createTileImprovementPlans();
        this.createWishes();
        this.colonyPlan.adjustProductionAndManufacture();
        this.checkConditionsForHorseBreed();
        if (this.colony.getUnitCount() <= 0) {
            if (this.colony.getTile().getUnitCount() > 0) {
                logger.warning("Colony " + this.colony.getName() + " autodestruct averted.");
                u4 = this.colony.getTile().getFirstUnit();
                GoodsType bells = this.colony.getSpecification().getGoodsType("model.goods.bells");
                AIMessage.askWork(this.getAIUnit(u4), this.colony.getBuildingForProducing(bells));
                this.getAIUnit(u4).setMission(null);
            } else {
                throw new IllegalStateException("Colony " + this.colony.getName() + " contains no units!");
            }
        }
        this.rearrangeWorkers = false;
        return true;
    }

    private void checkForUnequippedExpertPioneer() {
        if (this.colony.getUnitCount() < 2) {
            return;
        }
        for (Unit unit : this.colony.getUnitList()) {
            AIUnit aiu;
            if (!unit.hasAbility("model.ability.expertPioneer") || (aiu = this.getAIUnit(unit)) == null) continue;
            if (!PioneeringMission.isValid(aiu)) {
                return;
            }
            unit.putOutsideColony();
            aiu.setMission(new PioneeringMission(this.getAIMain(), aiu));
            return;
        }
    }

    public static Unit bestUnitForWorkLocation(Collection<Unit> units, WorkLocation workLocation, GoodsType goodsType) {
        if (units == null || units.isEmpty() || workLocation == null || workLocation instanceof ColonyTile && goodsType == null || workLocation instanceof Building && ((Building)workLocation).getUnitCount() >= ((Building)workLocation).getMaxUnits()) {
            return null;
        }
        Tile tile = null;
        Building building = null;
        UnitType expert = null;
        if (workLocation instanceof ColonyTile) {
            tile = ((ColonyTile)workLocation).getWorkTile();
            expert = goodsType.getSpecification().getExpertForProducing(goodsType);
        } else if (workLocation instanceof Building) {
            building = (Building)workLocation;
            expert = building.getExpertUnitType();
        } else {
            return null;
        }
        Unit bestUnit = null;
        int production = 0;
        int bestProduction = 0;
        int experience = 0;
        int wastedExperience = 0;
        ExperienceUpgrade canBeUpgraded = ExperienceUpgrade.NONE;
        for (Unit unit : units) {
            ExperienceUpgrade upgradeable;
            if (unit.getType() == expert) {
                return unit;
            }
            if (tile != null) {
                production = unit.getProductionOf(goodsType, tile.potential(goodsType, unit.getType()));
            } else if (building != null) {
                production = building.getUnitProductivity(unit);
            }
            if (production > bestProduction) {
                bestUnit = unit;
                bestProduction = production;
                canBeUpgraded = AIColony.getExperienceUpgrade(unit, expert);
                if (canBeUpgraded == ExperienceUpgrade.NONE) {
                    experience = 0;
                    wastedExperience = 0;
                    continue;
                }
                if (unit.getWorkType() == goodsType) {
                    experience = unit.getExperience();
                    wastedExperience = 0;
                    continue;
                }
                experience = 0;
                wastedExperience = unit.getExperience();
                continue;
            }
            if (production != bestProduction || !((upgradeable = AIColony.getExperienceUpgrade(unit, expert)) == ExperienceUpgrade.EXPERT && (canBeUpgraded != ExperienceUpgrade.EXPERT || unit.getWorkType() == goodsType && unit.getExperience() > experience || unit.getWorkType() != goodsType && unit.getExperience() < wastedExperience)) && (upgradeable != ExperienceUpgrade.NONE || canBeUpgraded != ExperienceUpgrade.SOME)) continue;
            bestUnit = unit;
            canBeUpgraded = upgradeable;
            if (unit.getWorkType() == goodsType) {
                experience = unit.getExperience();
                wastedExperience = 0;
                continue;
            }
            experience = 0;
            wastedExperience = unit.getExperience();
        }
        if (bestProduction == 0) {
            return null;
        }
        return bestUnit;
    }

    private static ExperienceUpgrade getExperienceUpgrade(Unit unit, UnitType expert) {
        ExperienceUpgrade result = ExperienceUpgrade.NONE;
        for (UnitTypeChange change : unit.getType().getTypeChanges()) {
            if (!change.asResultOf(UnitTypeChange.ChangeType.EXPERIENCE)) continue;
            if (expert == change.getNewUnitType()) {
                return ExperienceUpgrade.EXPERT;
            }
            result = ExperienceUpgrade.SOME;
        }
        return result;
    }

    private void checkForUnarmedExpertSoldier() {
        EquipmentType musketsEqType = this.colony.getSpecification().getEquipmentType("model.equipment.muskets");
        block0: for (Unit unit : this.colony.getUnitList()) {
            if (this.colony.getUnitCount() == 1) {
                return;
            }
            if (!unit.hasAbility("model.ability.expertSoldier")) continue;
            if (this.colony.canBuildEquipment(musketsEqType)) {
                unit.putOutsideColony();
                continue;
            }
            for (Unit outsideUnit : this.colony.getTile().getUnitList()) {
                if (!outsideUnit.isArmed() || outsideUnit.hasAbility("model.ability.expertSoldier")) continue;
                unit.putOutsideColony();
                continue block0;
            }
        }
    }

    void checkConditionsForHorseBreed() {
        GoodsType horsesType = this.colony.getSpecification().getGoodsType("model.goods.horses");
        EquipmentType horsesEqType = this.colony.getSpecification().getEquipmentType("model.equipment.horses");
        GoodsType reqGoodsType = horsesType.getRawMaterial();
        if (this.colony.getGoodsCount(horsesType) >= horsesType.getBreedingNumber()) {
            return;
        }
        int foodProdAvail = this.colony.getFoodProduction() - this.colony.getConsumptionOf(reqGoodsType);
        if (foodProdAvail <= 0) {
            return;
        }
        for (Unit u : this.colony.getTile().getUnitList()) {
            int amount = u.getEquipmentCount(horsesEqType);
            if (amount <= 0 || !AIMessage.askEquipUnit(this.getAIUnit(u), horsesEqType, -amount) || this.colony.getGoodsCount(horsesType) < horsesType.getBreedingNumber()) continue;
            return;
        }
    }

    private void placeExpertsInWorkPlaces(List<Unit> units, List<WorkLocationPlan> workLocationPlans) {
        boolean canProduceInWater = this.colony.hasAbility("model.ability.produceInWater");
        for (Unit unit : new ArrayList<Unit>(units)) {
            GoodsType expertProd = unit.getType().getExpertProduction();
            if (expertProd == null) continue;
            WorkLocationPlan bestWorkPlan = null;
            int bestProduction = 0;
            for (WorkLocationPlan wlp : workLocationPlans) {
                WorkLocation wl = wlp.getWorkLocation();
                GoodsType locGoods = wlp.getGoodsType();
                boolean isColonyTile = wl instanceof ColonyTile;
                if (isColonyTile && !this.tryUseTile(((ColonyTile)wl).getWorkTile())) continue;
                boolean isLand = true;
                if (isColonyTile) {
                    isLand = ((ColonyTile)wl).getWorkTile().isLand();
                }
                if (isColonyTile && !isLand && !canProduceInWater || expertProd != locGoods) continue;
                if (!isColonyTile) {
                    bestWorkPlan = wlp;
                    break;
                }
                int planProd = wlp.getProductionOf(expertProd);
                if (bestWorkPlan != null && bestProduction >= planProd) continue;
                bestWorkPlan = wlp;
                bestProduction = planProd;
            }
            if (bestWorkPlan == null || !AIMessage.askWork(this.getAIUnit(unit), bestWorkPlan.getWorkLocation())) continue;
            AIMessage.askChangeWorkType(this.getAIUnit(unit), bestWorkPlan.getGoodsType());
            workLocationPlans.remove(bestWorkPlan);
            units.remove(unit);
        }
    }

    private void decideBuildable(Connection connection) {
        BuildableType buildable;
        Iterator<BuildableType> bi = this.colonyPlan.getBuildable();
        BuildableType buildableType = buildable = bi.hasNext() ? bi.next() : null;
        if (buildable != null && this.colony.canBuild(buildable) && buildable != this.colony.getCurrentlyBuilding()) {
            ArrayList<BuildableType> queue = new ArrayList<BuildableType>();
            queue.add(buildable);
            AIMessage.askSetBuildQueue(this, queue);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        logger.finest("Property change REARRANGE_WORKERS fired.");
        this.rearrangeWorkers = true;
    }

    @Override
    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement(AIColony.getXMLElementTagName());
        out.writeAttribute("ID", this.getId());
        for (AIGoods ag : this.aiGoods) {
            if (ag == null) {
                logger.warning("ag == null");
                continue;
            }
            if (ag.getId() == null) {
                logger.warning("ag.getId() == null");
                continue;
            }
            out.writeStartElement(AIGoods.getXMLElementTagName() + "ListElement");
            out.writeAttribute("ID", ag.getId());
            out.writeEndElement();
        }
        for (Wish w : this.wishes) {
            if (!w.shouldBeStored()) continue;
            if (w instanceof WorkerWish) {
                out.writeStartElement(WorkerWish.getXMLElementTagName() + "WishListElement");
            } else if (w instanceof GoodsWish) {
                out.writeStartElement(GoodsWish.getXMLElementTagName() + "WishListElement");
            } else {
                logger.warning("Unknown type of wish.");
                continue;
            }
            out.writeAttribute("ID", w.getId());
            out.writeEndElement();
        }
        for (TileImprovementPlan ti : this.tileImprovementPlans) {
            out.writeStartElement(TileImprovementPlan.getXMLElementTagName() + "ListElement");
            out.writeAttribute("ID", ti.getId());
            out.writeEndElement();
        }
        out.writeEndElement();
    }

    @Override
    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        this.colony = (Colony)this.getAIMain().getFreeColGameObject(in.getAttributeValue(null, "ID"));
        if (this.colony == null) {
            throw new NullPointerException("Could not find Colony with ID: " + in.getAttributeValue(null, "ID"));
        }
        this.aiGoods.clear();
        this.wishes.clear();
        this.colonyPlan = new ColonyPlan(this.getAIMain(), this.colony);
        this.colonyPlan.create();
        while (in.nextTag() != 2) {
            Wish w;
            if (in.getLocalName().equals(AIGoods.getXMLElementTagName() + "ListElement")) {
                AIGoods ag = (AIGoods)this.getAIMain().getAIObject(in.getAttributeValue(null, "ID"));
                if (ag == null) {
                    ag = new AIGoods(this.getAIMain(), in.getAttributeValue(null, "ID"));
                }
                this.aiGoods.add(ag);
                in.nextTag();
                continue;
            }
            if (in.getLocalName().equals(WorkerWish.getXMLElementTagName() + "WishListElement")) {
                w = (Wish)this.getAIMain().getAIObject(in.getAttributeValue(null, "ID"));
                if (w == null) {
                    w = new WorkerWish(this.getAIMain(), in.getAttributeValue(null, "ID"));
                }
                this.wishes.add(w);
                in.nextTag();
                continue;
            }
            if (in.getLocalName().equals(GoodsWish.getXMLElementTagName() + "WishListElement")) {
                w = (Wish)this.getAIMain().getAIObject(in.getAttributeValue(null, "ID"));
                if (w == null) {
                    w = new GoodsWish(this.getAIMain(), in.getAttributeValue(null, "ID"));
                }
                this.wishes.add(w);
                in.nextTag();
                continue;
            }
            if (in.getLocalName().equals(TileImprovementPlan.getXMLElementTagName() + "ListElement")) {
                TileImprovementPlan ti = (TileImprovementPlan)this.getAIMain().getAIObject(in.getAttributeValue(null, "ID"));
                if (ti == null) {
                    ti = new TileImprovementPlan(this.getAIMain(), in.getAttributeValue(null, "ID"));
                }
                this.tileImprovementPlans.add(ti);
                in.nextTag();
                continue;
            }
            logger.warning("Unknown tag name: " + in.getLocalName());
        }
        if (!in.getLocalName().equals(AIColony.getXMLElementTagName())) {
            logger.warning("Expected end tag, received: " + in.getLocalName());
        }
    }

    public ColonyPlan getColonyPlan() {
        return this.colonyPlan;
    }

    public static String getXMLElementTagName() {
        return "aiColony";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ExperienceUpgrade {
        NONE,
        SOME,
        EXPERT;

    }
}

