/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

public class UpdateCurrentStopMessage
extends Message {
    private String unitId;

    public UpdateCurrentStopMessage(Unit unit) {
        this.unitId = unit.getId();
    }

    public UpdateCurrentStopMessage(Game game, Element element) {
        this.unitId = element.getAttribute("unit");
    }

    public Element handle(FreeColServer server, Connection connection) {
        Unit unit;
        ServerPlayer serverPlayer = server.getPlayer(connection);
        try {
            unit = server.getUnitSafely(this.unitId, serverPlayer);
        }
        catch (Exception e) {
            return Message.clientError(e.getMessage());
        }
        return server.getInGameController().updateCurrentStop(serverPlayer, unit);
    }

    public Element toXMLElement() {
        Element result = UpdateCurrentStopMessage.createNewRootElement(UpdateCurrentStopMessage.getXMLElementTagName());
        result.setAttribute("unit", this.unitId);
        return result;
    }

    public static String getXMLElementTagName() {
        return "updateCurrentStop";
    }
}

