/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import java.util.ArrayList;
import java.util.List;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerGame;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetBuildQueueMessage
extends Message {
    private String colonyId;
    private String[] queue;

    public SetBuildQueueMessage(Colony colony, List<BuildableType> queue) {
        this.colonyId = colony.getId();
        this.queue = new String[queue.size()];
        for (int i = 0; i < queue.size(); ++i) {
            this.queue[i] = queue.get(i).getId();
        }
    }

    public SetBuildQueueMessage(Game game, Element element) {
        int size;
        this.colonyId = element.getAttribute("colony");
        try {
            size = Integer.parseInt(element.getAttribute("size"));
        }
        catch (NumberFormatException e) {
            size = -1;
        }
        if (size >= 0) {
            this.queue = new String[size];
            for (int i = 0; i < size; ++i) {
                this.queue[i] = element.getAttribute("x" + Integer.toString(i));
            }
        } else {
            this.queue = null;
        }
    }

    public Element handle(FreeColServer server, Player player, Connection connection) {
        ServerPlayer serverPlayer = server.getPlayer(connection);
        ServerGame game = server.getGame();
        Specification spec = game.getSpecification();
        if (!(game.getFreeColGameObject(this.colonyId) instanceof Colony)) {
            return Message.clientError("Not a colony: " + this.colonyId);
        }
        Colony colony = (Colony)game.getFreeColGameObject(this.colonyId);
        if (player != colony.getOwner()) {
            return Message.clientError("Player does not own colony: " + this.colonyId);
        }
        if (this.queue == null) {
            return Message.clientError("Empty queue");
        }
        ArrayList<BuildableType> buildQueue = new ArrayList<BuildableType>();
        for (int i = 0; i < this.queue.length; ++i) {
            FreeColGameObjectType type = spec.getType(this.queue[i]);
            if (!(type instanceof BuildableType)) {
                return Message.clientError("Not a buildable type id: " + this.queue[i]);
            }
            buildQueue.add(i, (BuildableType)type);
        }
        return server.getInGameController().setBuildQueue(serverPlayer, colony, buildQueue);
    }

    @Override
    public Element toXMLElement() {
        Element result = SetBuildQueueMessage.createNewRootElement(SetBuildQueueMessage.getXMLElementTagName());
        result.setAttribute("colony", this.colonyId);
        result.setAttribute("size", Integer.toString(this.queue.length));
        for (int i = 0; i < this.queue.length; ++i) {
            result.setAttribute("x" + Integer.toString(i), this.queue[i]);
        }
        return result;
    }

    public static String getXMLElementTagName() {
        return "setBuildQueue";
    }
}

