/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import java.util.ArrayList;
import java.util.List;
import net.sf.freecol.common.model.AbstractUnit;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Monarch;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.FreeColServer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MonarchActionMessage
extends Message {
    private Monarch.MonarchAction action;
    private String amountString;
    private String goodsTypeId;
    private String enemyId;
    private List<AbstractUnit> additions;

    public MonarchActionMessage(Monarch.MonarchAction action) {
        this.action = action;
        this.amountString = null;
        this.goodsTypeId = null;
        this.enemyId = null;
        this.additions = new ArrayList<AbstractUnit>();
    }

    public MonarchActionMessage(int tax, GoodsType goodsType) {
        this(Monarch.MonarchAction.RAISE_TAX);
        this.amountString = Integer.toString(tax);
        this.goodsTypeId = goodsType.getId();
    }

    public MonarchActionMessage(int tax) {
        this(Monarch.MonarchAction.LOWER_TAX);
        this.amountString = Integer.toString(tax);
    }

    public MonarchActionMessage(Player enemy) {
        this(Monarch.MonarchAction.DECLARE_WAR);
        this.enemyId = enemy.getId();
    }

    public MonarchActionMessage(Monarch.MonarchAction action, List<AbstractUnit> additions) {
        this(action);
        this.additions = additions;
    }

    public MonarchActionMessage(int price, List<AbstractUnit> additions) {
        this(Monarch.MonarchAction.OFFER_MERCENARIES, additions);
        this.amountString = Integer.toString(price);
    }

    public MonarchActionMessage(Game game, Element element) {
        this.action = Enum.valueOf(Monarch.MonarchAction.class, element.getAttribute("action"));
        this.amountString = element.getAttribute("amount");
        this.goodsTypeId = element.getAttribute("goods");
        this.enemyId = element.getAttribute("enemy");
        this.additions = new ArrayList<AbstractUnit>();
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            AbstractUnit au = new AbstractUnit();
            au.readFromXMLElement((Element)children.item(i));
            this.additions.add(au);
        }
    }

    public Monarch.MonarchAction getAction() {
        return this.action;
    }

    public int getAmount() {
        int amount;
        try {
            amount = Integer.parseInt(this.amountString);
        }
        catch (NumberFormatException e) {
            amount = -1;
        }
        return amount;
    }

    public GoodsType getGoodsType(Game game) {
        return this.goodsTypeId == null ? null : game.getSpecification().getGoodsType(this.goodsTypeId);
    }

    public Player getEnemy(Game game) {
        return this.enemyId == null ? null : (game.getFreeColGameObject(this.enemyId) instanceof Player ? (Player)game.getFreeColGameObject(this.enemyId) : null);
    }

    public List<AbstractUnit> getAdditions() {
        return this.additions;
    }

    public Element handle(FreeColServer server, Player player, Connection connection) {
        return null;
    }

    @Override
    public Element toXMLElement() {
        Element result = MonarchActionMessage.createNewRootElement(MonarchActionMessage.getXMLElementTagName());
        Document doc = result.getOwnerDocument();
        result.setAttribute("action", this.action.toString());
        if (this.amountString != null) {
            result.setAttribute("amount", this.amountString);
        }
        if (this.goodsTypeId != null) {
            result.setAttribute("goods", this.goodsTypeId);
        }
        if (this.enemyId != null) {
            result.setAttribute("enemy", this.enemyId);
        }
        for (AbstractUnit au : this.additions) {
            result.appendChild(au.toXMLElement(null, doc));
        }
        return result;
    }

    public static String getXMLElementTagName() {
        return "monarchAction";
    }
}

