/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.DiplomaticTrade;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DiplomacyMessage
extends Message {
    private String unitId;
    private String settlementId;
    private DiplomaticTrade agreement;

    public DiplomacyMessage(Unit unit, Settlement settlement, DiplomaticTrade agreement) {
        this.unitId = unit.getId();
        this.settlementId = settlement.getId();
        this.agreement = agreement;
    }

    public DiplomacyMessage(Game game, Element element) {
        this.unitId = element.getAttribute("unit");
        this.settlementId = element.getAttribute("settlement");
        NodeList nodes = element.getChildNodes();
        this.agreement = nodes.getLength() < 1 ? null : new DiplomaticTrade(game, (Element)nodes.item(0));
    }

    public Unit getUnit(Game game) {
        return game.getFreeColGameObject(this.unitId) instanceof Unit ? (Unit)game.getFreeColGameObject(this.unitId) : null;
    }

    public Settlement getSettlement(Game game) {
        return game.getFreeColGameObject(this.settlementId) instanceof Settlement ? (Settlement)game.getFreeColGameObject(this.settlementId) : null;
    }

    public DiplomaticTrade getAgreement() {
        return this.agreement;
    }

    public void setAgreement(DiplomaticTrade agreement) {
        this.agreement = agreement;
    }

    public Element handle(FreeColServer server, Connection connection) {
        Settlement settlement;
        Unit unit;
        ServerPlayer serverPlayer = server.getPlayer(connection);
        try {
            unit = server.getUnitSafely(this.unitId, serverPlayer);
        }
        catch (Exception e) {
            return Message.clientError(e.getMessage());
        }
        if (unit.getTile() == null) {
            return Message.clientError("Unit is not on the map: " + this.unitId);
        }
        try {
            settlement = server.getAdjacentSettlementSafely(this.settlementId, unit);
        }
        catch (Exception e) {
            return Message.clientError(e.getMessage());
        }
        if (!(settlement instanceof Colony)) {
            return Message.clientError("Settlement is not a colony: " + this.settlementId);
        }
        Unit.MoveType type = unit.getMoveType(settlement.getTile());
        if (type != Unit.MoveType.ENTER_FOREIGN_COLONY_WITH_SCOUT) {
            return Message.clientError("Unable to enter " + settlement.getName() + ": " + type.whyIllegal());
        }
        if (this.agreement == null) {
            return Message.clientError("DiplomaticTrade with null agreement.");
        }
        if (this.agreement.getSender() != serverPlayer) {
            return Message.clientError("DiplomaticTrade received from player who is not the sender: " + serverPlayer.getId());
        }
        ServerPlayer enemyPlayer = (ServerPlayer)this.agreement.getRecipient();
        if (enemyPlayer == null) {
            return Message.clientError("DiplomaticTrade recipient is null");
        }
        if (enemyPlayer == serverPlayer) {
            return Message.clientError("DiplomaticTrade recipient matches sender: " + serverPlayer.getId());
        }
        Player settlementPlayer = settlement.getOwner();
        if (settlementPlayer != enemyPlayer) {
            return Message.clientError("DiplomaticTrade recipient: " + enemyPlayer.getId() + " does not match Settlement owner: " + settlementPlayer);
        }
        if (enemyPlayer == serverPlayer.getREFPlayer()) {
            return Message.clientError("Player can not negotiate with the REF: " + serverPlayer.getId());
        }
        return server.getInGameController().diplomaticTrade(serverPlayer, unit, settlement, this.agreement);
    }

    public Element toXMLElement() {
        Element result = DiplomacyMessage.createNewRootElement(DiplomacyMessage.getXMLElementTagName());
        result.setAttribute("unit", this.unitId);
        result.setAttribute("settlement", this.settlementId);
        result.appendChild(this.agreement.toXMLElement(null, result.getOwnerDocument()));
        return result;
    }

    public static String getXMLElementTagName() {
        return "diplomacy";
    }
}

