/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.Event;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Limit;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

public class DeclareIndependenceMessage
extends Message {
    private String nationName;
    private String countryName;

    public DeclareIndependenceMessage(String nationName, String countryName) {
        this.nationName = nationName;
        this.countryName = countryName;
    }

    public DeclareIndependenceMessage(Game game, Element element) {
        this.nationName = element.getAttribute("nationName");
        this.countryName = element.getAttribute("countryName");
    }

    public Element handle(FreeColServer server, Player player, Connection connection) {
        ServerPlayer serverPlayer = server.getPlayer(connection);
        if (this.nationName == null || this.nationName.length() == 0 || this.countryName == null || this.countryName.length() == 0) {
            return Message.clientError("Empty nation or country name.");
        }
        Event event = player.getSpecification().getEvent("model.event.declareIndependence");
        for (Limit limit : event.getLimits()) {
            if (limit.evaluate(player)) continue;
            return Message.clientError(limit.getDescriptionKey() + " " + Integer.toString(limit.getRightHandSide().getValue()));
        }
        if (player.getPlayerType() != Player.PlayerType.COLONIAL) {
            return Message.clientError("Only colonial players can declare independence.");
        }
        return server.getInGameController().declareIndependence(serverPlayer, this.nationName, this.countryName);
    }

    public Element toXMLElement() {
        Element result = DeclareIndependenceMessage.createNewRootElement(DeclareIndependenceMessage.getXMLElementTagName());
        result.setAttribute("nationName", this.nationName);
        result.setAttribute("countryName", this.countryName);
        return result;
    }

    public static String getXMLElementTagName() {
        return "declareIndependence";
    }
}

