/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovement;
import net.sf.freecol.common.model.TileImprovementType;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

public class ChangeWorkImprovementTypeMessage
extends Message {
    private String unitId;
    private String improvementId;

    public ChangeWorkImprovementTypeMessage(Unit unit, TileImprovementType type) {
        this.unitId = unit.getId();
        this.improvementId = type.getId();
    }

    public ChangeWorkImprovementTypeMessage(Game game, Element element) {
        this.unitId = element.getAttribute("unit");
        this.improvementId = element.getAttribute("improvementType");
    }

    public Element handle(FreeColServer server, Player player, Connection connection) {
        Unit unit;
        ServerPlayer serverPlayer = server.getPlayer(connection);
        try {
            unit = server.getUnitSafely(this.unitId, serverPlayer);
        }
        catch (Exception e) {
            return Message.clientError(e.getMessage());
        }
        Tile tile = unit.getTile();
        if (tile == null) {
            return Message.clientError("Unit is not on the map: " + this.unitId);
        }
        if (!unit.hasAbility("model.ability.improveTerrain")) {
            return Message.clientError("Unit can not improve tiles: " + this.unitId);
        }
        TileImprovementType type = server.getSpecification().getTileImprovementType(this.improvementId);
        if (type == null) {
            return Message.clientError("Not a tile improvement type: " + this.improvementId);
        }
        if (type.isNatural()) {
            return Message.clientError("ImprovementType must not be natural: " + this.improvementId);
        }
        if (!type.isTileTypeAllowed(tile.getType())) {
            return Message.clientError("ImprovementType not allowed on tile: " + this.improvementId);
        }
        TileImprovement improvement = tile.findTileImprovementType(type);
        if (improvement == null) {
            if (!type.isWorkerAllowed(unit)) {
                return Message.clientError("Unit can not to create improvement: " + this.improvementId);
            }
        } else if (!improvement.isWorkerAllowed(unit)) {
            return Message.clientError("Unit can not work on improvement: " + this.improvementId);
        }
        return server.getInGameController().changeWorkImprovementType(serverPlayer, unit, type);
    }

    public Element toXMLElement() {
        Element result = ChangeWorkImprovementTypeMessage.createNewRootElement(ChangeWorkImprovementTypeMessage.getXMLElementTagName());
        result.setAttribute("unit", this.unitId);
        result.setAttribute("improvementType", this.improvementId);
        return result;
    }

    public static String getXMLElementTagName() {
        return "changeWorkImprovementType";
    }
}

