/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

public class AssignTeacherMessage
extends Message {
    private String studentId;
    private String teacherId;

    public AssignTeacherMessage(Unit student, Unit teacher) {
        this.studentId = student.getId();
        this.teacherId = teacher.getId();
    }

    public AssignTeacherMessage(Game game, Element element) {
        this.studentId = element.getAttribute("student");
        this.teacherId = element.getAttribute("teacher");
    }

    public Element handle(FreeColServer server, Player player, Connection connection) {
        Unit teacher;
        Unit student;
        ServerPlayer serverPlayer = server.getPlayer(connection);
        try {
            student = server.getUnitSafely(this.studentId, serverPlayer);
        }
        catch (Exception e) {
            return Message.clientError(e.getMessage());
        }
        try {
            teacher = server.getUnitSafely(this.teacherId, serverPlayer);
        }
        catch (Exception e) {
            return Message.clientError(e.getMessage());
        }
        if (student.getColony() == null) {
            return Message.clientError("Student not in colony: " + this.studentId);
        }
        if (!(student.getLocation() instanceof WorkLocation)) {
            return Message.clientError("Student not working colony: " + this.studentId);
        }
        if (teacher.getColony() == null) {
            return Message.clientError("Teacher not in colony: " + this.teacherId);
        }
        if (!teacher.getColony().canTrain(teacher)) {
            return Message.clientError("Teacher can not teach: " + this.teacherId);
        }
        if (student.getColony() != teacher.getColony()) {
            return Message.clientError("Student and teacher not in same colony: " + this.studentId);
        }
        if (!student.canBeStudent(teacher)) {
            return Message.clientError("Student can not be taught by teacher: " + this.studentId);
        }
        return server.getInGameController().assignTeacher(serverPlayer, student, teacher);
    }

    public Element toXMLElement() {
        Element result = AssignTeacherMessage.createNewRootElement(AssignTeacherMessage.getXMLElementTagName());
        result.setAttribute("student", this.studentId);
        result.setAttribute("teacher", this.teacherId);
        return result;
    }

    public static String getXMLElementTagName() {
        return "assignTeacher";
    }
}

