/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

public class AbandonColonyMessage
extends Message {
    String colonyId;

    public AbandonColonyMessage(Colony colony) {
        this.colonyId = colony.getId();
    }

    public AbandonColonyMessage(Game game, Element element) {
        this.colonyId = element.getAttribute("colony");
    }

    public Element handle(FreeColServer server, Player player, Connection connection) {
        Game game = player.getGame();
        ServerPlayer serverPlayer = server.getPlayer(connection);
        if (!(game.getFreeColGameObject(this.colonyId) instanceof Colony)) {
            return Message.clientError("Not a colony: " + this.colonyId);
        }
        Colony colony = (Colony)game.getFreeColGameObject(this.colonyId);
        if (player != colony.getOwner()) {
            return Message.clientError("Player does not own colony: " + this.colonyId);
        }
        if (colony.getUnitCount() != 0) {
            return Message.clientError("Attempt to abandon colony " + this.colonyId + " with non-zero unit count " + Integer.toString(colony.getUnitCount()));
        }
        return server.getInGameController().abandonSettlement(serverPlayer, colony);
    }

    public Element toXMLElement() {
        Element result = AbandonColonyMessage.createNewRootElement(AbandonColonyMessage.getXMLElementTagName());
        result.setAttribute("colony", this.colonyId);
        return result;
    }

    public static String getXMLElementTagName() {
        return "abandonColony";
    }
}

