/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.Consumer;
import net.sf.freecol.common.model.EquipmentType;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.TypeCountMap;
import net.sf.freecol.common.model.UnitTypeChange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UnitType
extends BuildableType
implements Comparable<UnitType>,
Consumer {
    public static final int DEFAULT_OFFENCE = 0;
    public static final int DEFAULT_DEFENCE = 1;
    private int offence = 0;
    private int defence = 1;
    private int space = 0;
    private int hitPoints = 0;
    private int spaceTaken = 1;
    private int skill = Integer.MIN_VALUE;
    private int price = Integer.MIN_VALUE;
    private int movement = 3;
    private int lineOfSight = 1;
    private int recruitProbability = 0;
    private GoodsType expertProduction;
    private int scoreValue = 0;
    private int maximumExperience = 0;
    private int maximumAttrition = Integer.MAX_VALUE;
    private UnitType skillTaught;
    private EquipmentType defaultEquipment;
    private TypeCountMap<GoodsType> consumption = new TypeCountMap();
    private List<UnitTypeChange> typeChanges = new ArrayList<UnitTypeChange>();

    public UnitType(String id, Specification specification) {
        super(id, specification);
        this.setModifierIndex(Modifier.EXPERT_PRODUCTION_INDEX);
    }

    public final String getWorkingAsKey() {
        return this.getId() + ".workingAs";
    }

    public boolean canCarryUnits() {
        return this.hasAbility("model.ability.carryUnits");
    }

    public boolean canCarryGoods() {
        return this.hasAbility("model.ability.carryGoods");
    }

    public int getScoreValue() {
        return this.scoreValue;
    }

    public void setScoreValue(int newScoreValue) {
        this.scoreValue = newScoreValue;
    }

    public int getOffence() {
        return this.offence;
    }

    public void setOffence(int newOffence) {
        this.offence = newOffence;
    }

    public int getDefence() {
        return this.defence;
    }

    public void setDefence(int newDefence) {
        this.defence = newDefence;
    }

    public int getLineOfSight() {
        return this.lineOfSight;
    }

    public void setLineOfSight(int newLineOfSight) {
        this.lineOfSight = newLineOfSight;
    }

    public int getSpace() {
        return this.space;
    }

    public void setSpace(int newSpace) {
        this.space = newSpace;
    }

    public int getHitPoints() {
        return this.hitPoints;
    }

    public void setHitPoints(int newHitPoints) {
        this.hitPoints = newHitPoints;
    }

    public int getSpaceTaken() {
        return Math.max(this.spaceTaken, this.space + 1);
    }

    public void setSpaceTaken(int newSpaceTaken) {
        this.spaceTaken = newSpaceTaken;
    }

    public boolean isRecruitable() {
        return this.recruitProbability > 0;
    }

    public int getRecruitProbability() {
        return this.recruitProbability;
    }

    public void setRecruitProbability(int newRecruitProbability) {
        this.recruitProbability = newRecruitProbability;
    }

    public int getSkill() {
        return this.skill;
    }

    public void setSkill(int newSkill) {
        this.skill = newSkill;
    }

    public int getPrice() {
        return this.price;
    }

    public void setPrice(int newPrice) {
        this.price = newPrice;
    }

    public int getMovement() {
        return this.movement;
    }

    public void setMovement(int newMovement) {
        this.movement = newMovement;
    }

    public final int getMaximumExperience() {
        return this.maximumExperience;
    }

    public final void setMaximumExperience(int newMaximumExperience) {
        this.maximumExperience = newMaximumExperience;
    }

    public int getMaximumAttrition() {
        return this.maximumAttrition;
    }

    public void setMaximumAttrition(int newMaximumAttrition) {
        this.maximumAttrition = newMaximumAttrition;
    }

    public GoodsType getExpertProduction() {
        return this.expertProduction;
    }

    public void setExpertProduction(GoodsType newExpertProduction) {
        this.expertProduction = newExpertProduction;
    }

    public EquipmentType getDefaultEquipmentType() {
        return this.defaultEquipment;
    }

    public void setDefaultEquipmentType(EquipmentType newDefaultEquipment) {
        this.defaultEquipment = newDefaultEquipment;
    }

    public EquipmentType[] getDefaultEquipment() {
        if (this.hasAbility("model.ability.canBeEquipped") && this.defaultEquipment != null) {
            int count = this.defaultEquipment.getMaximumCount();
            EquipmentType[] result = new EquipmentType[count];
            for (int index = 0; index < count; ++index) {
                result[index] = this.defaultEquipment;
            }
            return result;
        }
        return EquipmentType.NO_EQUIPMENT;
    }

    public List<UnitTypeChange> getTypeChanges() {
        return this.typeChanges;
    }

    public UnitType getSkillTaught() {
        return this.skillTaught;
    }

    public void setSkillTaught(UnitType newSkillTaught) {
        this.skillTaught = newSkillTaught;
    }

    public boolean isAvailableTo(Player player) {
        Map<String, Boolean> requiredAbilities = this.getAbilitiesRequired();
        for (Map.Entry<String, Boolean> entry : requiredAbilities.entrySet()) {
            if (player.hasAbility(entry.getKey()) == entry.getValue().booleanValue()) continue;
            return false;
        }
        return true;
    }

    public UnitType getTargetType(UnitTypeChange.ChangeType changeType, Player player) {
        UnitTypeChange change = this.getUnitTypeChange(changeType, player);
        return change == null ? null : change.getNewUnitType();
    }

    public UnitTypeChange getUnitTypeChange(UnitTypeChange.ChangeType changeType, Player player) {
        for (UnitTypeChange change : this.typeChanges) {
            UnitType result;
            if (!change.asResultOf(changeType) || !change.appliesTo(player) || !(result = change.getNewUnitType()).isAvailableTo(player)) continue;
            return change;
        }
        return null;
    }

    public UnitTypeChange getUnitTypeChange(UnitType newType) {
        for (UnitTypeChange change : this.typeChanges) {
            if (change.getNewUnitType() != newType) continue;
            return change;
        }
        return null;
    }

    public boolean canBeUpgraded(UnitType newType, UnitTypeChange.ChangeType changeType) {
        for (UnitTypeChange change : this.typeChanges) {
            if (newType != null && newType != change.getNewUnitType() || change.getProbability(changeType) <= 0) continue;
            return true;
        }
        return false;
    }

    public List<UnitType> getUnitTypesLearntInLostCity() {
        ArrayList<UnitType> unitTypes = new ArrayList<UnitType>();
        for (UnitTypeChange change : this.typeChanges) {
            if (!change.asResultOf(UnitTypeChange.ChangeType.LOST_CITY)) continue;
            unitTypes.add(change.getNewUnitType());
        }
        return unitTypes;
    }

    public UnitType getEducationUnit(int maximumSkill) {
        for (UnitTypeChange change : this.typeChanges) {
            UnitType unitType;
            if (!change.canBeTaught() || !(unitType = change.getNewUnitType()).hasSkill() || unitType.getSkill() > maximumSkill) continue;
            return unitType;
        }
        return null;
    }

    public int getEducationTurns(UnitType unitType) {
        for (UnitTypeChange change : this.typeChanges) {
            if (!change.asResultOf(UnitTypeChange.ChangeType.EDUCATION) || unitType != change.getNewUnitType()) continue;
            return change.getTurnsToLearn();
        }
        return Integer.MIN_VALUE;
    }

    public boolean isNaval() {
        return this.hasAbility("model.ability.navalUnit");
    }

    @Override
    public void readAttributes(XMLStreamReader in) throws XMLStreamException {
        super.readAttributes(in);
        String extendString = in.getAttributeValue(null, "extends");
        UnitType parent = extendString == null ? this : this.getSpecification().getUnitType(extendString);
        this.offence = this.getAttribute(in, "offence", parent.offence);
        this.defence = this.getAttribute(in, "defence", parent.defence);
        this.movement = this.getAttribute(in, "movement", parent.movement);
        this.lineOfSight = this.getAttribute(in, "lineOfSight", parent.lineOfSight);
        this.scoreValue = this.getAttribute(in, "scoreValue", parent.scoreValue);
        this.space = this.getAttribute(in, "space", parent.space);
        this.hitPoints = this.getAttribute(in, "hitPoints", parent.hitPoints);
        this.spaceTaken = this.getAttribute(in, "spaceTaken", parent.spaceTaken);
        this.maximumExperience = this.getAttribute(in, "maximumExperience", parent.maximumExperience);
        this.maximumAttrition = this.getAttribute(in, "maximumAttrition", parent.maximumAttrition);
        String skillString = in.getAttributeValue(null, "skillTaught");
        this.skillTaught = skillString == null ? this : this.getSpecification().getUnitType(skillString);
        this.recruitProbability = this.getAttribute(in, "recruitProbability", parent.recruitProbability);
        this.skill = this.getAttribute(in, "skill", parent.skill);
        this.setPopulationRequired(this.getAttribute(in, "population-required", parent.getPopulationRequired()));
        this.price = this.getAttribute(in, "price", parent.price);
        this.expertProduction = this.getSpecification().getType(in, "expert-production", GoodsType.class, parent.expertProduction);
        if (parent != this) {
            this.typeChanges.addAll(parent.typeChanges);
            this.defaultEquipment = parent.defaultEquipment;
            this.consumption.putAll(parent.consumption);
            this.getFeatureContainer().add(parent.getFeatureContainer());
            if (parent.isAbstractType()) {
                this.getFeatureContainer().replaceSource(parent, this);
            }
        }
    }

    @Override
    public void readChild(XMLStreamReader in) throws XMLStreamException {
        String nodeName = in.getLocalName();
        if ("downgrade".equals(nodeName) || "upgrade".equals(nodeName)) {
            if (UnitType.getAttribute(in, "delete", false)) {
                String unitId = in.getAttributeValue(null, "unit");
                Iterator<UnitTypeChange> iterator = this.typeChanges.iterator();
                while (iterator.hasNext()) {
                    if (!unitId.equals(iterator.next().getNewUnitType().getId())) continue;
                    iterator.remove();
                    break;
                }
                in.nextTag();
            } else {
                UnitTypeChange change = new UnitTypeChange(in, this.getSpecification());
                if ("downgrade".equals(nodeName) && change.getChangeTypes().isEmpty()) {
                    change.getChangeTypes().put(UnitTypeChange.ChangeType.CLEAR_SKILL, 100);
                }
                this.typeChanges.add(change);
            }
        } else if ("default-equipment".equals(nodeName)) {
            String equipmentString = in.getAttributeValue(null, "id");
            if (equipmentString != null) {
                this.defaultEquipment = this.getSpecification().getEquipmentType(equipmentString);
            }
            in.nextTag();
        } else if ("consumes".equals(nodeName)) {
            String typeString = in.getAttributeValue(null, "id");
            String valueString = in.getAttributeValue(null, "value");
            if (typeString != null && valueString != null) {
                try {
                    GoodsType type = this.getSpecification().getGoodsType(typeString);
                    int amount = Integer.parseInt(valueString);
                    this.consumption.incrementCount(type, amount);
                }
                catch (Exception e) {
                    logger.warning("Failed to parse integer " + valueString);
                }
            }
            in.nextTag();
        } else {
            super.readChild(in);
        }
    }

    @Override
    public void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        super.toXML(out, UnitType.getXMLElementTagName());
    }

    @Override
    public void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        super.writeAttributes(out);
        out.writeAttribute("offence", Integer.toString(this.offence));
        out.writeAttribute("defence", Integer.toString(this.defence));
        out.writeAttribute("movement", Integer.toString(this.movement));
        out.writeAttribute("lineOfSight", Integer.toString(this.lineOfSight));
        out.writeAttribute("scoreValue", Integer.toString(this.scoreValue));
        out.writeAttribute("space", Integer.toString(this.space));
        out.writeAttribute("spaceTaken", Integer.toString(this.spaceTaken));
        out.writeAttribute("hitPoints", Integer.toString(this.hitPoints));
        out.writeAttribute("maximumExperience", Integer.toString(this.maximumExperience));
        if (this.maximumAttrition < Integer.MAX_VALUE) {
            out.writeAttribute("maximumAttrition", Integer.toString(this.maximumAttrition));
        }
        out.writeAttribute("recruitProbability", Integer.toString(this.recruitProbability));
        if (this.skill != Integer.MIN_VALUE) {
            out.writeAttribute("skill", Integer.toString(this.skill));
        }
        if (this.price != Integer.MIN_VALUE) {
            out.writeAttribute("price", Integer.toString(this.price));
        }
        out.writeAttribute("skillTaught", this.skillTaught.getId());
        if (this.expertProduction != null) {
            out.writeAttribute("expert-production", this.expertProduction.getId());
        }
    }

    @Override
    protected void writeChildren(XMLStreamWriter out) throws XMLStreamException {
        super.writeChildren(out);
        for (UnitTypeChange change : this.typeChanges) {
            change.toXMLImpl(out);
        }
        if (this.defaultEquipment != null) {
            out.writeStartElement("default-equipment");
            out.writeAttribute("id", this.defaultEquipment.getId());
            out.writeEndElement();
        }
        if (!this.consumption.isEmpty()) {
            for (GoodsType goodsType : this.consumption.keySet()) {
                out.writeStartElement("consumes");
                out.writeAttribute("id", goodsType.getId());
                out.writeAttribute("value", Integer.toString(this.consumption.getCount(goodsType)));
                out.writeEndElement();
            }
        }
    }

    public static String getXMLElementTagName() {
        return "unit-type";
    }

    public boolean hasSkill() {
        return this.skill != Integer.MIN_VALUE;
    }

    public boolean canBeBuilt() {
        return !this.getGoodsRequired().isEmpty();
    }

    public boolean hasPrice() {
        return this.price != Integer.MIN_VALUE;
    }

    public int getProductionFor(GoodsType goodsType, int base) {
        if (base == 0) {
            return 0;
        }
        base = (int)this.getFeatureContainer().applyModifier(base, goodsType.getId());
        return Math.max(base, 1);
    }

    public int getConsumptionOf(GoodsType goodsType) {
        return this.consumption.getCount(goodsType);
    }

    @Override
    public int compareTo(UnitType other) {
        return this.getIndex() - other.getIndex();
    }

    @Override
    public List<AbstractGoods> getConsumedGoods() {
        ArrayList<AbstractGoods> result = new ArrayList<AbstractGoods>();
        for (GoodsType goodsType : this.consumption.keySet()) {
            result.add(new AbstractGoods(goodsType, this.consumption.getCount(goodsType)));
        }
        return result;
    }

    @Override
    public int getPriority() {
        return 1000;
    }
}

