/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.ResourceType;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.TileImprovementType;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.option.OptionGroup;
import net.sf.freecol.common.option.StringOption;
import net.sf.freecol.common.util.RandomChoice;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TileType
extends FreeColGameObjectType {
    private boolean forest;
    private boolean water;
    private boolean canSettle;
    private int basicMoveCost;
    private int basicWorkTurns;
    private int[] humidity = new int[2];
    private int[] temperature = new int[2];
    private int[] altitude = new int[2];
    private List<RandomChoice<ResourceType>> resourceType = new ArrayList<RandomChoice<ResourceType>>();
    private boolean connected;
    private AbstractGoods primaryGoods = null;
    private AbstractGoods secondaryGoods = null;
    private List<AbstractGoods> production = new ArrayList<AbstractGoods>();
    private Map<String, AbstractGoods> primaryGoodsMap = new HashMap<String, AbstractGoods>();
    private Map<String, AbstractGoods> secondaryGoodsMap = new HashMap<String, AbstractGoods>();
    private Map<String, Map<GoodsType, AbstractGoods>> productionMap = new HashMap<String, Map<GoodsType, AbstractGoods>>();

    public TileType(String id, Specification specification) {
        super(id, specification);
    }

    @Override
    public int getIndex() {
        return super.getIndex();
    }

    public boolean isForested() {
        return this.forest;
    }

    public boolean isWater() {
        return this.water;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public boolean canSettle() {
        return this.canSettle;
    }

    public boolean canHaveImprovement(TileImprovementType improvement) {
        return improvement != null && improvement.isTileTypeAllowed(this);
    }

    public int getBasicMoveCost() {
        return this.basicMoveCost;
    }

    public int getBasicWorkTurns() {
        return this.basicWorkTurns;
    }

    public Set<Modifier> getDefenceBonus() {
        return this.getModifierSet("model.modifier.defence");
    }

    public int getProductionOf(GoodsType goodsType, UnitType unitType) {
        return (int)this.getFeatureContainer().applyModifier(0.0f, goodsType.getId(), unitType);
    }

    public Set<Modifier> getProductionBonus(GoodsType goodsType) {
        return this.getFeatureContainer().getModifierSet(goodsType.getId());
    }

    public AbstractGoods getPrimaryGoods() {
        return this.primaryGoods;
    }

    public AbstractGoods getPrimaryGoods(String tileProduction) {
        AbstractGoods result = this.primaryGoodsMap.get(tileProduction);
        if (result == null) {
            result = this.primaryGoodsMap.get(null);
        }
        return result;
    }

    public boolean isPrimaryGoodsType(GoodsType type) {
        return this.primaryGoods != null && this.primaryGoods.getType() == type;
    }

    public void setPrimaryGoods(AbstractGoods newPrimaryGoods) {
        this.primaryGoods = newPrimaryGoods;
    }

    public AbstractGoods getSecondaryGoods() {
        return this.secondaryGoods;
    }

    public AbstractGoods getSecondaryGoods(String tileProduction) {
        AbstractGoods result = this.secondaryGoodsMap.get(tileProduction);
        if (result == null) {
            result = this.secondaryGoodsMap.get(null);
        }
        return result;
    }

    public void setSecondaryGoods(AbstractGoods newSecondaryGoods) {
        this.secondaryGoods = newSecondaryGoods;
    }

    public boolean isSecondaryGoodsType(GoodsType type) {
        return this.secondaryGoods != null && this.secondaryGoods.getType() == type;
    }

    public List<AbstractGoods> getProduction() {
        return this.production;
    }

    public List<AbstractGoods> getProduction(String tileProduction) {
        HashMap<GoodsType, AbstractGoods> result = new HashMap<GoodsType, AbstractGoods>();
        Map<GoodsType, AbstractGoods> defaultMap = this.productionMap.get(null);
        Map<GoodsType, AbstractGoods> difficultyMap = this.productionMap.get(tileProduction);
        if (defaultMap != null) {
            result.putAll(defaultMap);
        }
        if (difficultyMap != null) {
            result.putAll(difficultyMap);
        }
        return new ArrayList<AbstractGoods>(result.values());
    }

    public List<RandomChoice<ResourceType>> getWeightedResources() {
        return this.resourceType;
    }

    public List<ResourceType> getResourceTypeList() {
        ArrayList<ResourceType> result = new ArrayList<ResourceType>();
        for (RandomChoice<ResourceType> resource : this.resourceType) {
            result.add(resource.getObject());
        }
        return result;
    }

    public boolean canHaveResourceType(ResourceType resourceType) {
        return this.getResourceTypeList().contains(resourceType);
    }

    public boolean withinRange(RangeType rangeType, int value) {
        switch (rangeType) {
            case HUMIDITY: {
                return this.humidity[0] <= value && value <= this.humidity[1];
            }
            case TEMPERATURE: {
                return this.temperature[0] <= value && value <= this.temperature[1];
            }
            case ALTITUDE: {
                return this.altitude[0] <= value && value <= this.altitude[1];
            }
        }
        return false;
    }

    @Override
    public void applyDifficultyLevel(OptionGroup difficultyLevel) {
        String tileProduction = ((StringOption)difficultyLevel.getOption("model.option.tileProduction")).getValue();
        this.primaryGoods = this.getPrimaryGoods(tileProduction);
        this.secondaryGoods = this.getSecondaryGoods(tileProduction);
        this.production = this.getProduction(tileProduction);
        for (GoodsType goodsType : this.getSpecification().getGoodsTypeList()) {
            this.getFeatureContainer().removeModifiers(goodsType.getId());
        }
        for (AbstractGoods goods : this.production) {
            this.addModifier(new Modifier(goods.getType().getId(), this, goods.getAmount(), Modifier.Type.ADDITIVE));
        }
    }

    @Override
    public void readAttributes(XMLStreamReader in) throws XMLStreamException {
        super.readAttributes(in);
        this.basicMoveCost = Integer.parseInt(in.getAttributeValue(null, "basic-move-cost"));
        this.basicWorkTurns = Integer.parseInt(in.getAttributeValue(null, "basic-work-turns"));
        this.forest = TileType.getAttribute(in, "is-forest", false);
        this.water = TileType.getAttribute(in, "is-water", false);
        this.canSettle = TileType.getAttribute(in, "can-settle", !this.water);
        this.connected = TileType.getAttribute(in, "is-connected", false);
    }

    @Override
    public void readChild(XMLStreamReader in) throws XMLStreamException {
        String childName = in.getLocalName();
        if ("gen".equals(childName)) {
            this.humidity[0] = this.getAttribute(in, "humidityMin", 0);
            this.humidity[1] = this.getAttribute(in, "humidityMax", 100);
            this.temperature[0] = this.getAttribute(in, "temperatureMin", -20);
            this.temperature[1] = this.getAttribute(in, "temperatureMax", 40);
            this.altitude[0] = this.getAttribute(in, "altitudeMin", 0);
            this.altitude[1] = this.getAttribute(in, "altitudeMax", 0);
            in.nextTag();
        } else if ("production".equals(childName) || "primary-production".equals(childName) || "secondary-production".equals(childName)) {
            GoodsType type = this.getSpecification().getGoodsType(in.getAttributeValue(null, "goods-type"));
            int amount = Integer.parseInt(in.getAttributeValue(null, "value"));
            AbstractGoods goods = new AbstractGoods(type, amount);
            String tileProduction = in.getAttributeValue(null, "tile-production");
            if ("primary-production".equals(childName)) {
                this.primaryGoodsMap.put(tileProduction, goods);
            } else if ("secondary-production".equals(childName)) {
                this.secondaryGoodsMap.put(tileProduction, goods);
            } else {
                Map<GoodsType, AbstractGoods> oldValue = this.productionMap.get(tileProduction);
                if (oldValue == null) {
                    oldValue = new HashMap<GoodsType, AbstractGoods>();
                    this.productionMap.put(tileProduction, oldValue);
                }
                oldValue.put(type, goods);
            }
            in.nextTag();
        } else if ("resource".equals(childName)) {
            ResourceType type = this.getSpecification().getResourceType(in.getAttributeValue(null, "type"));
            int probability = this.getAttribute(in, "probability", 100);
            this.resourceType.add(new RandomChoice<ResourceType>(type, probability));
            in.nextTag();
        } else {
            super.readChild(in);
        }
    }

    @Override
    public void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        super.toXML(out, TileType.getXMLElementTagName());
    }

    @Override
    public void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        super.writeAttributes(out);
        out.writeAttribute("basic-move-cost", Integer.toString(this.basicMoveCost));
        out.writeAttribute("basic-work-turns", Integer.toString(this.basicWorkTurns));
        out.writeAttribute("is-forest", Boolean.toString(this.forest));
        out.writeAttribute("is-water", Boolean.toString(this.water));
        out.writeAttribute("is-connected", Boolean.toString(this.connected));
        out.writeAttribute("can-settle", Boolean.toString(this.canSettle));
    }

    @Override
    protected void writeChildren(XMLStreamWriter out) throws XMLStreamException {
        super.writeChildren(out);
        out.writeStartElement("gen");
        out.writeAttribute("humidityMin", Integer.toString(this.humidity[0]));
        out.writeAttribute("humidityMax", Integer.toString(this.humidity[1]));
        out.writeAttribute("temperatureMin", Integer.toString(this.temperature[0]));
        out.writeAttribute("temperatureMax", Integer.toString(this.temperature[1]));
        out.writeAttribute("altitudeMin", Integer.toString(this.altitude[0]));
        out.writeAttribute("altitudeMax", Integer.toString(this.altitude[1]));
        out.writeEndElement();
        for (Map.Entry<String, AbstractGoods> entry : this.primaryGoodsMap.entrySet()) {
            out.writeStartElement("primary-production");
            out.writeAttribute("goods-type", entry.getValue().getType().getId());
            out.writeAttribute("value", Integer.toString(entry.getValue().getAmount()));
            if (entry.getKey() != null) {
                out.writeAttribute("tile-production", entry.getKey());
            }
            out.writeEndElement();
        }
        for (Map.Entry<String, AbstractGoods> entry : this.secondaryGoodsMap.entrySet()) {
            out.writeStartElement("secondary-production");
            out.writeAttribute("goods-type", entry.getValue().getType().getId());
            out.writeAttribute("value", Integer.toString(entry.getValue().getAmount()));
            if (entry.getKey() != null) {
                out.writeAttribute("tile-production", entry.getKey());
            }
            out.writeEndElement();
        }
        for (Map.Entry<String, Object> entry : this.productionMap.entrySet()) {
            for (AbstractGoods goods : ((Map)entry.getValue()).values()) {
                out.writeStartElement("production");
                out.writeAttribute("goods-type", goods.getType().getId());
                out.writeAttribute("value", Integer.toString(goods.getAmount()));
                if (entry.getKey() != null) {
                    out.writeAttribute("tile-production", entry.getKey());
                }
                out.writeEndElement();
            }
        }
        for (RandomChoice randomChoice : this.resourceType) {
            out.writeStartElement("resource");
            out.writeAttribute("type", ((ResourceType)randomChoice.getObject()).getId());
            out.writeAttribute("probability", Integer.toString(randomChoice.getProbability()));
            out.writeEndElement();
        }
    }

    public static String getXMLElementTagName() {
        return "tile-type";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RangeType {
        HUMIDITY,
        TEMPERATURE,
        ALTITUDE;

    }
}

