/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.common.model.Ability;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.AbstractUnit;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.EquipmentType;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.FeatureContainer;
import net.sf.freecol.common.model.FoundingFather;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.HistoryEvent;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.LastSale;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Market;
import net.sf.freecol.common.model.ModelMessage;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Monarch;
import net.sf.freecol.common.model.Nameable;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.NationOptions;
import net.sf.freecol.common.model.NationType;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Region;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.SettlementType;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tension;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TradeRoute;
import net.sf.freecol.common.model.TypeCountMap;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.WorkLocation;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Player
extends FreeColGameObject
implements Nameable {
    private static final Logger logger = Logger.getLogger(Player.class.getName());
    public static final int GOLD_NOT_ACCOUNTED = Integer.MIN_VALUE;
    public static final int SCORE_SETTLEMENT_DESTROYED = -40;
    public static final String ASSIGN_SETTLEMENT_NAME = "";
    private static final String FOUNDING_FATHER_TAG = "foundingFathers";
    private static final String OFFERED_FATHER_TAG = "offeredFathers";
    private static final String STANCE_TAG = "stance";
    private static final String TENSION_TAG = "tension";
    public static final String UNKNOWN_ENEMY = "unknown enemy";
    protected java.util.Map<Player, Tension> tension = new HashMap<Player, Tension>();
    protected java.util.Map<String, Stance> stance = new HashMap<String, Stance>();
    protected String name;
    protected String independentNationName;
    protected NationType nationType;
    protected String nationID;
    protected String newLandName = null;
    protected boolean admin;
    protected int score;
    protected int gold;
    protected int immigration;
    protected int liberty;
    protected Market market;
    protected Europe europe;
    protected Monarch monarch;
    protected boolean ready;
    protected boolean ai;
    protected boolean attackedByPrivateers = false;
    protected int oldSoL;
    protected boolean dead = false;
    protected final Set<FoundingFather> allFathers = new HashSet<FoundingFather>();
    protected FoundingFather currentFather;
    protected final List<FoundingFather> offeredFathers = new ArrayList<FoundingFather>();
    protected int tax = 0;
    protected PlayerType playerType;
    protected int immigrationRequired = 12;
    protected Location entryLocation;
    protected final java.util.Map<String, Unit> units = new HashMap<String, Unit>();
    protected final List<Settlement> settlements = new ArrayList<Settlement>();
    protected final List<TradeRoute> tradeRoutes = new ArrayList<TradeRoute>();
    protected final List<ModelMessage> modelMessages = new ArrayList<ModelMessage>();
    protected final List<HistoryEvent> history = new ArrayList<HistoryEvent>();
    protected HashMap<String, LastSale> lastSales = null;
    protected final HashMap<String, Integer> nameIndex = new HashMap();
    private boolean[][] canSeeTiles = null;
    private final Object canSeeLock = new Object();
    protected FeatureContainer featureContainer;
    private int maximumFoodConsumption = -1;
    private final UnitIterator nextActiveUnitIterator = new UnitIterator(this, new ActivePredicate(this));
    private final UnitIterator nextGoingToUnitIterator = new UnitIterator(this, new GoingToPredicate(this));
    protected List<String> settlementNames = null;
    protected String capitalName = null;
    protected String settlementFallback = null;
    public static final Comparator<Player> playerComparator = new Comparator<Player>(){

        @Override
        public int compare(Player player1, Player player2) {
            int counter1 = 0;
            int counter2 = 0;
            if (player1.isAdmin()) {
                counter1 += 8;
            }
            if (!player1.isAI()) {
                counter1 += 4;
            }
            if (player1.isEuropean()) {
                counter1 += 2;
            }
            if (player2.isAdmin()) {
                counter2 += 8;
            }
            if (!player2.isAI()) {
                counter2 += 4;
            }
            if (player2.isEuropean()) {
                counter2 += 2;
            }
            return counter2 - counter1;
        }
    };

    protected Player() {
    }

    protected Player(Game game) {
        super(game);
    }

    public Player(Game game, XMLStreamReader in) throws XMLStreamException {
        super(game, in);
        this.readFromXML(in);
    }

    public Player(Game game, Element e) {
        super(game, e);
        this.readFromXMLElement(e);
    }

    public Player(Game game, String id) {
        super(game, id);
    }

    public final FeatureContainer getFeatureContainer() {
        return this.featureContainer;
    }

    public final void setFeatureContainer(FeatureContainer newFeatureContainer) {
        this.featureContainer = newFeatureContainer;
    }

    public Set<Modifier> getModifierSet(String id) {
        return this.featureContainer.getModifierSet(id);
    }

    public Set<Modifier> getModifierSet(String id, FreeColGameObjectType type) {
        return this.featureContainer.getModifierSet(id, type);
    }

    @Override
    public boolean hasAbility(String ability) {
        return this.featureContainer.hasAbility(ability);
    }

    public void addModelMessage(ModelMessage modelMessage) {
        modelMessage.setOwnerId(this.getId());
        this.modelMessages.add(modelMessage);
    }

    public List<ModelMessage> getModelMessages() {
        return this.modelMessages;
    }

    public List<ModelMessage> getNewModelMessages() {
        ArrayList<ModelMessage> out = new ArrayList<ModelMessage>();
        for (ModelMessage message : this.modelMessages) {
            if (message.hasBeenDisplayed()) continue;
            out.add(message);
        }
        return out;
    }

    public void removeModelMessages() {
        Iterator<ModelMessage> messageIterator = this.modelMessages.iterator();
        while (messageIterator.hasNext()) {
            ModelMessage message = messageIterator.next();
            if (!message.hasBeenDisplayed()) continue;
            messageIterator.remove();
        }
    }

    public void clearModelMessages() {
        this.modelMessages.clear();
    }

    public void divertModelMessages(FreeColGameObject source, FreeColGameObject newSource) {
        ArrayList<ModelMessage> modelMessagesList = new ArrayList<ModelMessage>();
        modelMessagesList.addAll(this.modelMessages);
        for (ModelMessage modelMessage : modelMessagesList) {
            if (modelMessage.getSourceId() != source.getId()) continue;
            if (newSource == null) {
                this.modelMessages.remove(modelMessage);
                continue;
            }
            modelMessage.divert(newSource);
        }
    }

    public int getMaximumFoodConsumption() {
        if (this.maximumFoodConsumption < 0) {
            for (UnitType unitType : this.getSpecification().getUnitTypeList()) {
                if (!unitType.isAvailableTo(this)) continue;
                int foodConsumption = 0;
                for (GoodsType foodType : this.getSpecification().getFoodGoodsTypeList()) {
                    foodConsumption += unitType.getConsumptionOf(foodType);
                }
                if (foodConsumption <= this.maximumFoodConsumption) continue;
                this.maximumFoodConsumption = foodConsumption;
            }
        }
        return this.maximumFoodConsumption;
    }

    public int getScore() {
        return this.score;
    }

    public void setScore(int newScore) {
        this.score = newScore;
    }

    public void modifyScore(int value) {
        this.score += value;
    }

    public Market getMarket() {
        return this.market;
    }

    public void reinitialiseMarket() {
        this.market = new Market(this.getGame(), this);
    }

    public StringTemplate getMarketName() {
        return this.getEurope() == null ? StringTemplate.key("model.market.independent") : StringTemplate.key(this.nationID + ".europe");
    }

    public boolean hasSettlement(Settlement s) {
        return this.settlements.contains(s);
    }

    public void addSettlement(Settlement settlement) {
        if (!this.hasSettlement(settlement)) {
            if (settlement.getOwner() != this) {
                throw new IllegalStateException("Player does not own settlement.");
            }
            this.settlements.add(settlement);
        }
    }

    public void removeSettlement(Settlement settlement) {
        if (this.hasSettlement(settlement)) {
            if (settlement.getOwner() == this) {
                throw new IllegalStateException("Player still owns settlement.");
            }
            this.settlements.remove(settlement);
        }
    }

    public List<Settlement> getSettlements() {
        return this.settlements;
    }

    public int getNumberOfSettlements() {
        return this.settlements.size();
    }

    public List<Colony> getColonies() {
        ArrayList<Colony> colonies = new ArrayList<Colony>();
        for (Settlement s : this.settlements) {
            if (s instanceof Colony) {
                colonies.add((Colony)s);
                continue;
            }
            throw new RuntimeException("getColonies can only be called for players whose settlements are colonies.");
        }
        return colonies;
    }

    public int getColoniesPopulation() {
        int i = 0;
        for (Colony c : this.getColonies()) {
            i += c.getUnitCount();
        }
        return i;
    }

    public Colony getColony(String name) {
        for (Colony colony : this.getColonies()) {
            if (!colony.getName().equals(name)) continue;
            return colony;
        }
        return null;
    }

    public List<IndianSettlement> getIndianSettlements() {
        ArrayList<IndianSettlement> indianSettlements = new ArrayList<IndianSettlement>();
        for (Settlement s : this.settlements) {
            if (s instanceof IndianSettlement) {
                indianSettlements.add((IndianSettlement)s);
                continue;
            }
            throw new RuntimeException("getIndianSettlements found: " + s);
        }
        return indianSettlements;
    }

    public IndianSettlement getIndianSettlement(String name) {
        for (IndianSettlement settlement : this.getIndianSettlements()) {
            if (!settlement.getName().equals(name)) continue;
            return settlement;
        }
        return null;
    }

    public List<IndianSettlement> getIndianSettlementsWithMission(Player other) {
        ArrayList<IndianSettlement> indianSettlements = new ArrayList<IndianSettlement>();
        for (Settlement s : this.settlements) {
            Unit missionary;
            if (!(s instanceof IndianSettlement) || (missionary = ((IndianSettlement)s).getMissionary()) == null || other != null && missionary.getOwner() != other) continue;
            indianSettlements.add((IndianSettlement)s);
        }
        return indianSettlements;
    }

    public Settlement getSettlement(String name) {
        return this.isIndian() ? this.getIndianSettlement(name) : this.getColony(name);
    }

    public void installSettlementNames(List<String> names, Random random) {
        if (this.settlementNames == null) {
            this.settlementNames = new ArrayList<String>();
            this.settlementNames.addAll(names);
            this.settlementFallback = this.settlementNames.remove(0);
            if (this.isIndian()) {
                this.capitalName = this.settlementNames.remove(0);
                if (random != null) {
                    Collections.shuffle(this.settlementNames, random);
                }
            }
        }
        logger.info("Installed " + names.size() + " settlement names for player " + this.toString());
    }

    public String getCapitalName() {
        return this.capitalName == null ? ASSIGN_SETTLEMENT_NAME : this.capitalName;
    }

    public String getSettlementName() {
        String name;
        Game game = this.getGame();
        if (this.settlementNames == null) {
            return ASSIGN_SETTLEMENT_NAME;
        }
        while (!this.settlementNames.isEmpty()) {
            String name2 = this.settlementNames.remove(0);
            if (game.getSettlement(name2) != null) continue;
            return name2;
        }
        String base = this.settlementFallback + "-";
        int i = this.settlements.size() + 1;
        while (game.getSettlement(name = base + Integer.toString(i)) != null) {
            ++i;
        }
        return name;
    }

    public PlayerType getPlayerType() {
        return this.playerType;
    }

    public void setPlayerType(PlayerType type) {
        this.playerType = type;
    }

    public boolean isEuropean() {
        return this.nationType != null && this.nationType.isEuropean();
    }

    public boolean isIndian() {
        return this.playerType == PlayerType.NATIVE;
    }

    public boolean isUndead() {
        return this.playerType == PlayerType.UNDEAD;
    }

    public boolean isREF() {
        return this.nationType != null && this.nationType.isREF();
    }

    public boolean isAI() {
        return this.ai;
    }

    public void setAI(boolean ai) {
        this.ai = ai;
    }

    public boolean isAdmin() {
        return this.admin;
    }

    public boolean isDead() {
        return this.dead;
    }

    public boolean getDead() {
        return this.dead;
    }

    public void setDead(boolean dead) {
        this.dead = dead;
    }

    public boolean isAtWar() {
        for (Player player : this.getGame().getPlayers()) {
            if (!this.atWarWith(player)) continue;
            return true;
        }
        return false;
    }

    public boolean isWorkForREF() {
        for (Unit u : this.getUnits()) {
            if (u.getTile() == null) continue;
            return true;
        }
        return !this.getRebels().isEmpty();
    }

    public List<Player> getRebels() {
        ArrayList<Player> rebels = new ArrayList<Player>();
        for (Player p : this.getGame().getLiveEuropeanPlayers()) {
            if (p.getREFPlayer() != this || p.getPlayerType() != PlayerType.REBEL) continue;
            rebels.add(p);
        }
        return rebels;
    }

    public boolean canOwnTile(Tile tile) {
        return this.isEuropean() ? !tile.hasLostCityRumour() : tile.isLand();
    }

    public boolean canClaimForSettlement(Tile tile) {
        return this.canOwnTile(tile) && tile.getSettlement() == null && (tile.getOwner() == null || tile.getOwner() == this && (tile.getOwningSettlement() == null || tile.getOwningSettlement() instanceof Colony && !((Colony)tile.getOwningSettlement()).isTileInUse(tile)) || tile.getOwner() != null && tile.getOwner() != this && this.getLandPrice(tile) == 0);
    }

    private boolean canAcquireTile(Tile tile) {
        return this.canOwnTile(tile) && tile.getSettlement() == null && tile.getOwner() != null && tile.getOwner() != this && this.getLandPrice(tile) > 0;
    }

    public boolean canAcquireForSettlement(Tile tile) {
        return this.canClaimForSettlement(tile) || this.canAcquireTile(tile);
    }

    public boolean canClaimToFoundSettlement(Tile tile) {
        return tile.getType().canSettle() && (this.canClaimForSettlement(tile) || this.canClaimFreeCenterTile(tile));
    }

    private boolean canClaimFreeCenterTile(Tile tile) {
        String build = this.getGame().getSpecification().getStringOption("model.option.buildOnNativeLand").getValue();
        return this.isEuropean() && this.canOwnTile(tile) && tile.getSettlement() == null && tile.getOwner() != null && tile.getOwner() != this && ("model.option.buildOnNativeLand.always".equals(build) || "model.option.buildOnNativeLand.first".equals(build) && this.hasZeroSettlements() || "model.option.buildOnNativeLand.firstAndUncontacted".equals(build) && this.hasZeroSettlements() && (tile.getOwner() == null || tile.getOwner().getStance(this) == Stance.UNCONTACTED));
    }

    private boolean hasZeroSettlements() {
        List<Settlement> settlements = this.getSettlements();
        return settlements.isEmpty() || settlements.size() == 1 && settlements.get(0).getTile().getSettlement() == null;
    }

    public boolean canAcquireToFoundSettlement(Tile tile) {
        return this.canClaimToFoundSettlement(tile) || tile.getType().canSettle() && this.canAcquireTile(tile);
    }

    public boolean canClaimForImprovement(Tile tile) {
        Player owner = tile.getOwner();
        return owner == null || owner == this || this.getLandPrice(tile) == 0;
    }

    public boolean canAcquireForImprovement(Tile tile) {
        return this.canClaimForImprovement(tile) || this.canAcquireTile(tile);
    }

    public final Unit getUnit(String id) {
        return this.units.get(id);
    }

    public final void setUnit(Unit newUnit) {
        if (newUnit == null) {
            logger.warning("Unit to add is null");
            return;
        }
        if (newUnit.getOwner() != null && newUnit.getOwner() != this) {
            throw new IllegalStateException(this + " adding another players unit=" + newUnit);
        }
        this.units.put(newUnit.getId(), newUnit);
    }

    public void removeUnit(Unit oldUnit) {
        if (oldUnit != null) {
            this.units.remove(oldUnit.getId());
        }
    }

    public int getPrice(AbstractUnit au) {
        Specification spec = this.getSpecification();
        UnitType unitType = au.getUnitType(spec);
        if (unitType.hasPrice()) {
            int price = this.getEurope().getUnitPrice(unitType);
            for (EquipmentType equip : au.getEquipment(spec)) {
                for (AbstractGoods goods : equip.getGoodsRequired()) {
                    price += this.getMarket().getBidPrice(goods.getType(), goods.getAmount());
                }
            }
            return price * au.getNumber();
        }
        return Integer.MAX_VALUE;
    }

    public int getSoL() {
        int sum = 0;
        int number = 0;
        for (Colony c : this.getColonies()) {
            sum += c.getSoL();
            ++number;
        }
        if (number > 0) {
            return sum / number;
        }
        return 0;
    }

    public final String getIndependentNationName() {
        return this.independentNationName;
    }

    public final void setIndependentNationName(String newIndependentNationName) {
        this.independentNationName = newIndependentNationName;
    }

    public Player getREFPlayer() {
        Nation ref = this.getNation().getRefNation();
        return ref == null ? null : this.getGame().getPlayer(ref.getId());
    }

    public String getNewLandName() {
        return this.newLandName;
    }

    public boolean isNewLandNamed() {
        return this.newLandName != null;
    }

    public void setNewLandName(String newLandName) {
        this.newLandName = newLandName;
    }

    public int getLandPrice(Tile tile) {
        Player nationOwner = tile.getOwner();
        int price = 0;
        if (nationOwner == null || nationOwner == this) {
            return 0;
        }
        if (tile.getSettlement() != null) {
            return -1;
        }
        if (nationOwner.isEuropean()) {
            if (tile.getOwningSettlement() != null && tile.getOwningSettlement().getOwner() == nationOwner) {
                return -1;
            }
            return 0;
        }
        for (GoodsType type : this.getSpecification().getGoodsTypeList()) {
            if (type == this.getSpecification().getPrimaryFoodType()) continue;
            price += tile.potential(type, null);
        }
        price *= this.getSpecification().getIntegerOption("model.option.landPriceFactor").getValue().intValue();
        return (int)this.featureContainer.applyModifier(price += 100, "model.modifier.landPaymentModifier", null, this.getGame().getTurn());
    }

    public boolean getAttackedByPrivateers() {
        return this.attackedByPrivateers;
    }

    public void setAttackedByPrivateers(boolean attacked) {
        this.attackedByPrivateers = attacked;
    }

    public Location getEntryLocation() {
        return this.entryLocation;
    }

    public void setEntryLocation(Location entryLocation) {
        this.entryLocation = entryLocation;
    }

    public boolean hasExplored(Tile tile) {
        return tile.isExplored();
    }

    public void setExplored(Tile tile) {
        logger.warning("Implemented by ServerPlayer");
    }

    public void setExplored(Unit unit) {
        if (this.getGame() == null || this.getGame().getMap() == null || unit == null || unit.getLocation() == null || unit.getTile() == null || this.isIndian()) {
            return;
        }
        this.invalidateCanSeeTiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateCanSeeTiles() {
        Object object = this.canSeeLock;
        synchronized (object) {
            this.canSeeTiles = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canSee(Tile tile) {
        if (tile == null) {
            return false;
        }
        do {
            Object object = this.canSeeLock;
            synchronized (object) {
                if (this.canSeeTiles != null) {
                    return this.canSeeTiles[tile.getX()][tile.getY()];
                }
            }
        } while (this.resetCanSeeTiles());
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean resetCanSeeTiles() {
        Map map = this.getGame().getMap();
        if (map == null) {
            return false;
        }
        boolean[][] cST = this.makeCanSeeTiles(map);
        Object object = this.canSeeLock;
        synchronized (object) {
            this.canSeeTiles = cST;
        }
        return true;
    }

    private boolean[][] makeCanSeeTiles(Map map) {
        boolean[][] cST = new boolean[map.getWidth()][map.getHeight()];
        if (!this.getSpecification().getBoolean("model.option.fogOfWar")) {
            for (Tile t : this.getGame().getMap().getAllTiles()) {
                if (t == null) continue;
                cST[t.getX()][t.getY()] = this.hasExplored(t);
            }
        } else {
            Tile tile;
            for (Unit unit : this.getUnits()) {
                if (!(unit.getLocation() instanceof Tile)) continue;
                tile = (Tile)unit.getLocation();
                cST[tile.getX()][tile.getY()] = true;
                for (Tile t : tile.getSurroundingTiles(unit.getLineOfSight())) {
                    if (t == null) continue;
                    cST[t.getX()][t.getY()] = this.hasExplored(t);
                }
            }
            for (Settlement settlement : new ArrayList<Settlement>(this.getSettlements())) {
                tile = settlement.getTile();
                cST[tile.getX()][tile.getY()] = true;
                for (Tile t : tile.getSurroundingTiles(settlement.getLineOfSight())) {
                    if (t == null) continue;
                    cST[t.getX()][t.getY()] = this.hasExplored(t);
                }
            }
        }
        return cST;
    }

    public boolean canBuildColonies() {
        return this.nationType.hasAbility("model.ability.foundColony");
    }

    public boolean canHaveFoundingFathers() {
        return this.nationType.hasAbility("model.ability.electFoundingFather");
    }

    public boolean hasFather(FoundingFather someFather) {
        return this.allFathers.contains(someFather);
    }

    public int getFatherCount() {
        return this.allFathers.size();
    }

    public Set<FoundingFather> getFathers() {
        return this.allFathers;
    }

    public void addFather(FoundingFather father) {
        this.allFathers.add(father);
        this.featureContainer.add(father.getFeatureContainer());
    }

    public FoundingFather getCurrentFather() {
        return this.currentFather;
    }

    public void setCurrentFather(FoundingFather someFather) {
        this.currentFather = someFather;
    }

    public List<FoundingFather> getOfferedFathers() {
        return this.offeredFathers;
    }

    public void clearOfferedFathers() {
        this.offeredFathers.clear();
    }

    public void setOfferedFathers(List<FoundingFather> fathers) {
        this.clearOfferedFathers();
        this.offeredFathers.addAll(fathers);
    }

    public int getRemainingFoundingFatherCost() {
        return this.getTotalFoundingFatherCost() - this.getLiberty();
    }

    public int getTotalFoundingFatherCost() {
        int base = this.getSpecification().getIntegerOption("model.option.foundingFatherFactor").getValue();
        int count = this.getFatherCount();
        int previous = 1;
        for (int index = 0; index < count; ++index) {
            previous += 2 * (index + 2);
        }
        return previous * base + count;
    }

    public boolean canMoveToEurope() {
        return this.getEurope() != null;
    }

    public Europe getEurope() {
        return this.europe;
    }

    public void setEurope(Europe europe) {
        this.europe = europe;
    }

    public String getEuropeNameKey() {
        if (this.europe == null) {
            return null;
        }
        return this.nationID + ".europe";
    }

    public Monarch getMonarch() {
        return this.monarch;
    }

    public void setMonarch(Monarch monarch) {
        this.monarch = monarch;
    }

    public int getGold() {
        return this.gold;
    }

    public void setGold(int newGold) {
        this.gold = newGold;
    }

    public boolean checkGold(int amount) {
        return this.gold == Integer.MIN_VALUE || this.gold >= amount;
    }

    public int modifyGold(int amount) {
        if (this.gold != Integer.MIN_VALUE) {
            if (this.gold + amount >= 0) {
                this.modifyScore((this.gold + amount) / 1000 - this.gold / 1000);
                this.gold += amount;
            } else {
                logger.warning("Cannot add " + amount + " gold for " + this + ": would be negative!");
                this.gold = 0;
            }
        }
        return this.gold;
    }

    public Iterator<Unit> getUnitIterator() {
        return this.units.values().iterator();
    }

    public List<Unit> getUnits() {
        return new ArrayList<Unit>(this.units.values());
    }

    public int getNumberOfKingLandUnits() {
        int n = 0;
        for (Unit unit : this.getUnits()) {
            if (!unit.hasAbility("model.ability.refUnit") || unit.isNaval()) continue;
            ++n;
        }
        return n;
    }

    public boolean hasManOfWar() {
        Iterator<Unit> it = this.getUnitIterator();
        while (it.hasNext()) {
            Unit unit = it.next();
            if (!"model.unit.manOWar".equals(unit.getType().getId())) continue;
            return true;
        }
        return false;
    }

    public Unit getNextActiveUnit() {
        return this.nextActiveUnitIterator.next();
    }

    public boolean setNextActiveUnit(Unit unit) {
        return this.nextActiveUnitIterator.setNext(unit);
    }

    public Unit getNextGoingToUnit() {
        return this.nextGoingToUnitIterator.next();
    }

    public boolean hasNextActiveUnit() {
        return this.nextActiveUnitIterator.hasNext();
    }

    public boolean hasNextGoingToUnit() {
        return this.nextGoingToUnitIterator.hasNext();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getNameKey() {
        return this.getName();
    }

    public String getDisplayName() {
        return this.getName().startsWith("model.nation.") ? Messages.message(this.getName()) : this.getName();
    }

    public boolean isUnknownEnemy() {
        return UNKNOWN_ENEMY.equals(this.name);
    }

    @Override
    public String toString() {
        return this.getName() + " (" + this.nationID + ")";
    }

    @Override
    public void setName(String newName) {
        this.name = newName;
    }

    public NationType getNationType() {
        return this.nationType;
    }

    public void setNationType(NationType newNationType) {
        if (this.nationType != null) {
            this.featureContainer.remove(this.nationType.getFeatureContainer());
        }
        this.nationType = newNationType;
        this.featureContainer.add(newNationType.getFeatureContainer());
    }

    public Nation getNation() {
        return this.getSpecification().getNation(this.nationID);
    }

    public void setNation(Nation newNation) {
        Nation oldNation = this.getNation();
        this.nationID = newNation.getId();
        this.getGame().getNationOptions().getNations().put(newNation, NationOptions.NationState.NOT_AVAILABLE);
        this.getGame().getNationOptions().getNations().put(oldNation, NationOptions.NationState.AVAILABLE);
    }

    public String getNationID() {
        return this.nationID;
    }

    public String getNationNameKey() {
        return this.nationID.substring(this.nationID.lastIndexOf(46) + 1).toUpperCase(Locale.US);
    }

    public StringTemplate getNationName() {
        return this.playerType == PlayerType.REBEL || this.playerType == PlayerType.INDEPENDENT ? StringTemplate.name(this.independentNationName) : StringTemplate.key(this.nationID + ".name");
    }

    public final String getRulerNameKey() {
        return this.nationID + ".ruler";
    }

    public boolean isReady() {
        return this.ready;
    }

    public void setReady(boolean ready) {
        this.ready = ready;
    }

    public void incrementImmigration(int amount) {
        this.immigration = Math.max(0, this.immigration + amount);
    }

    public void reduceImmigration() {
        int cost;
        if (!this.canRecruitUnits()) {
            return;
        }
        int n = cost = this.getSpecification().getBoolean("model.option.saveProductionOverflow") ? this.immigrationRequired : this.immigration;
        this.immigration = cost > this.immigration ? 0 : (this.immigration -= cost);
    }

    public int getImmigration() {
        return this.canRecruitUnits() ? this.immigration : 0;
    }

    public void setImmigration(int immigration) {
        if (this.canRecruitUnits()) {
            this.immigration = immigration;
        }
    }

    public final List<TradeRoute> getTradeRoutes() {
        return this.tradeRoutes;
    }

    public final void setTradeRoutes(List<TradeRoute> newTradeRoutes) {
        this.tradeRoutes.clear();
        this.tradeRoutes.addAll(newTradeRoutes);
    }

    public boolean checkEmigrate() {
        if (!this.canRecruitUnits()) {
            return false;
        }
        return this.getImmigrationRequired() <= this.immigration;
    }

    public int getImmigrationRequired() {
        return this.canRecruitUnits() ? this.immigrationRequired : 0;
    }

    public void setImmigrationRequired(int immigrationRequired) {
        if (this.canRecruitUnits()) {
            this.immigrationRequired = immigrationRequired;
        }
    }

    public void updateImmigrationRequired() {
        if (!this.canRecruitUnits()) {
            return;
        }
        this.immigrationRequired += (int)this.featureContainer.applyModifier(this.getSpecification().getIntegerOption("model.option.crossesIncrement").getValue().intValue(), "model.modifier.religiousUnrestBonus");
    }

    public boolean canRecruitUnits() {
        return this.playerType == PlayerType.COLONIAL;
    }

    public List<FreeColGameObject> modifyTension(Player player, int addToTension) {
        return this.modifyTension(player, addToTension, null);
    }

    public List<FreeColGameObject> modifyTension(Player player, int addToTension, Settlement origin) {
        if (player == null) {
            throw new IllegalStateException("Null player");
        }
        if (player == this) {
            throw new IllegalStateException("Self tension!");
        }
        if (origin != null && origin.getOwner() != this) {
            throw new IllegalStateException("Bogus origin:" + origin.getId());
        }
        ArrayList<FreeColGameObject> objects = new ArrayList<FreeColGameObject>();
        Tension.Level oldLevel = this.getTension(player).getLevel();
        this.getTension(player).modify(addToTension);
        if (oldLevel != this.getTension(player).getLevel()) {
            objects.add(this);
        }
        for (Settlement settlement : this.settlements) {
            if (settlement.equals(origin) || !settlement.propagateAlarm(player, addToTension)) continue;
            objects.add(settlement);
        }
        return objects;
    }

    public void setTension(Player player, Tension newTension) {
        if (player == this || player == null) {
            return;
        }
        this.tension.put(player, newTension);
    }

    public Tension getTension(Player player) {
        if (player == null) {
            throw new IllegalStateException("Null player.");
        }
        Tension newTension = this.tension.get(player);
        if (newTension == null) {
            newTension = new Tension(0);
        }
        this.tension.put(player, newTension);
        return newTension;
    }

    public void removeTension(Player player) {
        if (player != null) {
            this.tension.remove(player);
        }
    }

    public final List<HistoryEvent> getHistory() {
        return this.history;
    }

    public int getOutpostValue(Tile t) {
        Market market = this.getMarket();
        if (this.canClaimToFoundSettlement(t)) {
            boolean nearbyTileIsOcean = false;
            float advantages = 1.0f;
            int value = 0;
            for (Tile tile : t.getSurroundingTiles(1)) {
                if (tile.getColony() != null) {
                    return 0;
                }
                if (tile.getSettlement() != null) {
                    SettlementType type = tile.getSettlement().getType();
                    if (type.getClaimableRadius() > 1) {
                        advantages *= 0.25f;
                        continue;
                    }
                    advantages *= 0.5f;
                    continue;
                }
                if (tile.isConnected()) {
                    nearbyTileIsOcean = true;
                }
                if (tile.getType() == null) continue;
                for (AbstractGoods production : tile.getType().getProduction()) {
                    GoodsType type = production.getType();
                    int potential = market.getSalePrice(type, tile.potential(type, null));
                    if (tile.getOwner() != null && tile.getOwner() != this.getGame().getCurrentPlayer()) {
                        if (tile.getOwner().isEuropean()) continue;
                        potential /= 2;
                    }
                    value = Math.max(value, potential);
                }
            }
            if (t.getType().getSecondaryGoods() != null) {
                GoodsType secondary = t.getType().getSecondaryGoods().getType();
                value += market.getSalePrice(secondary, t.potential(secondary, null));
            }
            if (nearbyTileIsOcean) {
                return Math.max(0, (int)((float)value * advantages));
            }
        }
        return 0;
    }

    public int getColonyValue(Tile t) {
        PathNode n;
        float MOD_HAS_RESOURCE = 0.75f;
        float MOD_NO_PATH = 0.5f;
        float MOD_LONG_PATH = 0.75f;
        float MOD_FOOD_LOW = 0.75f;
        float MOD_FOOD_VERY_LOW = 0.5f;
        float MOD_BUILD_MATERIAL_MISSING = 0.25f;
        float MOD_ADJ_SETTLEMENT_BIG = 0.25f;
        float MOD_ADJ_SETTLEMENT = 0.5f;
        float MOD_OWNED_EUROPEAN = 0.8f;
        float MOD_OWNED_NATIVE = 0.9f;
        float MOD_HIGH_PRODUCTION = 1.2f;
        float MOD_GOOD_PRODUCTION = 1.1f;
        float[] MOD_OWN_COLONY = new float[]{0.0f, 0.0f, 0.5f, 1.25f, 1.1f};
        float[] MOD_ENEMY_COLONY = new float[]{0.0f, 0.0f, 0.6f, 0.7f, 0.8f};
        float[] MOD_NEUTRAL_COLONY = new float[]{0.0f, 0.0f, 0.9f, 0.95f, 1.0f};
        float[] MOD_ENEMY_UNIT = new float[]{0.0f, 0.5f, 0.6f, 0.7f, 0.8f};
        int LONG_PATH_TURNS = 3;
        int PRIMARY_GOODS_VALUE = 30;
        int GOOD_PRODUCTION = 4;
        int HIGH_PRODUCTION = 8;
        int FOOD_LOW = 4;
        int FOOD_VERY_LOW = 2;
        for (Tile tile : t.getSurroundingTiles(0, 1)) {
            if (tile.getSettlement() == null) continue;
            return 0;
        }
        int value = 0;
        if (t.getType().getPrimaryGoods() != null) {
            value += t.potential(t.getType().getPrimaryGoods().getType(), null) * 30;
        }
        float advantage = 1.0f;
        TypeCountMap<GoodsType> buildingMaterialMap = new TypeCountMap<GoodsType>();
        TypeCountMap<GoodsType> foodMap = new TypeCountMap<GoodsType>();
        for (GoodsType type : this.getSpecification().getGoodsTypeList()) {
            if (type.isFoodType()) {
                foodMap.incrementCount(type, 0);
                continue;
            }
            if (!type.isRawBuildingMaterial()) continue;
            buildingMaterialMap.incrementCount(type, 0);
        }
        if (t.hasResource()) {
            advantage *= 0.75f;
        }
        if ((n = this.getGame().getMap().findPathToEurope(t)) == null) {
            advantage *= 0.5f;
        } else if (n.getTotalTurns() > 3) {
            advantage *= 0.75f;
        }
        boolean supportingColony = false;
        for (int radius = 1; radius < 5; ++radius) {
            Map.CircleIterator it = this.getGame().getMap().getCircleIterator(t.getPosition(), false, radius);
            while (it.hasNext()) {
                Tile tile = this.getGame().getMap().getTile((Map.Position)it.next());
                Settlement set = tile.getSettlement();
                Colony col = tile.getColony();
                if (radius == 1) {
                    if (set != null) {
                        SettlementType type = set.getType();
                        advantage = type.getClaimableRadius() > 1 ? (advantage *= 0.25f) : (advantage *= 0.5f);
                    } else {
                        if (tile.getOwner() != null && tile.getOwner() != this) {
                            advantage = tile.getOwner().isEuropean() ? (advantage *= 0.8f) : (advantage *= 0.9f);
                        }
                        if (tile.getType() != null) {
                            for (AbstractGoods production : tile.getType().getProduction()) {
                                GoodsType type = production.getType();
                                int potential = tile.potential(type, null);
                                value += potential * type.getInitialSellPrice();
                                int highProductionValue = 0;
                                if (potential > 8) {
                                    advantage *= 1.2f;
                                    highProductionValue = 2;
                                } else if (potential > 4) {
                                    advantage *= 1.1f;
                                    highProductionValue = 1;
                                }
                                if (type.isFoodType()) {
                                    foodMap.incrementCount(type, highProductionValue);
                                    continue;
                                }
                                if (!type.isRawBuildingMaterial()) continue;
                                buildingMaterialMap.incrementCount(type, highProductionValue);
                            }
                        }
                    }
                } else {
                    if (value <= 0) {
                        return 0;
                    }
                    if (col != null) {
                        if (col.getOwner() == this) {
                            if (!supportingColony) {
                                supportingColony = true;
                                advantage *= MOD_OWN_COLONY[radius];
                            }
                        } else {
                            advantage = this.atWarWith(col.getOwner()) ? (advantage *= MOD_ENEMY_COLONY[radius]) : (advantage *= MOD_NEUTRAL_COLONY[radius]);
                        }
                    }
                }
                Iterator<Unit> ui = tile.getUnitIterator();
                while (ui.hasNext()) {
                    Unit u = ui.next();
                    if (u.getOwner() == this || !u.isOffensiveUnit() || !u.getOwner().isEuropean() || !this.atWarWith(u.getOwner())) continue;
                    advantage *= MOD_ENEMY_UNIT[radius];
                }
            }
        }
        for (GoodsType type : buildingMaterialMap.keySet()) {
            Integer amount = buildingMaterialMap.getCount(type);
            if (amount != 0) continue;
            advantage *= 0.25f;
        }
        int foodProduction = 0;
        for (Integer food : foodMap.values()) {
            foodProduction += food.intValue();
        }
        if (foodProduction < 2) {
            advantage *= 0.5f;
        } else if (foodProduction < 4) {
            advantage *= 0.75f;
        }
        return (int)((float)value * advantage);
    }

    public Stance getStance(Player player) {
        return player == null || this.stance.get(player.getId()) == null ? Stance.UNCONTACTED : this.stance.get(player.getId());
    }

    public void setStance(Player player, Stance newStance) {
        if (player == null) {
            throw new IllegalArgumentException("Player must not be 'null'.");
        }
        if (player == this) {
            throw new IllegalArgumentException("Cannot set the stance towards ourselves.");
        }
        if (newStance == null) {
            this.stance.remove(player.getId());
            return;
        }
        Stance oldStance = this.stance.get(player.getId());
        if (newStance.equals((Object)oldStance)) {
            return;
        }
        if (newStance == Stance.CEASE_FIRE && oldStance != Stance.WAR) {
            throw new IllegalStateException("Cease fire can only be declared when at war.");
        }
        if (newStance == Stance.UNCONTACTED) {
            throw new IllegalStateException("Attempt to set UNCONTACTED stance");
        }
        this.stance.put(player.getId(), newStance);
    }

    public boolean atWarWith(Player player) {
        return this.getStance(player) == Stance.WAR;
    }

    public boolean hasContacted(Player player) {
        return this.getStance(player) != Stance.UNCONTACTED;
    }

    public boolean hasContactedEuropeans() {
        for (Player other : this.getGame().getLiveEuropeanPlayers()) {
            if (other == this || !this.hasContacted(other)) continue;
            return true;
        }
        return false;
    }

    public boolean hasContactedIndians() {
        for (Player other : this.getGame().getPlayers()) {
            if (other == this || other.isDead() || !other.isIndian() || !this.hasContacted(other)) continue;
            return true;
        }
        return false;
    }

    public static void makeContact(Player player1, Player player2) {
        player1.stance.put(player2.getId(), Stance.PEACE);
        player2.stance.put(player1.getId(), Stance.PEACE);
        player1.setTension(player2, new Tension(0));
        player2.setTension(player1, new Tension(0));
    }

    public boolean hasVisited(IndianSettlement settlement) {
        GoodsType[] wanted = settlement.getWantedGoods();
        if (wanted == null) {
            return false;
        }
        for (GoodsType g : wanted) {
            if (g != null) continue;
            return false;
        }
        return true;
    }

    public int getRecruitPrice() {
        return this.getEurope().getRecruitPrice();
    }

    public int getLiberty() {
        return this.canHaveFoundingFathers() ? this.liberty : 0;
    }

    public void setLiberty(int liberty) {
        this.liberty = liberty;
    }

    public void incrementLiberty(int amount) {
        this.setLiberty(Math.max(0, this.getLiberty() + amount));
    }

    public int getLibertyProductionNextTurn() {
        int libertyNextTurn = 0;
        for (Colony colony : this.getColonies()) {
            for (GoodsType libertyGoods : this.getSpecification().getLibertyGoodsTypeList()) {
                libertyNextTurn += colony.getProductionOf(libertyGoods);
            }
        }
        return libertyNextTurn;
    }

    public void resetIterators() {
        this.nextActiveUnitIterator.reset();
        this.nextGoingToUnitIterator.reset();
    }

    public int getArrears(GoodsType type) {
        return this.getMarket().getArrears(type);
    }

    public int getArrears(Goods goods) {
        return this.getArrears(goods.getType());
    }

    public boolean canTrade(GoodsType type) {
        return this.canTrade(type, Market.Access.EUROPE);
    }

    public boolean canTrade(GoodsType type, Market.Access access) {
        if (this.getMarket().getArrears(type) == 0) {
            return true;
        }
        if (access == Market.Access.CUSTOM_HOUSE) {
            if (this.getSpecification().getBoolean("model.option.customIgnoreBoycott")) {
                return true;
            }
            if (this.hasAbility("model.ability.customHouseTradesWithForeignCountries")) {
                for (Player otherPlayer : this.getGame().getLiveEuropeanPlayers()) {
                    if (otherPlayer == this || this.getStance(otherPlayer) != Stance.PEACE && this.getStance(otherPlayer) != Stance.ALLIANCE) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean canTrade(Goods goods, Market.Access access) {
        return this.canTrade(goods.getType(), access);
    }

    public boolean canTrade(Goods goods) {
        return this.canTrade(goods, Market.Access.EUROPE);
    }

    public int getTax() {
        return this.tax;
    }

    public void setTax(int amount) {
        this.tax = amount;
    }

    public boolean recalculateBellsBonus() {
        Set<Modifier> libertyBonus = this.featureContainer.getModifierSet("model.goods.bells");
        boolean ret = false;
        for (Ability ability : this.featureContainer.getAbilitySet("model.ability.addTaxToBells")) {
            FreeColGameObjectType source = ability.getSource();
            if (source == null) continue;
            for (Modifier modifier : libertyBonus) {
                if (!source.equals(modifier.getSource())) continue;
                modifier.setValue(this.tax);
                ret = true;
            }
        }
        return ret;
    }

    public int getSales(GoodsType goodsType) {
        return this.getMarket().getSales(goodsType);
    }

    public void modifySales(GoodsType goodsType, int amount) {
        this.getMarket().modifySales(goodsType, amount);
    }

    public boolean hasTraded(GoodsType goodsType) {
        return this.getMarket().hasBeenTraded(goodsType);
    }

    public Goods getMostValuableGoods() {
        Goods goods = null;
        if (!this.isEuropean()) {
            return goods;
        }
        int value = 0;
        for (Colony colony : this.getColonies()) {
            List<Goods> colonyGoods = colony.getCompactGoods();
            for (Goods currentGoods : colonyGoods) {
                int goodsValue;
                if (this.getArrears(currentGoods) != 0 || !this.hasTraded(currentGoods.getType())) continue;
                if (currentGoods.getAmount() > 100) {
                    currentGoods.setAmount(100);
                }
                if ((goodsValue = this.market.getSalePrice(currentGoods)) <= value) continue;
                value = goodsValue;
                goods = currentGoods;
            }
        }
        return goods;
    }

    public int getIncomeBeforeTaxes(GoodsType goodsType) {
        return this.getMarket().getIncomeBeforeTaxes(goodsType);
    }

    public void modifyIncomeBeforeTaxes(GoodsType goodsType, int amount) {
        this.getMarket().modifyIncomeBeforeTaxes(goodsType, amount);
    }

    public int getIncomeAfterTaxes(GoodsType goodsType) {
        return this.getMarket().getIncomeAfterTaxes(goodsType);
    }

    public void modifyIncomeAfterTaxes(GoodsType goodsType, int amount) {
        this.getMarket().modifyIncomeAfterTaxes(goodsType, amount);
    }

    public void addHistory(HistoryEvent event) {
        this.history.add(event);
    }

    public boolean equals(Player o) {
        if (o == null) {
            return false;
        }
        if (this.getId() == null || o.getId() == null) {
            return false;
        }
        return this.getId().equals(o.getId());
    }

    public int getNameIndex(String key) {
        Integer val = this.nameIndex.get(key);
        return val == null ? 0 : val;
    }

    public void setNameIndex(String key, int value) {
        this.nameIndex.put(key, new Integer(value));
    }

    public void saveSale(LastSale sale) {
        if (this.lastSales == null) {
            this.lastSales = new HashMap();
        }
        this.lastSales.put(sale.getId(), sale);
    }

    public LastSale getLastSale(Location where, GoodsType what) {
        return this.lastSales == null ? null : this.lastSales.get(LastSale.makeKey(where, what));
    }

    public String getLastSaleString(Location where, GoodsType what) {
        LastSale data = this.getLastSale(where, what);
        return data == null ? null : String.valueOf(data.getPrice());
    }

    @Override
    protected void toXMLImpl(XMLStreamWriter out, Player player, boolean showAll, boolean toSavedGame) throws XMLStreamException {
        out.writeStartElement(Player.getXMLElementTagName());
        out.writeAttribute("ID", this.getId());
        out.writeAttribute("username", this.name);
        out.writeAttribute("nationID", this.nationID);
        if (this.nationType != null) {
            out.writeAttribute("nationType", this.nationType.getId());
        }
        out.writeAttribute("admin", Boolean.toString(this.admin));
        out.writeAttribute("ready", Boolean.toString(this.ready));
        out.writeAttribute("dead", Boolean.toString(this.dead));
        out.writeAttribute("playerType", this.playerType.toString());
        out.writeAttribute("ai", Boolean.toString(this.ai));
        out.writeAttribute("tax", Integer.toString(this.tax));
        out.writeAttribute("numberOfSettlements", Integer.toString(this.getNumberOfSettlements()));
        if (this.getGame().isClientTrusted() || showAll || this.equals(player)) {
            out.writeAttribute("gold", Integer.toString(this.gold));
            out.writeAttribute("immigration", Integer.toString(this.immigration));
            out.writeAttribute("liberty", Integer.toString(this.liberty));
            if (this.currentFather != null) {
                out.writeAttribute("currentFather", this.currentFather.getId());
            }
            out.writeAttribute("immigrationRequired", Integer.toString(this.immigrationRequired));
            out.writeAttribute("attackedByPrivateers", Boolean.toString(this.attackedByPrivateers));
            out.writeAttribute("oldSoL", Integer.toString(this.oldSoL));
            out.writeAttribute("score", Integer.toString(this.score));
        } else {
            out.writeAttribute("gold", Integer.toString(-1));
            out.writeAttribute("immigration", Integer.toString(-1));
            out.writeAttribute("liberty", Integer.toString(-1));
            out.writeAttribute("immigrationRequired", Integer.toString(-1));
        }
        if (this.newLandName != null) {
            out.writeAttribute("newLandName", this.newLandName);
        }
        if (this.independentNationName != null) {
            out.writeAttribute("independentNationName", this.independentNationName);
        }
        if (this.entryLocation != null) {
            out.writeAttribute("entryLocation", this.entryLocation.getId());
        }
        for (Region.RegionType regionType : Region.RegionType.values()) {
            String key = regionType.getNameIndexKey();
            int index = this.getNameIndex(key);
            if (index <= 0) continue;
            out.writeAttribute(key, Integer.toString(index));
        }
        for (Map.Entry<Player, Tension> entry : this.tension.entrySet()) {
            out.writeStartElement(TENSION_TAG);
            out.writeAttribute("player", entry.getKey().getId());
            out.writeAttribute("value", String.valueOf(entry.getValue().getValue()));
            out.writeEndElement();
        }
        for (Map.Entry<Object, Object> entry : this.stance.entrySet()) {
            out.writeStartElement(STANCE_TAG);
            out.writeAttribute("player", (String)entry.getKey());
            out.writeAttribute("value", ((Stance)((Object)entry.getValue())).toString());
            out.writeEndElement();
        }
        for (HistoryEvent historyEvent : this.history) {
            historyEvent.toXML(out, this);
        }
        for (TradeRoute tradeRoute : this.tradeRoutes) {
            tradeRoute.toXML(out, this);
        }
        if (this.market != null) {
            this.market.toXML(out, player, showAll, toSavedGame);
        }
        if (this.getGame().isClientTrusted() || showAll || this.equals(player)) {
            out.writeStartElement(FOUNDING_FATHER_TAG);
            out.writeAttribute("xLength", Integer.toString(this.allFathers.size()));
            int index = 0;
            for (FoundingFather father : this.allFathers) {
                out.writeAttribute("x" + Integer.toString(index), father.getId());
                ++index;
            }
            out.writeEndElement();
            out.writeStartElement(OFFERED_FATHER_TAG);
            out.writeAttribute("xLength", Integer.toString(this.offeredFathers.size()));
            index = 0;
            for (FoundingFather father : this.offeredFathers) {
                out.writeAttribute("x" + Integer.toString(index), father.getId());
                ++index;
            }
            out.writeEndElement();
            if (this.europe != null) {
                this.europe.toXML(out, player, showAll, toSavedGame);
            }
            if (this.monarch != null) {
                this.monarch.toXML(out, player, showAll, toSavedGame);
            }
            if (!this.modelMessages.isEmpty()) {
                for (ModelMessage m : this.modelMessages) {
                    m.toXML(out);
                }
            }
            if (this.lastSales != null) {
                for (LastSale sale : this.lastSales.values()) {
                    sale.toXMLImpl(out);
                }
            }
        }
        out.writeEndElement();
    }

    @Override
    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        this.setId(in.getAttributeValue(null, "ID"));
        this.name = in.getAttributeValue(null, "username");
        this.nationID = in.getAttributeValue(null, "nationID");
        if (!this.isUnknownEnemy()) {
            this.nationType = this.getSpecification().getNationType(in.getAttributeValue(null, "nationType"));
        }
        this.admin = Player.getAttribute(in, "admin", false);
        this.gold = Integer.parseInt(in.getAttributeValue(null, "gold"));
        this.immigration = this.getAttribute(in, "immigration", 0);
        this.liberty = this.getAttribute(in, "liberty", 0);
        this.oldSoL = this.getAttribute(in, "oldSoL", 0);
        this.score = this.getAttribute(in, "score", 0);
        this.ready = Player.getAttribute(in, "ready", false);
        this.ai = Player.getAttribute(in, "ai", false);
        this.dead = Player.getAttribute(in, "dead", false);
        this.tax = Integer.parseInt(in.getAttributeValue(null, "tax"));
        this.playerType = Enum.valueOf(PlayerType.class, in.getAttributeValue(null, "playerType"));
        this.currentFather = this.getSpecification().getType(in, "currentFather", FoundingFather.class, null);
        this.immigrationRequired = this.getAttribute(in, "immigrationRequired", 12);
        this.newLandName = this.getAttribute(in, "newLandName", null);
        this.independentNationName = this.getAttribute(in, "independentNationName", null);
        this.attackedByPrivateers = Player.getAttribute(in, "attackedByPrivateers", false);
        String entryLocationStr = in.getAttributeValue(null, "entryLocation");
        if (entryLocationStr != null) {
            this.entryLocation = (Location)((Object)this.getGame().getFreeColGameObject(entryLocationStr));
            if (this.entryLocation == null) {
                this.entryLocation = new Tile(this.getGame(), entryLocationStr);
            }
        }
        for (Region.RegionType regionType : Region.RegionType.values()) {
            String key = regionType.getNameIndexKey();
            int index = this.getAttribute(in, key, -1);
            if (index <= 0) continue;
            this.setNameIndex(key, index);
        }
        this.featureContainer = new FeatureContainer(this.getSpecification());
        if (this.nationType != null) {
            this.featureContainer.add(this.nationType.getFeatureContainer());
        }
        switch (this.playerType) {
            case REBEL: 
            case INDEPENDENT: {
                this.featureContainer.addAbility(new Ability("model.ability.independenceDeclared"));
                break;
            }
        }
        this.tension.clear();
        this.stance.clear();
        this.allFathers.clear();
        this.offeredFathers.clear();
        this.europe = null;
        this.monarch = null;
        this.history.clear();
        this.tradeRoutes.clear();
        this.modelMessages.clear();
        this.lastSales = null;
        while (in.nextTag() != 2) {
            FoundingFather father;
            int index;
            if (in.getLocalName().equals(TENSION_TAG)) {
                Player player = (Player)this.getGame().getFreeColGameObject(in.getAttributeValue(null, "player"));
                this.tension.put(player, new Tension(this.getAttribute(in, "value", 0)));
                in.nextTag();
                continue;
            }
            if (in.getLocalName().equals(FOUNDING_FATHER_TAG)) {
                int length = Integer.parseInt(in.getAttributeValue(null, "xLength"));
                for (index = 0; index < length; ++index) {
                    String fatherId = in.getAttributeValue(null, "x" + String.valueOf(index));
                    father = this.getSpecification().getFoundingFather(fatherId);
                    this.addFather(father);
                }
                in.nextTag();
                continue;
            }
            if (in.getLocalName().equals(OFFERED_FATHER_TAG)) {
                int length = Integer.parseInt(in.getAttributeValue(null, "xLength"));
                for (index = 0; index < length; ++index) {
                    String fatherId = in.getAttributeValue(null, "x" + String.valueOf(index));
                    father = this.getSpecification().getFoundingFather(fatherId);
                    this.offeredFathers.add(father);
                }
                in.nextTag();
                continue;
            }
            if (in.getLocalName().equals(STANCE_TAG)) {
                String playerId = in.getAttributeValue(null, "player");
                this.stance.put(playerId, Enum.valueOf(Stance.class, in.getAttributeValue(null, "value")));
                in.nextTag();
                continue;
            }
            if (in.getLocalName().equals(Europe.getXMLElementTagName())) {
                this.europe = this.updateFreeColGameObject(in, Europe.class);
                continue;
            }
            if (in.getLocalName().equals(Monarch.getXMLElementTagName())) {
                this.monarch = this.updateFreeColGameObject(in, Monarch.class);
                continue;
            }
            if (in.getLocalName().equals(HistoryEvent.getXMLElementTagName())) {
                HistoryEvent event = new HistoryEvent();
                event.readFromXMLImpl(in);
                this.getHistory().add(event);
                continue;
            }
            if (in.getLocalName().equals(TradeRoute.getXMLElementTagName())) {
                TradeRoute route = this.updateFreeColGameObject(in, TradeRoute.class);
                this.tradeRoutes.add(route);
                continue;
            }
            if (in.getLocalName().equals(Market.getXMLElementTagName())) {
                this.market = this.updateFreeColGameObject(in, Market.class);
                continue;
            }
            if (in.getLocalName().equals(ModelMessage.getXMLElementTagName())) {
                ModelMessage message = new ModelMessage();
                message.readFromXMLImpl(in);
                this.addModelMessage(message);
                continue;
            }
            if (in.getLocalName().equals(LastSale.getXMLElementTagName())) {
                LastSale lastSale = new LastSale();
                lastSale.readFromXMLImpl(in);
                this.saveSale(lastSale);
                continue;
            }
            logger.warning("Unknown tag: " + in.getLocalName() + " loading player");
            in.nextTag();
        }
        if (!in.getLocalName().equals(Player.getXMLElementTagName())) {
            logger.warning("Error parsing xml: expecting closing tag </" + Player.getXMLElementTagName() + "> " + "found instead: " + in.getLocalName());
        }
        if (this.market == null) {
            this.market = new Market(this.getGame(), this);
        }
        this.recalculateBellsBonus();
        this.invalidateCanSeeTiles();
    }

    @Override
    protected void toXMLPartialImpl(XMLStreamWriter out, String[] fields) throws XMLStreamException {
        this.toXMLPartialByClass(out, this.getClass(), fields);
    }

    @Override
    protected void readFromXMLPartialImpl(XMLStreamReader in) throws XMLStreamException {
        this.readFromXMLPartialByClass(in, this.getClass());
    }

    public static String getXMLElementTagName() {
        return "player";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class UnitIterator
    implements Iterator<Unit> {
        private Player owner;
        private UnitPredicate predicate;
        private List<Unit> units = null;
        private final Comparator<Unit> xyComparator = new Comparator<Unit>(){

            @Override
            public int compare(Unit unit1, Unit unit2) {
                Tile tile1 = unit1.getTile();
                Tile tile2 = unit2.getTile();
                int cmp = (tile1 == null ? 0 : tile1.getY()) - (tile2 == null ? 0 : tile2.getY());
                return cmp != 0 || tile1 == null || tile2 == null ? cmp : tile1.getX() - tile2.getX();
            }
        };

        public UnitIterator(Player owner, UnitPredicate predicate) {
            this.owner = owner;
            this.predicate = predicate;
            this.reset();
        }

        public void reset() {
            this.units = new ArrayList<Unit>();
            for (Unit u : this.owner.getUnits()) {
                if (!this.predicate.obtains(u)) continue;
                this.units.add(u);
            }
            Collections.sort(this.units, this.xyComparator);
        }

        @Override
        public boolean hasNext() {
            while (!this.units.isEmpty()) {
                if (this.predicate.obtains(this.units.get(0))) {
                    return true;
                }
                this.units.remove(0);
            }
            this.reset();
            return !this.units.isEmpty();
        }

        @Override
        public Unit next() {
            return this.hasNext() ? this.units.remove(0) : null;
        }

        public boolean setNext(Unit unit) {
            if (this.predicate.obtains(unit)) {
                Unit first;
                Unit unit2 = first = this.units.isEmpty() ? null : this.units.get(0);
                while (!this.units.isEmpty()) {
                    if (this.units.get(0) == unit) {
                        return true;
                    }
                    this.units.remove(0);
                }
                this.reset();
                while (!this.units.isEmpty() && this.units.get(0) != first) {
                    if (this.units.get(0) == unit) {
                        return true;
                    }
                    this.units.remove(0);
                }
            }
            return false;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public class GoingToPredicate
    extends UnitPredicate {
        private final Player player;

        public GoingToPredicate(Player player2) {
            this.player = player2;
        }

        public boolean obtains(Unit unit) {
            return !unit.isDisposed() && unit.getOwner() == this.player && unit.getMovesLeft() > 0 && (unit.getDestination() != null || unit.getTradeRoute() != null) && !(unit.getLocation() instanceof WorkLocation) && unit.getTile() != null;
        }
    }

    public class ActivePredicate
    extends UnitPredicate {
        private final Player player;

        public ActivePredicate(Player player2) {
            this.player = player2;
        }

        public boolean obtains(Unit unit) {
            return !unit.isDisposed() && unit.getOwner() == this.player && unit.getMovesLeft() > 0 && unit.getState() == Unit.UnitState.ACTIVE && unit.getDestination() == null && unit.getTradeRoute() == null && !(unit.getLocation() instanceof WorkLocation) && unit.getTile() != null;
        }
    }

    public abstract class UnitPredicate {
        public abstract boolean obtains(Unit var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PlayerType {
        NATIVE,
        COLONIAL,
        REBEL,
        INDEPENDENT,
        ROYAL,
        UNDEAD;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Stance {
        UNCONTACTED,
        ALLIANCE,
        PEACE,
        CEASE_FIRE,
        WAR;


        private void badStance() throws IllegalStateException {
            throw new IllegalStateException("Bogus stance");
        }

        private void badTransition(Stance newStance) throws IllegalStateException {
            throw new IllegalStateException("Bad transition: " + this.toString() + " -> " + newStance.toString());
        }

        public Stance getStanceFromTension(Tension tension) {
            int value = tension.getValue();
            switch (this) {
                case WAR: {
                    if (value > Tension.Level.CONTENT.getLimit() - 10) break;
                    return CEASE_FIRE;
                }
                case CEASE_FIRE: {
                    if (value <= Tension.Level.HAPPY.getLimit() - 10) {
                        return PEACE;
                    }
                }
                case ALLIANCE: 
                case PEACE: {
                    if (value <= Tension.Level.HATEFUL.getLimit() + 10) break;
                    return WAR;
                }
                case UNCONTACTED: {
                    break;
                }
                default: {
                    this.badStance();
                }
            }
            return this;
        }

        public int getTensionModifier(Stance newStance) throws IllegalStateException {
            switch (newStance) {
                case UNCONTACTED: {
                    this.badTransition(newStance);
                }
                case ALLIANCE: {
                    switch (this) {
                        case UNCONTACTED: {
                            this.badTransition(newStance);
                        }
                        case ALLIANCE: {
                            return 0;
                        }
                        case PEACE: {
                            return -500;
                        }
                        case CEASE_FIRE: {
                            return -750;
                        }
                        case WAR: {
                            return -1000;
                        }
                    }
                    this.badStance();
                }
                case PEACE: {
                    switch (this) {
                        case UNCONTACTED: {
                            return 0;
                        }
                        case ALLIANCE: {
                            return 200;
                        }
                        case PEACE: {
                            return 0;
                        }
                        case CEASE_FIRE: {
                            return -250;
                        }
                        case WAR: {
                            return -500;
                        }
                    }
                    this.badStance();
                }
                case CEASE_FIRE: {
                    switch (this) {
                        case UNCONTACTED: {
                            this.badTransition(newStance);
                        }
                        case ALLIANCE: {
                            this.badTransition(newStance);
                        }
                        case PEACE: {
                            this.badTransition(newStance);
                        }
                        case CEASE_FIRE: {
                            return 0;
                        }
                        case WAR: {
                            return -250;
                        }
                    }
                    this.badStance();
                }
                case WAR: {
                    switch (this) {
                        case UNCONTACTED: {
                            return Tension.WAR_MODIFIER;
                        }
                        case ALLIANCE: {
                            return Tension.WAR_MODIFIER;
                        }
                        case PEACE: {
                            return Tension.WAR_MODIFIER;
                        }
                        case CEASE_FIRE: {
                            return 750;
                        }
                        case WAR: {
                            return 0;
                        }
                    }
                    this.badStance();
                }
            }
            throw new IllegalStateException("Bogus newStance");
        }
    }
}

