/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Tile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathNode
implements Comparable<PathNode> {
    private Tile tile;
    private int cost;
    private int f;
    private Map.Direction direction;
    private int movesLeft;
    private int turns;
    private boolean onCarrier = false;
    public PathNode next = null;
    public PathNode previous = null;

    public PathNode(Tile tile, int cost, int f, Map.Direction direction, int movesLeft, int turns) {
        this.tile = tile;
        this.cost = cost;
        this.f = f;
        this.direction = direction;
        this.movesLeft = movesLeft;
        this.turns = turns;
    }

    public int getCost() {
        return this.cost;
    }

    public Tile getTile() {
        return this.tile;
    }

    public boolean isOnCarrier() {
        return this.onCarrier;
    }

    public void setOnCarrier(boolean onCarrier) {
        this.onCarrier = onCarrier;
    }

    public int getTransportDropTurns() {
        PathNode temp = this;
        while (temp.next != null && temp.isOnCarrier()) {
            temp = temp.next;
        }
        return temp.getTurns();
    }

    public PathNode getTransportDropNode() {
        PathNode temp = this;
        while (temp.next != null && temp.isOnCarrier()) {
            temp = temp.next;
        }
        return temp;
    }

    public PathNode getLastNode() {
        PathNode temp = this;
        while (temp.next != null) {
            temp = temp.next;
        }
        return temp;
    }

    public int getF() {
        return this.f;
    }

    public Map.Direction getDirection() {
        return this.direction;
    }

    public int getTurns() {
        return this.turns;
    }

    public int getTotalTurns() {
        PathNode temp = this;
        while (temp.next != null) {
            temp = temp.next;
        }
        return temp.getTurns();
    }

    public int getMovesLeft() {
        return this.movesLeft;
    }

    public void setMovesLeft(int movesLeft) {
        this.movesLeft = movesLeft;
    }

    @Override
    public int compareTo(PathNode o) {
        return o.getF() - this.f;
    }

    public boolean equals(Object o) {
        if (!(o instanceof PathNode)) {
            return false;
        }
        return this.tile.getId().equals(((PathNode)o).getTile().getId());
    }

    public int hashCode() {
        return this.tile.getX() * 10000 + this.tile.getY();
    }

    public String toString() {
        return "PathNode tile=\"" + this.tile.getId() + "(" + Integer.toString(this.tile.getX()) + "," + Integer.toString(this.tile.getY()) + ")\"" + " cost=\"" + Integer.toString(this.cost) + "\"" + " f=\"" + Integer.toString(this.f) + "\"" + " direction=\"" + String.valueOf((Object)this.direction) + "\"" + " movesLeft=\"" + Integer.toString(this.movesLeft) + "\"" + " turns=\"" + Integer.toString(this.turns) + "\"" + " onCarrier=\"" + Boolean.toString(this.onCarrier) + "\"";
    }
}

