/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.NationType;
import net.sf.freecol.common.model.Region;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.util.RandomChoice;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndianNationType
extends NationType {
    private SettlementNumber numberOfSettlements = SettlementNumber.AVERAGE;
    private AggressionLevel aggression = AggressionLevel.AVERAGE;
    private List<RandomChoice<UnitType>> skills = new ArrayList<RandomChoice<UnitType>>();
    private List<String> regions = new ArrayList<String>();

    public IndianNationType(String id, Specification specification) {
        super(id, specification);
    }

    @Override
    public boolean isEuropean() {
        return false;
    }

    @Override
    public boolean isIndian() {
        return true;
    }

    @Override
    public boolean isREF() {
        return false;
    }

    public final SettlementNumber getNumberOfSettlements() {
        return this.numberOfSettlements;
    }

    public final void setNumberOfSettlements(SettlementNumber newNumberOfSettlements) {
        this.numberOfSettlements = newNumberOfSettlements;
    }

    public final AggressionLevel getAggression() {
        return this.aggression;
    }

    public final void setAggression(AggressionLevel newAggression) {
        this.aggression = newAggression;
    }

    public final String getSettlementTypeKey(boolean plural) {
        return this.getSettlementType(false).getId() + (plural ? ".plural" : "");
    }

    public List<String> getRegionNames() {
        return this.regions;
    }

    public List<RandomChoice<UnitType>> generateSkillsForTile(Tile tile) {
        List<RandomChoice<UnitType>> skills = this.getSkills();
        HashMap<GoodsType, Integer> scale = new HashMap<GoodsType, Integer>();
        for (RandomChoice<UnitType> skill : skills) {
            scale.put(skill.getObject().getExpertProduction(), 1);
        }
        for (Tile t : tile.getSurroundingTiles(1)) {
            for (GoodsType goodsType : scale.keySet()) {
                scale.put(goodsType, (Integer)scale.get(goodsType) + t.potential(goodsType, null));
            }
        }
        ArrayList<RandomChoice<UnitType>> scaledSkills = new ArrayList<RandomChoice<UnitType>>();
        for (RandomChoice<UnitType> skill : skills) {
            UnitType unitType = skill.getObject();
            int scaleValue = (Integer)scale.get(unitType.getExpertProduction());
            scaledSkills.add(new RandomChoice<UnitType>(unitType, skill.getProbability() * scaleValue));
        }
        return scaledSkills;
    }

    public List<RandomChoice<UnitType>> getSkills() {
        return this.skills;
    }

    @Override
    public void readAttributes(XMLStreamReader in) throws XMLStreamException {
        super.readAttributes(in);
        String extendString = in.getAttributeValue(null, "extends");
        IndianNationType parent = extendString == null ? this : this.getSpecification().getType(extendString, IndianNationType.class);
        String valueString = in.getAttributeValue(null, "number-of-settlements");
        this.numberOfSettlements = valueString == null ? parent.numberOfSettlements : Enum.valueOf(SettlementNumber.class, valueString.toUpperCase(Locale.US));
        valueString = in.getAttributeValue(null, "aggression");
        this.aggression = valueString == null ? parent.aggression : Enum.valueOf(AggressionLevel.class, valueString.toUpperCase(Locale.US));
        if (parent != this) {
            this.skills.addAll(parent.skills);
            this.getSettlementTypes().addAll(parent.getSettlementTypes());
            this.getFeatureContainer().add(parent.getFeatureContainer());
            if (parent.isAbstractType()) {
                this.getFeatureContainer().replaceSource(parent, this);
            }
        }
    }

    @Override
    public void readChildren(XMLStreamReader in) throws XMLStreamException {
        super.readChildren(in);
        Collections.sort(this.skills, new Comparator<RandomChoice<UnitType>>(){

            @Override
            public int compare(RandomChoice<UnitType> choice1, RandomChoice<UnitType> choice2) {
                return choice2.getProbability() - choice1.getProbability();
            }
        });
    }

    @Override
    public void readChild(XMLStreamReader in) throws XMLStreamException {
        String childName = in.getLocalName();
        if ("skill".equals(childName)) {
            UnitType unitType = this.getSpecification().getUnitType(in.getAttributeValue(null, "id"));
            int probability = this.getAttribute(in, "probability", 0);
            this.skills.add(new RandomChoice<UnitType>(unitType, probability));
            in.nextTag();
        } else if (Region.getXMLElementTagName().equals(childName)) {
            this.regions.add(in.getAttributeValue(null, "id"));
            in.nextTag();
        } else {
            super.readChild(in);
        }
    }

    @Override
    public void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        super.toXML(out, IndianNationType.getXMLElementTagName());
    }

    @Override
    public void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        super.writeAttributes(out);
        out.writeAttribute("number-of-settlements", this.numberOfSettlements.toString().toLowerCase(Locale.US));
        out.writeAttribute("aggression", this.aggression.toString().toLowerCase(Locale.US));
    }

    @Override
    protected void writeChildren(XMLStreamWriter out) throws XMLStreamException {
        super.writeChildren(out);
        for (RandomChoice<UnitType> choice : this.skills) {
            out.writeStartElement("skill");
            out.writeAttribute("id", choice.getObject().getId());
            out.writeAttribute("probability", Integer.toString(choice.getProbability()));
            out.writeEndElement();
        }
        for (String region : this.regions) {
            out.writeStartElement(Region.getXMLElementTagName());
            out.writeAttribute("id", region);
            out.writeEndElement();
        }
    }

    public static String getXMLElementTagName() {
        return "indian-nation-type";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AggressionLevel {
        LOW,
        AVERAGE,
        HIGH;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SettlementNumber {
        LOW,
        AVERAGE,
        HIGH;

    }
}

