/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.TradeItem;
import net.sf.freecol.common.model.Unit;

public class GoodsTradeItem
extends TradeItem {
    private Goods goods;
    private Settlement settlement;

    public GoodsTradeItem(Game game, Player source, Player destination, Goods goods, Settlement settlement) {
        super(game, "tradeItem.goods", source, destination);
        this.goods = goods;
        this.settlement = settlement;
    }

    public GoodsTradeItem(Game game, XMLStreamReader in) throws XMLStreamException {
        super(game, in);
        this.readFromXMLImpl(in);
    }

    public final Settlement getSettlement() {
        return this.settlement;
    }

    public final void setSettlement(Settlement newSettlement) {
        this.settlement = newSettlement;
    }

    public boolean isValid() {
        if (!(this.goods.getLocation() instanceof Unit)) {
            return false;
        }
        Unit unit = (Unit)this.goods.getLocation();
        if (unit.getOwner() != this.getSource()) {
            return false;
        }
        return this.settlement != null && this.settlement.getOwner() == this.getDestination();
    }

    public boolean isUnique() {
        return false;
    }

    public Goods getGoods() {
        return this.goods;
    }

    public void setGoods(Goods goods) {
        this.goods = goods;
    }

    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        super.readFromXMLImpl(in);
        this.settlement = (Settlement)this.game.getFreeColGameObject(in.getAttributeValue(null, "settlement"));
        while (in.nextTag() != 2) {
            if (!in.getLocalName().equals(Goods.getXMLElementTagName())) continue;
            this.goods = new Goods(this.game, in);
        }
    }

    public void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement(GoodsTradeItem.getXMLElementTagName());
        super.toXMLImpl(out);
        out.writeAttribute("settlement", this.settlement.getId());
        this.goods.toXML(out);
        out.writeEndElement();
    }

    public static String getXMLElementTagName() {
        return "goodsTradeItem";
    }
}

