/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.EquipmentType;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsContainer;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Locatable;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Named;
import net.sf.freecol.common.model.Ownable;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Europe
extends FreeColGameObject
implements Location,
Ownable,
Named {
    private static final Logger logger = Logger.getLogger(Europe.class.getName());
    private static final int RECRUIT_PRICE_INITIAL = 200;
    private static final int LOWER_CAP_INITIAL = 80;
    public static final String UNITS_TAG_NAME = "units";
    public static final String UNIT_CHANGE = "unitChange";
    private UnitType[] recruitables = new UnitType[]{null, null, null};
    public static final int RECRUIT_COUNT = 3;
    protected Map<UnitType, Integer> unitPrices = new HashMap<UnitType, Integer>();
    private int recruitPrice;
    private int recruitLowerCap;
    private List<Unit> units = Collections.emptyList();
    private Player owner;

    protected Europe() {
    }

    protected Europe(Game game, Player owner) {
        super(game);
        this.owner = owner;
        this.recruitPrice = 200;
        this.recruitLowerCap = 80;
    }

    public Europe(Game game, XMLStreamReader in) throws XMLStreamException {
        super(game, in);
        this.readFromXML(in);
    }

    public Europe(Game game, Element e) {
        super(game, e);
        this.readFromXMLElement(e);
    }

    public Europe(Game game, String id) {
        super(game, id);
    }

    public boolean canBuildEquipment(EquipmentType equipmentType) {
        for (AbstractGoods requiredGoods : equipmentType.getGoodsRequired()) {
            GoodsType goodsType = requiredGoods.getType();
            if (this.getOwner().canTrade(goodsType) && this.getOwner().checkGold(this.getOwner().getMarket().getBidPrice(goodsType, requiredGoods.getAmount()))) continue;
            return false;
        }
        return true;
    }

    public boolean recruitablesDiffer() {
        return !this.recruitables[0].equals(this.recruitables[1]) || !this.recruitables[0].equals(this.recruitables[2]);
    }

    public UnitType getRecruitable(int slot) {
        if (slot >= 0 && slot < 3) {
            return this.recruitables[slot];
        }
        throw new IllegalArgumentException("Wrong recruitement slot: " + slot);
    }

    public void setRecruitable(int slot, UnitType type) {
        if (slot >= 0 && slot < 3) {
            this.recruitables[slot] = type;
        } else {
            logger.warning("setRecruitable: invalid slot(" + slot + ") given.");
        }
    }

    @Override
    public Tile getTile() {
        return null;
    }

    @Override
    public Settlement getSettlement() {
        return null;
    }

    @Override
    public Colony getColony() {
        return null;
    }

    @Override
    public void add(Locatable locatable) {
        if (!(locatable instanceof Unit)) {
            throw new IllegalArgumentException("Only units can be added to Europe.");
        }
        if (!this.units.contains(locatable)) {
            if (((Object)this.units).equals(Collections.emptyList())) {
                this.units = new ArrayList<Unit>();
            }
            Unit newUnit = (Unit)locatable;
            this.units.add(newUnit);
            if (!newUnit.isBetweenEuropeAndNewWorld()) {
                newUnit.setState(Unit.UnitState.SENTRY);
            }
        }
    }

    @Override
    public void remove(Locatable locatable) {
        if (locatable instanceof Unit) {
            this.units.remove(locatable);
        } else {
            logger.warning("Tried to remove an unrecognized 'Locatable' from a europe.");
        }
    }

    @Override
    public boolean contains(Locatable locatable) {
        if (locatable instanceof Unit) {
            return this.units.contains(locatable);
        }
        return false;
    }

    @Override
    public GoodsContainer getGoodsContainer() {
        return null;
    }

    @Override
    public boolean canAdd(Locatable locatable) {
        return true;
    }

    @Override
    public int getUnitCount() {
        return this.units.size();
    }

    @Override
    public List<Unit> getUnitList() {
        return this.units;
    }

    @Override
    public List<FreeColGameObject> disposeList() {
        ArrayList<FreeColGameObject> objects = new ArrayList<FreeColGameObject>();
        while (this.units.size() > 0) {
            objects.addAll(this.units.remove(0).disposeList());
        }
        this.units = null;
        objects.addAll(super.disposeList());
        return objects;
    }

    @Override
    public void dispose() {
        this.disposeList();
    }

    @Override
    public Iterator<Unit> getUnitIterator() {
        return this.units.iterator();
    }

    public Unit getFirstUnit() {
        if (this.units.isEmpty()) {
            return null;
        }
        return this.units.get(0);
    }

    public Unit getLastUnit() {
        if (this.units.isEmpty()) {
            return null;
        }
        return this.units.get(this.units.size() - 1);
    }

    public int getUnitPrice(UnitType unitType) {
        Integer price = this.unitPrices.get(unitType);
        if (price != null) {
            return price;
        }
        return unitType.getPrice();
    }

    public int getRecruitPrice() {
        int required = this.owner.getImmigrationRequired();
        int immigration = this.owner.getImmigration();
        int difference = Math.max(required - immigration, 0);
        return Math.max(this.recruitPrice * difference / required, this.recruitLowerCap);
    }

    public void increaseRecruitmentDifficulty() {
        Specification spec = this.getSpecification();
        this.recruitPrice += spec.getIntegerOption("model.option.recruitPriceIncrease").getValue().intValue();
        this.recruitLowerCap += spec.getIntegerOption("model.option.lowerCapIncrease").getValue().intValue();
    }

    @Override
    public Player getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(Player p) {
        throw new UnsupportedOperationException();
    }

    @Override
    public StringTemplate getLocationName() {
        return StringTemplate.key(this.getNameKey());
    }

    @Override
    public StringTemplate getLocationNameFor(Player player) {
        return this.getLocationName();
    }

    @Override
    public String getNameKey() {
        return this.getOwner().getEuropeNameKey();
    }

    @Override
    public String toString() {
        return "Europe";
    }

    private void unitsToXML(XMLStreamWriter out, Player player, boolean showAll, boolean toSavedGame) throws XMLStreamException {
        if (!this.units.isEmpty()) {
            out.writeStartElement(UNITS_TAG_NAME);
            for (Unit unit : this.units) {
                unit.toXML(out, player, showAll, toSavedGame);
            }
            out.writeEndElement();
        }
    }

    @Override
    protected void toXMLImpl(XMLStreamWriter out, Player player, boolean showAll, boolean toSavedGame) throws XMLStreamException {
        out.writeStartElement(Europe.getXMLElementTagName());
        out.writeAttribute("ID", this.getId());
        for (int index = 0; index < this.recruitables.length; ++index) {
            if (this.recruitables[index] == null) continue;
            out.writeAttribute("recruit" + index, this.recruitables[index].getId());
        }
        out.writeAttribute("recruitPrice", Integer.toString(this.recruitPrice));
        out.writeAttribute("recruitLowerCap", Integer.toString(this.recruitLowerCap));
        out.writeAttribute("owner", this.owner.getId());
        for (Map.Entry<UnitType, Integer> entry : this.unitPrices.entrySet()) {
            out.writeStartElement("unitPrice");
            out.writeAttribute("unitType", entry.getKey().getId());
            out.writeAttribute("price", entry.getValue().toString());
            out.writeEndElement();
        }
        this.unitsToXML(out, player, showAll, toSavedGame);
        out.writeEndElement();
    }

    @Override
    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        this.setId(in.getAttributeValue(null, "ID"));
        Specification spec = this.getSpecification();
        for (int index = 0; index < this.recruitables.length; ++index) {
            String unitTypeId = in.getAttributeValue(null, "recruit" + index);
            if (unitTypeId == null) continue;
            this.recruitables[index] = spec.getUnitType(unitTypeId);
        }
        this.owner = this.getFreeColGameObject(in, "owner", Player.class);
        this.recruitPrice = this.getAttribute(in, "recruitPrice", 200);
        this.recruitLowerCap = this.getAttribute(in, "recruitLowerCap", 80);
        this.units.clear();
        this.unitPrices.clear();
        while (in.nextTag() != 2) {
            if (in.getLocalName().equals(UNITS_TAG_NAME)) {
                this.units = new ArrayList<Unit>();
                while (in.nextTag() != 2) {
                    if (!in.getLocalName().equals(Unit.getXMLElementTagName())) continue;
                    this.units.add(this.updateFreeColGameObject(in, Unit.class));
                }
                continue;
            }
            if (!in.getLocalName().equals("unitPrice")) continue;
            String unitTypeId = in.getAttributeValue(null, "unitType");
            Integer price = new Integer(in.getAttributeValue(null, "price"));
            this.unitPrices.put(spec.getUnitType(unitTypeId), price);
            in.nextTag();
        }
    }

    @Override
    protected void toXMLPartialImpl(XMLStreamWriter out, String[] fields) throws XMLStreamException {
        this.toXMLPartialByClass(out, this.getClass(), fields);
    }

    @Override
    protected void readFromXMLPartialImpl(XMLStreamReader in) throws XMLStreamException {
        this.readFromXMLPartialByClass(in, this.getClass());
    }

    public static String getXMLElementTagName() {
        return "europe";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MigrationType {
        NORMAL,
        RECRUIT,
        FOUNTAIN;

    }
}

