/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.BuildingType;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Consumer;
import net.sf.freecol.common.model.FeatureContainer;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsContainer;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Locatable;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Named;
import net.sf.freecol.common.model.Ownable;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.ProductionInfo;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.WorkLocation;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Building
extends FreeColGameObject
implements WorkLocation,
Ownable,
Named,
Comparable<Building>,
Consumer {
    private static final Logger logger = Logger.getLogger(Building.class.getName());
    public static final String UNIT_CHANGE = "UNIT_CHANGE";
    protected Colony colony;
    protected BuildingType buildingType;
    private final List<Unit> units = new ArrayList<Unit>();

    protected Building() {
    }

    protected Building(Game game) {
        super(game);
    }

    public Building(Game game, XMLStreamReader in) throws XMLStreamException {
        super(game, in);
        this.readFromXML(in);
    }

    public Building(Game game, Element e) {
        super(game, e);
        this.readFromXMLElement(e);
    }

    public Building(Game game, String id) {
        super(game, id);
    }

    @Override
    public Player getOwner() {
        return this.colony.getOwner();
    }

    @Override
    public void setOwner(Player p) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Tile getTile() {
        return this.colony.getTile();
    }

    @Override
    public String getNameKey() {
        return this.buildingType.getNameKey();
    }

    public int getLevel() {
        return this.buildingType.getLevel();
    }

    @Override
    public StringTemplate getLocationName() {
        return StringTemplate.template("inLocation").add("%location%", this.getNameKey());
    }

    @Override
    public StringTemplate getLocationNameFor(Player player) {
        return this.getLocationName();
    }

    public String getNextNameKey() {
        BuildingType next = this.buildingType.getUpgradesTo();
        return next == null ? null : next.getNameKey();
    }

    public boolean canBuildNext() {
        return this.getColony().canBuild(this.buildingType.getUpgradesTo());
    }

    @Override
    public Settlement getSettlement() {
        return this.colony;
    }

    @Override
    public Colony getColony() {
        return this.colony;
    }

    public BuildingType getType() {
        return this.buildingType;
    }

    @Override
    public boolean hasAbility(String id) {
        return this.getType().hasAbility(id);
    }

    public boolean canBeDamaged() {
        return !this.buildingType.isAutomaticBuild() && !this.colony.isAutomaticBuild(this.buildingType);
    }

    public boolean damage() {
        if (this.canBeDamaged()) {
            this.setType(this.buildingType.getUpgradesFrom());
            return true;
        }
        return false;
    }

    public boolean upgrade() {
        if (this.canBuildNext()) {
            this.setType(this.buildingType.getUpgradesTo());
            return true;
        }
        return false;
    }

    private void setType(BuildingType newBuildingType) {
        this.colony.getFeatureContainer().remove(this.buildingType.getFeatureContainer());
        if (newBuildingType != null) {
            this.buildingType = newBuildingType;
            this.colony.getFeatureContainer().add(this.buildingType.getFeatureContainer());
            for (Unit unit : this.units) {
                if (this.canAdd(unit.getType())) continue;
                unit.putOutsideColony();
            }
        }
        while (this.units.size() > this.getMaxUnits()) {
            this.getLastUnit().putOutsideColony();
        }
    }

    public int getMaxUnits() {
        return this.buildingType.getWorkPlaces();
    }

    @Override
    public int getUnitCount() {
        return this.units.size();
    }

    public UnitType getExpertUnitType() {
        return this.getSpecification().getExpertForProducing(this.getGoodsOutputType());
    }

    @Override
    public boolean canAdd(Locatable locatable) {
        if (locatable.getLocation() == this) {
            return true;
        }
        if (this.getUnitCount() >= this.getMaxUnits()) {
            return false;
        }
        if (!(locatable instanceof Unit)) {
            return false;
        }
        return this.canAdd(((Unit)locatable).getType());
    }

    public boolean canAdd(UnitType unitType) {
        return this.buildingType.canAdd(unitType);
    }

    @Override
    public void add(Locatable locatable) {
        if (!this.canAdd(locatable)) {
            throw new IllegalStateException("Can not add " + locatable + " to " + this.toString());
        }
        if (this.units.contains(locatable)) {
            return;
        }
        Unit unit = (Unit)locatable;
        this.units.add(unit);
        unit.setState(Unit.UnitState.IN_COLONY);
        unit.setWorkType(this.getGoodsOutputType());
        this.getColony().invalidateCache();
        if (this.buildingType.hasAbility("model.ability.teach")) {
            Unit student = unit.getStudent();
            if (student == null && (student = this.getColony().findStudent(unit)) != null) {
                unit.setStudent(student);
                student.setTeacher(unit);
            }
            unit.setWorkType(null);
        } else {
            Unit teacher = unit.getTeacher();
            if (teacher == null && (teacher = this.getColony().findTeacher(unit)) != null) {
                unit.setTeacher(teacher);
                teacher.setStudent(unit);
            }
        }
    }

    @Override
    public void remove(Locatable locatable) {
        if (!(locatable instanceof Unit)) {
            throw new IllegalStateException("Can only remove units from building.");
        }
        Unit unit = (Unit)locatable;
        if (this.units.remove(unit)) {
            unit.setMovesLeft(0);
            unit.setState(Unit.UnitState.ACTIVE);
            this.getColony().invalidateCache();
            if (this.buildingType.hasAbility("model.ability.teach")) {
                Unit student = unit.getStudent();
                if (student != null) {
                    student.setTeacher(null);
                    unit.setStudent(null);
                }
            } else {
                Unit teacher = unit.getTeacher();
                if (teacher != null) {
                    teacher.setStudent(null);
                    unit.setTeacher(null);
                }
            }
        }
    }

    @Override
    public boolean contains(Locatable locatable) {
        return this.units.contains(locatable);
    }

    public Unit getFirstUnit() {
        if (this.units.isEmpty()) {
            return null;
        }
        return this.units.get(0);
    }

    public Unit getLastUnit() {
        if (this.units.isEmpty()) {
            return null;
        }
        return this.units.get(this.units.size() - 1);
    }

    @Override
    public Iterator<Unit> getUnitIterator() {
        return this.units.iterator();
    }

    @Override
    public List<Unit> getUnitList() {
        return new ArrayList<Unit>(this.units);
    }

    @Override
    public GoodsContainer getGoodsContainer() {
        return null;
    }

    public GoodsType getGoodsOutputType() {
        return this.getType().getProducedGoodsType();
    }

    public GoodsType getGoodsInputType() {
        return this.getType().getConsumedGoodsType();
    }

    public int getMaximumGoodsInput() {
        if (this.getGoodsInputType() == null) {
            return 0;
        }
        if (this.canAutoProduce()) {
            return this.getMaximumAutoProduction(this.colony.getGoodsCount(this.getGoodsOutputType()));
        }
        return this.getProductivity(new Unit[0]);
    }

    protected int getStoredInput() {
        if (this.getGoodsInputType() == null) {
            return 0;
        }
        return this.colony.getGoodsCount(this.getGoodsInputType());
    }

    public int getGoodsInput() {
        GoodsType inputType = this.getGoodsInputType();
        if (inputType == null) {
            return 0;
        }
        if (this.canAutoProduce()) {
            return this.getMaximumAutoProduction(this.colony.getGoodsCount(this.getGoodsOutputType()));
        }
        return Math.min(this.getMaximumGoodsInput(), this.getStoredInput());
    }

    protected int getProductionAdding(int availableGoodsInput, Unit ... additionalUnits) {
        if (this.getGoodsOutputType() == null) {
            return 0;
        }
        int maximumGoodsInput = this.getProductivity(additionalUnits);
        if (this.getGoodsInputType() != null) {
            if (availableGoodsInput < maximumGoodsInput) {
                maximumGoodsInput = availableGoodsInput;
            }
            if (this.buildingType.hasAbility("model.ability.expertsUseConnections") && this.getSpecification().getBoolean("model.option.expertsHaveConnections")) {
                int minimumGoodsInput = 0;
                for (Unit unit : this.units) {
                    if (unit.getType() != this.getExpertUnitType()) continue;
                    minimumGoodsInput += 4;
                }
                for (Unit unit : additionalUnits) {
                    if (!this.canAdd(unit) || unit.getType() != this.getExpertUnitType()) continue;
                    minimumGoodsInput += 4;
                }
                if (maximumGoodsInput < minimumGoodsInput) {
                    maximumGoodsInput = minimumGoodsInput;
                }
            }
        }
        return this.applyModifiers(maximumGoodsInput);
    }

    public ProductionInfo getProductionInfo() {
        return this.colony.getProductionInfo(this);
    }

    public ProductionInfo getProductionInfo(AbstractGoods output, List<AbstractGoods> input) {
        ProductionInfo result = new ProductionInfo();
        if (this.getGoodsOutputType() != null) {
            if (this.getGoodsInputType() == null) {
                int amount = this.canAutoProduce() ? this.getAutoProduction(0) : this.getProductionAdding(0, new Unit[0]);
                result.addProduction(new AbstractGoods(this.getGoodsOutputType(), amount));
                result.addMaximumProduction(new AbstractGoods(this.getGoodsOutputType(), amount));
            } else {
                for (AbstractGoods goods : input) {
                    if (goods.getType() != this.getGoodsInputType()) continue;
                    int amount = this.canAutoProduce() ? this.getAutoProduction(goods.getAmount()) : this.getProductionAdding(goods.getAmount(), new Unit[0]);
                    result.addProduction(new AbstractGoods(this.getGoodsOutputType(), amount));
                    result.addConsumption(new AbstractGoods(this.getGoodsInputType(), Math.min(this.getMaximumGoodsInput(), goods.getAmount())));
                    result.addMaximumProduction(new AbstractGoods(this.getGoodsOutputType(), this.getMaximumProduction()));
                    result.addMaximumConsumption(new AbstractGoods(this.getGoodsInputType(), this.getMaximumGoodsInput()));
                    break;
                }
            }
        }
        return result;
    }

    public int getProduction() {
        if (this.canAutoProduce()) {
            return this.getAutoProduction(this.getGoodsInput());
        }
        return this.getProductionAdding(this.getStoredInput(), new Unit[0]);
    }

    public boolean canAutoProduce() {
        return this.buildingType.hasAbility("model.ability.autoProduction");
    }

    protected int getAutoProduction(int availableInput) {
        int availSpace;
        if (this.getGoodsOutputType() == null || this.colony.getGoodsCount(this.getGoodsOutputType()) >= this.colony.getWarehouseCapacity()) {
            return 0;
        }
        int goodsOutput = this.getMaximumAutoProduction(this.colony.getGoodsCount(this.getGoodsOutputType()));
        if (this.getGoodsInputType() != null && availableInput < goodsOutput) {
            goodsOutput = availableInput;
        }
        if ((goodsOutput = this.applyModifiers(goodsOutput)) > (availSpace = this.colony.getWarehouseCapacity() - this.colony.getGoodsCount(this.getGoodsOutputType()))) {
            goodsOutput = availSpace;
        }
        return goodsOutput;
    }

    public int getAdditionalProductionNextTurn(Unit addUnit) {
        return this.getUnitProductivity(addUnit);
    }

    @Override
    public int getProductionOf(GoodsType goodsType) {
        if (goodsType == this.getGoodsOutputType()) {
            return this.getProduction();
        }
        return 0;
    }

    private int getProductivity(Unit ... additionalUnits) {
        if (this.getGoodsOutputType() == null) {
            return 0;
        }
        int productivity = 0;
        for (Unit unit : this.units) {
            productivity += this.getUnitProductivity(unit);
        }
        for (Unit unit : additionalUnits) {
            if (!this.canAdd(unit)) continue;
            productivity += this.getUnitProductivity(unit);
        }
        return productivity;
    }

    public int getUnitProductivity(Unit prodUnit) {
        if (this.getGoodsOutputType() == null || prodUnit == null) {
            return 0;
        }
        int productivity = this.buildingType.getBasicProduction();
        if (productivity > 0) {
            return (int)prodUnit.getType().getFeatureContainer().applyModifier(Math.max(1, productivity += this.colony.getProductionBonus()), this.getGoodsOutputType().getId());
        }
        return 0;
    }

    public int getMaximumProduction() {
        int production;
        int n = production = this.canAutoProduce() ? this.getMaximumAutoProduction(this.colony.getGoodsCount(this.getGoodsOutputType())) : this.applyModifiers(this.getProductivity(new Unit[0]));
        if (this.getType().hasAbility("model.ability.avoidExcessProduction")) {
            int capacity = this.colony.getWarehouseCapacity() - this.colony.getGoodsCount(this.getGoodsOutputType());
            production = Math.min(capacity, production);
        }
        return production;
    }

    private int getMaximumAutoProduction(int available) {
        if (available < this.getGoodsOutputType().getBreedingNumber()) {
            return 0;
        }
        int divisor = (int)this.getType().getFeatureContainer().applyModifier(0.0f, "model.modifier.breedingDivisor");
        int factor = (int)this.getType().getFeatureContainer().applyModifier(0.0f, "model.modifier.breedingFactor");
        int result = ((available - 1) / divisor + 1) * factor;
        if (this.getType().hasAbility("model.ability.avoidExcessProduction")) {
            int capacity = this.colony.getWarehouseCapacity() - this.colony.getGoodsCount(this.getGoodsOutputType());
            result = Math.min(capacity, result);
        }
        return result;
    }

    public int getAdditionalProduction(Unit addUnit) {
        return this.getProductionAdding(this.getStoredInput(), addUnit) - this.getProduction();
    }

    public int applyModifiers(int productivity) {
        GoodsType goodsOutputType = this.getGoodsOutputType();
        if (goodsOutputType == null) {
            return 0;
        }
        ArrayList<Modifier> modifiers = new ArrayList<Modifier>(this.colony.getFeatureContainer().getModifierSet(goodsOutputType.getId(), this.buildingType, this.getGame().getTurn()));
        Collections.sort(modifiers);
        return (int)FeatureContainer.applyModifiers(productivity, this.getGame().getTurn(), modifiers);
    }

    @Override
    public int compareTo(Building other) {
        return this.getType().compareTo(other.getType());
    }

    @Override
    public List<FreeColGameObject> disposeList() {
        ArrayList<FreeColGameObject> objects = new ArrayList<FreeColGameObject>();
        while (!this.units.isEmpty()) {
            objects.addAll(this.units.remove(0).disposeList());
        }
        objects.addAll(super.disposeList());
        return objects;
    }

    @Override
    public void dispose() {
        this.disposeList();
    }

    public boolean consumes(GoodsType goodsType) {
        return goodsType == this.getGoodsInputType();
    }

    @Override
    public List<AbstractGoods> getConsumedGoods() {
        ArrayList<AbstractGoods> result = new ArrayList<AbstractGoods>();
        GoodsType inputType = this.getGoodsInputType();
        if (inputType != null) {
            result.add(new AbstractGoods(inputType, 0));
        }
        return result;
    }

    @Override
    public int getPriority() {
        return this.buildingType.getPriority();
    }

    @Override
    public Set<Modifier> getModifierSet(String id) {
        return this.buildingType.getModifierSet(id);
    }

    @Override
    protected void toXMLImpl(XMLStreamWriter out, Player player, boolean showAll, boolean toSavedGame) throws XMLStreamException {
        out.writeStartElement(Building.getXMLElementTagName());
        out.writeAttribute("ID", this.getId());
        out.writeAttribute("colony", this.colony.getId());
        out.writeAttribute("buildingType", this.buildingType.getId());
        Iterator<Unit> unitIterator = this.getUnitIterator();
        while (unitIterator.hasNext()) {
            unitIterator.next().toXML(out, player, showAll, toSavedGame);
        }
        out.writeEndElement();
    }

    @Override
    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        this.setId(in.getAttributeValue(null, "ID"));
        this.colony = this.getFreeColGameObject(in, "colony", Colony.class);
        this.buildingType = this.getSpecification().getBuildingType(in.getAttributeValue(null, "buildingType"));
        this.units.clear();
        while (in.nextTag() != 2) {
            Unit unit = this.updateFreeColGameObject(in, Unit.class);
            if (this.units.contains(unit)) continue;
            this.units.add(unit);
        }
    }

    @Override
    protected void toXMLPartialImpl(XMLStreamWriter out, String[] fields) throws XMLStreamException {
        this.toXMLPartialByClass(out, this.getClass(), fields);
    }

    @Override
    protected void readFromXMLPartialImpl(XMLStreamReader in) throws XMLStreamException {
        this.readFromXMLPartialByClass(in, this.getClass());
    }

    @Override
    public String toString() {
        return this.getType().getId() + " [" + this.colony.getName() + "]";
    }

    public static String getXMLElementTagName() {
        return "building";
    }
}

