/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.border.Border;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.UnitLabel;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ColonyTile;
import net.sf.freecol.common.model.FeatureContainer;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Scope;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.resources.ResourceManager;

public class WorkProductionPanel
extends FreeColPanel {
    private static final Border border = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.BLACK), BorderFactory.createEmptyBorder(2, 2, 2, 2));

    public WorkProductionPanel(Canvas canvas, Unit unit) {
        super(canvas);
        GoodsType goodsType;
        this.setLayout((LayoutManager)new MigLayout("wrap 3, insets 10 10 10 10", "[]30:push[right][]", ""));
        Colony colony = unit.getColony();
        UnitType unitType = unit.getType();
        ArrayList<Modifier> modifiers = new ArrayList<Modifier>();
        if (unit.getLocation() instanceof ColonyTile) {
            ColonyTile colonyTile = (ColonyTile)unit.getLocation();
            goodsType = unit.getWorkType();
            Set<Modifier> basicModifiers = colonyTile.getProductionModifiers(goodsType, unitType);
            if (FeatureContainer.applyModifierSet(0.0f, this.getGame().getTurn(), basicModifiers) > 0.0f) {
                basicModifiers.addAll(unit.getModifierSet(goodsType.getId()));
                if (colony.getProductionBonus() != 0) {
                    basicModifiers.add(colony.getProductionModifier(goodsType));
                }
                basicModifiers.addAll(colony.getModifierSet(goodsType.getId()));
                modifiers.addAll(basicModifiers);
            }
            this.add((Component)this.localizedLabel(colonyTile.getLabel()), "span, align center, wrap 30");
            TileType tileType = colonyTile.getWorkTile().getType();
            int width = canvas.getClient().getImageLibrary().getTerrainImageWidth(tileType);
            int height = canvas.getClient().getImageLibrary().getTerrainImageHeight(tileType);
            BufferedImage image = new BufferedImage(width, height, 2);
            canvas.getGUI().displayColonyTile((Graphics2D)image.getGraphics(), colonyTile.getWorkTile(), colony);
            this.add(new JLabel(new ImageIcon(image)));
        } else {
            Building building = (Building)unit.getLocation();
            goodsType = building.getGoodsOutputType();
            if (building.getType().getProductionModifier() != null) {
                modifiers.add(building.getType().getProductionModifier());
            }
            if (colony.getProductionBonus() != 0) {
                modifiers.add(colony.getProductionModifier(goodsType));
            }
            if (goodsType != null) {
                modifiers.addAll(unit.getType().getModifierSet(goodsType.getId()));
            }
            modifiers.addAll(colony.getModifierSet(goodsType.getId()));
            this.add((Component)this.localizedLabel(building.getNameKey()), "span, align center, wrap 30");
            this.add(new JLabel(ResourceManager.getImageIcon(building.getType().getId() + ".image")));
        }
        Collections.sort(modifiers);
        this.add((Component)new UnitLabel(unit, canvas, false, false), "wrap");
        float result = 0.0f;
        for (Modifier modifier : modifiers) {
            String sourceName;
            FreeColGameObjectType source = modifier.getSource();
            if (source == null) {
                sourceName = "???";
            } else {
                sourceName = Messages.message(source.getNameKey());
                if (unitType != null && modifier.hasScope()) {
                    for (Scope scope : modifier.getScopes()) {
                        if (!scope.appliesTo(unitType)) continue;
                        sourceName = sourceName + " (" + Messages.message(unitType.getNameKey()) + ")";
                    }
                }
            }
            String bonus = WorkProductionPanel.getModifierFormat().format(modifier.getValue());
            boolean percentage = false;
            switch (modifier.getType()) {
                case ADDITIVE: {
                    if (!(modifier.getValue() > 0.0f)) break;
                    bonus = "+" + bonus;
                    break;
                }
                case PERCENTAGE: {
                    if (modifier.getValue() > 0.0f) {
                        bonus = "+" + bonus;
                    }
                    percentage = true;
                    break;
                }
                case MULTIPLICATIVE: {
                    bonus = "\u00d7" + bonus;
                    break;
                }
            }
            result = modifier.applyTo(result);
            this.add((Component)new JLabel(sourceName), "newline");
            this.add(new JLabel(bonus));
            if (!percentage) continue;
            this.add(new JLabel("%"));
        }
        Font bigFont = this.getFont().deriveFont(1, 16.0f);
        JLabel finalLabel = new JLabel(Messages.message("model.source.finalResult.name"));
        finalLabel.setFont(bigFont);
        this.add((Component)finalLabel, "newline");
        JLabel finalResult = new JLabel(WorkProductionPanel.getModifierFormat().format(result));
        finalResult.setFont(bigFont);
        finalResult.setBorder(border);
        this.add((Component)finalResult, "wrap 30");
        this.add((Component)this.okButton, "span, tag ok");
        this.setSize(this.getPreferredSize());
    }
}

