/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextPane;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.ClientOptions;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.ReportPanel;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Market;
import net.sf.freecol.common.model.ModelMessage;
import net.sf.freecol.common.model.Nameable;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.option.BooleanOption;

public final class ReportTurnPanel
extends ReportPanel {
    private ModelMessage[] _messages;
    private Hashtable<String, Vector<JComponent>> textPanesByMessage = new Hashtable();
    private Hashtable<String, Vector<JComponent>> labelsByMessage = new Hashtable();

    public ReportTurnPanel(Canvas parent, ModelMessage ... messages) {
        super(parent, Messages.message("reportTurnAction.name"));
        FreeColGameObject messageSource;
        this._messages = messages;
        Comparator<ModelMessage> comparator = this.getClient().getClientOptions().getModelMessageComparator();
        if (comparator != null) {
            Arrays.sort(messages, comparator);
        }
        ClientOptions options = this.getClient().getClientOptions();
        int groupBy = options.getInteger("model.option.guiMessagesGroupBy");
        Object source = this;
        ModelMessage.MessageType type = null;
        Game game = this.getClient().getGame();
        for (final ModelMessage message : messages) {
            if (groupBy == 2) {
                messageSource = game.getMessageSource(message);
                if (messageSource == source) continue;
                source = messageSource;
                continue;
            }
            if (groupBy != 1 || message.getMessageType() == type) continue;
            type = message.getMessageType();
        }
        this.reportPanel.removeAll();
        this.reportPanel.setLayout((LayoutManager)new MigLayout("wrap 4", "[center][550!]:push[][]", ""));
        source = this;
        type = null;
        for (final ModelMessage message : messages) {
            if (groupBy == 2) {
                messageSource = game.getMessageSource(message);
                if (messageSource != source) {
                    source = messageSource;
                    this.reportPanel.add((Component)this.getHeadline(source), "newline 20, skip");
                }
            } else if (groupBy == 1 && message.getMessageType() != type) {
                type = message.getMessageType();
                JLabel headline = this.localizedLabel(message.getMessageTypeName());
                headline.setFont(smallHeaderFont);
                this.reportPanel.add((Component)headline, "newline 20, skip, span");
            }
            JComponent component = new JLabel();
            FreeColObject messageDisplay = game.getMessageDisplay(message);
            if (messageDisplay != null) {
                JButton button;
                ImageIcon icon = this.getCanvas().getImageIcon(messageDisplay, false);
                if (icon != null && icon.getIconHeight() > 40) {
                    Image image = icon.getImage();
                    int newWidth = (int)((double)image.getWidth(null) / (double)image.getHeight(null) * 40.0);
                    image = image.getScaledInstance(newWidth, 40, 4);
                    icon.setImage(image);
                }
                if (messageDisplay instanceof Colony) {
                    button = new JButton();
                    button.setIcon(icon);
                    button.setActionCommand(((Colony)messageDisplay).getId());
                    button.addActionListener(this);
                    button.setBorder(BorderFactory.createEmptyBorder());
                    component = button;
                } else if (messageDisplay instanceof Unit) {
                    button = new JButton();
                    button.setIcon(icon);
                    button.setActionCommand(((Unit)messageDisplay).getLocation().getId());
                    button.addActionListener(this);
                    button.setBorder(BorderFactory.createEmptyBorder());
                    component = button;
                } else {
                    component = messageDisplay instanceof Player ? new JLabel(icon) : new JLabel(icon);
                }
            }
            this.reportPanel.add((Component)component, "newline");
            final JTextPane textPane = ReportTurnPanel.getDefaultTextPane();
            this.insertMessage(textPane.getStyledDocument(), message, this.getMyPlayer());
            this.reportPanel.add(textPane);
            boolean ignore = false;
            final JLabel label = component;
            if (message.getMessageType() == ModelMessage.MessageType.WAREHOUSE_CAPACITY) {
                JButton ignoreButton = new JButton("x");
                ignoreButton.setToolTipText(Messages.message(new StringTemplate("model.message.ignore", message)));
                ignoreButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent event) {
                        boolean flag = label.isEnabled();
                        ReportTurnPanel.this.getController().ignoreMessage(message, flag);
                        textPane.setEnabled(!flag);
                        label.setEnabled(!flag);
                    }
                });
                this.reportPanel.add(ignoreButton);
                ignore = true;
            }
            if (!this.textPanesByMessage.containsKey(message.getId())) {
                this.textPanesByMessage.put(message.getId(), new Vector());
            }
            this.textPanesByMessage.get(message.getId()).add(textPane);
            if (!this.labelsByMessage.containsKey(message.getId())) {
                this.labelsByMessage.put(message.getId(), new Vector());
            }
            this.textPanesByMessage.get(message.getId()).add(textPane);
            this.textPanesByMessage.get(message.getId()).add(label);
            final BooleanOption filterOption = options.getBooleanOption(message);
            if (filterOption == null) continue;
            JButton filterButton = new JButton("X");
            filterButton.setToolTipText(Messages.message(StringTemplate.template("model.message.filter").addName("%type%", message.getMessageTypeName())));
            filterButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    boolean flag = filterOption.getValue();
                    filterOption.setValue(!flag);
                    ReportTurnPanel.this.setEnabledByType(message.getMessageType(), !flag);
                }
            });
            if (ignore) {
                this.reportPanel.add(filterButton);
                continue;
            }
            this.reportPanel.add((Component)filterButton, "skip");
        }
    }

    private void setEnabledByType(ModelMessage.MessageType type, boolean enabled) {
        for (int i = 0; i < this._messages.length; ++i) {
            if (this._messages[i].getMessageType() != type) continue;
            for (JComponent textPane : this.textPanesByMessage.get(this._messages[i].getId())) {
                textPane.setEnabled(enabled);
            }
            for (JComponent label : this.labelsByMessage.get(this._messages[i].getId())) {
                label.setEnabled(enabled);
            }
        }
    }

    private JComponent getHeadline(Object source) {
        JComponent headline;
        if (source == null) {
            return new JLabel();
        }
        if (source instanceof Player) {
            Player player = (Player)source;
            headline = this.localizedLabel(StringTemplate.template("playerNation").addName("%player%", player.getDisplayName()).addStringTemplate("%nation%", player.getNationName()));
        } else if (source instanceof Europe) {
            Europe europe = (Europe)source;
            JButton button = new JButton(Messages.message(europe.getNameKey()));
            button.addActionListener(this);
            button.setActionCommand(europe.getId());
            headline = button;
        } else if (source instanceof Market) {
            Market market = (Market)source;
            JButton button = new JButton(Messages.message(market.getOwner().getMarketName()));
            button.addActionListener(this);
            button.setActionCommand(this.getMyPlayer().getEurope().getId());
            headline = button;
        } else if (source instanceof Colony) {
            Colony colony = (Colony)source;
            JButton button = new JButton(colony.getName());
            button.addActionListener(this);
            button.setActionCommand(colony.getId());
            headline = button;
        } else if (source instanceof Unit) {
            Unit unit = (Unit)source;
            JButton button = new JButton(Messages.message(unit.getLabel()));
            button.addActionListener(this);
            button.setActionCommand(unit.getLocation().getId());
            headline = button;
        } else if (source instanceof Tile) {
            Tile tile = (Tile)source;
            JButton button = new JButton(Messages.message(tile.getLocationNameFor(this.getMyPlayer())));
            button.addActionListener(this);
            button.setActionCommand(tile.getId());
            headline = button;
        } else {
            headline = source instanceof Nameable ? new JLabel(((Nameable)source).getName()) : new JLabel(source.toString());
        }
        headline.setFont(smallHeaderFont);
        headline.setOpaque(false);
        headline.setForeground(LINK_COLOR);
        headline.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        return headline;
    }

    private void insertMessage(StyledDocument document, ModelMessage message, Player player) {
        try {
            int end;
            int start;
            String input;
            String id = message.getId();
            if (id == null || id.equals(input = Messages.message(id))) {
                input = Messages.message(message.getDefaultId());
            }
            if ((start = input.indexOf(37)) == -1) {
                this.insertText(document, input.substring(0));
                return;
            }
            if (start > 0) {
                this.insertText(document, input.substring(0, start));
            }
            while ((end = input.indexOf(37, start + 1)) >= 0) {
                String var = input.substring(start, end + 1);
                String[] item = this.findReplacementData(message, var);
                FreeColGameObject messageSource = this.getClient().getGame().getMessageSource(message);
                if (item != null && var.equals(item[0])) {
                    if (var.equals("%colony%")) {
                        Colony colony = player.getColony(item[1]);
                        if (colony != null) {
                            this.insertLinkButton(document, colony, item[1]);
                        } else if (messageSource instanceof Tile) {
                            this.insertLinkButton(document, messageSource, item[1]);
                        } else {
                            this.insertText(document, item[1]);
                        }
                    } else if (var.equals("%europe%")) {
                        this.insertLinkButton(document, player.getEurope(), Messages.message(player.getEurope().getNameKey()));
                    } else if (var.equals("%unit%") || var.equals("%newName%")) {
                        Tile tile = null;
                        if (messageSource instanceof Unit) {
                            tile = ((Unit)messageSource).getTile();
                        } else if (messageSource instanceof Tile) {
                            tile = (Tile)messageSource;
                        }
                        if (tile != null) {
                            this.insertLinkButton(document, tile, item[1]);
                        } else {
                            this.insertText(document, item[1]);
                        }
                    } else if (var.equals("%repairLocation%")) {
                        if (messageSource instanceof Europe) {
                            this.insertLinkButton(document, player.getEurope(), Messages.message(player.getEurope().getNameKey()));
                        } else if (messageSource instanceof Colony) {
                            this.insertLinkButton(document, (Colony)messageSource, item[1]);
                        } else {
                            this.insertText(document, item[1]);
                        }
                    } else {
                        this.insertText(document, item[1]);
                    }
                    start = end + 1;
                    continue;
                }
                this.insertText(document, input.substring(start, end));
                start = end;
            }
            if (start < input.length()) {
                this.insertText(document, input.substring(start));
            }
        }
        catch (Exception e) {
            logger.warning(e.toString());
        }
    }

    private String[] findReplacementData(ModelMessage message, String variable) {
        List<String> data = message.getKeys();
        if (data != null) {
            for (int index = 0; index < data.size(); ++index) {
                if (!variable.equals(data.get(index))) continue;
                return new String[]{variable, Messages.message(message.getReplacements().get(index))};
            }
        }
        return null;
    }

    private void insertText(StyledDocument document, String text) throws Exception {
        document.insertString(document.getLength(), text, document.getStyle("regular"));
    }

    private void insertLinkButton(StyledDocument document, FreeColGameObject object, String name) throws Exception {
        JButton button = ReportTurnPanel.getLinkButton(name, null, object.getId());
        button.addActionListener(this);
        StyleConstants.setComponent(document.getStyle("button"), button);
        document.insertString(document.getLength(), " ", document.getStyle("button"));
    }
}

