/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.ReportPanel;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;

public final class ReportIndianPanel
extends ReportPanel {
    public ReportIndianPanel(Canvas parent) {
        super(parent, Messages.message("reportIndianAction.name"));
        Player player = this.getMyPlayer();
        this.reportPanel.setLayout((LayoutManager)new MigLayout("wrap 5, fillx", "[]20px[center]", ""));
        for (Player opponent : this.getGame().getPlayers()) {
            if (!opponent.isIndian() || opponent.isDead() || !player.hasContacted(opponent)) continue;
            this.buildIndianAdvisorPanel(player, opponent);
        }
        this.scrollPane.getViewport().setOpaque(false);
        this.reportPanel.setOpaque(true);
        this.reportPanel.doLayout();
    }

    private void buildIndianAdvisorPanel(Player player, Player opponent) {
        this.reportPanel.add(this.localizedLabel("report.indian.nameOfTribe"));
        this.reportPanel.add((Component)this.localizedLabel(opponent.getNationName()), "span 2, wrap");
        this.reportPanel.add(this.localizedLabel("report.indian.chieftain"));
        this.reportPanel.add((Component)new JLabel(Messages.message(opponent.getName())), "span 2, wrap");
        this.reportPanel.add(this.localizedLabel("report.indian.typeOfSettlements"));
        this.reportPanel.add((Component)this.localizedLabel(opponent.getNationType().getCapitalType().getId() + ".name"), "span 2, wrap");
        this.reportPanel.add(this.localizedLabel("report.indian.numberOfSettlements"));
        this.reportPanel.add((Component)new JLabel(String.valueOf(opponent.getSettlements().size())), "span 2, wrap");
        this.reportPanel.add(new JLabel(Messages.message("report.indian.tension") + ":"));
        this.reportPanel.add((Component)this.localizedLabel(opponent.getTension(player).toString()), "span 2, wrap");
        this.reportPanel.add((Component)new JSeparator(0), "span, growx");
        int numberOfSettlements = opponent.getIndianSettlements().size();
        if (numberOfSettlements > 0) {
            this.reportPanel.add((Component)this.localizedLabel("Settlement"), "newline 10");
            this.reportPanel.add(this.localizedLabel("mission"));
            this.reportPanel.add(this.localizedLabel("report.indian.tension"));
            this.reportPanel.add(this.localizedLabel("report.indian.skillTaught"));
            this.reportPanel.add(this.localizedLabel("report.indian.tradeInterests"));
            ArrayList<IndianSettlement> settlements = new ArrayList<IndianSettlement>(numberOfSettlements);
            for (IndianSettlement settlement : opponent.getIndianSettlements()) {
                if (settlement.isCapital()) {
                    settlements.add(0, settlement);
                    continue;
                }
                settlements.add(settlement);
            }
            for (IndianSettlement settlement : settlements) {
                String skillString;
                boolean known = settlement.getTile().isExplored();
                boolean visited = player.hasVisited(settlement);
                String locationName = Messages.message(settlement.getNameFor(player));
                if (known && settlement.isCapital()) {
                    locationName = locationName + "*";
                }
                JButton settlementButton = ReportIndianPanel.getLinkButton(locationName, null, settlement.getTile().getId());
                settlementButton.addActionListener(this);
                this.reportPanel.add((Component)settlementButton, "newline 15");
                JLabel missionLabel = new JLabel();
                Unit missionary = settlement.getMissionary();
                if (missionary != null) {
                    boolean expert = missionary.hasAbility("model.ability.expertMissionary");
                    missionLabel.setIcon(new ImageIcon(this.getLibrary().getMissionChip(missionary, expert, 1.0)));
                    String text = Messages.message(StringTemplate.template("model.unit.nationUnit").addStringTemplate("%nation%", missionary.getOwner().getNationName()).addStringTemplate("%unit%", Messages.getLabel(missionary)));
                    missionLabel.setToolTipText(text);
                }
                this.reportPanel.add(missionLabel);
                String messageId = settlement.getShortAlarmLevelMessageId(player);
                this.reportPanel.add(this.localizedLabel(messageId));
                JLabel skillLabel = new JLabel();
                UnitType skillType = settlement.getLearnableSkill();
                if (visited) {
                    if (skillType == null) {
                        skillString = "indianSettlement.skillNone";
                    } else {
                        skillString = skillType.getNameKey();
                        ImageIcon skillImage = this.getLibrary().getUnitImageIcon(skillType, 0.66);
                        skillLabel.setIcon(skillImage);
                    }
                } else {
                    skillString = "indianSettlement.skillUnknown";
                }
                skillLabel.setText(Messages.message(skillString));
                this.reportPanel.add(skillLabel);
                GoodsType[] wantedGoods = settlement.getWantedGoods();
                if (visited && wantedGoods[0] != null) {
                    JLabel goodsLabel = this.localizedLabel(wantedGoods[0].getNameKey());
                    goodsLabel.setIcon(new ImageIcon(this.getLibrary().getGoodsImage(wantedGoods[0], 0.66)));
                    String split = "split " + String.valueOf(wantedGoods.length);
                    this.reportPanel.add((Component)goodsLabel, split);
                    for (int i = 1; i < wantedGoods.length; ++i) {
                        if (wantedGoods[i] == null) continue;
                        String sale = player.getLastSaleString(settlement, wantedGoods[i]);
                        goodsLabel = new JLabel(Messages.message(wantedGoods[i].getNameKey()) + (sale == null ? "" : " " + sale));
                        goodsLabel.setIcon(this.getLibrary().getScaledGoodsImageIcon(wantedGoods[i], 0.5));
                        this.reportPanel.add(goodsLabel);
                    }
                    continue;
                }
                this.reportPanel.add(this.localizedLabel("indianSettlement.wantedGoodsUnknown"));
            }
        } else {
            this.reportPanel.add(this.localizedLabel("report.indian.noKnownSettlements"));
        }
        this.reportPanel.add((Component)new JSeparator(0), "newline 10, span, growx");
    }
}

