/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JTextArea;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.FreeColDialog;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.UnitType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RecruitDialog
extends FreeColDialog<Integer>
implements ActionListener {
    private static Logger logger = Logger.getLogger(RecruitDialog.class.getName());
    private static final int RECRUIT_CANCEL = -1;
    private static final int NUMBER_OF_PERSONS = 3;
    private final JButton[] person = new JButton[3];
    private final JTextArea question;

    public RecruitDialog(Canvas parent) {
        super(parent);
        this.setFocusCycleRoot(true);
        this.question = RecruitDialog.getDefaultTextArea(Messages.message("recruitDialog.clickOn"));
        for (int index = 0; index < 3; ++index) {
            this.person[index] = new JButton();
            this.person[index].setActionCommand(String.valueOf(index));
            RecruitDialog.enterPressesWhenFocused(this.person[index]);
            this.person[index].addActionListener(this);
            this.person[index].setIconTextGap(3);
        }
        this.initialize();
    }

    @Override
    public void initialize() {
        this.setLayout((LayoutManager)new MigLayout("wrap 1", "", ""));
        this.add((Component)this.question, "wrap 20");
        int recruitPrice = 0;
        Player player = this.getMyPlayer();
        if (this.getGame() != null && player != null) {
            int production = 0;
            for (Colony colony : player.getColonies()) {
                production += colony.getProductionOf(this.getSpecification().getGoodsType("model.goods.crosses"));
            }
            int turns = 100;
            if (production > 0) {
                int immigrationRequired = player.getImmigrationRequired() - player.getImmigration();
                turns = immigrationRequired / production;
                if (immigrationRequired % production > 0) {
                    ++turns;
                }
            }
            recruitPrice = player.getRecruitPrice();
            this.question.setText(Messages.message(StringTemplate.template("recruitDialog.clickOn").addAmount("%money%", recruitPrice).addAmount("%number%", turns)));
            for (int index = 0; index < 3; ++index) {
                UnitType unitType = player.getEurope().getRecruitable(index);
                ImageIcon unitIcon = this.getLibrary().getUnitImageIcon(unitType, 0.66);
                this.person[index].setText(Messages.message(unitType.getNameKey()));
                this.person[index].setIcon(unitIcon);
                this.person[index].setEnabled(player.checkGold(recruitPrice));
                this.add((Component)this.person[index], "growx");
            }
        }
        this.add((Component)this.cancelButton, "newline 20, tag cancel");
        this.setSize(this.getPreferredSize());
    }

    @Override
    public void requestFocus() {
        this.cancelButton.requestFocus();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if ("CANCEL".equals(command)) {
            this.setResponse(new Integer(-1));
        } else {
            try {
                int action = Integer.parseInt(command);
                if (action >= 0 && action < 3) {
                    this.getController().recruitUnitInEurope(action);
                    this.setResponse(new Integer(0));
                } else {
                    logger.warning("Invalid action command");
                    this.setResponse(new Integer(-1));
                }
            }
            catch (NumberFormatException e) {
                logger.warning("Invalid action number");
                this.setResponse(new Integer(-1));
            }
        }
    }
}

