/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import javax.swing.JLabel;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.FreeColDialog;
import net.sf.freecol.common.model.Monarch;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.StringTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MonarchPanel
extends FreeColDialog<Boolean>
implements ActionListener {
    private static final Logger logger = Logger.getLogger(MonarchPanel.class.getName());

    public MonarchPanel(Canvas parent, Monarch.MonarchAction action) {
        this(parent, action, null);
    }

    public MonarchPanel(Canvas parent, Monarch.MonarchAction action, StringTemplate replace) {
        super(parent);
        String messageID;
        this.setLayout((LayoutManager)new MigLayout("wrap 2"));
        JLabel header = new JLabel(Messages.message("aMessageFromTheCrown"));
        header.setFont(mediumHeaderFont);
        this.add((Component)header, "span, align center, wrap 20");
        Nation nation = this.getMyPlayer().getNation();
        this.add(new JLabel(this.getLibrary().getMonarchImageIcon(nation)));
        String okText = "ok";
        String cancelText = null;
        switch (action) {
            case RAISE_TAX: {
                messageID = "model.monarch.raiseTax";
                okText = "model.monarch.acceptTax";
                cancelText = "model.monarch.rejectTax";
                break;
            }
            case LOWER_TAX: {
                messageID = "model.monarch.lowerTax";
                break;
            }
            case WAIVE_TAX: {
                messageID = "model.monarch.waiveTax";
                break;
            }
            case ADD_TO_REF: {
                messageID = "model.monarch.addToREF";
                break;
            }
            case DECLARE_WAR: {
                messageID = "model.monarch.declareWar";
                break;
            }
            case SUPPORT_SEA: {
                messageID = "model.monarch.supportSea";
                cancelText = "display";
                break;
            }
            case SUPPORT_LAND: {
                messageID = "model.monarch.supportLand";
                cancelText = "display";
                break;
            }
            case OFFER_MERCENARIES: {
                messageID = "model.monarch.offerMercenaries";
                okText = "model.monarch.acceptMercenaries";
                cancelText = "model.monarch.rejectMercenaries";
                break;
            }
            default: {
                messageID = "Unknown monarch action: " + (Object)((Object)action);
            }
        }
        if (replace == null) {
            this.add(MonarchPanel.getDefaultTextArea(Messages.message(messageID)));
        } else {
            this.add(MonarchPanel.getDefaultTextArea(Messages.message(new StringTemplate(messageID, replace))));
        }
        this.okButton.setText(Messages.message(okText));
        if (cancelText == null) {
            this.add((Component)this.okButton, "newline 20, span, tag ok");
        } else {
            this.add((Component)this.okButton, "newline 20, span, tag ok, split 2");
            this.cancelButton.setText(Messages.message(cancelText));
            this.add((Component)this.cancelButton, "tag cancel");
        }
        this.setSize(this.getPreferredSize());
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if ("OK".equals(command)) {
            this.setResponse(Boolean.TRUE);
        } else if ("CANCEL".equals(command)) {
            this.setResponse(Boolean.FALSE);
        } else {
            logger.warning("Invalid action command: " + command);
        }
    }
}

