/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import net.sf.freecol.client.control.MapEditorController;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.ChoiceItem;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.common.model.IndianNationType;
import net.sf.freecol.common.model.LostCityRumour;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Resource;
import net.sf.freecol.common.model.ResourceType;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.SettlementType;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovement;
import net.sf.freecol.common.model.TileImprovementType;
import net.sf.freecol.common.model.TileItemContainer;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.generator.RiverSection;
import net.sf.freecol.server.model.ServerIndianSettlement;
import net.sf.freecol.server.model.ServerUnit;

public final class MapEditorTransformPanel
extends FreeColPanel {
    private static final Logger logger = Logger.getLogger(MapEditorTransformPanel.class.getName());
    private final JPanel listPanel;
    private JToggleButton settlementButton;
    private ButtonGroup group;
    private static Player nativePlayer;

    public MapEditorTransformPanel(Canvas parent) {
        super(parent, new BorderLayout());
        if (this.getGame().getPlayers().isEmpty()) {
            FreeColServer server = this.getClient().getFreeColServer();
            if (server.getAIMain() == null) {
                server.setAIMain(new AIMain(server));
            }
            for (Nation nation : this.getSpecification().getIndianNations()) {
                server.addAIPlayer(nation);
            }
        }
        nativePlayer = this.getGame().getPlayers().get(0);
        this.listPanel = new JPanel(new GridLayout(2, 0));
        this.group = new ButtonGroup();
        this.group.add(new JToggleButton());
        this.buildList();
        JScrollPane sl = new JScrollPane(this.listPanel, 20, 30);
        sl.getViewport().setOpaque(false);
        this.add(sl);
    }

    private void buildList() {
        List<TileType> tileList = this.getSpecification().getTileTypeList();
        for (TileType type : tileList) {
            this.listPanel.add(this.buildButton(this.getLibrary().getCompoundTerrainImage(type, 0.5), Messages.message(type.getNameKey()), new TileTypeTransform(type)));
        }
        this.listPanel.add(this.buildButton(this.getLibrary().getRiverImage(10, 0.5), Messages.message("minorRiver"), new RiverTransform(1)));
        this.listPanel.add(this.buildButton(this.getLibrary().getRiverImage(20, 0.5), Messages.message("majorRiver"), new RiverTransform(2)));
        this.listPanel.add(this.buildButton(this.getLibrary().getBonusImage(this.getSpecification().getResourceTypeList().get(0), 0.8), Messages.message("editor.resource"), new ResourceTransform()));
        this.listPanel.add(this.buildButton(this.getLibrary().getMiscImage("lostCityRumour.image", 0.66), Messages.message("model.message.LOST_CITY_RUMOUR"), new LostCityRumourTransform()));
        SettlementType settlementType = nativePlayer.getNationType().getCapitalType();
        this.settlementButton = this.buildButton(this.getLibrary().getSettlementImage(settlementType, 0.5), Messages.message("Settlement"), new SettlementTransform());
        this.listPanel.add(this.settlementButton);
    }

    private JToggleButton buildButton(Image image, String text, final MapTransform mt) {
        JPanel descriptionPanel = new JPanel(new BorderLayout());
        descriptionPanel.add((Component)new JLabel(new ImageIcon(image)), "Center");
        descriptionPanel.add((Component)new JLabel(text, 0), "South");
        descriptionPanel.setBackground(Color.RED);
        mt.setDescriptionPanel(descriptionPanel);
        ImageIcon icon = new ImageIcon(image);
        JToggleButton button = new JToggleButton(icon);
        button.setToolTipText(text);
        button.setOpaque(false);
        this.group.add(button);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MapEditorController ctlr = MapEditorTransformPanel.this.getClient().getMapEditorController();
                MapTransform newMapTransform = null;
                if (ctlr.getMapTransform() != mt) {
                    newMapTransform = mt;
                }
                ctlr.setMapTransform(newMapTransform);
                if (newMapTransform == null && mt != null) {
                    MapEditorTransformPanel.this.group.setSelected(MapEditorTransformPanel.this.group.getElements().nextElement().getModel(), true);
                }
            }
        });
        button.setBorder(null);
        return button;
    }

    public static Player getNativePlayer() {
        return nativePlayer;
    }

    public static void setNativePlayer(Player newNativePlayer) {
        nativePlayer = newNativePlayer;
    }

    private class SettlementTransform
    extends MapTransform {
        private SettlementTransform() {
        }

        public void transform(Tile t) {
            Settlement settlement;
            if (t.isLand() && (settlement = t.getSettlement()) == null) {
                UnitType skill = ((IndianNationType)nativePlayer.getNationType()).getSkills().get(0).getObject();
                String name = nativePlayer.getSettlementName();
                if ("".equals(name)) {
                    nativePlayer.installSettlementNames(Messages.getSettlementNames(nativePlayer), null);
                    name = nativePlayer.getSettlementName();
                }
                settlement = new ServerIndianSettlement(t.getGame(), nativePlayer, name, t, false, skill, new HashSet<Player>(), null);
                t.setSettlement(settlement);
                UnitType brave = MapEditorTransformPanel.this.getSpecification().getUnitType("model.unit.brave");
                for (int index = 0; index < 5; ++index) {
                    settlement.add(new ServerUnit(settlement.getGame(), settlement, settlement.getOwner(), brave, Unit.UnitState.ACTIVE));
                }
            }
        }
    }

    private class LostCityRumourTransform
    extends MapTransform {
        private LostCityRumourTransform() {
        }

        public void transform(Tile t) {
            if (t.isLand()) {
                LostCityRumour rumour = t.getLostCityRumour();
                if (rumour == null) {
                    t.addLostCityRumour(new LostCityRumour(t.getGame(), t));
                } else {
                    t.removeLostCityRumour();
                }
            }
        }
    }

    private class ResourceTransform
    extends MapTransform {
        private ResourceTransform() {
        }

        public void transform(Tile t) {
            Resource resource = null;
            if (t.getTileItemContainer() != null) {
                resource = t.getTileItemContainer().getResource();
            }
            if (resource != null) {
                t.getTileItemContainer().removeTileItem(resource);
            } else {
                List<ResourceType> resList = t.getType().getResourceTypeList();
                switch (resList.size()) {
                    case 0: {
                        return;
                    }
                    case 1: {
                        ResourceType resourceType = resList.get(0);
                        t.addResource(new Resource(t.getGame(), t, resourceType, resourceType.getMaxValue()));
                        return;
                    }
                }
                ArrayList choices = new ArrayList();
                for (ResourceType resType : resList) {
                    String name = Messages.message(resType.getNameKey());
                    choices.add(new ChoiceItem<ResourceType>(name, resType));
                }
                ResourceType choice = (ResourceType)MapEditorTransformPanel.this.getCanvas().showChoiceDialog(null, Messages.message("ok"), Messages.message("cancel"), choices);
                if (choice != null) {
                    t.addResource(new Resource(t.getGame(), t, choice, choice.getMaxValue()));
                }
            }
        }
    }

    private class RiverTransform
    extends MapTransform {
        private int magnitude;

        private RiverTransform(int magnitude) {
            this.magnitude = magnitude;
        }

        public void transform(Tile tile) {
            TileImprovementType riverType = tile.getSpecification().getTileImprovementType("model.improvement.river");
            if (tile.getType().canHaveImprovement(riverType)) {
                TileItemContainer tic = tile.getTileItemContainer();
                if (tic == null) {
                    tic = new TileItemContainer(tile.getGame(), tile);
                    tile.setTileItemContainer(tic);
                }
                int oldMagnitude = 0;
                TileImprovement river = tic.getRiver();
                if (river == null) {
                    river = new TileImprovement(tile.getGame(), tile, riverType);
                } else {
                    oldMagnitude = river.getMagnitude();
                }
                if (this.magnitude != oldMagnitude) {
                    tic.addRiver(this.magnitude, river.getStyle());
                    RiverSection mysection = new RiverSection(river.getStyle());
                    for (Map.Direction direction : Map.Direction.longSides) {
                        Tile t = tile.getNeighbourOrNull(direction);
                        if (t == null) continue;
                        TileImprovement otherRiver = t.getRiver();
                        if (!t.isLand() && otherRiver == null) {
                            otherRiver = new TileImprovement(tile.getGame(), tile, riverType);
                            otherRiver.setMagnitude(tile.getRiver().getMagnitude());
                        }
                        if (otherRiver == null) continue;
                        Map.Direction otherDirection = direction.getReverseDirection();
                        RiverSection oppositesection = new RiverSection(otherRiver.getStyle());
                        oppositesection.setBranch(otherDirection, tile.getRiver().getMagnitude());
                        otherRiver.setStyle(oppositesection.encodeStyle());
                        mysection.setBranch(direction, tile.getRiver().getMagnitude());
                    }
                    tile.getRiver().setStyle(mysection.encodeStyle());
                }
            }
        }
    }

    public class TileTypeTransform
    extends MapTransform {
        private TileType tileType;

        private TileTypeTransform(TileType tileType) {
            this.tileType = tileType;
        }

        public TileType getTileType() {
            return this.tileType;
        }

        public void transform(Tile t) {
            t.setType(this.tileType);
            t.removeLostCityRumour();
        }
    }

    public abstract class MapTransform {
        private JPanel descriptionPanel = null;

        public abstract void transform(Tile var1);

        public JPanel getDescriptionPanel() {
            return this.descriptionPanel;
        }

        public void setDescriptionPanel(JPanel descriptionPanel) {
            this.descriptionPanel = descriptionPanel;
        }
    }
}

