/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.LayoutManager;
import java.util.logging.Logger;
import javax.swing.JLabel;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;

public final class IndianSettlementPanel
extends FreeColPanel {
    private static final Logger logger = Logger.getLogger(IndianSettlementPanel.class.getName());

    public IndianSettlementPanel(Canvas canvas, IndianSettlement settlement) {
        super(canvas);
        String sale;
        this.setLayout((LayoutManager)new MigLayout("wrap 2, gapx 20", "", ""));
        JLabel settlementLabel = new JLabel(canvas.getImageIcon(settlement, false));
        Player indian = settlement.getOwner();
        Player player = this.getMyPlayer();
        boolean visited = player.hasVisited(settlement);
        String text = Messages.message(settlement.getNameFor(player)) + ", " + Messages.message(StringTemplate.template(settlement.isCapital() ? "indianCapital" : "indianSettlement").addStringTemplate("%nation%", indian.getNationName()));
        String messageId = settlement.getShortAlarmLevelMessageId(player);
        text = text + " (" + Messages.message(messageId) + ")";
        settlementLabel.setText(text);
        this.add(settlementLabel);
        Unit missionary = settlement.getMissionary();
        if (missionary != null) {
            String missionaryName = Messages.message(StringTemplate.template("model.unit.nationUnit").addStringTemplate("%nation%", missionary.getOwner().getNationName()).addStringTemplate("%unit%", missionary.getLabel()));
            this.add(new JLabel(missionaryName, canvas.getImageIcon(missionary, true), 0));
        }
        this.add((Component)this.localizedLabel("indianSettlement.learnableSkill"), "newline");
        UnitType skillType = settlement.getLearnableSkill();
        if (visited) {
            if (skillType == null) {
                this.add(this.localizedLabel("indianSettlement.skillNone"));
            } else {
                this.add(new JLabel(Messages.message(skillType.getNameKey()), canvas.getImageIcon(skillType, true), 0));
            }
        } else {
            this.add(this.localizedLabel("indianSettlement.skillUnknown"));
        }
        GoodsType[] wantedGoods = settlement.getWantedGoods();
        this.add((Component)this.localizedLabel("indianSettlement.highlyWanted"), "newline");
        if (!visited) {
            this.add(this.localizedLabel("indianSettlement.wantedGoodsUnknown"));
        } else {
            sale = player.getLastSaleString(settlement, wantedGoods[0]);
            this.add(new JLabel(Messages.message(wantedGoods[0].getNameKey()) + (sale == null ? "" : " " + sale), canvas.getImageIcon(wantedGoods[0], false), 0));
        }
        this.add((Component)this.localizedLabel("indianSettlement.otherWanted"), "newline");
        if (!visited) {
            this.add(this.localizedLabel("indianSettlement.wantedGoodsUnknown"));
        } else {
            int i;
            int n = 1;
            for (i = 2; i < wantedGoods.length; ++i) {
                if (wantedGoods[i] == null) continue;
                ++n;
            }
            sale = player.getLastSaleString(settlement, wantedGoods[1]);
            this.add((Component)new JLabel(Messages.message(wantedGoods[1].getNameKey()) + (sale == null ? "" : " " + sale), canvas.getImageIcon(wantedGoods[1], false), 0), "split " + Integer.toString(n));
            for (i = 2; i < wantedGoods.length; ++i) {
                if (wantedGoods[i] == null) continue;
                sale = player.getLastSaleString(settlement, wantedGoods[i]);
                this.add(new JLabel(Messages.message(wantedGoods[i].getNameKey()) + (sale == null ? "" : " " + sale), canvas.getImageIcon(wantedGoods[i], false), 0));
            }
        }
        this.add((Component)this.okButton, "newline 20, span, tag ok");
        this.setSize(this.getPreferredSize());
    }
}

