/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.ColopediaTreeCellRenderer;
import net.sf.freecol.client.gui.panel.ColopediaTreeItem;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.common.model.Ability;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.AbstractUnit;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.BuildingType;
import net.sf.freecol.common.model.EquipmentType;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.EuropeanNationType;
import net.sf.freecol.common.model.Feature;
import net.sf.freecol.common.model.FoundingFather;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.IndianNationType;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.NationType;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.ResourceType;
import net.sf.freecol.common.model.Scope;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.TileImprovementType;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.resources.ResourceManager;
import net.sf.freecol.common.util.RandomChoice;
import net.sf.freecol.common.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ColopediaPanel
extends FreeColPanel
implements TreeSelectionListener {
    private static final Logger logger = Logger.getLogger(ColopediaPanel.class.getName());
    private static final Font arrowFont = ResourceManager.getFont("SimpleFont", 1, 24.0f);
    private static final DecimalFormat modifierFormat = new DecimalFormat("0.##");
    private final String none;
    private static final int MODIFIERS_PER_ROW = 5;
    private JLabel header;
    private JPanel listPanel;
    private JPanel detailPanel;
    private JTree tree;
    private Map<String, DefaultMutableTreeNode> nodeMap = new HashMap<String, DefaultMutableTreeNode>();

    public ColopediaPanel(Canvas parent, PanelType panelType, FreeColGameObjectType objectType) {
        super(parent);
        if (panelType == null) {
            panelType = this.getPanelType(objectType);
        }
        this.none = Messages.message("none");
        this.setLayout((LayoutManager)new MigLayout("fill", "[200:]unrelated[550:, grow, fill]", "[][grow, fill][]"));
        this.header = ColopediaPanel.getDefaultHeader(Messages.message("menuBar.colopedia"));
        this.add((Component)this.header, "span, align center");
        this.listPanel = new JPanel(){

            public String getUIClassID() {
                return "ColopediaPanelUI";
            }
        };
        this.listPanel.setOpaque(true);
        JScrollPane sl = new JScrollPane(this.listPanel, 22, 30);
        sl.getVerticalScrollBar().setUnitIncrement(16);
        sl.getViewport().setOpaque(false);
        this.add(sl);
        this.detailPanel = new JPanel(){

            public String getUIClassID() {
                return "ColopediaPanelUI";
            }
        };
        this.detailPanel.setOpaque(true);
        JScrollPane detail = new JScrollPane(this.detailPanel, 20, 31);
        detail.getVerticalScrollBar().setUnitIncrement(16);
        detail.getViewport().setOpaque(false);
        this.add((Component)detail, "grow");
        this.add((Component)this.okButton, "newline 20, span, tag ok");
        this.restoreSavedSize(850, 600);
        this.tree = this.buildTree();
        this.initialize(panelType, objectType);
    }

    public void initialize(PanelType panelType, FreeColGameObjectType type) {
        this.detailPanel.removeAll();
        DefaultMutableTreeNode node = this.nodeMap.get(panelType.toString());
        this.tree.expandPath(new TreePath(node.getPath()));
        this.selectDetail(panelType, type);
        this.detailPanel.validate();
    }

    public void initialize(FreeColGameObjectType type) {
        this.initialize(this.getPanelType(type), type);
    }

    public PanelType getPanelType(FreeColGameObjectType type) {
        if (type instanceof TileType) {
            return PanelType.TERRAIN;
        }
        if (type instanceof ResourceType) {
            return PanelType.RESOURCES;
        }
        if (type instanceof UnitType) {
            if (((UnitType)type).hasSkill()) {
                return PanelType.SKILLS;
            }
            return PanelType.UNITS;
        }
        if (type instanceof GoodsType) {
            return PanelType.GOODS;
        }
        if (type instanceof BuildingType) {
            return PanelType.BUILDINGS;
        }
        if (type instanceof FoundingFather) {
            return PanelType.FATHERS;
        }
        if (type instanceof Nation) {
            return PanelType.NATIONS;
        }
        if (type instanceof NationType) {
            return PanelType.NATION_TYPES;
        }
        return null;
    }

    public void selectDetail(PanelType panelType, FreeColGameObjectType type) {
        this.detailPanel.removeAll();
        if (type != null) {
            switch (panelType) {
                case TERRAIN: {
                    this.buildTerrainDetail((TileType)type);
                    break;
                }
                case RESOURCES: {
                    this.buildResourceDetail((ResourceType)type);
                    break;
                }
                case UNITS: 
                case SKILLS: {
                    this.buildUnitDetail((UnitType)type);
                    break;
                }
                case GOODS: {
                    this.buildGoodsDetail((GoodsType)type);
                    break;
                }
                case BUILDINGS: {
                    this.buildBuildingDetail((BuildingType)type);
                    break;
                }
                case FATHERS: {
                    this.buildFatherDetail((FoundingFather)type);
                    break;
                }
                case NATIONS: {
                    this.buildNationDetail((Nation)type);
                    break;
                }
                case NATION_TYPES: {
                    if (type instanceof EuropeanNationType) {
                        this.buildEuropeanNationTypeDetail((EuropeanNationType)type);
                        break;
                    }
                    if (!(type instanceof IndianNationType)) break;
                    this.buildIndianNationTypeDetail((IndianNationType)type);
                    break;
                }
            }
        }
    }

    private JTree buildTree() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(new ColopediaTreeItem(null, Messages.message("menuBar.colopedia")));
        DefaultMutableTreeNode terrain = new DefaultMutableTreeNode(new ColopediaTreeItem(PanelType.TERRAIN));
        this.buildTerrainSubtree(terrain);
        root.add(terrain);
        this.nodeMap.put(PanelType.TERRAIN.toString(), terrain);
        root.add(this.buildSubTree(PanelType.RESOURCES, this.getSpecification().getResourceTypeList(), 0.75));
        root.add(this.buildSubTree(PanelType.GOODS, this.getSpecification().getGoodsTypeList(), 0.75));
        ArrayList<UnitType> units = new ArrayList<UnitType>();
        ArrayList<UnitType> skills = new ArrayList<UnitType>();
        for (UnitType u : this.getSpecification().getUnitTypeList()) {
            if (u.getSkill() <= 0 || u.hasAbility("model.ability.expertSoldier")) {
                units.add(u);
                continue;
            }
            skills.add(u);
        }
        root.add(this.buildSubTree(PanelType.UNITS, units, 0.5));
        root.add(this.buildSubTree(PanelType.SKILLS, skills, 0.5));
        DefaultMutableTreeNode buildings = new DefaultMutableTreeNode(new ColopediaTreeItem(PanelType.BUILDINGS));
        this.buildBuildingSubtree(buildings);
        root.add(buildings);
        this.nodeMap.put(PanelType.BUILDINGS.toString(), buildings);
        DefaultMutableTreeNode fathers = new DefaultMutableTreeNode(new ColopediaTreeItem(PanelType.FATHERS));
        this.buildFathersSubtree(fathers);
        root.add(fathers);
        this.nodeMap.put(PanelType.FATHERS.toString(), fathers);
        ArrayList<Nation> nations = new ArrayList<Nation>();
        nations.addAll(this.getSpecification().getEuropeanNations());
        nations.addAll(this.getSpecification().getIndianNations());
        root.add(this.buildSubTree(PanelType.NATIONS, nations, 0.5));
        DefaultMutableTreeNode nationTypes = new DefaultMutableTreeNode(new ColopediaTreeItem(PanelType.NATION_TYPES));
        this.buildNationTypesSubtree(nationTypes);
        root.add(nationTypes);
        this.nodeMap.put(PanelType.NATION_TYPES.toString(), nationTypes);
        DefaultTreeModel treeModel = new DefaultTreeModel(root);
        this.tree = new JTree(treeModel){

            public Dimension getPreferredSize() {
                return new Dimension(200, super.getPreferredSize().height);
            }
        };
        this.tree.setRootVisible(false);
        this.tree.setCellRenderer(new ColopediaTreeCellRenderer());
        this.tree.setOpaque(false);
        this.tree.addTreeSelectionListener(this);
        this.listPanel.add(this.tree);
        return this.tree;
    }

    private <T extends FreeColGameObjectType> DefaultMutableTreeNode buildSubTree(PanelType panelType, List<T> types, double scale) {
        DefaultMutableTreeNode parent = new DefaultMutableTreeNode(new ColopediaTreeItem(panelType));
        int width = 0;
        int height = 0;
        for (FreeColGameObjectType type : types) {
            Image image = this.getLibrary().getImage(type, scale);
            width = Math.max(image.getWidth(null), width);
            height = Math.max(image.getHeight(null), height);
        }
        for (FreeColGameObjectType type : types) {
            BufferedImage centeredImage = new BufferedImage(width, height, 2);
            Image image = this.getLibrary().getImage(type, scale);
            int x = (width - image.getWidth(null)) / 2;
            int y = (height - image.getHeight(null)) / 2;
            centeredImage.getGraphics().drawImage(image, x, y, null);
            parent.add(this.buildItem(type, new ImageIcon(centeredImage)));
        }
        this.nodeMap.put(panelType.toString(), parent);
        return parent;
    }

    private void buildTerrainSubtree(DefaultMutableTreeNode parent) {
        for (TileType t : this.getSpecification().getTileTypeList()) {
            ImageIcon icon = new ImageIcon(this.getLibrary().getCompoundTerrainImage(t, 0.25));
            parent.add(this.buildItem(t, icon));
        }
    }

    private void buildBuildingSubtree(DefaultMutableTreeNode parent) {
        Image buildingImage = ResourceManager.getImage("Colopedia.buildingSection.image");
        ImageIcon buildingIcon = new ImageIcon(buildingImage != null ? buildingImage : null);
        ArrayList<BuildingType> buildingTypes = new ArrayList<BuildingType>();
        HashMap<BuildingType, DefaultMutableTreeNode> buildingHash = new HashMap<BuildingType, DefaultMutableTreeNode>();
        for (BuildingType buildingType : this.getSpecification().getBuildingTypeList()) {
            if (buildingType.getUpgradesFrom() == null) {
                String name = Messages.message(buildingType.getNameKey());
                DefaultMutableTreeNode item = new DefaultMutableTreeNode(new ColopediaTreeItem(buildingType, name, buildingIcon));
                buildingHash.put(buildingType, item);
                parent.add(item);
                this.nodeMap.put(buildingType.getId(), item);
                continue;
            }
            buildingTypes.add(buildingType);
        }
        while (!buildingTypes.isEmpty()) {
            Iterator iterator = buildingTypes.iterator();
            while (iterator.hasNext()) {
                BuildingType buildingType;
                buildingType = (BuildingType)iterator.next();
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)buildingHash.get(buildingType.getUpgradesFrom());
                if (node == null) continue;
                String name = Messages.message(buildingType.getNameKey());
                DefaultMutableTreeNode item = new DefaultMutableTreeNode(new ColopediaTreeItem(buildingType, name, buildingIcon));
                node.add(item);
                this.nodeMap.put(buildingType.getId(), item);
                buildingHash.put(buildingType, item);
                iterator.remove();
            }
        }
    }

    private void buildFathersSubtree(DefaultMutableTreeNode parent) {
        EnumMap fathersByType = new EnumMap(FoundingFather.FoundingFatherType.class);
        for (FoundingFather.FoundingFatherType fatherType : FoundingFather.FoundingFatherType.values()) {
            fathersByType.put(fatherType, new ArrayList());
        }
        for (FoundingFather foundingFather : this.getSpecification().getFoundingFathers()) {
            ((List)fathersByType.get((Object)foundingFather.getType())).add(foundingFather);
        }
        for (FoundingFather.FoundingFatherType fatherType : FoundingFather.FoundingFatherType.values()) {
            String typeName = Messages.message(FoundingFather.getTypeKey(fatherType));
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(new ColopediaTreeItem(PanelType.FATHERS, typeName));
            parent.add(node);
            this.nodeMap.put(fatherType.toString(), node);
            for (FoundingFather father : (List)fathersByType.get((Object)fatherType)) {
                ImageIcon icon = new ImageIcon(ResourceManager.getImage("model.goods.bells.image", 0.75));
                node.add(this.buildItem(father, icon));
            }
        }
    }

    private void buildNationTypesSubtree(DefaultMutableTreeNode parent) {
        ArrayList<NationType> nations = new ArrayList<NationType>();
        nations.addAll(this.getSpecification().getEuropeanNationTypes());
        nations.addAll(this.getSpecification().getREFNationTypes());
        nations.addAll(this.getSpecification().getIndianNationTypes());
        for (NationType type : nations) {
            ImageIcon icon = new ImageIcon(ResourceManager.getImage("model.goods.bells.image", 0.75));
            parent.add(this.buildItem(type, icon));
        }
    }

    private DefaultMutableTreeNode buildItem(FreeColGameObjectType type, ImageIcon icon) {
        String name = Messages.getName(type);
        DefaultMutableTreeNode item = new DefaultMutableTreeNode(new ColopediaTreeItem(type, name, icon));
        this.nodeMap.put(type.getId(), item);
        return item;
    }

    private JButton getButton(FreeColGameObjectType type, String text, ImageIcon icon) {
        JButton button = ColopediaPanel.getLinkButton(text == null ? Messages.getName(type) : text, icon, type.getId());
        button.addActionListener(this);
        return button;
    }

    private JButton getButton(FreeColGameObjectType type) {
        return this.getButton(type, null, null);
    }

    private JButton getResourceButton(ResourceType resourceType) {
        return this.getButton(resourceType, null, this.getLibrary().getBonusImageIcon(resourceType));
    }

    private JButton getGoodsButton(GoodsType goodsType) {
        return this.getGoodsButton(goodsType, null);
    }

    private JButton getGoodsButton(GoodsType goodsType, int amount) {
        return this.getGoodsButton(goodsType, Integer.toString(amount));
    }

    private JButton getGoodsButton(GoodsType goodsType, String text) {
        JButton result = this.getButton(goodsType, text, this.getLibrary().getGoodsImageIcon(goodsType));
        result.setToolTipText(Messages.getName(goodsType));
        return result;
    }

    private JButton getUnitButton(AbstractUnit unit) {
        return this.getUnitButton(unit.getUnitType(this.getSpecification()), unit.getRole());
    }

    private JButton getUnitButton(UnitType unitType, Unit.Role role) {
        ImageIcon unitIcon = this.getLibrary().getUnitImageIcon(unitType, role, 0.66);
        JButton unitButton = this.getButton(unitType, null, unitIcon);
        unitButton.setHorizontalAlignment(2);
        return unitButton;
    }

    private JButton getUnitButton(UnitType unitType) {
        return this.getUnitButton(unitType, Unit.Role.DEFAULT);
    }

    private void buildTerrainDetail(TileType tileType) {
        this.detailPanel.setLayout((LayoutManager)new MigLayout("wrap 4, gap 20"));
        String movementCost = String.valueOf(tileType.getBasicMoveCost() / 3);
        String defenseBonus = this.none;
        Set<Modifier> defenceModifiers = tileType.getDefenceBonus();
        if (!defenceModifiers.isEmpty()) {
            defenseBonus = this.getModifierAsString(defenceModifiers.iterator().next());
        }
        JLabel nameLabel = this.localizedLabel(tileType.getNameKey());
        nameLabel.setFont(smallHeaderFont);
        this.detailPanel.add((Component)nameLabel, "span, align center");
        this.detailPanel.add((Component)this.localizedLabel("colopedia.terrain.terrainImage"), "spany 3");
        Image terrainImage = this.getLibrary().getCompoundTerrainImage(tileType, 1.0);
        this.detailPanel.add((Component)new JLabel(new ImageIcon(terrainImage)), "spany 3");
        List<ResourceType> resourceList = tileType.getResourceTypeList();
        if (resourceList.size() > 0) {
            this.detailPanel.add(this.localizedLabel("colopedia.terrain.resource"));
            if (resourceList.size() > 1) {
                this.detailPanel.add((Component)this.getResourceButton(resourceList.get(0)), "split " + resourceList.size());
                for (int index = 1; index < resourceList.size(); ++index) {
                    this.detailPanel.add(this.getResourceButton(resourceList.get(index)));
                }
            } else {
                this.detailPanel.add(this.getResourceButton(resourceList.get(0)));
            }
        } else {
            this.detailPanel.add((Component)new JLabel(), "wrap");
        }
        this.detailPanel.add(this.localizedLabel("colopedia.terrain.movementCost"));
        this.detailPanel.add(new JLabel(movementCost));
        this.detailPanel.add(this.localizedLabel("colopedia.terrain.defenseBonus"));
        this.detailPanel.add(new JLabel(defenseBonus));
        this.detailPanel.add(this.localizedLabel("colopedia.terrain.production"));
        List<AbstractGoods> production = tileType.getProduction();
        if (production.size() > 0) {
            AbstractGoods goods = production.get(0);
            if (production.size() > 1) {
                this.detailPanel.add((Component)this.getGoodsButton(goods.getType(), goods.getAmount()), "span, split " + production.size());
                for (int index = 1; index < production.size(); ++index) {
                    goods = production.get(index);
                    this.detailPanel.add(this.getGoodsButton(goods.getType(), goods.getAmount()));
                }
            } else {
                this.detailPanel.add((Component)this.getGoodsButton(goods.getType(), goods.getAmount()), "span");
            }
        } else {
            this.detailPanel.add((Component)new JLabel(), "wrap");
        }
        this.detailPanel.add(this.localizedLabel("colopedia.terrain.description"));
        this.detailPanel.add((Component)ColopediaPanel.getDefaultTextArea(Messages.message(tileType.getDescriptionKey()), 20), "span, growx");
        this.detailPanel.revalidate();
        this.detailPanel.repaint();
    }

    private void buildResourceDetail(ResourceType type) {
        this.detailPanel.setLayout((LayoutManager)new MigLayout("wrap 2", "[]20[]"));
        JLabel name = this.localizedLabel(type.getNameKey());
        name.setFont(smallHeaderFont);
        this.detailPanel.add((Component)name, "span, align center, wrap 40");
        Set<Modifier> modifiers = type.getFeatureContainer().getModifiers();
        this.detailPanel.add(this.localizedLabel("colopedia.resource.bonusProduction"));
        JPanel goodsPanel = new JPanel();
        goodsPanel.setOpaque(false);
        for (Modifier modifier : modifiers) {
            String text = this.getModifierAsString(modifier);
            if (modifier.hasScope()) {
                ArrayList<String> scopeStrings = new ArrayList<String>();
                for (Scope scope : modifier.getScopes()) {
                    if (scope.getType() == null) continue;
                    FreeColGameObjectType objectType = this.getSpecification().getType(scope.getType());
                    scopeStrings.add(Messages.message(objectType.getNameKey()));
                }
                if (!scopeStrings.isEmpty()) {
                    text = text + " (" + Utils.join(", ", scopeStrings) + ")";
                }
            }
            GoodsType goodsType = this.getSpecification().getGoodsType(modifier.getId());
            JButton goodsButton = this.getGoodsButton(goodsType, text);
            goodsPanel.add(goodsButton);
        }
        this.detailPanel.add(goodsPanel);
        this.detailPanel.add((Component)this.localizedLabel("colopedia.resource.description"), "newline 20");
        this.detailPanel.add((Component)ColopediaPanel.getDefaultTextArea(Messages.message(type.getDescriptionKey()), 30), "growx");
        this.detailPanel.revalidate();
        this.detailPanel.repaint();
    }

    private void buildUnitDetail(UnitType type) {
        Player player;
        this.detailPanel.setLayout((LayoutManager)new MigLayout("wrap 4", "[]20[]40[]20[]"));
        JLabel name = this.localizedLabel(type.getNameKey());
        name.setFont(smallHeaderFont);
        this.detailPanel.add((Component)name, "span, align center, wrap 40");
        this.detailPanel.add(this.localizedLabel("colopedia.unit.offensivePower"));
        this.detailPanel.add((Component)new JLabel(Integer.toString(type.getOffence())), "right");
        this.detailPanel.add(this.localizedLabel("colopedia.unit.defensivePower"));
        this.detailPanel.add((Component)new JLabel(Integer.toString(type.getDefence())), "right");
        this.detailPanel.add(this.localizedLabel("colopedia.unit.movement"));
        this.detailPanel.add((Component)new JLabel(String.valueOf(type.getMovement() / 3)), "right");
        if (type.canCarryGoods() || type.canCarryUnits()) {
            this.detailPanel.add(this.localizedLabel("colopedia.unit.capacity"));
            this.detailPanel.add((Component)new JLabel(Integer.toString(type.getSpace())), "right");
        }
        Europe europe = (player = this.getMyPlayer()) == null ? null : player.getEurope();
        String price = null;
        if (europe != null && europe.getUnitPrice(type) > 0) {
            price = Integer.toString(europe.getUnitPrice(type));
        } else if (type.getPrice() > 0) {
            price = Integer.toString(type.getPrice());
        }
        if (price != null) {
            this.detailPanel.add(this.localizedLabel("colopedia.unit.price"));
            this.detailPanel.add((Component)new JLabel(price), "right");
        }
        if (type.hasSkill()) {
            this.detailPanel.add(this.localizedLabel("colopedia.unit.skill"));
            this.detailPanel.add((Component)new JLabel(Integer.toString(type.getSkill())), "right");
            ArrayList<BuildingType> schools = new ArrayList<BuildingType>();
            for (BuildingType buildingType : this.getSpecification().getBuildingTypeList()) {
                if (!buildingType.hasAbility("model.ability.teach") || !buildingType.canAdd(type)) continue;
                schools.add(buildingType);
            }
            if (!schools.isEmpty()) {
                this.detailPanel.add((Component)this.localizedLabel("colopedia.unit.school"), "newline");
                int count = 0;
                for (BuildingType school : schools) {
                    JButton label = this.getButton(school);
                    if (count > 0 && count % 3 == 0) {
                        this.detailPanel.add((Component)label, "skip");
                    } else {
                        this.detailPanel.add(label);
                    }
                    ++count;
                }
            }
            ArrayList<IndianNationType> nations = new ArrayList<IndianNationType>();
            for (IndianNationType nation : this.getSpecification().getIndianNationTypes()) {
                for (RandomChoice randomChoice : nation.getSkills()) {
                    if (randomChoice.getObject() != type) continue;
                    nations.add(nation);
                }
            }
            if (!nations.isEmpty()) {
                this.detailPanel.add((Component)this.localizedLabel("colopedia.unit.natives"), "newline");
                int count = 0;
                for (IndianNationType nation : nations) {
                    JButton jButton = this.getButton(nation);
                    if (count > 0 && count % 3 == 0) {
                        this.detailPanel.add((Component)jButton, "skip");
                    } else {
                        this.detailPanel.add(jButton);
                    }
                    ++count;
                }
            }
        }
        if (!type.getAbilitiesRequired().isEmpty()) {
            this.detailPanel.add((Component)this.localizedLabel("colopedia.unit.requirements"), "newline, top");
            String key = type.getAbilitiesRequired().keySet().iterator().next();
            try {
                JTextPane textPane = ColopediaPanel.getDefaultTextPane();
                StyledDocument doc = textPane.getStyledDocument();
                this.appendRequiredAbilities(doc, type);
                this.detailPanel.add((Component)textPane, "span, width 70%");
            }
            catch (BadLocationException e) {
                logger.warning(e.toString());
            }
        }
        ArrayList<Modifier> bonusList = new ArrayList<Modifier>();
        for (GoodsType goodsType : this.getSpecification().getGoodsTypeList()) {
            bonusList.addAll(type.getModifierSet(goodsType.getId()));
        }
        int bonusNumber = bonusList.size();
        if (bonusNumber > 0) {
            StringTemplate template = StringTemplate.template("colopedia.unit.productionBonus").addAmount("%number%", bonusNumber);
            this.detailPanel.add((Component)this.localizedLabel(template), "newline 20, top");
            JPanel productionPanel = new JPanel(new GridLayout(0, 5));
            productionPanel.setOpaque(false);
            for (Modifier modifier : bonusList) {
                GoodsType goodsType = this.getSpecification().getGoodsType(modifier.getId());
                String bonus = this.getModifierAsString(modifier);
                productionPanel.add(this.getGoodsButton(goodsType, bonus));
            }
            this.detailPanel.add((Component)productionPanel, "span");
        }
        if (!type.getGoodsRequired().isEmpty()) {
            this.detailPanel.add((Component)this.localizedLabel("colopedia.unit.goodsRequired"), "newline 20");
            AbstractGoods goods = type.getGoodsRequired().get(0);
            if (type.getGoodsRequired().size() > 1) {
                this.detailPanel.add((Component)this.getGoodsButton(goods.getType(), goods.getAmount()), "span, split " + type.getGoodsRequired().size());
                for (int index = 1; index < type.getGoodsRequired().size(); ++index) {
                    goods = type.getGoodsRequired().get(index);
                    this.detailPanel.add(this.getGoodsButton(goods.getType(), goods.getAmount()));
                }
            } else {
                this.detailPanel.add(this.getGoodsButton(goods.getType(), goods.getAmount()));
            }
        }
        this.detailPanel.add((Component)this.localizedLabel("colopedia.unit.description"), "newline 20");
        this.detailPanel.add((Component)ColopediaPanel.getDefaultTextArea(Messages.message(type.getDescriptionKey()), 30), "span");
        this.detailPanel.revalidate();
        this.detailPanel.repaint();
    }

    private void buildGoodsDetail(GoodsType type) {
        this.detailPanel.setLayout((LayoutManager)new MigLayout("wrap 4", "[]20[]"));
        JLabel name = this.localizedLabel(type.getNameKey());
        name.setFont(smallHeaderFont);
        this.detailPanel.add((Component)name, "span, align center, wrap 40");
        if (type.isFarmed()) {
            ArrayList<TileImprovementType> improvements = new ArrayList<TileImprovementType>();
            ArrayList<Modifier> modifiers = new ArrayList<Modifier>();
            for (TileImprovementType improvementType : this.getSpecification().getTileImprovementTypeList()) {
                Modifier productionModifier = improvementType.getProductionModifier(type);
                if (productionModifier == null) continue;
                improvements.add(improvementType);
                modifiers.add(productionModifier);
            }
            this.detailPanel.add((Component)this.localizedLabel("colopedia.goods.improvedBy"), "newline 20, top");
            if (improvements.size() == 0) {
                this.detailPanel.add((Component)new JLabel(this.none), "span");
            } else {
                for (int index = 0; index < improvements.size(); ++index) {
                    String constraints = index == 0 ? "span" : "skip, span";
                    this.detailPanel.add((Component)this.localizedLabel(StringTemplate.template("colopedia.goods.improvement").addName("%name%", (FreeColObject)improvements.get(index)).addName("%amount%", this.getModifierAsString((Modifier)modifiers.get(index)))), constraints);
                }
            }
        } else {
            this.detailPanel.add((Component)this.localizedLabel("colopedia.goods.madeFrom"), "newline 20");
            if (type.isRefined()) {
                this.detailPanel.add((Component)this.getGoodsButton(type.getRawMaterial()), "span");
            } else {
                this.detailPanel.add((Component)this.localizedLabel("nothing"), "span");
            }
        }
        this.detailPanel.add((Component)this.localizedLabel("colopedia.goods.makes"), "newline 20");
        if (type.isRawMaterial()) {
            this.detailPanel.add((Component)this.getGoodsButton(type.getProducedMaterial()), "span");
        } else if (type.getStoredAs() != type) {
            this.detailPanel.add((Component)this.getGoodsButton(type.getStoredAs()), "span");
        } else if (!type.isBuildingMaterial()) {
            this.detailPanel.add((Component)this.localizedLabel("nothing"), "span");
        }
        if (type.isBuildingMaterial()) {
            JComponent label;
            ArrayList buildingTypes = new ArrayList();
            boolean allTypes = this.filterBuildables(this.getSpecification().getBuildingTypeList(), buildingTypes, type);
            if (buildingTypes.size() > 0) {
                this.detailPanel.add((Component)this.localizedLabel("colopedia.goods.buildings"), "newline 20");
                if (allTypes) {
                    JButton button = ColopediaPanel.getLinkButton(Messages.message("colopedia.goods.allBuildings"), null, PanelType.BUILDINGS.toString());
                    button.addActionListener(this);
                    this.detailPanel.add((Component)button, "span");
                } else {
                    int count = 0;
                    for (BuildingType building : buildingTypes) {
                        JButton label2 = this.getButton(building);
                        if (count > 0 && count % 3 == 0) {
                            this.detailPanel.add((Component)label2, "skip");
                        } else {
                            this.detailPanel.add(label2);
                        }
                        ++count;
                    }
                }
            }
            ArrayList equipmentTypes = new ArrayList();
            allTypes = this.filterBuildables(this.getSpecification().getEquipmentTypeList(), equipmentTypes, type);
            if (equipmentTypes.size() > 0) {
                this.detailPanel.add((Component)this.localizedLabel("colopedia.goods.equipment"), "newline 20");
                EnumSet<Unit.Role> roles = EnumSet.noneOf(Unit.Role.class);
                for (EquipmentType equipment : equipmentTypes) {
                    roles.add(equipment.getRole());
                }
                if (roles.contains((Object)Unit.Role.SOLDIER) || roles.contains((Object)Unit.Role.SCOUT)) {
                    roles.add(Unit.Role.DRAGOON);
                }
                int count = 0;
                for (Unit.Role role : roles) {
                    label = this.localizedLabel("model.unit.role." + role.getId());
                    if (count > 0 && count % 3 == 0) {
                        this.detailPanel.add((Component)label, "skip");
                    } else {
                        this.detailPanel.add(label);
                    }
                    ++count;
                }
            }
            ArrayList unitTypes = new ArrayList();
            allTypes = this.filterBuildables(this.getSpecification().getUnitTypeList(), unitTypes, type);
            if (unitTypes.size() > 0) {
                this.detailPanel.add((Component)this.localizedLabel("colopedia.goods.units"), "newline 20");
                if (allTypes) {
                    JButton button = ColopediaPanel.getLinkButton(Messages.message("colopedia.goods.allUnits"), null, PanelType.UNITS.toString());
                    button.addActionListener(this);
                    this.detailPanel.add((Component)button, "span");
                } else {
                    int count = 0;
                    for (UnitType unit : unitTypes) {
                        label = this.getButton(unit);
                        if (count > 0 && count % 3 == 0) {
                            this.detailPanel.add((Component)label, "skip");
                        } else {
                            this.detailPanel.add(label);
                        }
                        ++count;
                    }
                }
            }
        }
        this.detailPanel.add((Component)this.localizedLabel("colopedia.goods.description"), "newline 20");
        this.detailPanel.add((Component)ColopediaPanel.getDefaultTextArea(Messages.message(type.getDescriptionKey()), 30), "span, growx");
        this.detailPanel.revalidate();
        this.detailPanel.repaint();
    }

    private <T extends BuildableType> boolean filterBuildables(List<T> input, List<T> output, GoodsType type) {
        boolean result = true;
        block0: for (BuildableType buildableType : input) {
            if (buildableType.getGoodsRequired().isEmpty()) continue;
            for (AbstractGoods goods : buildableType.getGoodsRequired()) {
                if (type != goods.getType()) continue;
                output.add(buildableType);
                continue block0;
            }
            result = false;
        }
        return result;
    }

    private void buildBuildingDetail(BuildingType buildingType) {
        this.detailPanel.setLayout((LayoutManager)new MigLayout("wrap 7, gapx 20", "", ""));
        JLabel name = this.localizedLabel(buildingType.getNameKey());
        name.setFont(smallHeaderFont);
        this.detailPanel.add((Component)name, "span, align center, wrap 40");
        JTextPane textPane = ColopediaPanel.getDefaultTextPane();
        StyledDocument doc = textPane.getStyledDocument();
        try {
            if (buildingType.getUpgradesFrom() != null) {
                StyleConstants.setComponent(doc.getStyle("button"), this.getButton(buildingType.getUpgradesFrom()));
                doc.insertString(doc.getLength(), " ", doc.getStyle("button"));
                doc.insertString(doc.getLength(), "\n", doc.getStyle("regular"));
            }
            if (buildingType.getPopulationRequired() > 0) {
                StringTemplate template = StringTemplate.template("colonist").addAmount("%number%", buildingType.getPopulationRequired());
                doc.insertString(doc.getLength(), Messages.message(template) + "\n", doc.getStyle("regular"));
            }
            this.appendRequiredAbilities(doc, buildingType);
            this.detailPanel.add((Component)this.localizedLabel("colopedia.buildings.requires"), "top");
            this.detailPanel.add((Component)textPane, "span, growx");
        }
        catch (BadLocationException e) {
            logger.warning(e.toString());
        }
        this.detailPanel.add(this.localizedLabel("colopedia.buildings.cost"));
        if (buildingType.getGoodsRequired().isEmpty()) {
            this.detailPanel.add((Component)this.localizedLabel("colopedia.buildings.autoBuilt"), "span");
        } else {
            AbstractGoods goodsRequired = buildingType.getGoodsRequired().get(0);
            if (buildingType.getGoodsRequired().size() > 1) {
                this.detailPanel.add((Component)this.getGoodsButton(goodsRequired.getType(), goodsRequired.getAmount()), "span, split " + buildingType.getGoodsRequired().size());
                for (int index = 1; index < buildingType.getGoodsRequired().size(); ++index) {
                    goodsRequired = buildingType.getGoodsRequired().get(index);
                    this.detailPanel.add(this.getGoodsButton(goodsRequired.getType(), goodsRequired.getAmount()));
                }
            } else {
                this.detailPanel.add((Component)this.getGoodsButton(goodsRequired.getType(), goodsRequired.getAmount()), "span");
            }
        }
        if (buildingType.hasAbility("model.ability.teach")) {
            this.detailPanel.add((Component)this.localizedLabel("colopedia.buildings.teaches"), "newline, top");
            int count = 0;
            for (UnitType unitType2 : this.getSpecification().getUnitTypeList()) {
                if (!buildingType.canAdd(unitType2)) continue;
                if (count > 0 && count % 3 == 0) {
                    this.detailPanel.add((Component)this.getButton(unitType2), "skip, span 2");
                } else {
                    this.detailPanel.add((Component)this.getButton(unitType2), "span 2");
                }
                ++count;
            }
        } else {
            GoodsType inputType = buildingType.getConsumedGoodsType();
            GoodsType outputType = buildingType.getProducedGoodsType();
            if (outputType != null) {
                this.detailPanel.add((Component)this.localizedLabel("colopedia.buildings.production"), "newline");
                if (inputType != null) {
                    this.detailPanel.add((Component)this.getGoodsButton(inputType), "span, split 3");
                    JLabel arrow = new JLabel("\u2192");
                    arrow.setFont(arrowFont);
                    this.detailPanel.add(arrow);
                }
                this.detailPanel.add(this.getGoodsButton(outputType));
            }
        }
        int workplaces = buildingType.getWorkPlaces();
        this.detailPanel.add((Component)this.localizedLabel("colopedia.buildings.workplaces"), "newline");
        this.detailPanel.add((Component)new JLabel(Integer.toString(workplaces)), "span");
        if (workplaces > 0) {
            this.detailPanel.add((Component)this.localizedLabel("colopedia.buildings.specialist"), "newline");
            UnitType unitType = this.getSpecification().getExpertForProducing(buildingType.getProducedGoodsType());
            if (unitType == null) {
                this.detailPanel.add((Component)new JLabel(this.none), "span");
            } else {
                this.detailPanel.add((Component)this.getUnitButton(unitType), "span");
            }
        }
        Set<Modifier> bonusList = buildingType.getFeatureContainer().getModifiers();
        ArrayList<JComponent> labels = new ArrayList<JComponent>();
        for (Modifier productionBonus : bonusList) {
            JComponent component = this.getModifierComponent(productionBonus);
            if (component instanceof JButton) {
                labels.add(0, component);
                continue;
            }
            labels.add(component);
        }
        Set<Ability> abilities = buildingType.getFeatureContainer().getAbilities();
        for (Ability ability : abilities) {
            JLabel jLabel = this.getAbilityComponent(ability);
            if (jLabel == null) continue;
            labels.add(jLabel);
        }
        if (!labels.isEmpty()) {
            this.detailPanel.add((Component)this.localizedLabel(StringTemplate.template("colopedia.buildings.modifiers").addAmount("%number%", labels.size())), "newline, top");
            int count = 0;
            for (JComponent jComponent : labels) {
                if (count > 0 && count % 2 == 0) {
                    this.detailPanel.add((Component)jComponent, "skip, span 3");
                } else {
                    this.detailPanel.add((Component)jComponent, "span 3");
                }
                ++count;
            }
        }
        this.detailPanel.add((Component)this.localizedLabel("colopedia.buildings.notes"), "newline 20, top");
        this.detailPanel.add((Component)ColopediaPanel.getDefaultTextArea(Messages.message(buildingType.getDescriptionKey()), 20), "span, growx");
        this.detailPanel.revalidate();
        this.detailPanel.repaint();
    }

    private void buildFatherDetail(FoundingFather father) {
        this.detailPanel.setLayout((LayoutManager)new MigLayout("wrap 2, fillx, gapx 20", "", ""));
        JLabel name = new JLabel(Messages.message(father.getNameKey()) + " (" + Messages.message(father.getTypeKey()) + ")");
        name.setFont(smallHeaderFont);
        this.detailPanel.add((Component)name, "span, align center, wrap 40");
        Image image = this.getLibrary().getFoundingFatherImage(father);
        JLabel imageLabel = image != null ? new JLabel(new ImageIcon(image)) : new JLabel();
        this.detailPanel.add((Component)imageLabel, "top");
        String text = Messages.message(father.getDescriptionKey()) + "\n\n" + "[" + Messages.message(father.getId() + ".birthAndDeath") + "] " + Messages.message(father.getId() + ".text");
        JTextArea description = ColopediaPanel.getDefaultTextArea(text, 20);
        this.detailPanel.add((Component)description, "top, growx");
        this.detailPanel.revalidate();
        this.detailPanel.repaint();
    }

    private void buildNationDetail(Nation nation) {
        NationType currentNationType = nation.getType();
        for (Player player : this.getGame().getPlayers()) {
            if (player.getNation() != nation) continue;
            currentNationType = player.getNationType();
            break;
        }
        this.detailPanel.setLayout((LayoutManager)new MigLayout("wrap 3, fillx, gapx 20", "", ""));
        JLabel name = this.localizedLabel(nation.getNameKey());
        name.setFont(smallHeaderFont);
        this.detailPanel.add((Component)name, "span, align center, wrap 40");
        JLabel artLabel = new JLabel(this.getLibrary().getMonarchImageIcon(nation));
        this.detailPanel.add((Component)artLabel, "spany, gap 40, top");
        this.detailPanel.add(this.localizedLabel("colopedia.nation.ruler"));
        this.detailPanel.add(this.localizedLabel(nation.getRulerNameKey()));
        this.detailPanel.add(this.localizedLabel("colopedia.nation.defaultAdvantage"));
        this.detailPanel.add(this.getButton(nation.getType()));
        this.detailPanel.add(this.localizedLabel("colopedia.nation.currentAdvantage"));
        this.detailPanel.add((Component)this.getButton(currentNationType), "wrap push");
        this.detailPanel.revalidate();
        this.detailPanel.repaint();
    }

    private void buildEuropeanNationTypeDetail(EuropeanNationType nationType) {
        Font boldFont = ResourceManager.getFont("SimpleFont", 1, 16.0f);
        Set<Ability> abilities = nationType.getFeatureContainer().getAbilities();
        Set<Modifier> modifiers = nationType.getFeatureContainer().getModifiers();
        this.detailPanel.setLayout((LayoutManager)new MigLayout("wrap 2, gapx 20"));
        JLabel label = this.localizedLabel(nationType.getNameKey());
        label.setFont(smallHeaderFont);
        this.detailPanel.add((Component)label, "span, align center, wrap 40");
        label = this.localizedLabel("colopedia.nationType.units");
        label.setFont(boldFont);
        this.detailPanel.add((Component)label, "wrap");
        List<AbstractUnit> startingUnits = nationType.getStartingUnits();
        if (!startingUnits.isEmpty()) {
            AbstractUnit startingUnit = startingUnits.get(0);
            if (startingUnits.size() > 1) {
                this.detailPanel.add((Component)this.getUnitButton(startingUnit), "span, split " + startingUnits.size());
                for (int index = 1; index < startingUnits.size(); ++index) {
                    startingUnit = startingUnits.get(index);
                    this.detailPanel.add(this.getUnitButton(startingUnit));
                }
            } else {
                this.detailPanel.add(this.getUnitButton(startingUnit));
            }
        }
        if (!abilities.isEmpty()) {
            label = this.localizedLabel("abilities");
            label.setFont(boldFont);
            this.detailPanel.add((Component)label, "newline 20, span");
            for (Ability ability : abilities) {
                this.detailPanel.add(this.getAbilityComponent(ability));
            }
        }
        if (!modifiers.isEmpty()) {
            label = this.localizedLabel("modifiers");
            label.setFont(boldFont);
            this.detailPanel.add((Component)label, "newline 20, span");
            for (Modifier modifier : modifiers) {
                this.detailPanel.add(this.getModifierComponent(modifier));
            }
        }
        this.detailPanel.revalidate();
        this.detailPanel.repaint();
    }

    private void buildIndianNationTypeDetail(IndianNationType nationType) {
        List<RandomChoice<UnitType>> skills = nationType.getSkills();
        this.detailPanel.setLayout((LayoutManager)new MigLayout("wrap 2, gapx 20", "", ""));
        JLabel name = this.localizedLabel(nationType.getNameKey());
        name.setFont(smallHeaderFont);
        this.detailPanel.add((Component)name, "span, align center, wrap 40");
        this.detailPanel.add(this.localizedLabel("colopedia.nationType.aggression"));
        this.detailPanel.add(new JLabel(Messages.message("colopedia.nationType.aggression." + nationType.getAggression().toString().toLowerCase())));
        this.detailPanel.add(this.localizedLabel("colopedia.nationType.numberOfSettlements"));
        this.detailPanel.add(new JLabel(Messages.message("colopedia.nationType.numberOfSettlements." + nationType.getNumberOfSettlements().toString().toLowerCase())));
        this.detailPanel.add(this.localizedLabel("colopedia.nationType.typeOfSettlements"));
        this.detailPanel.add(new JLabel(Messages.message(nationType.getCapitalType().getId() + ".name"), new ImageIcon(this.getLibrary().getSettlementImage(nationType.getCapitalType())), 0));
        ArrayList<String> regionNames = new ArrayList<String>();
        for (String regionName : nationType.getRegionNames()) {
            regionNames.add(Messages.message(regionName + ".name"));
        }
        this.detailPanel.add(this.localizedLabel("colopedia.nationType.regions"));
        this.detailPanel.add(new JLabel(Utils.join(", ", regionNames)));
        this.detailPanel.add((Component)this.localizedLabel("colopedia.nationType.skills"), "top, newline 20");
        GridLayout gridLayout = new GridLayout(0, 2);
        gridLayout.setHgap(10);
        JPanel unitPanel = new JPanel(gridLayout);
        unitPanel.setOpaque(false);
        for (RandomChoice<UnitType> choice : skills) {
            unitPanel.add(this.getUnitButton(choice.getObject()));
        }
        this.detailPanel.add(unitPanel);
        this.detailPanel.revalidate();
        this.detailPanel.repaint();
    }

    @Override
    public void valueChanged(TreeSelectionEvent event) {
        if (event.getSource() == this.tree) {
            DefaultMutableTreeNode node;
            for (DefaultMutableTreeNode parent = node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent(); parent != null; parent = (DefaultMutableTreeNode)parent.getParent()) {
                ColopediaTreeItem parentItem = (ColopediaTreeItem)parent.getUserObject();
                if (parentItem.getPanelType() == null) {
                    continue;
                }
                ColopediaTreeItem nodeItem = (ColopediaTreeItem)node.getUserObject();
                this.selectDetail(parentItem.getPanelType(), nodeItem.getFreeColGameObjectType());
                break;
            }
        }
    }

    public static JTextArea getDefaultTextArea(String text) {
        JTextArea textArea = new JTextArea(text);
        textArea.setOpaque(false);
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        textArea.setFocusable(false);
        textArea.setFont(defaultFont);
        return textArea;
    }

    private String getFeatureName(Feature feature) {
        return Messages.message(feature.getNameKey());
    }

    private String getFeatureAsString(Feature feature) {
        String label = Messages.message(this.getFeatureName(feature)) + ":";
        if (feature.hasScope()) {
            for (Scope scope : feature.getScopes()) {
                String key = null;
                if (scope.getType() != null) {
                    key = scope.getType();
                } else if (scope.getAbilityID() != null) {
                    key = scope.getAbilityID();
                } else if (scope.getMethodName() != null) {
                    key = "model.scope." + scope.getMethodName();
                }
                if (key == null) continue;
                label = label + (scope.isMatchNegated() ? " !" : " ") + Messages.message(key + ".name") + ",";
            }
        }
        return label.substring(0, label.length() - 1);
    }

    public String getModifierAsString(Modifier modifier) {
        String bonus = modifierFormat.format(modifier.getValue());
        switch (modifier.getType()) {
            case ADDITIVE: {
                if (!(modifier.getValue() > 0.0f)) break;
                bonus = "+" + bonus;
                break;
            }
            case PERCENTAGE: {
                if (modifier.getValue() > 0.0f) {
                    bonus = "+" + bonus;
                }
                bonus = bonus + "%";
                break;
            }
            case MULTIPLICATIVE: {
                bonus = "\u00d7" + bonus;
                break;
            }
        }
        return bonus;
    }

    public JComponent getModifierComponent(Modifier modifier) {
        try {
            GoodsType goodsType = this.getSpecification().getGoodsType(modifier.getId());
            String bonus = this.getModifierAsString(modifier);
            return this.getGoodsButton(goodsType, bonus);
        }
        catch (Exception e) {
            JLabel label = new JLabel(this.getFeatureAsString(modifier) + ": " + this.getModifierAsString(modifier));
            label.setToolTipText(Messages.message(modifier.getId() + ".shortDescription"));
            return label;
        }
    }

    public JLabel getAbilityComponent(Ability ability) {
        if (ability.getValue()) {
            JLabel label = new JLabel(this.getFeatureAsString(ability));
            label.setToolTipText(Messages.message(ability.getId() + ".shortDescription"));
            return label;
        }
        return null;
    }

    public void appendRequiredAbilities(StyledDocument doc, BuildableType buildableType) throws BadLocationException {
        for (Map.Entry<String, Boolean> entry : buildableType.getAbilitiesRequired().entrySet()) {
            doc.insertString(doc.getLength(), Messages.message(entry.getKey() + ".name"), doc.getStyle("regular"));
            ArrayList<JButton> requiredTypes = new ArrayList<JButton>();
            for (FreeColGameObjectType type : this.getSpecification().getTypesProviding(entry.getKey(), entry.getValue())) {
                JButton typeButton = this.getButton(type);
                typeButton.addActionListener(this);
                requiredTypes.add(typeButton);
            }
            if (!requiredTypes.isEmpty()) {
                doc.insertString(doc.getLength(), " (", doc.getStyle("regular"));
                StyleConstants.setComponent(doc.getStyle("button"), (Component)requiredTypes.get(0));
                doc.insertString(doc.getLength(), " ", doc.getStyle("button"));
                for (int index = 1; index < requiredTypes.size(); ++index) {
                    JButton button = (JButton)requiredTypes.get(index);
                    doc.insertString(doc.getLength(), " / ", doc.getStyle("regular"));
                    StyleConstants.setComponent(doc.getStyle("button"), button);
                    doc.insertString(doc.getLength(), " ", doc.getStyle("button"));
                }
                doc.insertString(doc.getLength(), ")", doc.getStyle("regular"));
            }
            doc.insertString(doc.getLength(), "\n", doc.getStyle("regular"));
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if ("OK".equals(command)) {
            this.getCanvas().remove(this);
        } else {
            DefaultMutableTreeNode node = this.nodeMap.get(command);
            this.tree.collapsePath(this.tree.getSelectionPath().getParentPath());
            TreePath newPath = new TreePath(node.getPath());
            this.tree.scrollPathToVisible(newPath);
            this.tree.expandPath(newPath);
            try {
                this.initialize(this.getSpecification().getType(command));
            }
            catch (IllegalArgumentException e) {
                this.detailPanel.removeAll();
                this.detailPanel.revalidate();
                this.detailPanel.repaint();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PanelType {
        TERRAIN,
        RESOURCES,
        UNITS,
        GOODS,
        SKILLS,
        BUILDINGS,
        FATHERS,
        NATIONS,
        NATION_TYPES;

    }
}

