/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.option;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.option.OptionUpdater;
import net.sf.freecol.client.gui.panel.FreeColDialog;
import net.sf.freecol.common.option.ListOption;
import net.sf.freecol.common.option.ListOptionSelector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ListOptionUI<T>
extends JPanel
implements OptionUpdater,
PropertyChangeListener {
    private static final Logger logger = Logger.getLogger(ListOptionUI.class.getName());
    private final ListOption<T> option;
    private final JList list;
    private final DefaultListModel listModel;
    private List<ListOptionElement<T>> originalValue;
    private JButton addButton = new JButton(Messages.message("list.add"));
    private JButton removeButton = new JButton(Messages.message("list.remove"));
    private JButton upButton = new JButton(Messages.message("list.up"));
    private JButton downButton = new JButton(Messages.message("list.down"));

    public ListOptionUI(final ListOption<T> option, boolean editable) {
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK), Messages.getName(option)));
        this.option = option;
        this.originalValue = this.createElementList((List<T>)option.getValue());
        this.listModel = new DefaultListModel();
        for (ListOptionElement<T> e : this.createElementList((List<T>)option.getValue())) {
            this.listModel.addElement(e);
        }
        String name = Messages.getName(option);
        String description = Messages.getShortDescription(option);
        this.list = new JList(this.listModel);
        JScrollPane sp = new JScrollPane(this.list);
        this.list.setToolTipText(description != null ? description : name);
        this.list.setEnabled(editable);
        this.add((Component)sp, "Center");
        JPanel buttonPanel = new JPanel(new GridLayout(4, 1));
        buttonPanel.setOpaque(false);
        buttonPanel.add(this.addButton);
        buttonPanel.add(this.removeButton);
        buttonPanel.add(this.upButton);
        buttonPanel.add(this.downButton);
        this.add((Component)buttonPanel, "East");
        sp.setPreferredSize(new Dimension(500, buttonPanel.getPreferredSize().height));
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ListOptionUI.this.showAddElementDialog();
            }
        });
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ListOptionUI.this.listModel.removeElementAt(ListOptionUI.this.list.getSelectedIndex());
            }
        });
        this.upButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ListOptionUI.this.list.getSelectedIndex() == 0) {
                    return;
                }
                int index = ListOptionUI.this.list.getSelectedIndex();
                Object temp = ListOptionUI.this.listModel.getElementAt(index);
                ListOptionUI.this.listModel.setElementAt(ListOptionUI.this.listModel.getElementAt(index - 1), index);
                ListOptionUI.this.listModel.setElementAt(temp, index - 1);
                ListOptionUI.this.list.setSelectedIndex(index - 1);
            }
        });
        this.downButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ListOptionUI.this.list.getSelectedIndex() == ListOptionUI.this.listModel.getSize() - 1) {
                    return;
                }
                int index = ListOptionUI.this.list.getSelectedIndex();
                Object temp = ListOptionUI.this.listModel.getElementAt(index);
                ListOptionUI.this.listModel.setElementAt(ListOptionUI.this.listModel.getElementAt(index + 1), index);
                ListOptionUI.this.listModel.setElementAt(temp, index + 1);
                ListOptionUI.this.list.setSelectedIndex(index + 1);
            }
        });
        this.list.getModel().addListDataListener(new ListDataListener(){

            public void contentsChanged(ListDataEvent e) {
                if (option.isPreviewEnabled() && !option.getValue().equals(ListOptionUI.this.getValue())) {
                    option.setValue(ListOptionUI.this.getValue());
                }
            }

            public void intervalAdded(ListDataEvent e) {
            }

            public void intervalRemoved(ListDataEvent e) {
            }
        });
        option.addPropertyChangeListener(this);
        this.setOpaque(false);
    }

    private void showAddElementDialog() {
        Canvas canvas = FreeCol.getFreeColClient().getCanvas();
        final JButton addButton = new JButton(Messages.message("list.add"));
        final FreeColDialog<Object> addElementDialog = new FreeColDialog<Object>(canvas){

            @Override
            public void requestFocus() {
                addButton.requestFocus();
            }
        };
        addElementDialog.setLayout(new BorderLayout());
        JPanel buttons = new JPanel(new FlowLayout());
        buttons.add(addButton);
        JButton cancelButton = new JButton(Messages.message("cancel"));
        buttons.add(cancelButton);
        addElementDialog.setCancelComponent(cancelButton);
        addElementDialog.add((Component)buttons, "South");
        final JComboBox<Object> mods = new JComboBox<Object>(this.option.getListOptionSelector().getOptions().toArray());
        addElementDialog.add(mods, "Center");
        addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                addElementDialog.setResponse(mods.getSelectedItem());
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                addElementDialog.setResponse(null);
            }
        });
        canvas.addAsFrame(addElementDialog);
        addElementDialog.requestFocus();
        Object response = addElementDialog.getResponse();
        canvas.remove(addElementDialog);
        if (response != null) {
            this.listModel.addElement(new ListOptionElement(response, this.option.getListOptionSelector().toString(response)));
        }
    }

    private List<ListOptionElement<T>> createElementList(List<T> list) {
        ArrayList<ListOptionElement<T>> elementList = new ArrayList<ListOptionElement<T>>(list.size());
        for (T o : list) {
            ListOptionSelector<T> los = this.option.getListOptionSelector();
            ListOptionElement e = new ListOptionElement(o, los.toString(o));
            elementList.add(e);
        }
        return elementList;
    }

    private List<T> createNormalList(List<ListOptionElement<T>> elementList) {
        ArrayList<Object> list = new ArrayList<Object>(elementList.size());
        for (ListOptionElement<T> o : elementList) {
            list.add(((ListOptionElement)o).object);
        }
        return list;
    }

    @Override
    public void rollback() {
        this.option.setValue(this.createNormalList(this.originalValue));
    }

    @Override
    public void unregister() {
        this.option.removePropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        List value;
        if (event.getPropertyName().equals("value") && !((Object)(value = (List)event.getNewValue())).equals(this.getValue())) {
            this.listModel.clear();
            for (ListOptionElement<T> o : this.createElementList(value)) {
                this.listModel.addElement(o);
            }
            this.originalValue = this.createElementList(value);
        }
    }

    @Override
    public void updateOption() {
        this.option.setValue(this.getValue());
    }

    private List<T> getValue() {
        ArrayList<ListOptionElement<T>> l = new ArrayList<ListOptionElement<T>>();
        for (int i = 0; i < this.listModel.getSize(); ++i) {
            l.add((ListOptionElement)this.listModel.getElementAt(i));
        }
        return this.createNormalList(l);
    }

    @Override
    public void reset() {
        this.listModel.clear();
        for (ListOptionElement<T> o : this.createElementList((List<T>)this.option.getValue())) {
            this.listModel.addElement(o);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ListOptionElement<T> {
        private final T object;
        private final String text;

        private ListOptionElement(T object, String text) {
            this.object = object;
            this.text = text;
        }

        public String toString() {
            return this.text;
        }
    }
}

