/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.option;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.option.OptionUpdater;
import net.sf.freecol.common.option.LanguageOption;

public final class LanguageOptionUI
extends JComboBox
implements OptionUpdater,
PropertyChangeListener {
    private static final Logger logger = Logger.getLogger(LanguageOptionUI.class.getName());
    private final LanguageOption option;
    private LanguageOption.Language originalValue;
    private JLabel label;

    public LanguageOptionUI(final LanguageOption option, boolean editable) {
        this.option = option;
        this.originalValue = option.getValue();
        String name = Messages.getName(option);
        String description = Messages.getShortDescription(option);
        this.label = new JLabel(name, 2);
        this.label.setToolTipText(description != null ? description : name);
        LanguageOption.Language[] languages = option.getOptions();
        this.setModel(new DefaultComboBoxModel<LanguageOption.Language>(languages));
        this.reset();
        this.setEnabled(editable);
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (option.isPreviewEnabled()) {
                    LanguageOption.Language value = (LanguageOption.Language)LanguageOptionUI.this.getSelectedItem();
                    if (option.getValue() != value) {
                        option.setValue(value);
                    }
                }
            }
        });
        option.addPropertyChangeListener(this);
        this.setOpaque(false);
    }

    public JLabel getLabel() {
        return this.label;
    }

    public void setLabel(JLabel newLabel) {
        this.label = newLabel;
    }

    public void rollback() {
        this.option.setValue(this.originalValue);
    }

    public void unregister() {
        this.option.removePropertyChangeListener(this);
    }

    public void propertyChange(PropertyChangeEvent event) {
        LanguageOption.Language value;
        if (event.getPropertyName().equals("value") && (value = (LanguageOption.Language)event.getNewValue()) != this.getSelectedItem()) {
            this.setSelectedItem(value);
            this.originalValue = value;
        }
    }

    public void updateOption() {
        this.option.setValue((LanguageOption.Language)this.getSelectedItem());
    }

    public void reset() {
        this.setSelectedItem(this.option.getValue());
    }
}

