/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.animation;

import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JLabel;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.OutForAnimationCallback;
import net.sf.freecol.client.gui.animation.Animations;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;

final class UnitMoveAnimation {
    private static final int ANIMATION_DELAY = 33;
    private final Canvas canvas;
    private final Unit unit;
    private final Tile sourceTile;
    private final Tile destinationTile;

    public UnitMoveAnimation(Canvas canvas, Unit unit, Tile sourceTile, Tile destinationTile) {
        this.canvas = canvas;
        this.unit = unit;
        this.sourceTile = sourceTile;
        this.destinationTile = destinationTile;
    }

    public void animate() {
        final GUI gui = this.canvas.getGUI();
        int movementSpeed = Animations.getAnimationSpeed(this.canvas, this.unit);
        final Point srcP = gui.getTilePosition(this.sourceTile);
        final Point dstP = gui.getTilePosition(this.destinationTile);
        if (srcP == null || dstP == null || movementSpeed <= 0) {
            return;
        }
        float scale = gui.getMapScale();
        final int movementRatio = (int)(Math.pow(2.0, movementSpeed + 1) * (double)scale);
        Rectangle r1 = gui.getTileBounds(this.sourceTile);
        Rectangle r2 = gui.getTileBounds(this.destinationTile);
        final Rectangle bounds = r1.union(r2);
        gui.executeWithUnitOutForAnimation(this.unit, this.sourceTile, new OutForAnimationCallback(){

            public void executeWithUnitOutForAnimation(JLabel unitLabel) {
                int signalX;
                Point srcPoint = gui.getUnitLabelPositionInTile(unitLabel, srcP);
                Point dstPoint = gui.getUnitLabelPositionInTile(unitLabel, dstP);
                double xratio = gui.getTileWidth() / gui.getTileHeight();
                int n = srcPoint.getX() == dstPoint.getX() ? 0 : (signalX = srcPoint.getX() > dstPoint.getX() ? -1 : 1);
                int signalY = srcPoint.getY() == dstPoint.getY() ? 0 : (srcPoint.getY() > dstPoint.getY() ? -1 : 1);
                UnitMoveAnimation.this.canvas.paintImmediately(UnitMoveAnimation.this.canvas.getBounds());
                int dropFrames = 0;
                while (!srcPoint.equals(dstPoint)) {
                    long time = System.currentTimeMillis();
                    srcPoint.x = (int)((double)srcPoint.x + (double)signalX * xratio * (double)movementRatio);
                    srcPoint.y += signalY * movementRatio;
                    if (signalX == -1 && srcPoint.x < dstPoint.x) {
                        srcPoint.x = dstPoint.x;
                    } else if (signalX == 1 && srcPoint.x > dstPoint.x) {
                        srcPoint.x = dstPoint.x;
                    }
                    if (signalY == -1 && srcPoint.y < dstPoint.y) {
                        srcPoint.y = dstPoint.y;
                    } else if (signalY == 1 && srcPoint.y > dstPoint.y) {
                        srcPoint.y = dstPoint.y;
                    }
                    if (dropFrames <= 0) {
                        unitLabel.setLocation(srcPoint);
                        UnitMoveAnimation.this.canvas.paintImmediately(bounds);
                        int timeTaken = (int)(System.currentTimeMillis() - time);
                        int waitTime = 33 - timeTaken;
                        if (waitTime > 0) {
                            try {
                                Thread.sleep(waitTime);
                            }
                            catch (InterruptedException ex) {
                                // empty catch block
                            }
                            dropFrames = 0;
                            continue;
                        }
                        dropFrames = timeTaken / 33 - 1;
                        continue;
                    }
                    --dropFrames;
                }
            }
        });
    }
}

