/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.animation;

import java.awt.Rectangle;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.OutForAnimationCallback;
import net.sf.freecol.common.io.sza.AnimationEvent;
import net.sf.freecol.common.io.sza.ImageAnimationEvent;
import net.sf.freecol.common.io.sza.SimpleZippedAnimation;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Unit;

public final class UnitImageAnimation {
    private final Canvas canvas;
    private final Unit unit;
    private final SimpleZippedAnimation animation;
    private final Location currentLocation;

    public UnitImageAnimation(Canvas canvas, Unit unit, SimpleZippedAnimation animation) {
        this.canvas = canvas;
        this.unit = unit;
        this.currentLocation = unit.getLocation();
        this.animation = animation;
    }

    public void animate() {
        GUI gui = this.canvas.getGUI();
        if (gui.getTilePosition(this.unit.getTile()) == null) {
            return;
        }
        this.canvas.paintImmediately(this.canvas.getBounds());
        gui.executeWithUnitOutForAnimation(this.unit, this.unit.getTile(), new OutForAnimationCallback(){

            public void executeWithUnitOutForAnimation(JLabel unitLabel) {
                for (AnimationEvent event : UnitImageAnimation.this.animation) {
                    long time = System.nanoTime();
                    if (!(event instanceof ImageAnimationEvent)) continue;
                    ImageAnimationEvent ievent = (ImageAnimationEvent)event;
                    ImageIcon icon = (ImageIcon)unitLabel.getIcon();
                    icon.setImage(ievent.getImage());
                    UnitImageAnimation.this.canvas.paintImmediately(UnitImageAnimation.this.getDirtyAnimationArea());
                    time = (long)ievent.getDurationInMs() - (System.nanoTime() - time) / 1000000L;
                    if (time <= 0L) continue;
                    try {
                        Thread.sleep(time);
                    }
                    catch (InterruptedException ex) {}
                }
            }
        });
    }

    protected Rectangle getDirtyAnimationArea() {
        return this.canvas.getGUI().getTileBounds(this.currentLocation.getTile());
    }
}

