/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.action;

import java.awt.event.ActionEvent;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.action.UnitAction;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovementType;
import net.sf.freecol.common.model.Unit;

public class ImprovementAction
extends UnitAction {
    private TileImprovementType improvement;

    public ImprovementAction(FreeColClient freeColClient, TileImprovementType improvement) {
        super(freeColClient, improvement.getShortId() + "Action");
        this.improvement = improvement;
        this.addImageIcons(improvement.getShortId());
    }

    protected boolean shouldBeEnabled() {
        if (super.shouldBeEnabled()) {
            Unit selectedUnit = this.getFreeColClient().getGUI().getActiveUnit();
            Tile tile = selectedUnit.getTile();
            return selectedUnit.checkSetState(Unit.UnitState.IMPROVING) && this.improvement.isTileAllowed(tile) && this.improvement.isWorkerAllowed(selectedUnit);
        }
        return false;
    }

    public void actionPerformed(ActionEvent e) {
        this.getFreeColClient().getInGameController().changeWorkImprovementType(this.getFreeColClient().getGUI().getActiveUnit(), this.improvement);
        this.getFreeColClient().getInGameController().nextActiveUnit();
    }
}

